/*
 * Decompiled with CFR 0.152.
 */
package AIspace.neural;

import AIspace.neural.NeuralGraph;

public class AutoStep
extends Thread {
    public NeuralGraph graph;
    public boolean running;
    public boolean pause;
    public boolean untilFinished;

    public AutoStep(NeuralGraph graph, boolean untilFinished) {
        this.graph = graph;
        this.running = false;
        this.pause = false;
        this.untilFinished = untilFinished;
    }

    @Override
    public void run() {
        this.running = true;
        while (!this.untilFinished && this.graph.autoStepContinue() || this.untilFinished && this.graph.runContinue()) {
            if (!this.running) {
                return;
            }
            this.graph.step();
            this.graph.repaint();
            try {
                while (this.pause) {
                    AutoStep.sleep(5L);
                }
                Thread.sleep(this.graph.dt);
            }
            catch (InterruptedException err) {
                System.out.println(err);
            }
        }
        this.graph.autoStepEnd();
    }

    public void quit() {
        this.running = false;
    }
}

