/*
 * Decompiled with CFR 0.152.
 */
package AIspace.neural;

import AIspace.graphToolKit.elements.Edge;
import AIspace.graphToolKit.elements.Node;
import AIspace.neural.NeuralGraph;
import AIspace.neural.elements.NeuralEdge;
import AIspace.neural.elements.NeuralNode;
import AIspace.neural.intList.IntList;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;

public class BackPropagation {
    private NeuralGraph graph;
    private Double[] parameters;
    private int numberOfParameters;
    private double learningRate;
    private ArrayList<Hashtable<Integer, String>> examples;
    private ArrayList<Hashtable<Integer, String>> testExamples;
    private Node[] outputIndex;
    private Node[] inputNodes;
    private int numberOfInputNodes;
    private int numberOfOutputNodes;
    private IntList xVals;
    private IntList yVals;
    private IntList xTestVals;
    private IntList yTestVals;
    private int iterationCount;
    private double currErr;
    private double currTestErr;
    private double[] momentumWeights;
    private ArrayList<ArrayList<NeuralNode>> nodeLayers;
    private double[] midrange;
    private double[] range;
    private boolean standardize;
    private Double stoppingCondition = null;

    public BackPropagation(NeuralGraph g, ArrayList<Node> outputNodes, boolean standardize) {
        this.graph = g;
        this.range = null;
        this.midrange = null;
        this.standardize = standardize;
        this.momentumWeights = null;
        this.examples = this.graph.getExampleList().getTrainingArrayList();
        this.testExamples = this.graph.getExampleList().getTestArrayList();
        this.numberOfParameters = 0;
        this.numberOfInputNodes = 0;
        this.numberOfOutputNodes = outputNodes.size();
        this.outputIndex = new Node[this.numberOfOutputNodes];
        int i = 0;
        while (i < this.numberOfOutputNodes) {
            this.outputIndex[i] = outputNodes.get(i);
            ++i;
        }
        Iterator<Node> nodeItr = this.graph.getNodes();
        while (nodeItr.hasNext()) {
            NeuralNode tmpNode = (NeuralNode)nodeItr.next();
            if (tmpNode.getNumParentNodes() > 0) {
                ++this.numberOfParameters;
            }
            if (tmpNode.getNumParentNodes() != 0 || tmpNode.getNumChildrenNodes() == 0) continue;
            ++this.numberOfInputNodes;
        }
        this.numberOfParameters += this.graph.numEdges();
        this.parameters = new Double[this.numberOfParameters];
        this.inputNodes = new Node[this.numberOfInputNodes];
        int count1 = 0;
        int count3 = 0;
        NeuralNode[] inputArray = new NeuralNode[this.graph.getInputNodes().size()];
        NeuralNode[] outputArray = new NeuralNode[this.graph.getOutputNodes().size()];
        int inputCount = 0;
        int outputCount = 0;
        this.nodeLayers = new ArrayList();
        ArrayList<NeuralNode> outputList = new ArrayList<NeuralNode>();
        this.nodeLayers.add(outputList);
        nodeItr = this.graph.getNodes();
        while (nodeItr.hasNext()) {
            NeuralNode tmpNode = (NeuralNode)nodeItr.next();
            if (tmpNode.getNumParentNodes() > 0 && tmpNode.getNumChildrenNodes() == 0) {
                this.parameters[count1] = new Double(tmpNode.getCurrentParaValue());
                tmpNode.setParameterIndex(count1);
                outputArray[outputCount] = tmpNode;
                outputList.add(tmpNode);
                ++outputCount;
                ++count1;
                continue;
            }
            if (tmpNode.getNumParentNodes() != 0 || tmpNode.getNumChildrenNodes() <= 0) continue;
            this.inputNodes[count3] = tmpNode;
            inputArray[inputCount] = tmpNode;
            ++inputCount;
            ++count3;
        }
        this.orderBackpropParameters(count1, inputArray, outputArray, 1);
        this.xVals = new IntList();
        this.yVals = new IntList();
        this.xTestVals = new IntList();
        this.yTestVals = new IntList();
        if (standardize) {
            this.solveForStandardize();
        }
        this.currErr = this.totalError(this.parameters);
        this.currTestErr = this.totalTestError(this.parameters);
        this.addPoint(0, (int)(this.currErr * 100.0));
        this.addTestPoint(0, (int)(this.currTestErr * 100.0));
        this.graph.updatePlot();
        this.iterationCount = 0;
    }

    private void solveForStandardize() {
        this.midrange = new double[this.numberOfInputNodes];
        this.range = new double[this.numberOfInputNodes];
        double[] minInput = new double[this.numberOfInputNodes];
        double[] maxInput = new double[this.numberOfInputNodes];
        int i = 0;
        while (i < this.examples.size()) {
            Hashtable<Integer, String> oneExample = this.examples.get(i);
            int j = 0;
            while (j < this.numberOfInputNodes) {
                Double inputValue = Double.valueOf(oneExample.get(this.inputNodes[j].getIndex()));
                if (i > 0) {
                    maxInput[j] = Math.max(maxInput[j], inputValue);
                    minInput[j] = Math.min(minInput[j], inputValue);
                } else {
                    maxInput[j] = inputValue;
                    minInput[j] = inputValue;
                }
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < this.numberOfInputNodes) {
            this.midrange[i] = (maxInput[i] + minInput[i]) / 2.0;
            this.range[i] = maxInput[i] - minInput[i];
            ++i;
        }
    }

    public void orderBackpropParameters(int count, NeuralNode[] inputArray, NeuralNode[] outputArray, int layerLevel) {
        ArrayList<Edge> edgesIn = null;
        if (count >= this.parameters.length) {
            return;
        }
        int i = 0;
        while (i < outputArray.length) {
            edgesIn = outputArray[i].getAllEdges()[0];
            int j = 0;
            while (j < edgesIn.size()) {
                NeuralEdge edge = (NeuralEdge)edgesIn.get(j);
                this.parameters[count] = new Double(edge.getCurrentParaValue());
                edge.setParameterIndex(count);
                ++count;
                ++j;
            }
            ++i;
        }
        ArrayList<NeuralNode> inputs = new ArrayList<NeuralNode>();
        NeuralNode[] neuralNodeArray = inputArray;
        int n = inputArray.length;
        int edge = 0;
        while (edge < n) {
            NeuralNode node = neuralNodeArray[edge];
            inputs.add(node);
            ++edge;
        }
        ArrayList<NeuralNode> parents = new ArrayList<NeuralNode>();
        int i2 = 0;
        while (i2 < outputArray.length) {
            ArrayList<Node> parentNodes = outputArray[i2].getParentNodes();
            int j = 0;
            while (j < parentNodes.size()) {
                Iterator<Node> nodeItr = this.graph.getNodes();
                while (nodeItr.hasNext()) {
                    NeuralNode node = (NeuralNode)nodeItr.next();
                    int indexOfParent = parentNodes.get(j).getIndex();
                    if (node.index != indexOfParent || parents.contains(node) || inputs.contains(node)) continue;
                    parents.add(node);
                    break;
                }
                ++j;
            }
            ++i2;
        }
        if (parents.size() == 0) {
            return;
        }
        ArrayList<NeuralNode> hiddenLayer = new ArrayList<NeuralNode>();
        NeuralNode[] hiddenArray = new NeuralNode[parents.size()];
        int j = 0;
        while (j < hiddenArray.length) {
            NeuralNode node = (NeuralNode)parents.get(j);
            if (count >= this.parameters.length) {
                return;
            }
            this.parameters[count] = new Double(node.getCurrentParaValue());
            node.setParameterIndex(count);
            hiddenArray[j] = node;
            hiddenLayer.add(node);
            ++count;
            ++j;
        }
        this.nodeLayers.add(hiddenLayer);
        this.orderBackpropParameters(count, inputArray, hiddenArray, layerLevel + 1);
    }

    public static double sigmoidFunction(double x) {
        double netoutput = x < -45.0 ? 0.0 : (x > 45.0 ? 1.0 : 1.0 / (1.0 + Math.exp(-x)));
        return netoutput;
    }

    public static double tanhFunction(double x) {
        double e2x = Math.exp(2.0 * x);
        return (e2x - 1.0) / (e2x + 1.0);
    }

    public static double expFunction(double x) {
        return Math.exp(x);
    }

    public static double sigmoidDerivative(double x) {
        double temp = BackPropagation.sigmoidFunction(x);
        return temp * (1.0 - temp);
    }

    public double getCurrErr() {
        return this.currErr;
    }

    public double getCurrTestErr() {
        return this.currTestErr;
    }

    public double getStoppingError() {
        return this.stoppingCondition;
    }

    public int getIterationCount() {
        return this.iterationCount;
    }

    public void setLearningRate(double rate) {
        this.learningRate = rate;
    }

    public double getLearningRate() {
        return this.learningRate;
    }

    public Double[] getParameters() {
        return this.parameters;
    }

    public double getValue(int nodeIndex) {
        NeuralNode currNode = (NeuralNode)this.graph.nodeFromIndex(nodeIndex);
        if (currNode == null) {
            return -9999.99;
        }
        double value = currNode.getCurrentParaValue();
        ArrayList<Node> parents = currNode.getParentNodes();
        if (parents.size() == 0) {
            return value;
        }
        int i = 0;
        while (i < parents.size()) {
            int parentNodeIndex = parents.get(i).getIndex();
            double tmpValue = this.getValue(parentNodeIndex);
            NeuralEdge currEdge = (NeuralEdge)this.graph.getEdge(parentNodeIndex, nodeIndex);
            if (currEdge != null) {
                value += currEdge.getCurrentParaValue() * tmpValue;
            } else {
                return -9999.99;
            }
            ++i;
        }
        switch (currNode.functionType) {
            case 0: {
                return BackPropagation.sigmoidFunction(value);
            }
            case 1: {
                return value;
            }
            case 2: {
                return BackPropagation.tanhFunction(value);
            }
            case 3: {
                return BackPropagation.expFunction(value);
            }
        }
        return 0.0;
    }

    public double getValue(int nodeIndex, Double[] para) {
        NeuralNode currNode = (NeuralNode)this.graph.nodeFromIndex(nodeIndex);
        if (currNode == null) {
            return -9999.99;
        }
        int paraIndex = currNode.getParameterIndex();
        if (paraIndex == -1) {
            return currNode.getCurrentParaValue();
        }
        double value = para[paraIndex];
        ArrayList<Node> parents = currNode.getParentNodes();
        if (parents.size() != 0) {
            int i = 0;
            while (i < parents.size()) {
                int parentNodeIndex = parents.get(i).getIndex();
                double tmpValue = this.getValue(parentNodeIndex, para);
                NeuralEdge currEdge = (NeuralEdge)this.graph.getEdge(parentNodeIndex, nodeIndex);
                if (currEdge != null) {
                    paraIndex = currEdge.getParameterIndex();
                    value += para[paraIndex] * tmpValue;
                } else {
                    return -9999.99;
                }
                ++i;
            }
        }
        switch (currNode.functionType) {
            case 0: {
                return BackPropagation.sigmoidFunction(value);
            }
            case 1: {
                return value;
            }
            case 2: {
                return BackPropagation.tanhFunction(value);
            }
            case 3: {
                return BackPropagation.expFunction(value);
            }
        }
        return 0.0;
    }

    public Double[] nnlearn(int numIter, double rate, double momentum) {
        Double[] newPara = new Double[this.numberOfParameters];
        int i = 0;
        while (i < this.numberOfParameters) {
            newPara[i] = new Double(this.parameters[i]);
            ++i;
        }
        i = 0;
        while (i < numIter) {
            int paraIndex;
            ++this.iterationCount;
            newPara = this.updateEach(newPara, rate, momentum);
            int j = 0;
            while (j < this.numberOfParameters) {
                this.parameters[j] = new Double(newPara[j]);
                ++j;
            }
            Iterator<Node> nodeItr = this.graph.getNodes();
            while (nodeItr.hasNext()) {
                NeuralNode tmpNode = (NeuralNode)nodeItr.next();
                paraIndex = tmpNode.getParameterIndex();
                if (paraIndex == -1) continue;
                tmpNode.setCurrentParaValue(this.parameters[paraIndex]);
            }
            Iterator<Edge> itr = this.graph.getEdges();
            while (itr.hasNext()) {
                NeuralEdge edge = (NeuralEdge)itr.next();
                paraIndex = edge.getParameterIndex();
                edge.setCurrentParaValue(this.parameters[paraIndex]);
            }
            ++i;
        }
        this.currErr = this.totalError(this.parameters);
        this.currTestErr = this.totalTestError(this.parameters);
        this.addPoint(this.iterationCount, (int)(this.currErr * 100.0));
        this.addTestPoint(this.iterationCount, (int)(this.currTestErr * 100.0));
        this.graph.updatePlot();
        return newPara;
    }

    public Double[] updateEach(Double[] para, double rate, double momentum) {
        int i;
        Double[] newPara = new Double[para.length];
        Double[] tmpPara = new Double[para.length];
        if (this.momentumWeights == null) {
            this.momentumWeights = new double[para.length];
            i = 0;
            while (i < this.momentumWeights.length) {
                this.momentumWeights[i] = 0.0;
                ++i;
            }
        }
        i = 0;
        while (i < para.length) {
            tmpPara[i] = new Double(para[i]);
            ++i;
        }
        this.learningRate = rate;
        double[] derrors = this.solvePartials(tmpPara);
        ArrayList<NeuralNode> outputLayer = this.nodeLayers.get(0);
        int i2 = 0;
        while (i2 < outputLayer.size()) {
            NeuralNode output = outputLayer.get(i2);
            int paraIndex = output.getParameterIndex();
            double derror = derrors[paraIndex];
            double delta = rate * derror + momentum * this.momentumWeights[paraIndex];
            newPara[paraIndex] = new Double(para[paraIndex] + delta);
            this.momentumWeights[paraIndex] = delta;
            ArrayList<Edge> outputEdges = output.getAllEdges()[0];
            int j = 0;
            while (j < outputEdges.size()) {
                NeuralEdge outputEdge = (NeuralEdge)outputEdges.get(j);
                int paraIndexEdge = outputEdge.getParameterIndex();
                double derrorEdge = derrors[paraIndexEdge];
                delta = rate * derrorEdge + momentum * this.momentumWeights[paraIndexEdge];
                newPara[paraIndexEdge] = new Double(para[paraIndexEdge] + delta);
                this.momentumWeights[paraIndexEdge] = delta;
                ++j;
            }
            ++i2;
        }
        i2 = 1;
        while (i2 < this.nodeLayers.size()) {
            ArrayList<NeuralNode> hiddenLayer = this.nodeLayers.get(i2);
            int j = 0;
            while (j < hiddenLayer.size()) {
                NeuralNode output = hiddenLayer.get(j);
                int paraIndex = output.getParameterIndex();
                double derror = derrors[paraIndex];
                double delta = rate * derror + momentum * this.momentumWeights[paraIndex];
                newPara[paraIndex] = new Double(para[paraIndex] + delta);
                this.momentumWeights[paraIndex] = delta;
                ArrayList<Edge> hiddenEdges = output.getAllEdges()[0];
                int k = 0;
                while (k < hiddenEdges.size()) {
                    NeuralEdge outputEdge = (NeuralEdge)hiddenEdges.get(k);
                    int paraIndexEdge = outputEdge.getParameterIndex();
                    double derrorEdge = derrors[paraIndexEdge];
                    delta = rate * derrorEdge + momentum * this.momentumWeights[paraIndexEdge];
                    newPara[paraIndexEdge] = new Double(para[paraIndexEdge] + delta);
                    this.momentumWeights[paraIndexEdge] = delta;
                    ++k;
                }
                ++j;
            }
            ++i2;
        }
        return newPara;
    }

    public double solveNodeOutput(int index, Hashtable<Integer, String> example, Double[] para) {
        String[] params = this.graph.getExampleList().parameters;
        int j = 0;
        while (j < this.numberOfInputNodes) {
            int nodeIndex = -1;
            NeuralNode node = (NeuralNode)this.inputNodes[j];
            int i = 0;
            while (i < params.length) {
                if (node.getLabel().equals(params[i])) {
                    nodeIndex = i;
                    break;
                }
                ++i;
            }
            Double inputValue = Double.valueOf(example.get(new Integer(nodeIndex)));
            double value = inputValue;
            if (this.standardize) {
                value = (value - this.midrange[j]) / (this.range[j] / 2.0);
            }
            node.setCurrentParaValue(value);
            ++j;
        }
        return this.getValue(index, para);
    }

    public double solveNodeOutput(int index, Double[] values) {
        int i = 0;
        while (i < this.numberOfInputNodes) {
            NeuralNode node = (NeuralNode)this.inputNodes[i];
            double value = values[i];
            if (this.standardize) {
                value = (value - this.midrange[i]) / (this.range[i] / 2.0);
            }
            node.setCurrentParaValue(value);
            ++i;
        }
        return this.getValue(index);
    }

    private void storeAllNodeOutputs(ArrayList<NeuralNode> outputNodes, Hashtable<Integer, String> oneExample, Double[] para) {
        String[] params = this.graph.getExampleList().parameters;
        int j = 0;
        while (j < this.numberOfInputNodes) {
            int nodeIndex = -1;
            NeuralNode node = (NeuralNode)this.inputNodes[j];
            int i = 0;
            while (i < params.length) {
                if (node.getLabel().equals(params[i])) {
                    nodeIndex = i;
                    break;
                }
                ++i;
            }
            Double inputValue = Double.valueOf(oneExample.get(new Integer(nodeIndex)));
            double value = inputValue;
            if (this.standardize) {
                value = (value - this.midrange[j]) / (this.range[j] / 2.0);
            }
            node.setCurrentParaValue(value);
            ++j;
        }
        j = 0;
        while (j < outputNodes.size()) {
            NeuralNode output = outputNodes.get(j);
            this.storeNodeOutput(output.index, para);
            ++j;
        }
    }

    public double storeNodeOutput(int nodeIndex, Double[] para) {
        NeuralNode curNode = (NeuralNode)this.graph.nodeFromIndex(nodeIndex);
        if (curNode == null) {
            return -9999.99;
        }
        int paraIndex = curNode.getParameterIndex();
        if (paraIndex == -1) {
            return curNode.getCurrentParaValue();
        }
        double value = para[paraIndex];
        ArrayList<Node> parents = curNode.getParentNodes();
        if (parents.size() != 0) {
            int i = 0;
            while (i < parents.size()) {
                int parentNodeIndex = parents.get(i).getIndex();
                double tmpValue = this.storeNodeOutput(parentNodeIndex, para);
                NeuralEdge currEdge = (NeuralEdge)this.graph.getEdge(parentNodeIndex, nodeIndex);
                if (currEdge != null) {
                    paraIndex = currEdge.getParameterIndex();
                    value += para[paraIndex] * tmpValue;
                } else {
                    return -9999.99;
                }
                ++i;
            }
        }
        switch (curNode.functionType) {
            case 0: {
                value = BackPropagation.sigmoidFunction(value);
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                value = BackPropagation.tanhFunction(value);
                break;
            }
            case 3: {
                value = BackPropagation.expFunction(value);
            }
        }
        curNode.setOutputValue(value);
        return value;
    }

    private double[] solvePartials(Double[] para) {
        double[] derrAccumulator = new double[para.length];
        Iterator<Node> itr = this.graph.getNodes();
        while (itr.hasNext()) {
            NeuralNode node = (NeuralNode)itr.next();
            if (node.currentError != null) continue;
            node.currentError = new double[this.examples.size()];
        }
        int i = 0;
        while (i < this.examples.size()) {
            Hashtable<Integer, String> oneExample = this.examples.get(i);
            ArrayList<NeuralNode> outputNodes = this.nodeLayers.get(0);
            this.storeAllNodeOutputs(outputNodes, oneExample, para);
            int j = 0;
            while (j < outputNodes.size()) {
                NeuralNode output = outputNodes.get(j);
                int realIndex = this.graph.getInputNodes().size() + j;
                Double actual = Double.valueOf(oneExample.get(new Integer(realIndex)));
                double actualvalue = actual;
                double predicted = output.getOutputValue();
                double error = 0.0;
                switch (output.functionType) {
                    case 0: {
                        error = (actualvalue - predicted) * predicted * (1.0 - predicted);
                        break;
                    }
                    case 1: {
                        error = actualvalue - predicted;
                        break;
                    }
                    case 2: {
                        error = (actualvalue - predicted) * (1.0 - predicted * predicted);
                        break;
                    }
                    case 3: {
                        error = (actualvalue - predicted) * BackPropagation.expFunction(predicted);
                    }
                }
                int n = output.getParameterIndex();
                derrAccumulator[n] = derrAccumulator[n] + error;
                ArrayList<Edge> edgesIn = output.getAllEdges()[0];
                int k = 0;
                while (k < edgesIn.size()) {
                    NeuralNode sourceNode = (NeuralNode)((NeuralEdge)edgesIn.get(k)).otherNode(output);
                    int n2 = ((NeuralEdge)edgesIn.get(k)).getParameterIndex();
                    derrAccumulator[n2] = derrAccumulator[n2] + error * this.getValue(sourceNode.index, para);
                    ++k;
                }
                output.currentError[i] = error;
                ++j;
            }
            j = 1;
            while (j < this.nodeLayers.size()) {
                ArrayList<NeuralNode> hiddenLayer = this.nodeLayers.get(j);
                int k = 0;
                while (k < hiddenLayer.size()) {
                    NeuralNode hidden = hiddenLayer.get(k);
                    double predicted = hidden.getOutputValue();
                    ArrayList<Edge> edgesOut = hidden.getAllEdges()[1];
                    double weightCorrection = 0.0;
                    int l = 0;
                    while (l < edgesOut.size()) {
                        int edgeIndex = ((NeuralEdge)edgesOut.get(l)).getParameterIndex();
                        double weight = para[edgeIndex];
                        NeuralNode otherNode = (NeuralNode)((NeuralEdge)edgesOut.get(l)).otherNode(hidden);
                        double otherError = otherNode.currentError[i];
                        weightCorrection += weight * otherError;
                        ++l;
                    }
                    double error = 0.0;
                    switch (hidden.functionType) {
                        case 0: {
                            error = weightCorrection * predicted * (1.0 - predicted);
                            break;
                        }
                        case 1: {
                            error = weightCorrection;
                            break;
                        }
                        case 2: {
                            error = weightCorrection * (1.0 - predicted * predicted);
                            break;
                        }
                        case 3: {
                            error = weightCorrection * BackPropagation.expFunction(predicted);
                        }
                    }
                    int n = hidden.getParameterIndex();
                    derrAccumulator[n] = derrAccumulator[n] + error;
                    ArrayList<Edge> edgesIn = hidden.getAllEdges()[0];
                    int l2 = 0;
                    while (l2 < edgesIn.size()) {
                        NeuralNode sourceNode = (NeuralNode)((NeuralEdge)edgesIn.get(l2)).otherNode(hidden);
                        int n3 = ((NeuralEdge)edgesIn.get(l2)).getParameterIndex();
                        derrAccumulator[n3] = derrAccumulator[n3] + error * this.getValue(sourceNode.index, para);
                        ++l2;
                    }
                    hidden.currentError[i] = error;
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        return derrAccumulator;
    }

    public double totalError(Double[] para) {
        double acc = 0.0;
        double stopAcc = 0.0;
        int i = 0;
        while (i < this.examples.size()) {
            Hashtable<Integer, String> oneExample = this.examples.get(i);
            int k = 0;
            while (k < this.numberOfOutputNodes) {
                double nodeOutputErrSquared;
                int realIndex = this.graph.getInputNodes().size() + k;
                int unadjustedIndex = this.outputIndex[k].getIndex();
                Double actual = Double.valueOf(oneExample.get(new Integer(realIndex)));
                if (this.graph.getErrorType() == NeuralGraph.AVERAGE_SUMSQUARES) {
                    nodeOutputErrSquared = Math.pow(this.solveNodeOutput(unadjustedIndex, oneExample, para) - actual, 2.0);
                    acc += 0.5 * nodeOutputErrSquared;
                    stopAcc += nodeOutputErrSquared;
                } else if (this.graph.getErrorType() == NeuralGraph.SUMSQUARES) {
                    nodeOutputErrSquared = Math.pow(this.solveNodeOutput(unadjustedIndex, oneExample, para) - actual, 2.0);
                    acc += nodeOutputErrSquared;
                    stopAcc += nodeOutputErrSquared;
                }
                ++k;
            }
            ++i;
        }
        this.stoppingCondition = new Double(stopAcc);
        if (this.graph.getErrorType() == NeuralGraph.AVERAGE_SUMSQUARES) {
            return acc / (double)this.examples.size();
        }
        return acc;
    }

    public double totalTestError(Double[] para) {
        double acc = 0.0;
        int i = 0;
        while (i < this.testExamples.size()) {
            Hashtable<Integer, String> oneExample = this.testExamples.get(i);
            int k = 0;
            while (k < this.numberOfOutputNodes) {
                double nodeOutputErrSquared;
                int realIndex = this.graph.getInputNodes().size() + k;
                int unadjustedIndex = this.outputIndex[k].getIndex();
                Double actual = Double.valueOf(oneExample.get(new Integer(realIndex)));
                if (this.graph.getErrorType() == NeuralGraph.AVERAGE_SUMSQUARES) {
                    nodeOutputErrSquared = Math.pow(this.solveNodeOutput(unadjustedIndex, oneExample, para) - actual, 2.0);
                    acc += 0.5 * nodeOutputErrSquared;
                } else if (this.graph.getErrorType() == NeuralGraph.SUMSQUARES) {
                    nodeOutputErrSquared = Math.pow(this.solveNodeOutput(unadjustedIndex, oneExample, para) - actual, 2.0);
                    acc += nodeOutputErrSquared;
                }
                ++k;
            }
            ++i;
        }
        if (this.graph.getErrorType() == NeuralGraph.AVERAGE_SUMSQUARES) {
            return acc / (double)this.examples.size();
        }
        return acc;
    }

    public void addPoint(int x, int y) {
        this.xVals.add(x);
        this.yVals.add(y);
    }

    public void addTestPoint(int x, int y) {
        this.xTestVals.add(x);
        this.yTestVals.add(y);
    }

    public IntList[] getPlotVals() {
        IntList[] tmp = new IntList[]{this.xVals, this.yVals};
        return tmp;
    }

    public IntList[] getTestPlotVals() {
        IntList[] tmp = new IntList[]{this.xTestVals, this.yTestVals};
        return tmp;
    }

    public void clearPlotPts() {
        this.xVals = new IntList();
        this.yVals = new IntList();
        this.xTestVals = new IntList();
        this.yTestVals = new IntList();
    }
}

