/*
 * Decompiled with CFR 0.152.
 */
package AIspace.neural;

import AIspace.graphToolKit.InlineApplet;
import AIspace.graphToolKit.dialogs.MessageDialog;
import AIspace.neural.ExampleList;
import AIspace.neural.InlineCanvas;
import AIspace.neural.Legend;
import AIspace.neural.NeuralCanvas;
import AIspace.neural.NeuralGraph;
import AIspace.neural.dialogs.ExampleDialog;
import AIspace.neural.dialogs.InitializationOptionsDialog;
import AIspace.neural.dialogs.InputExampleFrame;
import AIspace.neural.dialogs.LearningOptionsDialog;
import AIspace.neural.dialogs.StoppingOptionsDialog;
import AIspace.neural.dialogs.TestStatisticsDialog;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;

public class InlineNeuralApplet
extends InlineApplet {
    private static final long serialVersionUID = 1L;
    private JPanel colorKey;
    public JToggleButton examplesButton;
    public JToggleButton initializeParametersButton;
    public JToggleButton stepButton;
    public JToggleButton stepXButton;
    public JToggleButton stepToTargetErrorButton;
    public JToggleButton stopButton;
    public JToggleButton calculateOutputButton;
    public JToggleButton showPlotButton;
    public JToggleButton summaryStatisticsButton;
    public JToggleButton fakeButton;
    private boolean examplesButtonOn = false;
    private boolean initializeParametersButtonOn = false;
    private boolean stepButtonOn = false;
    private boolean stepXButtonOn = false;
    private boolean stepToTargetErrorButtonOn = false;
    private boolean stopButtonOn = false;
    private boolean calculateOutputButtonOn = false;
    private boolean showPlotButtonOn = false;
    private boolean summaryStatisticsButtonOn = false;
    public boolean examplesPopupOn = false;
    public boolean initializeParametersPopupOn = false;
    public boolean stepPopupOn = false;
    public boolean stepXPopupOn = false;
    public boolean stepToTargetErrorPopupOn = false;
    public boolean stopPopupOn = false;
    public boolean calculateOutputPopupOn = false;
    public boolean showPlotPopupOn = false;
    public boolean summaryStatisticsPopupOn = false;
    public boolean parameterInitializationOptionsPopup = false;
    public boolean learningOptionsPopup = false;
    public boolean stoppingConditionsPopup = false;
    private boolean showColorKey = false;
    private StoppingOptionsDialog sod;
    private LearningOptionsDialog lod;
    private InitializationOptionsDialog iod;

    @Override
    public void init() {
        super.init();
        this.makeCanvas();
        this.loadParams();
        if (this.incorrectParameter) {
            return;
        }
        ((InlineCanvas)this.canvas).initializePopup();
        this.createToolBar();
        this.addComponent(this.messageCanvas, this.canvasPanel, 0, 0, 1, 1, 1.0, 0.0);
        this.addComponent(this.canvas, this.canvasPanel, 1, 0, 1, 1, 1.0, 1.0);
        this.canvas.setMinimumSize(new Dimension(10, 100));
        if (!this.showMessagePanel) {
            this.messageCanvas.setVisible(false);
        } else {
            this.messageCanvas.setMinimumSize(new Dimension(10, 50));
            this.setPromptLabel("Click on a variable to split its domain.\nClick on a constraint to reorder its variables.\nClick on an arc to make it arc-consistent.");
        }
        this.colorKey = new JPanel();
        this.colorKey.setBorder(BorderFactory.createRaisedBevelBorder());
        this.colorKey.setMinimumSize(new Dimension(100, 17));
        this.canvas.add(this.colorKey);
        JSplitPane splitPane = new JSplitPane(0);
        splitPane.setTopComponent(this.canvasPanel);
        this.canvasPanel.addComponentListener(this);
        splitPane.setBottomComponent(this.colorKey);
        splitPane.setResizeWeight(1.0);
        splitPane.setDividerSize(0);
        splitPane.setEnabled(false);
        if (!this.showColorKey) {
            this.colorKey.setVisible(false);
        } else {
            this.colorKey.add(new JLabel("Color Key:"));
            this.colorKey.add(new Legend());
            splitPane.setResizeWeight(1.0);
            this.colorKey.setMinimumSize(new Dimension(30, 30));
        }
        if (this.showButtons) {
            splitPane.setPreferredSize(new Dimension(this.getSize().width - 10, this.getSize().height - 75));
        } else {
            splitPane.setPreferredSize(new Dimension(this.getSize().width - 10, this.getSize().height - 10));
            this.toolBarPanel.setVisible(false);
        }
        this.colorKey.setBorder(null);
        if (this.showBorder) {
            this.canvas.setBorder(BorderFactory.createLineBorder(Color.black));
            splitPane.setBorder(BorderFactory.createLineBorder(Color.black));
        } else {
            this.canvas.setBorder(null);
            splitPane.setBorder(null);
        }
        this.mainPanel.add((Component)splitPane, "Center");
        this.mainPanel.setBackground(Color.white);
        this.mainPanel.setBorder(null);
        this.getContentPane().add((Component)this.mainPanel, "Center");
        this.setPromptLabel("Click on an entity to view its properties.");
        this.setVisible(true);
    }

    public void createToolBar() {
        this.toolBarPanel = new JPanel(new BorderLayout());
        JToolBar toolBar = new JToolBar();
        ButtonGroup buttonGroup = new ButtonGroup();
        this.buttons = new JToggleButton[10];
        int index = 0;
        this.setSolveButtonsWithText(index, "View/Edit Examples", InlineNeuralApplet.createImageIcon("images/neural/Edit24.gif"), "View/Edit Examples");
        this.examplesButton = this.buttons[index++];
        if (!this.examplesButtonOn) {
            this.examplesButton.setVisible(false);
        }
        this.setSolveButtonsWithText(index, "Initialize Parameters", InlineNeuralApplet.createImageIcon("images/neural/randomPara.png"), "Initialize Parameters");
        this.initializeParametersButton = this.buttons[index++];
        if (!this.initializeParametersButtonOn) {
            this.initializeParametersButton.setVisible(false);
        }
        this.setSolveButtonsWithText(index, "    Step    ", InlineNeuralApplet.createImageIcon("images/neural/step.png"), "Step");
        this.stepButton = this.buttons[index++];
        if (!this.stepButtonOn) {
            this.stepButton.setVisible(false);
        }
        this.setSolveButtonsWithText(index, "  Step " + ((NeuralGraph)this.canvas.graph).getNumberOfIterations() + "X  ", InlineNeuralApplet.createImageIcon("images/common/finestep.png"), "Step " + ((NeuralGraph)this.canvas.graph).getNumberOfIterations() + "X");
        this.stepXButton = this.buttons[index++];
        if (!this.stepXButtonOn) {
            this.stepXButton.setVisible(false);
        }
        this.setSolveButtonsWithText(index, "Step to Target Error", InlineNeuralApplet.createImageIcon("images/neural/stepTarget.png"), "Step to Target Error");
        this.stepToTargetErrorButton = this.buttons[index++];
        if (!this.stepToTargetErrorButtonOn) {
            this.stepToTargetErrorButton.setVisible(false);
        }
        this.setSolveButtonsWithText(index, "    Stop    ", InlineNeuralApplet.createImageIcon("images/neural/stop.gif"), "Stop");
        this.stopButton = this.buttons[index++];
        this.stopButton.setEnabled(false);
        if (!this.stopButtonOn) {
            this.stopButton.setVisible(false);
        }
        this.setSolveButtonsWithText(index, "Calculate Output", InlineNeuralApplet.createImageIcon("images/neural/quiz.gif"), "Calculate Output");
        this.calculateOutputButton = this.buttons[index++];
        if (!this.calculateOutputButtonOn) {
            this.calculateOutputButton.setVisible(false);
        }
        this.setSolveButtonsWithText(index, "Show Plot", InlineNeuralApplet.createImageIcon("images/neural/showPlot.png"), "Show Plot");
        this.showPlotButton = this.buttons[index++];
        if (!this.showPlotButtonOn) {
            this.showPlotButton.setVisible(false);
        }
        this.setSolveButtonsWithText(index, "Summary Statistics", InlineNeuralApplet.createImageIcon("images/neural/History24.gif"), "Summary Statistics");
        this.summaryStatisticsButton = this.buttons[index++];
        if (!this.summaryStatisticsButtonOn) {
            this.summaryStatisticsButton.setVisible(false);
        }
        this.setSolveButtonsWithText(index, "Fake", InlineNeuralApplet.createImageIcon("images/common/finestep.png"), "Fake");
        this.fakeButton = this.buttons[index++];
        Font toolFont = new Font("arial", 0, 10);
        int i = 0;
        while (i < index) {
            buttonGroup.add(this.buttons[i]);
            toolBar.add(this.buttons[i]);
            this.buttons[i].setFont(toolFont);
            ++i;
        }
        this.buttons[index - 1].setVisible(false);
        this.toolBarPanel.add((Component)toolBar, "Center");
        this.mainPanel.add((Component)this.toolBarPanel, "North");
    }

    protected void makeCanvas() {
        this.canvas = new InlineCanvas(this);
        this.canvas.WIDTH = this.getSize().width;
        this.canvas.HEIGHT = this.getSize().height;
        this.canvas.setPreferredSize(new Dimension(this.canvas.WIDTH, this.canvas.HEIGHT));
        this.canvas.setMode(2221);
    }

    @Override
    protected void loadParams() {
        super.loadParams();
        String param = this.getParameter("viewEditExamplesButton");
        if (param != null) {
            if (param.equals("on")) {
                this.examplesButtonOn = true;
                this.showButtons = true;
            } else if (!param.equals("off")) {
                this.incorrectParameter("viewEditExamplesButton", param);
            }
        }
        if ((param = this.getParameter("initializeParametersButton")) != null) {
            if (param.equals("on")) {
                this.initializeParametersButtonOn = true;
                this.showButtons = true;
            } else if (!param.equals("off")) {
                this.incorrectParameter("initializeParametersButton", param);
            }
        }
        if ((param = this.getParameter("stepButton")) != null) {
            if (param.equals("on")) {
                this.stepButtonOn = true;
                this.showButtons = true;
            } else if (!param.equals("off")) {
                this.incorrectParameter("stepButton", param);
            }
        }
        if ((param = this.getParameter("stepXButton")) != null) {
            if (param.equals("on")) {
                this.stepXButtonOn = true;
                this.showButtons = true;
            } else if (!param.equals("off")) {
                this.incorrectParameter("stepXButton", param);
            }
        }
        if ((param = this.getParameter("stepToTargetErrorButton")) != null) {
            if (param.equals("on")) {
                this.stepToTargetErrorButtonOn = true;
                this.showButtons = true;
            } else if (!param.equals("off")) {
                this.incorrectParameter("stepToTargetErrorButton", param);
            }
        }
        if ((param = this.getParameter("stopButton")) != null) {
            if (param.equals("on")) {
                this.stopButtonOn = true;
                this.showButtons = true;
            } else if (!param.equals("off")) {
                this.incorrectParameter("stopButton", param);
            }
        }
        if ((param = this.getParameter("calculateOutputButton")) != null) {
            if (param.equals("on")) {
                this.calculateOutputButtonOn = true;
                this.showButtons = true;
            } else if (!param.equals("off")) {
                this.incorrectParameter("calculateOutputButton", param);
            }
        }
        if ((param = this.getParameter("showPlotButton")) != null) {
            if (param.equals("on")) {
                this.showPlotButtonOn = true;
                this.showButtons = true;
            } else if (!param.equals("off")) {
                this.incorrectParameter("showPlotButton", param);
            }
        }
        if ((param = this.getParameter("summaryStatisticsButton")) != null) {
            if (param.equals("on")) {
                this.summaryStatisticsButtonOn = true;
                this.showButtons = true;
            } else if (!param.equals("off")) {
                this.incorrectParameter("summaryStatisticsButton", param);
            }
        }
        if ((param = this.getParameter("viewEditExamplesPopup")) != null) {
            if (param.equals("on")) {
                this.examplesPopupOn = true;
            } else if (!param.equals("off")) {
                this.incorrectParameter("viewEditExamplesPopup", param);
            }
        }
        if ((param = this.getParameter("initializeParametersPopup")) != null) {
            if (param.equals("on")) {
                this.initializeParametersPopupOn = true;
            } else if (!param.equals("off")) {
                this.incorrectParameter("initializeParametersPopup", param);
            }
        }
        if ((param = this.getParameter("stepPopup")) != null) {
            if (param.equals("on")) {
                this.stepPopupOn = true;
            } else if (!param.equals("off")) {
                this.incorrectParameter("stepPopup", param);
            }
        }
        if ((param = this.getParameter("stepXPopup")) != null) {
            if (param.equals("on")) {
                this.stepXPopupOn = true;
            } else if (!param.equals("off")) {
                this.incorrectParameter("stepXPopup", param);
            }
        }
        if ((param = this.getParameter("stepToTargetErrorPopup")) != null) {
            if (param.equals("on")) {
                this.stepToTargetErrorPopupOn = true;
            } else if (!param.equals("off")) {
                this.incorrectParameter("stepToTargetErrorPopup", param);
            }
        }
        if ((param = this.getParameter("stopPopup")) != null) {
            if (param.equals("on")) {
                this.stopPopupOn = true;
            } else if (!param.equals("off")) {
                this.incorrectParameter("stopPopup", param);
            }
        }
        if ((param = this.getParameter("calculateOutputPopup")) != null) {
            if (param.equals("on")) {
                this.calculateOutputPopupOn = true;
            } else if (!param.equals("off")) {
                this.incorrectParameter("calculateOutputPopup", param);
            }
        }
        if ((param = this.getParameter("showPlotPopup")) != null) {
            if (param.equals("on")) {
                this.showPlotPopupOn = true;
            } else if (!param.equals("off")) {
                this.incorrectParameter("showPlotPopup", param);
            }
        }
        if ((param = this.getParameter("summaryStatisticsPopup")) != null) {
            if (param.equals("on")) {
                this.summaryStatisticsPopupOn = true;
            } else if (!param.equals("off")) {
                this.incorrectParameter("summaryStatisticsPopup", param);
            }
        }
        if ((param = this.getParameter("showColorKey")) != null) {
            if (param.equals("on")) {
                this.showColorKey = true;
            } else if (!param.equals("off")) {
                this.incorrectParameter("showColorKey", param);
            }
        }
        if ((param = this.getParameter("showParameters")) != null) {
            if (param.equals("off")) {
                ((NeuralGraph)this.canvas.graph).setShowParam(false);
            } else if (!param.equals("on")) {
                this.incorrectParameter("showParameters", param);
            }
        }
        if ((param = this.getParameter("parameterInitializationOptionsPopup")) != null) {
            if (param.equals("on")) {
                this.parameterInitializationOptionsPopup = true;
            } else if (!param.equals("off")) {
                this.incorrectParameter("parameterInitializationOptionsPopup", param);
            }
        }
        if ((param = this.getParameter("learningOptionsPopup")) != null) {
            if (param.equals("on")) {
                this.learningOptionsPopup = true;
            } else if (!param.equals("off")) {
                this.incorrectParameter("learningOptionsPopup", param);
            }
        }
        if ((param = this.getParameter("stoppingConditionsPopup")) != null) {
            if (param.equals("on")) {
                this.stoppingConditionsPopup = true;
            } else if (!param.equals("off")) {
                this.incorrectParameter("stoppingConditionsPopup", param);
            }
        }
        if ((param = this.getParameter("normalizeInputs")) != null) {
            if (param.equals("on")) {
                NeuralGraph g = (NeuralGraph)this.canvas.graph;
                ExampleList ex = g.getExampleList();
                g.standardized = true;
                if ((ex != null || g.getExampleList().getTrainingArrayList().size() > 0) && g.getInputNodes().size() > 0 && g.getOutputNodes().size() > 0) {
                    g.initBackProp();
                }
            } else if (!param.equals("off")) {
                this.incorrectParameter("normalizeInputs", param);
            }
        }
        try {
            param = this.getParameter("iterations");
            if (param != null) {
                int value = Integer.parseInt(param);
                if (value < 1) {
                    value = 50;
                }
                ((NeuralGraph)this.canvas.graph).setNumberOfIterations(value);
            }
        }
        catch (NumberFormatException e) {
            this.incorrectParameter("iterations", param);
        }
        if ((param = this.getParameter("speed")) != null) {
            if (param.equals("veryFast")) {
                ((NeuralGraph)this.canvas.graph).dt = 0;
            } else if (param.equals("fast")) {
                ((NeuralGraph)this.canvas.graph).dt = 100;
            } else if (param.equals("medium")) {
                ((NeuralGraph)this.canvas.graph).dt = 500;
            } else if (param.equals("slow")) {
                ((NeuralGraph)this.canvas.graph).dt = 1000;
            } else {
                this.incorrectParameter("speed", param);
            }
        }
    }

    @Override
    public void load(String filename) {
        try {
            String line;
            ((NeuralGraph)this.canvas.graph).disposeWindows();
            StringBuffer allText = new StringBuffer();
            BufferedReader in = new BufferedReader(new InputStreamReader(new URL(filename).openStream()));
            while ((line = in.readLine()) != null) {
                allText.append(line).append("\n");
            }
            in.close();
            ExampleList example = new ExampleList();
            String errorMessage = example.parseString(allText.toString());
            if (errorMessage.length() > 0 && !errorMessage.equals("OK")) {
                new MessageDialog(null).open("Error Loading File", errorMessage);
                return;
            }
            this.resetCanvas();
            ((NeuralCanvas)this.canvas).parseXML(allText.toString());
            ((NeuralGraph)((NeuralCanvas)this.canvas).graph).setInputOutputNodes(true);
            if (this.canvas.getMode() == 2221) {
                ((NeuralGraph)this.canvas.graph).setTotalErrorAfterInitialization();
            }
            if (this.autoscale) {
                this.canvas.autoscale();
            }
            ((NeuralGraph)this.canvas.graph).repaint();
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            super.setPromptLabel("Error" + e.toString());
        }
    }

    protected void resetCanvas() {
        int speed = ((NeuralGraph)this.canvas.graph).dt;
        this.canvas.reset();
        ((NeuralGraph)this.canvas.graph).dt = speed;
    }

    public void enableButtons(boolean bool) {
        this.stepXButton.setEnabled(bool);
        this.stepToTargetErrorButton.setEnabled(bool);
        this.stopButton.setEnabled(!bool);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String arg = e.getActionCommand();
        if (arg.equals("Autoscale")) {
            this.canvas.autoscale();
        } else if (arg.equals("Reset Edge Labels")) {
            this.canvas.resetLabels();
        } else if (arg.equals("Pan")) {
            this.canvas.setRMode(4440);
        } else if (arg.equals("Zoom")) {
            this.canvas.setRMode(4441);
        } else if (arg.equals("Step")) {
            ((NeuralGraph)this.canvas.graph).step();
            this.fakeButton.setSelected(true);
            this.canvas.repaint();
        } else if (arg.equals("Step " + ((NeuralGraph)this.canvas.graph).getNumberOfIterations() + "X")) {
            ((NeuralGraph)this.canvas.graph).autoStep();
            this.stopButton.setEnabled(true);
        } else if (arg.equals("Step to Target Error")) {
            ((NeuralGraph)this.canvas.graph).runUntilFinished();
            this.stopButton.setEnabled(true);
        } else if (arg.equals("Stop")) {
            ((NeuralGraph)this.canvas.graph).stop();
            this.stopButton.setEnabled(false);
            this.fakeButton.setSelected(true);
        } else if (arg.equals("Initialize Parameters")) {
            ((NeuralGraph)this.canvas.graph).initializeParaValues();
            this.fakeButton.setSelected(true);
        } else if (arg.equals("Calculate Output")) {
            new InputExampleFrame((NeuralGraph)this.canvas.graph, "Calculate Output Values", false);
            this.fakeButton.setSelected(true);
        } else if (arg.equals("Show Plot")) {
            ((NeuralGraph)this.canvas.graph).showPlot();
            this.fakeButton.setSelected(true);
        } else if (arg.equals("Summary Statistics")) {
            new TestStatisticsDialog(null, (NeuralGraph)this.canvas.graph);
            this.fakeButton.setSelected(true);
        } else if (arg.equals("View/Edit Examples")) {
            this.fakeButton.setSelected(true);
            if (this.validGraph()) {
                new ExampleDialog(this, (NeuralGraph)this.canvas.graph, ((NeuralGraph)this.canvas.graph).getExampleList());
            } else {
                this.canvas.showMessage("View/Edit Examples", "At least one input and output node are needed to manipulate examples.");
            }
        } else if (arg.equals("View Prolog Code")) {
            ((NeuralCanvas)this.canvas).openPrologTextRep();
        } else if (arg.equals("View Text Representation")) {
            ((NeuralCanvas)this.canvas).openTextRep(false);
        } else if (arg.equals("View XML Representation")) {
            ((NeuralCanvas)this.canvas).openXMLTextRep(false);
        } else {
            if (arg.equals("Parameter Initialization Options...")) {
                if (this.iod == null) {
                    this.iod = new InitializationOptionsDialog(null, (NeuralGraph)this.canvas.graph, true);
                } else {
                    this.iod.open();
                }
                return;
            }
            if (arg.equals("Learning Options...")) {
                if (this.lod == null) {
                    this.lod = new LearningOptionsDialog(null, (NeuralGraph)this.canvas.graph);
                } else {
                    this.lod.open();
                }
                return;
            }
            if (arg.equals("Stopping Conditions...")) {
                if (this.sod == null) {
                    this.sod = new StoppingOptionsDialog(null, (NeuralGraph)this.canvas.graph, "Stopping Conditions");
                } else {
                    this.sod.open();
                }
                this.stepXButton.setText("Step " + ((NeuralGraph)this.canvas.graph).getNumberOfIterations() + "X");
                this.stepXButton.setToolTipText("Step " + ((NeuralGraph)this.canvas.graph).getNumberOfIterations() + "X");
                this.stepXButton.setActionCommand(this.stepXButton.getText());
                return;
            }
        }
    }

    private boolean validGraph() {
        NeuralGraph g = (NeuralGraph)this.canvas.graph;
        return g.getInputNodes().size() > 0 && g.getOutputNodes().size() > 0;
    }

    public void viewEditExamples() {
        if (this.examplesButton.isEnabled()) {
            ((InlineCanvas)this.canvas).actionPerformed(new ActionEvent(this.examplesButton, 0, "View/Edit Examples"));
        }
    }

    public void initializeParameters() {
        if (this.initializeParametersButton.isEnabled()) {
            ((InlineCanvas)this.canvas).actionPerformed(new ActionEvent(this.initializeParametersButton, 0, "Initialize Parameters"));
        }
    }

    public void step() {
        if (this.stepButton.isEnabled()) {
            ((InlineCanvas)this.canvas).actionPerformed(new ActionEvent(this.stepButton, 0, "Step"));
        }
    }

    public void stepX() {
        if (this.stepXButton.isEnabled()) {
            ((InlineCanvas)this.canvas).actionPerformed(new ActionEvent(this.stepXButton, 0, "Step " + ((NeuralGraph)this.canvas.graph).getNumberOfIterations() + "X"));
        }
    }

    public void stepToTargetError() {
        if (this.stepToTargetErrorButton.isEnabled()) {
            ((InlineCanvas)this.canvas).actionPerformed(new ActionEvent(this.stepToTargetErrorButton, 0, "Step to Target Error"));
        }
    }

    @Override
    public void stop() {
        if (this.stopButton.isEnabled()) {
            ((InlineCanvas)this.canvas).actionPerformed(new ActionEvent(this.stopButton, 0, "Stop"));
        }
    }

    public void calculateOutput() {
        if (this.calculateOutputButton.isEnabled()) {
            ((InlineCanvas)this.canvas).actionPerformed(new ActionEvent(this.calculateOutputButton, 0, "Calculate Output"));
        }
    }

    public void showPlot() {
        if (this.showPlotButton.isEnabled()) {
            this.actionPerformed(new ActionEvent(this.showPlotButton, 0, "Show Plot"));
        }
    }

    public void summaryStatistics() {
        if (this.summaryStatisticsButton.isEnabled()) {
            this.actionPerformed(new ActionEvent(this.summaryStatisticsButton, 0, "Summary Statistics"));
        }
    }

    public void autoscale() {
        ((InlineCanvas)this.canvas).actionPerformed(new ActionEvent(this.fakeButton, 0, "Autoscale"));
    }
}

