/*
 * Decompiled with CFR 0.152.
 */
package AIspace.neural;

import AIspace.graphToolKit.GraphCanvas;
import AIspace.graphToolKit.elements.Entity;
import AIspace.graphToolKit.elements.Point;
import AIspace.neural.NeuralGraph;
import AIspace.neural.NeuralWindow;
import AIspace.neural.dialogs.CalculateOutputDialog;
import AIspace.neural.dialogs.EdgeDialog;
import AIspace.neural.dialogs.ExampleDialog;
import AIspace.neural.dialogs.NeuralTextFrame;
import AIspace.neural.dialogs.NodeDialog;
import AIspace.neural.dialogs.TestStatisticsDialog;
import AIspace.neural.elements.NeuralEdge;
import AIspace.neural.elements.NeuralNode;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.print.PageFormat;
import java.awt.print.PrinterException;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;

public class NeuralCanvas
extends GraphCanvas {
    private NodeDialog nd;
    private Container window;

    public NeuralCanvas(Container parent, boolean inline) {
        super(parent, inline);
        this.window = parent;
        this.graph = new NeuralGraph(this);
        this.pop.setLightWeightPopupEnabled(false);
    }

    @Override
    protected void popupCanvas(int x, int y) {
        JRadioButtonMenuItem pan;
        JRadioButtonMenuItem zoom;
        JMenuItem mItem;
        this.pop.removeAll();
        if (this.mode == 2220) {
            this.pop.setBorder(BorderFactory.createTitledBorder("Create Options"));
            mItem = new JMenuItem("Create Node");
            mItem.addActionListener(this);
            this.pop.add(mItem);
            mItem = new JMenuItem("View/Edit Examples");
            mItem.addActionListener((NeuralWindow)this.window);
            this.pop.add(mItem);
        } else {
            this.pop.setBorder(BorderFactory.createTitledBorder("Solve Options"));
            mItem = new JMenuItem("Initialize Parameters");
            mItem.addActionListener(this);
            this.pop.add(mItem);
            mItem = new JMenuItem("Step");
            mItem.addActionListener((NeuralWindow)this.window);
            this.pop.add(mItem);
            mItem = new JMenuItem("Step " + ((NeuralGraph)this.graph).getNumberOfIterations() + "X");
            mItem.addActionListener((NeuralWindow)this.window);
            this.pop.add(mItem);
            mItem.setEnabled(!((NeuralWindow)this.window).isStopEnabled());
            mItem = new JMenuItem("Step to Target Error");
            mItem.addActionListener((NeuralWindow)this.window);
            this.pop.add(mItem);
            mItem.setEnabled(!((NeuralWindow)this.window).isStopEnabled());
            mItem = new JMenuItem("Stop");
            mItem.addActionListener((NeuralWindow)this.window);
            this.pop.add(mItem);
            mItem.setEnabled(((NeuralWindow)this.window).isStopEnabled());
            mItem = new JMenuItem("Calculate Output");
            mItem.addActionListener((NeuralWindow)this.window);
            this.pop.add(mItem);
            mItem = new JMenuItem("Show Plot");
            mItem.addActionListener((NeuralWindow)this.window);
            this.pop.add(mItem);
            mItem = new JMenuItem("Summary Statistics");
            mItem.addActionListener((NeuralWindow)this.window);
            this.pop.add(mItem);
            mItem = new JMenuItem("View/Edit Examples");
            mItem.addActionListener((NeuralWindow)this.window);
            this.pop.add(mItem);
        }
        this.pop.addSeparator();
        this.pop.add(new JLabel("View Options"));
        mItem = new JMenuItem("Autoscale");
        mItem.addActionListener((NeuralWindow)this.window);
        this.pop.add(mItem);
        JMenu zp = new JMenu("Pan/Zoom");
        ButtonGroup zpGroup = new ButtonGroup();
        if (this.getRMode() == 4441) {
            zoom = new JRadioButtonMenuItem("Zoom", true);
            pan = new JRadioButtonMenuItem("Pan", false);
        } else {
            zoom = new JRadioButtonMenuItem("Zoom", false);
            pan = new JRadioButtonMenuItem("Pan", true);
        }
        zoom.setToolTipText("Zoom into certain area of graph");
        zoom.addActionListener((NeuralWindow)this.window);
        zpGroup.add(zoom);
        zp.add(zoom);
        pan.setToolTipText("Pan the graph to a different area on the canvas");
        pan.addActionListener((NeuralWindow)this.window);
        zp.add(pan);
        zpGroup.add(pan);
        this.pop.add(zp);
        mItem = new JMenuItem("Reset Labels");
        mItem.addActionListener(this);
        this.pop.add(mItem);
        this.pop.show(this, x, y);
    }

    @Override
    protected void popupNode(int x, int y) {
        this.pop.setBorder(BorderFactory.createTitledBorder("Node Options"));
        this.pop.removeAll();
        if (this.mode == 2220) {
            JMenuItem mItem = new JMenuItem("Create Edge");
            mItem.addActionListener(this);
            this.pop.add(mItem);
            mItem = new JMenuItem("Delete Node");
            mItem.addActionListener(this);
            this.pop.add(mItem);
            mItem = new JMenuItem("Set Properties of Node");
            mItem.addActionListener(this);
            this.pop.add(mItem);
            this.pop.show(this, x, y);
        }
    }

    @Override
    protected void popupEdge(int x, int y) {
        this.pop.removeAll();
        this.pop.setBorder(BorderFactory.createTitledBorder("Edge Options"));
        if (this.mode == 2220) {
            JMenuItem mItem = new JMenuItem("Set Properties of Edge");
            mItem.addActionListener(this);
            this.pop.add(mItem);
            mItem = new JMenuItem("Delete Edge");
            mItem.addActionListener(this);
            this.pop.add(mItem);
            this.pop.show(this, x, y);
        }
    }

    @Override
    public void reset() {
        double tempBound = ((NeuralGraph)this.graph).getInitParamBound();
        double tempValue = ((NeuralGraph)this.graph).getInitParamValue();
        boolean tempType = ((NeuralGraph)this.graph).getInitParamType();
        super.reset();
        this.graph = new NeuralGraph(this);
        ((NeuralGraph)this.graph).setInitParamBound(tempBound);
        ((NeuralGraph)this.graph).setInitParamValue(tempValue);
        ((NeuralGraph)this.graph).setInitParamType(tempType);
    }

    @Override
    public int print(Graphics g, PageFormat pf, int pi) throws PrinterException {
        if (pi >= 1) {
            return 1;
        }
        Point min = this.graph.getBound()[0];
        Point max = this.graph.getBound()[1];
        float midX = Math.abs(max.x - min.x) / 2.0f + min.x;
        float midY = Math.abs(max.y - min.y) / 2.0f + min.y;
        float graphScale = this.graph.getScale();
        this.zoomForPrinting();
        this.drawPrint((Graphics2D)g);
        this.graph.setScale(graphScale);
        this.moveGraphToPoint(new Point(midX, midY));
        return 0;
    }

    @Override
    protected void createNode(Entity ent, Point p) {
        if (ent == null || ent.type != 7770) {
            int graphIndex = this.graph.getNextIndex();
            NeuralNode node = new NeuralNode((NeuralGraph)this.graph);
            node.pos = p;
            this.nd = !this.inline ? new NodeDialog((JFrame)this.parent, (NeuralGraph)this.graph, graphIndex, "Node Properties Dialog", true, node) : new NodeDialog(null, (NeuralGraph)this.graph, graphIndex, "Node Properties", true, node);
            if (!this.nd.isCancelled()) {
                this.graph.addNode(node);
                ((NeuralGraph)this.graph).setIOParameters();
            }
            this.repaint();
        }
    }

    @Override
    protected void createEdge(Entity ent, Point p) {
        if (this.makingEdge == 1) {
            if (ent == null || ent.type != 7770) {
                this.makingEdge = 0;
            } else if (ent.type == 7770) {
                this.makingEdge = 2;
                this.to = (NeuralNode)ent;
                if (!this.to.equals(this.from)) {
                    ((NeuralNode)this.from).addChild(this.to);
                    ((NeuralNode)this.to).addParent(this.from);
                    NeuralEdge edge = new NeuralEdge((NeuralGraph)this.graph, this.from, this.to);
                    edge.setLabel(((NeuralGraph)this.graph).showParam);
                    this.graph.addEdge(edge);
                    if (((NeuralGraph)this.graph).cycleCheck()) {
                        ((NeuralGraph)this.graph).select(edge);
                        ((NeuralGraph)this.graph).deleteSelected();
                    }
                    ((NeuralGraph)this.graph).setInputOutputNodes(true);
                }
                this.makingEdge = 0;
            }
            if (this.tmpMode != -1) {
                this.submode = this.tmpMode;
            }
            this.tmpMode = -1;
        } else if (ent != null && ent.type == 7770) {
            this.from = (NeuralNode)ent;
            this.makingEdge = 1;
            this.mMovedPos.move(p);
        }
    }

    @Override
    protected void setEntProperties(Entity ent) {
        if (ent != null) {
            this.pause();
            if (this.inline) {
                if (ent.type == 7770) {
                    new NodeDialog(null, (NeuralGraph)this.graph, ((NeuralNode)ent).index, "Node Properties Dialog", true, (NeuralNode)ent);
                    this.graph.updateNodeSize((NeuralNode)ent);
                } else if (ent.type == 7771) {
                    new EdgeDialog(null, (NeuralEdge)ent);
                }
            } else if (ent.type == 7770) {
                new NodeDialog((JFrame)this.parent, (NeuralGraph)this.graph, ((NeuralNode)ent).index, "Node Properties Dialog", true, (NeuralNode)ent);
                this.graph.updateNodeSize((NeuralNode)ent);
            } else if (ent.type == 7771) {
                new EdgeDialog((JFrame)this.parent, (NeuralEdge)ent);
            }
            this.unpause();
        }
    }

    public String parseText(String all) {
        String errMsg = ((NeuralGraph)this.graph).parseText(all);
        if (errMsg.equals("OK")) {
            this.repaint();
            this.autoscale();
        }
        return errMsg;
    }

    public String parseXML(String all) {
        String errMsg = ((NeuralGraph)this.graph).parseXMLText(all);
        if (errMsg.equals("OK")) {
            this.repaint();
        }
        return errMsg;
    }

    public void openTextRep(boolean modify) {
        new NeuralTextFrame(this, ((NeuralGraph)this.graph).generateTextRep(), "Text Representation of the Graph", false, modify);
    }

    public void openXMLTextRep(boolean modify) {
        new NeuralTextFrame(this, ((NeuralGraph)this.graph).generateXMLTextRep(), "XML Text Representation of the Graph", true, modify);
    }

    public void openPrologTextRep() {
        new NeuralTextFrame(this, ((NeuralGraph)this.graph).generatePrologTextRep(), "Prolog Code for the Graph", false, false);
    }

    public boolean updateGraphFromText(String allText, boolean isXML) {
        NeuralGraph old = (NeuralGraph)this.graph;
        this.graph = new NeuralGraph(this);
        String errMessage = isXML ? ((NeuralGraph)this.graph).parseXMLText(allText) : ((NeuralGraph)this.graph).parseText(allText);
        if (errMessage.equals("OK")) {
            ((NeuralGraph)this.graph).setInputOutputNodes(true);
            this.repaint();
            return true;
        }
        this.graph = old;
        this.showMessage("Error", errMessage);
        return false;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        super.mouseClicked(e);
        Entity ent = this.graph.searchEntities(new Point(e.getX(), e.getY()));
        if (e.getModifiers() == 4) {
            return;
        }
        if (this.mode == 2221 && ent != null) {
            this.pause();
            if (this.inline) {
                if (ent.type == 7770) {
                    new NodeDialog(null, (NeuralGraph)this.graph, ((NeuralNode)ent).index, "Node Properties Dialog", false, (NeuralNode)ent);
                } else if (ent.type == 7771) {
                    new EdgeDialog(null, (NeuralEdge)ent);
                }
            } else if (ent.type == 7770) {
                new NodeDialog((JFrame)this.parent, (NeuralGraph)this.graph, ((NeuralNode)ent).index, "Node Properties Dialog", false, (NeuralNode)ent);
            } else if (ent.type == 7771) {
                new EdgeDialog((JFrame)this.parent, (NeuralEdge)ent);
            }
            this.unpause();
        }
    }

    @Override
    protected void aPerformed(ActionEvent e) {
        super.aPerformed(e);
        String arg = e.getActionCommand();
        if (arg.equals("Step")) {
            ((NeuralGraph)this.graph).step();
            this.repaint();
        } else if (arg.equals("Step " + ((NeuralGraph)this.graph).getNumberOfIterations() + "X")) {
            ((NeuralGraph)this.graph).autoStep();
            this.repaint();
        } else if (arg.equals("Step to Target Error")) {
            ((NeuralGraph)this.graph).runUntilFinished();
        } else if (arg.equals("Stop")) {
            ((NeuralGraph)this.graph).stop();
        } else if (arg.equals("Calculate Output")) {
            this.pause();
            if (!this.inline) {
                new CalculateOutputDialog((JFrame)((NeuralWindow)this.parent), (NeuralGraph)this.graph);
            } else {
                new CalculateOutputDialog(null, (NeuralGraph)this.graph);
            }
            this.unpause();
        } else if (arg.equals("Initialize Parameters")) {
            ((NeuralGraph)this.graph).initializeParaValues();
            this.setPromptLabel("Initialized Parameters");
        } else if (arg.equals("View/Edit Examples")) {
            this.pause();
            new ExampleDialog(this.parent, (NeuralGraph)this.graph, ((NeuralGraph)this.graph).getExampleList());
            this.unpause();
        } else if (arg.equals("Summary Statistics")) {
            this.pause();
            if (this.inline) {
                new TestStatisticsDialog(null, (NeuralGraph)this.graph);
            } else {
                new TestStatisticsDialog((JFrame)((NeuralWindow)this.parent), (NeuralGraph)this.graph);
            }
            this.unpause();
        }
        this.graph.deselectAll();
    }
}

