/*
 * Decompiled with CFR 0.152.
 */
package AIspace.neural;

import AIspace.XMLReader.XMLBlock;
import AIspace.XMLReader.XMLTree;
import AIspace.graphToolKit.Graph;
import AIspace.graphToolKit.elements.Edge;
import AIspace.graphToolKit.elements.Node;
import AIspace.graphToolKit.elements.Point;
import AIspace.neural.AutoStep;
import AIspace.neural.BackPropagation;
import AIspace.neural.ExampleList;
import AIspace.neural.InlineNeuralApplet;
import AIspace.neural.NeuralCanvas;
import AIspace.neural.NeuralWindow;
import AIspace.neural.PlotFrame;
import AIspace.neural.elements.NeuralEdge;
import AIspace.neural.elements.NeuralNode;
import AIspace.neural.intList.IntList;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Hashtable;
import java.util.Iterator;

public class NeuralGraph
extends Graph {
    private ArrayList<Node> inputNodes;
    private ArrayList<Node> outputNodes;
    private double learningRate;
    private double paramBound;
    private double paramValue;
    private boolean paramRandom;
    private int numberOfIterations;
    private ExampleList exampleList;
    public BackPropagation backPropagation;
    private int startingCount;
    public PlotFrame pFrame;
    private AutoStep auto;
    private double stoppingErrVal;
    public boolean showParam;
    private double momentum;
    public boolean standardized;
    public int dt = 100;
    private int errorType;
    private String shortDescription;
    private String detailedDescription;
    public static int CORRECT = 110;
    public static int INCORRECT = 111;
    public static int NO_PREDICTION = 112;
    public static int AVERAGE_SUMSQUARES = -1;
    public static int SUMSQUARES = -2;

    public NeuralGraph(NeuralCanvas canvas) {
        super(canvas);
        this.setLineWidth(2);
        this.learningRate = 0.2;
        this.numberOfIterations = 50;
        this.stoppingErrVal = 0.1;
        this.startingCount = 0;
        this.inputNodes = new ArrayList();
        this.outputNodes = new ArrayList();
        this.exampleList = new ExampleList();
        this.showParam = true;
        this.paramBound = 1.0;
        this.paramValue = 0.0;
        this.paramRandom = true;
        this.momentum = 0.0;
        this.standardized = false;
        this.errorType = SUMSQUARES;
        this.shortDescription = new String();
        this.detailedDescription = new String();
    }

    public void setErrorType(int errConst) {
        this.errorType = errConst;
    }

    public int getErrorType() {
        return this.errorType;
    }

    @Override
    public void addNode(Node node) {
        super.addNode(node);
        this.resetBackPropagation();
    }

    @Override
    public void addEdge(Edge edge) {
        super.addEdge(edge);
        if (this.paramsChanged()) {
            this.rebuildData();
        }
        this.resetBackPropagation();
    }

    public void addEdge(Edge edge, boolean rebuildData) {
        super.addEdge(edge);
        if (rebuildData && this.paramsChanged()) {
            this.rebuildData();
        }
        this.resetBackPropagation();
    }

    public boolean cycleCheck() {
        boolean returnValue = false;
        for (Node inputNode : this.inputNodes) {
            boolean bl = returnValue = returnValue || this.cycleDFS((NeuralNode)inputNode, null);
        }
        return returnValue;
    }

    private boolean cycleDFS(NeuralNode node, ArrayList<NeuralNode> path) {
        if (path == null) {
            path = new ArrayList();
        }
        if (path.contains(node)) {
            return true;
        }
        if (node.getNumChildrenNodes() == 0) {
            return false;
        }
        path.add(node);
        boolean returnValue = false;
        for (Node child : node.getChildrenNodes()) {
            boolean bl = returnValue = returnValue || this.cycleDFS((NeuralNode)child, path);
        }
        path.remove(node);
        return returnValue;
    }

    public boolean paramsChanged() {
        ArrayList<String> inputParameters = new ArrayList<String>();
        Iterator<Node> nodeItr = this.getNodes();
        while (nodeItr.hasNext()) {
            NeuralNode tmpNeuralNode = (NeuralNode)nodeItr.next();
            if (tmpNeuralNode.getParentNodes().size() + tmpNeuralNode.getChildrenNodes().size() == 0 || tmpNeuralNode.getParentNodes().size() != 0 && tmpNeuralNode.getChildrenNodes().size() != 0) continue;
            inputParameters.add(tmpNeuralNode.getLabel());
        }
        boolean paramsChanged = false;
        String[] params = this.exampleList.getParameters();
        if (params != null && params.length == inputParameters.size()) {
            int i = 0;
            while (i < params.length) {
                if (!params[i].equals(inputParameters.get(i))) {
                    paramsChanged = true;
                    break;
                }
                ++i;
            }
        } else {
            paramsChanged = true;
        }
        return paramsChanged;
    }

    public void rebuildData() {
        int numInputs = 0;
        ArrayList<String> nodeParams = new ArrayList<String>();
        ArrayList<String> outParams = new ArrayList<String>();
        Iterator<Node> nodeItr = this.getNodes();
        while (nodeItr.hasNext()) {
            NeuralNode tmpNeuralNode = (NeuralNode)nodeItr.next();
            if (tmpNeuralNode.getParentNodes().size() + tmpNeuralNode.getChildrenNodes().size() == 0) continue;
            if (tmpNeuralNode.getParentNodes().size() == 0) {
                nodeParams.add(tmpNeuralNode.getLabel());
                ++numInputs;
                continue;
            }
            if (tmpNeuralNode.getChildrenNodes().size() != 0) continue;
            outParams.add(tmpNeuralNode.getLabel());
        }
        nodeParams.addAll(outParams);
        String[] params = this.exampleList.getParameters();
        if (params != null) {
            if (params.length > nodeParams.size()) {
                this.removeExamplesUpdate(params, nodeParams);
            } else if (params.length < nodeParams.size()) {
                this.addExamplesUpdate(params, nodeParams, numInputs);
            } else {
                this.hiddenExamplesUpdate(params, nodeParams);
            }
        }
        if (nodeParams.size() == 0) {
            this.exampleList.resetAll();
        }
        if (nodeParams.size() > 0) {
            this.exampleList.setParameters(nodeParams.toArray(new String[0]));
        } else {
            this.exampleList.clearParams();
        }
    }

    private void hiddenExamplesUpdate(String[] params, ArrayList<String> nodeParams) {
        int oldIndex = -1;
        int newIndex = -1;
        int j = 0;
        while (j < params.length) {
            if (!nodeParams.contains(params[j])) {
                oldIndex = j;
                break;
            }
            ++j;
        }
        int i = 0;
        while (i < nodeParams.size()) {
            boolean found = false;
            int j2 = 0;
            while (j2 < params.length) {
                if (params[j2].equals(nodeParams.get(i))) {
                    found = true;
                    break;
                }
                ++j2;
            }
            if (!found) {
                newIndex = i;
                break;
            }
            ++i;
        }
        if (newIndex == -1 || oldIndex == -1) {
            return;
        }
        params[oldIndex] = nodeParams.get(newIndex);
        i = 0;
        while (i < nodeParams.size()) {
            nodeParams.set(i, params[i]);
            ++i;
        }
    }

    private void addExamplesUpdate(String[] params, ArrayList<String> nodeParams, int numInputs) {
        int[][] isOutNode = this.isOutputNode(params, nodeParams);
        int boolIndex = 0;
        while (boolIndex < isOutNode.length) {
            Hashtable<Integer, String> oneExample;
            boolean isNodeOutput = isOutNode[boolIndex][1] != 0;
            int nodeIndex = isOutNode[boolIndex][0];
            int nextNodeIndex = -1;
            int i = nodeIndex + 1;
            while (i < this.nodes.size()) {
                if (isNodeOutput && ((NeuralNode)this.nodeAt(i)).getNumChildrenNodes() == 0 && ((NeuralNode)this.nodeAt(i)).getNumParentNodes() > 0) {
                    nextNodeIndex = i;
                    break;
                }
                if (!isNodeOutput && ((NeuralNode)this.nodeAt(i)).getNumParentNodes() == 0 && ((NeuralNode)this.nodeAt(i)).getNumChildrenNodes() > 0) {
                    nextNodeIndex = i;
                    break;
                }
                ++i;
            }
            if (nextNodeIndex == -1) {
                nextNodeIndex = isNodeOutput ? nodeParams.size() - 1 : numInputs - 1;
            } else {
                String nodeLabel = ((NeuralNode)this.nodeAt(nextNodeIndex)).getLabel();
                int i2 = 0;
                while (i2 < params.length) {
                    if (nodeLabel.equals(params[i2])) {
                        nextNodeIndex = i2;
                        break;
                    }
                    ++i2;
                }
            }
            i = 0;
            while (i < this.exampleList.trainingData.size()) {
                oneExample = this.exampleList.trainingData.get(i);
                this.exampleList.updateTrainingExample(i, this.updateInsertExample(oneExample, nextNodeIndex));
                ++i;
            }
            i = 0;
            while (i < this.exampleList.testData.size()) {
                oneExample = this.exampleList.testData.get(i);
                this.exampleList.updateTestExample(i, this.updateInsertExample(oneExample, nextNodeIndex));
                ++i;
            }
            ++boolIndex;
        }
    }

    private void removeExamplesUpdate(String[] params, ArrayList nodeParams) {
        int[] indices = new int[params.length - nodeParams.size()];
        int indicesIndex = -1;
        int j = 0;
        while (j < params.length) {
            if (!nodeParams.contains(params[j])) {
                indices[++indicesIndex] = j;
            }
            ++j;
        }
        while (indicesIndex >= 0) {
            int i = 0;
            while (i < this.exampleList.trainingData.size()) {
                Hashtable<Integer, String> oneExample = this.exampleList.trainingData.get(i);
                this.exampleList.updateTrainingExample(i, this.updateRemoveExample(oneExample, indices[indicesIndex]));
                ++i;
            }
            i = 0;
            while (i < this.exampleList.testData.size()) {
                Hashtable<Integer, String> oneExample = this.exampleList.testData.get(i);
                this.exampleList.updateTestExample(i, this.updateRemoveExample(oneExample, indices[indicesIndex]));
                ++i;
            }
            --indicesIndex;
        }
    }

    private int[][] isOutputNode(String[] params, ArrayList<String> nodeParams) {
        int[][] isOutputNode = new int[nodeParams.size() - params.length][2];
        int boolIndex = 0;
        int i = 0;
        while (i < nodeParams.size()) {
            boolean found = false;
            int j = 0;
            while (j < params.length) {
                if (params[j].equals(nodeParams.get(i))) {
                    found = true;
                    break;
                }
                ++j;
            }
            if (!found) {
                int k = 0;
                while (k < this.nodes.size()) {
                    NeuralNode node = (NeuralNode)this.nodes.get(k);
                    if (node.getLabel().equals(nodeParams.get(i))) {
                        isOutputNode[boolIndex][0] = k;
                        if (node.getChildrenNodes().size() == 0) {
                            isOutputNode[boolIndex][1] = 1;
                        }
                    }
                    ++k;
                }
                ++boolIndex;
            }
            ++i;
        }
        return isOutputNode;
    }

    private Hashtable<Integer, String> updateInsertExample(Hashtable<Integer, String> oneExample, int nextNodeIndex) {
        int j = oneExample.size() - 1;
        while (j >= nextNodeIndex) {
            oneExample.put(new Integer(j + 1), oneExample.get(new Integer(j)));
            oneExample.remove(new Integer(j));
            --j;
        }
        oneExample.put(new Integer(nextNodeIndex), "0.0");
        return oneExample;
    }

    private Hashtable<Integer, String> updateRemoveExample(Hashtable<Integer, String> oneExample, int index) {
        oneExample.remove(new Integer(index));
        int j = index;
        while (j < oneExample.size()) {
            oneExample.put(new Integer(j), oneExample.get(new Integer(j + 1)));
            oneExample.remove(new Integer(j + 1));
            ++j;
        }
        return oneExample;
    }

    public void setLearningRate(double rate) {
        this.learningRate = rate;
        if (this.backPropagation != null) {
            this.backPropagation.setLearningRate(rate);
        }
    }

    public double getLearningRate() {
        return this.learningRate;
    }

    public void setNumberOfIterations(int iter) {
        this.numberOfIterations = iter;
    }

    public int getNumberOfIterations() {
        return this.numberOfIterations;
    }

    public void setStoppingErrVal(double val) {
        this.stoppingErrVal = val;
    }

    public double getStoppingErrVal() {
        return this.stoppingErrVal;
    }

    public void setInitParamBound(double val) {
        this.paramBound = val;
    }

    public double getInitParamBound() {
        return this.paramBound;
    }

    public void setInitParamValue(double val) {
        this.paramValue = val;
    }

    public double getInitParamValue() {
        return this.paramValue;
    }

    public void setInitParamType(boolean val) {
        this.paramRandom = val;
    }

    public boolean getInitParamType() {
        return this.paramRandom;
    }

    public ExampleList getExampleList() {
        return this.exampleList;
    }

    public void addTrainingExample(Integer[] indices, Double[] values) {
        String[] valueStringArray = new String[values.length];
        int i = 0;
        while (i < values.length) {
            valueStringArray[i] = values[i].toString();
            ++i;
        }
        this.exampleList.addTrainingExample(indices, valueStringArray);
    }

    public void addTestExample(Integer[] indices, Double[] values) {
        String[] valueStringArray = new String[values.length];
        int i = 0;
        while (i < values.length) {
            valueStringArray[i] = values[i].toString();
            ++i;
        }
        this.exampleList.addTestExample(indices, valueStringArray);
    }

    public ArrayList<Node> getInputNodes() {
        return this.inputNodes;
    }

    public ArrayList<Node> getOutputNodes() {
        return this.outputNodes;
    }

    public void setInputOutputNodes(boolean paint) {
        this.inputNodes = new ArrayList(5);
        this.outputNodes = new ArrayList(5);
        Iterator<Node> nodeItr = this.getNodes();
        while (nodeItr.hasNext()) {
            NeuralNode tmpNode = (NeuralNode)nodeItr.next();
            tmpNode.shape = 1110;
            tmpNode.setLabel(this.showParam);
            if (paint) {
                tmpNode.setColoring(true);
            }
            if (tmpNode.getNumParentNodes() == 0 && tmpNode.getNumChildrenNodes() > 0) {
                this.inputNodes.add(tmpNode);
                if (!paint) continue;
                tmpNode.shape = 1112;
                tmpNode.setColoring(false);
                continue;
            }
            if (tmpNode.getNumChildrenNodes() == 0 && tmpNode.getNumParentNodes() > 0) {
                tmpNode.shape = 1111;
                this.outputNodes.add(tmpNode);
                continue;
            }
            if (tmpNode.getNumChildrenNodes() + tmpNode.getNumParentNodes() != 0) continue;
            tmpNode.shape = 1111;
            tmpNode.setLabel(false);
        }
        int i = 0;
        while (i < this.numEdges()) {
            this.edgeAt(i).updateLength();
            ++i;
        }
        this.setIOParameters();
    }

    public void setExampleList(ExampleList e) {
        this.exampleList = e;
    }

    public void resetInputOutputNodes() {
        Iterator<Node> nodeItr = this.getNodes();
        while (nodeItr.hasNext()) {
            NeuralNode tmpNode = (NeuralNode)nodeItr.next();
            tmpNode.updateSize();
            tmpNode.color = Color.black;
            tmpNode.setColoring(false);
        }
        int i = 0;
        while (i < this.numEdges()) {
            this.edgeAt(i).updateLength();
            ++i;
        }
    }

    public void initializeParaValues() {
        if (this.paramRandom) {
            this.randomParaValues();
        } else {
            this.clearParaValues();
        }
    }

    public void randomParaValues() {
        this.stop();
        Iterator<Node> nodeItr = this.getNodes();
        while (nodeItr.hasNext()) {
            NeuralNode tmpNode = (NeuralNode)nodeItr.next();
            if (tmpNode.getNumParentNodes() <= 0) continue;
            tmpNode.setCurrentParaValue(2.0 * this.paramBound * Math.random() - this.paramBound);
        }
        for (Edge e : this.edges) {
            ((NeuralEdge)e).setCurrentParaValue(2.0 * this.paramBound * Math.random() - this.paramBound);
        }
        this.resetBackPropagation();
        this.repaint();
    }

    public void clearParaValues() {
        this.stop();
        Iterator<Node> nodeItr = this.getNodes();
        while (nodeItr.hasNext()) {
            NeuralNode tmpNode = (NeuralNode)nodeItr.next();
            if (tmpNode.getNumParentNodes() <= 0) continue;
            tmpNode.setCurrentParaValue(this.paramValue);
        }
        for (Edge e : this.edges) {
            ((NeuralEdge)e).setCurrentParaValue(this.paramValue);
        }
        this.resetBackPropagation();
        this.repaint();
    }

    public void resetParaValues() {
        this.stop();
        Iterator<Node> nodeItr = this.getNodes();
        while (nodeItr.hasNext()) {
            NeuralNode tmpNode = (NeuralNode)nodeItr.next();
            if (tmpNode.getNumParentNodes() <= 0) continue;
            tmpNode.setCurrentParaValue(tmpNode.getInitialParaValue());
        }
        for (Edge e : this.edges) {
            ((NeuralEdge)e).setCurrentParaValue(((NeuralEdge)e).getInitialParaValue());
        }
        this.resetBackPropagation();
        this.repaint();
    }

    public void setShowParam(boolean show) {
        this.showParam = show;
        Iterator nodeItr = this.nodes.iterator();
        while (nodeItr.hasNext()) {
            ((NeuralNode)nodeItr.next()).setLabel(this.showParam);
        }
        int i = 0;
        while (i < this.numEdges()) {
            NeuralEdge tmpEdge = (NeuralEdge)this.edgeAt(i);
            tmpEdge.setLabel(this.showParam);
            tmpEdge.updateLength();
            ++i;
        }
        this.repaint();
    }

    public void resetBackPropagation() {
        this.backPropagation = null;
        int i = 0;
        while (i < this.nodes.size()) {
            ((NeuralNode)this.nodes.get((int)i)).currentError = null;
            ++i;
        }
    }

    public void enableButtons(boolean bool) {
        if (!this.canvas.inline) {
            ((NeuralWindow)this.canvas.parent).enableButtons(bool);
        } else {
            ((InlineNeuralApplet)this.canvas.parent).enableButtons(bool);
        }
        if (this.pFrame != null) {
            this.pFrame.auto.setEnabled(bool);
            this.pFrame.run.setEnabled(bool);
            this.pFrame.stop.setEnabled(!bool);
        }
    }

    public void step() {
        if (this.backPropagation == null) {
            this.initBackProp();
        }
        this.backPropagation.nnlearn(1, this.learningRate, this.momentum);
        this.setPromptLabel("Step " + this.backPropagation.getIterationCount() + ", " + "Training Error: " + (double)Math.round(this.backPropagation.getCurrErr() * 10000.0) / 10000.0 + "\nTest Error: " + (double)Math.round(this.backPropagation.getCurrTestErr() * 10000.0) / 10000.0);
    }

    public void setTotalErrorAfterInitialization() {
        this.backPropagation = new BackPropagation(this, this.outputNodes, this.standardized);
        this.setPromptLabel("Initialized parameters.\nStep " + this.backPropagation.getIterationCount() + ": " + "Training Error: " + (double)Math.round(this.backPropagation.getCurrErr() * 10000.0) / 10000.0 + ", Test Error: " + (double)Math.round(this.backPropagation.getCurrTestErr() * 10000.0) / 10000.0);
    }

    public void stepTo(int x) {
        if (this.backPropagation == null) {
            this.initBackProp();
        }
        this.backPropagation.nnlearn(x, this.learningRate, this.momentum);
        this.setPromptLabel("Step " + this.backPropagation.getIterationCount() + ", " + "Training Error: " + (double)Math.round(this.backPropagation.getCurrErr() * 10000.0) / 10000.0 + "\nTest Error: " + (double)Math.round(this.backPropagation.getCurrTestErr() * 10000.0) / 10000.0);
    }

    public void autoStep() {
        if (this.autoStepAlive()) {
            return;
        }
        this.enableButtons(false);
        this.setPromptLabel("Starting Auto Step...");
        if (this.backPropagation == null) {
            this.initBackProp();
        }
        this.startingCount = this.backPropagation.getIterationCount();
        this.auto = new AutoStep(this, false);
        this.auto.start();
    }

    public void initBackProp() {
        this.backPropagation = new BackPropagation(this, this.outputNodes, this.standardized);
    }

    public boolean autoStepContinue() {
        if (this.backPropagation == null) {
            return false;
        }
        if (this.backPropagation.getIterationCount() - this.startingCount >= this.numberOfIterations) {
            this.setPromptLabel("Finished " + this.backPropagation.getIterationCount() + " steps.  Training Error: " + (double)Math.round(this.backPropagation.getCurrErr() * 10000.0) / 10000.0 + "\nTest Error: " + (double)Math.round(this.backPropagation.getCurrTestErr() * 10000.0) / 10000.0);
            return false;
        }
        return true;
    }

    public boolean runContinue() {
        if (this.backPropagation == null) {
            return false;
        }
        if (this.backPropagation.getStoppingError() <= this.stoppingErrVal) {
            this.setPromptLabel("Reached target training error of " + (double)Math.round(this.backPropagation.getCurrErr() * 10000.0) / 10000.0 + " after " + this.backPropagation.getIterationCount() + " steps." + "\nTest Error: " + (double)Math.round(this.backPropagation.getCurrTestErr() * 10000.0) / 10000.0);
            return false;
        }
        return true;
    }

    public void runUntilFinished() {
        if (this.autoStepAlive()) {
            return;
        }
        this.enableButtons(false);
        this.setPromptLabel("Running until finished...");
        if (this.backPropagation == null) {
            this.initBackProp();
        }
        this.startingCount = this.backPropagation.getIterationCount();
        this.auto = new AutoStep(this, true);
        this.auto.start();
    }

    public void stop() {
        if (this.auto != null) {
            this.auto.quit();
        }
        this.enableButtons(true);
        this.repaint();
    }

    public void autoStepEnd() {
        this.enableButtons(true);
        if (this.pFrame != null && this.pFrame.isVisible()) {
            this.pFrame.repaint();
        }
        this.repaint();
    }

    public boolean autoStepAlive() {
        if (this.auto == null) {
            return false;
        }
        return this.auto.isAlive();
    }

    public String parseText(String file) {
        this.clearGraph();
        String errorMessage = new String("");
        String inString = new String("");
        int p1 = -1;
        int p2 = file.indexOf("\n");
        int lineCount = 0;
        try {
            while (p2 != -1) {
                inString = file.substring(p1 + 1, p2).trim();
                if (inString.length() > 0) {
                    if (inString.charAt(0) != '%' && inString.indexOf(";") == -1) {
                        errorMessage = new String("Missing semicolon");
                        throw new Exception();
                    }
                    errorMessage = this.parseLine(inString.trim());
                    if (errorMessage.length() > 0) {
                        throw new Exception();
                    }
                }
                p1 = p2;
                p2 = file.indexOf("\n", p1 + 1);
                ++lineCount;
            }
            this.exampleList = new ExampleList();
            errorMessage = this.exampleList.parseString(file);
            while (errorMessage.equals("You must identify parameters before loading examples")) {
                errorMessage = this.exampleList.parseString(file);
            }
            if (!errorMessage.equals("OK")) {
                throw new Exception();
            }
            this.resetBackPropagation();
            this.learningRate = 0.2;
            return "OK";
        }
        catch (Exception e) {
            if (errorMessage.length() > 0) {
                return "Error at line " + (lineCount + 1) + " -- " + errorMessage;
            }
            return "Error at line " + (lineCount + 1) + " -- " + e.toString();
        }
    }

    public String parseXMLText(String file) {
        this.clearGraph();
        String errorMessage = new String("");
        try {
            XMLTree tree = new XMLTree();
            tree.readString(file);
            errorMessage = this.parseXML(tree);
            if (!errorMessage.equals("OK")) {
                throw new Exception();
            }
            this.exampleList = new ExampleList();
            errorMessage = this.exampleList.parseString(file);
            while (errorMessage.equals("You must identify parameters before loading examples")) {
                errorMessage = this.exampleList.parseString(file);
            }
            if (!errorMessage.equals("OK")) {
                throw new Exception();
            }
            this.resetBackPropagation();
            this.learningRate = 0.2;
            return "OK";
        }
        catch (Exception e) {
            String message = "";
            message = errorMessage.length() > 0 ? errorMessage : e.toString();
            return message;
        }
    }

    public String parseLine(String inString) {
        String errorMessage = new String("");
        if (inString.charAt(0) == 'N') {
            int p1 = inString.indexOf(",");
            int p2 = inString.indexOf(",", p1 + 1);
            String name = inString.substring(p1 + 1, p2).trim();
            p1 = p2;
            p2 = inString.indexOf(",", p1 + 1);
            float x = Float.parseFloat(inString.substring(p1 + 1, p2).trim());
            p1 = p2;
            p2 = inString.indexOf(",", p1 + 1);
            float y = Float.parseFloat(inString.substring(p1 + 1, p2).trim());
            Point pos = new Point(x, y);
            p1 = p2;
            p2 = inString.indexOf(";", p1 + 1);
            double paraValue = Double.parseDouble(inString.substring(p1 + 1, p2).trim());
            p1 = inString.indexOf(":");
            p2 = inString.indexOf(",");
            Integer ind = new Integer(inString.substring(p1 + 1, p2).trim());
            int index = ind;
            NeuralNode node = new NeuralNode(this);
            node.setLabel(name);
            node.pos = pos;
            node.setInitialParaValue(paraValue);
            node.setCurrentParaValue(paraValue);
            this.addNode(node);
            node.index = index;
        } else if (inString.charAt(0) == 'E') {
            int p1 = inString.indexOf(":");
            int p2 = inString.indexOf(",");
            int from = Integer.parseInt(inString.substring(p1 + 1, p2).trim());
            p1 = p2;
            p2 = inString.indexOf(",", p1 + 1);
            int to = Integer.parseInt(inString.substring(p1 + 1, p2).trim());
            p1 = p2;
            p2 = inString.indexOf(";", p1 + 1);
            double paraValue = Double.parseDouble(inString.substring(p1 + 1, p2).trim());
            NeuralNode fromNode = null;
            NeuralNode toNode = null;
            fromNode = (NeuralNode)this.nodeFromIndex(from);
            toNode = (NeuralNode)this.nodeFromIndex(to);
            if (fromNode == null) {
                errorMessage = new String("Error: Node " + from + " does not exist!");
            } else if (toNode == null) {
                errorMessage = new String("Error: Node " + to + " does not exist!");
            } else {
                fromNode.addChild(this.nodeAt(to));
                toNode.addParent(this.nodeAt(from));
                NeuralEdge edge = new NeuralEdge(this, (Node)fromNode, (Node)toNode);
                edge.setInitialParaValue(paraValue);
                edge.setCurrentParaValue(paraValue);
                edge.setLabel(this.showParam);
                this.addEdge(edge);
            }
        } else if (inString.charAt(0) != 'T' && inString.charAt(0) != 'X' && inString.charAt(0) != 'A' && inString.charAt(0) != 'B' && inString.charAt(0) != '%' && inString.charAt(0) != ' ' && inString.charAt(0) != '\n') {
            errorMessage = new String("Invalid format");
        }
        return errorMessage;
    }

    public String parseXML(XMLTree tree) {
        String errString = "";
        try {
            XMLBlock desc = tree.findNetworkTree("description");
            ArrayList<Object> sdescs = new ArrayList();
            ArrayList<Object> ldescs = new ArrayList();
            if (desc == null) {
                this.setShortDesc("");
                this.setDetailedDesc("");
            } else {
                sdescs = desc.searchChildTag("short");
                ldescs = desc.searchChildTag("detailed");
                if (sdescs == null || sdescs.size() == 0) {
                    this.setShortDesc("");
                } else {
                    this.setShortDesc(((XMLBlock)sdescs.get(0)).getText());
                }
                if (ldescs == null || ldescs.size() == 0) {
                    this.setDetailedDesc("");
                } else {
                    this.setDetailedDesc(((XMLBlock)ldescs.get(0)).getText());
                }
            }
            XMLBlock net = tree.findNetworkTree("network");
            if (net == null) {
                errString = "No Neural Network Defined";
                throw new Exception();
            }
            ArrayList<XMLBlock> nodes = net.searchChildTag("node");
            if (nodes == null) {
                errString = "No nodes defined";
                throw new Exception();
            }
            int i = 0;
            while (i < nodes.size()) {
                ArrayList<XMLBlock> ind;
                XMLBlock thisNode = nodes.get(i);
                ArrayList<XMLBlock> n = thisNode.searchChildTag("name");
                if (n == null) {
                    errString = "No name defined for a node";
                    throw new Exception();
                }
                String name = n.get(0).getText().trim();
                ArrayList<XMLBlock> xpos = thisNode.searchChildTag("xpos");
                ArrayList<XMLBlock> ypos = thisNode.searchChildTag("ypos");
                if (xpos == null) {
                    errString = "Node " + name + " has no x-position defined";
                    throw new Exception();
                }
                if (ypos == null) {
                    errString = "Node " + name + " has no y-position defined";
                    throw new Exception();
                }
                float x = Float.parseFloat(xpos.get(0).getText().trim());
                float y = Float.parseFloat(ypos.get(0).getText().trim());
                Point pos = new Point(x, y);
                ArrayList<XMLBlock> paraVal = thisNode.searchChildTag("weight");
                double paraValue = 0.0;
                if (paraVal != null) {
                    paraValue = Double.parseDouble(paraVal.get(0).getText().trim());
                }
                if ((ind = thisNode.searchChildTag("index")) == null) {
                    errString = "Node " + name + " does not have an index defined";
                    throw new Exception();
                }
                int index = Integer.parseInt(ind.get(0).getText().trim());
                ArrayList<XMLBlock> func = thisNode.searchChildTag("function");
                int funcType = 0;
                if (func != null) {
                    String type = func.get(0).getText().trim();
                    funcType = type.equalsIgnoreCase("exp") ? 3 : (type.equalsIgnoreCase("tanh") ? 2 : (type.equalsIgnoreCase("linear") ? 1 : 0));
                }
                NeuralNode node = new NeuralNode(this);
                node.setLabel(name);
                node.pos = pos;
                node.setInitialParaValue(paraValue);
                node.setCurrentParaValue(paraValue);
                node.functionType = funcType;
                this.addNode(node);
                node.index = index;
                ++i;
            }
            ArrayList<XMLBlock> edges = net.searchChildTag("edge");
            if (edges != null) {
                int i2 = 0;
                while (i2 < edges.size()) {
                    XMLBlock thisEdge = edges.get(i2);
                    ArrayList<XMLBlock> start = thisEdge.searchChildTag("startindex");
                    if (start == null) {
                        errString = "Start node for an edge is not defined";
                        throw new Exception();
                    }
                    ArrayList<XMLBlock> end = thisEdge.searchChildTag("endindex");
                    if (end == null) {
                        errString = "End node for an edge is not defined";
                        throw new Exception();
                    }
                    int startIndex = Integer.parseInt(start.get(0).getText().trim());
                    int endIndex = Integer.parseInt(end.get(0).getText().trim());
                    ArrayList<XMLBlock> paraVal = thisEdge.searchChildTag("weight");
                    double paraValue = 0.0;
                    if (paraVal != null) {
                        paraValue = Double.parseDouble(paraVal.get(0).getText().trim());
                    }
                    NeuralNode fromNode = (NeuralNode)this.nodeFromIndex(startIndex);
                    NeuralNode toNode = (NeuralNode)this.nodeFromIndex(endIndex);
                    if (fromNode == null) {
                        errString = "Node " + startIndex + " does not exist!";
                        throw new Exception();
                    }
                    if (toNode == null) {
                        errString = "Node " + endIndex + " does not exist!";
                        throw new Exception();
                    }
                    fromNode.addChild(this.nodeAt(endIndex));
                    toNode.addParent(this.nodeAt(startIndex));
                    NeuralEdge edge = new NeuralEdge(this, (Node)fromNode, (Node)toNode);
                    edge.setInitialParaValue(paraValue);
                    edge.setCurrentParaValue(paraValue);
                    edge.setLabel(this.showParam);
                    this.addEdge(edge);
                    ++i2;
                }
            }
        }
        catch (Exception e) {
            if (errString.length() > 0) {
                return "Error: " + errString;
            }
            return "Error: " + e.toString();
        }
        return "OK";
    }

    private String getNNLearnCode() {
        StringBuffer prologText = new StringBuffer();
        prologText.append("% Neural-net style learning for parameterized logic\n");
        prologText.append("% programs.  Given a set of examples, a parameterized\n");
        prologText.append("% logic program and a measure of error for each\n");
        prologText.append("% example, this program used back-propagation to tune\n");
        prologText.append("% the parameters. Derivatives are calculated analytically.\n");
        prologText.append("% The applet does NOT use this algorithm, although this will work.\n\n");
        prologText.append("% nnlearn(N,DX,LC,Exs,P0,P1)\n% N is the number of iterations to do\n");
        prologText.append("% DX is the increment to evaluate derivatives\n");
        prologText.append("% LC is the learning constant for gradient descent\n");
        prologText.append("% Exs is a list of all of the examples\n");
        prologText.append("% P0 is the list of parameter settings before the learning\n");
        prologText.append("% P1 is the list of parameter settings after the learning\n");
        prologText.append("nnlearn(0,_,_,Exs,P0,P0) :-\n\ttotal_error(Exs,P0,0,Err0),\n\twriteln(['Error = ', Err0]).\n");
        prologText.append("nnlearn(N,DX,LC,Exs,P0,P2) :-\n\tupdate_parms(DX,LC,Exs,P0,P1),\n");
        prologText.append("\tN1 is N-1,\n\tnnlearn(N1,DX,LC,Exs,P1,P2).\n\n");
        prologText.append("% update_parms(DX,LC,Exs,P0,P1).\n");
        prologText.append("% updates all of parameter in P0 to P1\n");
        prologText.append("update_parms(DX,LC,Exs,P0,P1) :-\n\ttotal_error(Exs,P0,0,Err0),\n");
        prologText.append("\twriteln(['Error = ', Err0]),\n\tupdate_each(P0,P0,Err0,Exs,DX,LC,P1).\n\n");
        prologText.append("% update_each(PR,P0,Err0,Exs,DX,LC,P1)\n");
        prologText.append("% updates each parameter in PR.\n");
        prologText.append("% P0 is the initial parameter setting with error Err0\n% Exs is a list of all of the examples\n");
        prologText.append("% DX is the increment to evaluate derivatives\n");
        prologText.append("% LC is the learning constant for gradient descent\n");
        prologText.append("% P1 is the updated parameter settings\nupdate_each([],_,_,_,_,_,[]).\n");
        prologText.append("update_each([val(P,V)|RPs],P0,Err0,Exs,DX,LC,\n\t\t\t\t\t\t\t\t\t\t[val(P,NV)|NPs]) :-\n");
        prologText.append("\tV1 is V+DX,\n\ttotal_error(Exs,[val(P,V1)|P0],0,Nerr),\n");
        prologText.append("\tNV is V+LC*(Err0-Nerr)/DX,\n\tupdate_each(RPs,P0,Err0,Exs,DX,LC,NPs).\n\n");
        prologText.append("% total_error(Exs,P,Err0,Err1)\n% P is a list of parameter settings\n");
        prologText.append("% Exs is a list of examples\n% Err1 is Err0 plus the sum of the errors on examples\n");
        prologText.append("total_error([],_,Err,Err).\ntotal_error([Ex|Exs],P,PErr,TErr) :-\n");
        prologText.append("\tpprove(error(Ex,Err),P),!,\n\tNErr is PErr+Err,\n\ttotal_error(Exs,P,NErr,TErr).\n\n");
        prologText.append("% `<-' is the object-level `if'\n:- op(1150, xfx, <- ).\n");
        prologText.append("% `&' is the object level conjunction.\n:- op(950,xfy, &).\n\n");
        prologText.append("% pprove(G,P) means prove G with parameter settings P.\n");
        prologText.append("% P is a list of the value assignments of the\n% form val(P,V)\n\n");
        prologText.append("pprove(true,_) :- !.\npprove((A & B),P) :-\n\t!,\n\tpprove(A,P),\n");
        prologText.append("\tpprove(B,P).\npprove((A is E),P) :-\n\t!,\n");
        prologText.append("\teval(E,A,P).\npprove(H,P) :-\n\t(H <- B),\n\tpprove(B,P).\n\n");
        prologText.append("% eval(E,V,P) true if expression E has value V\n");
        prologText.append("% given parameter settings P\neval((A+B),S,P) :-\n");
        prologText.append("\t!,\n\teval(A,VA,P),\n\teval(B,VB,P),\n\tS is VA+VB.\n");
        prologText.append("eval((A*B),S,P) :-\n\t!,\n\teval(A,VA,P),\n\teval(B,VB,P),\n");
        prologText.append("\tS is VA*VB.\neval((A-B),S,P) :-\n");
        prologText.append("\t!,\n\teval(A,VA,P),\n\teval(B,VB,P),\n\tS is VA-VB.\n");
        prologText.append("eval((A/B),S,P) :-\n\t!,\n\teval(A,VA,P),\n\teval(B,VB,P),\n");
        prologText.append("\tS is VA/VB.\neval(sigmoid(E),V,P) :-\n\t!,\n\teval(E,EV,P),\n");
        prologText.append("\tV is 1/(1+exp(-EV)).\neval(N,N,_) :-\n\tnumber(N),!.\n");
        prologText.append("eval(N,V,P) :-\n\tmember(val(N,V1),P),!,V=V1.\n\t\t% it only sees the first value for the parameter\n");
        prologText.append("eval(N,V,_) :-\n\twriteln(['Arithmetic Error: ',V,' is ',N]),fail.\n\n");
        prologText.append("member(A, [A|_]).\nmember(A, [H|L]) :- member(A, L).\n\n");
        prologText.append("writeln([]) :- nl.\nwriteln([X|Xs]) :- write(X), writeln(Xs).\n");
        return prologText.toString();
    }

    public String generatePrologTextRep() {
        NeuralEdge curEdge2;
        NeuralNode parentNode;
        Iterator<Node> indexItr;
        StringBuffer textBuffer;
        NeuralNode curNode2;
        Integer curIONodeIndex;
        Iterator<Node> ioNodeItr;
        StringBuffer prologText = new StringBuffer("% Auto-generated on ");
        prologText.append(Calendar.getInstance().getTime().toString()).append("\n\n");
        prologText.append(this.getNNLearnCode()).append("\n\n");
        prologText.append("% Example Data:\n% prop(Object,Attribute,Value)\n");
        Iterator<Hashtable<Integer, String>> exampleItr = this.getExampleList().getTrainingArrayList().iterator();
        int index = 1;
        while (exampleItr.hasNext()) {
            Hashtable<Integer, String> oneExample = exampleItr.next();
            ioNodeItr = this.inputNodes.iterator();
            while (ioNodeItr.hasNext()) {
                curIONodeIndex = ioNodeItr.next().getIndex();
                curNode2 = (NeuralNode)this.nodeFromIndex(curIONodeIndex);
                prologText.append("prop(e").append(index).append(", '");
                if (curNode2.getLabel().equals("")) {
                    prologText.append("node").append(curIONodeIndex);
                } else {
                    prologText.append(curNode2.getLabel());
                }
                prologText.append("', ").append(oneExample.get(curIONodeIndex)).append(") <- true.\n");
            }
            ioNodeItr = this.outputNodes.iterator();
            while (ioNodeItr.hasNext()) {
                curIONodeIndex = ioNodeItr.next().getIndex();
                curNode2 = (NeuralNode)this.nodeFromIndex(curIONodeIndex);
                if (oneExample.get(curIONodeIndex) == null) continue;
                prologText.append("prop(e").append(index).append(", '");
                if (curNode2.getLabel().equals("")) {
                    prologText.append("node").append(curIONodeIndex);
                } else {
                    prologText.append(curNode2.getLabel());
                }
                prologText.append("', ").append(oneExample.get(curIONodeIndex)).append(") <- true.\n");
            }
            prologText.append("\n");
            ++index;
        }
        prologText.append("\n");
        ioNodeItr = this.outputNodes.iterator();
        while (ioNodeItr.hasNext()) {
            curIONodeIndex = ioNodeItr.next().getIndex();
            curNode2 = (NeuralNode)this.nodeFromIndex(curIONodeIndex);
            prologText.append("predicted_prop(Obj, '");
            if (curNode2.getLabel().equals("")) {
                prologText.append("node").append(curIONodeIndex);
            } else {
                prologText.append(curNode2.getLabel());
            }
            prologText.append("', V) <-\n");
            textBuffer = new StringBuffer("\tV is sigmoid(w_" + curNode2.getParameterIndex());
            indexItr = curNode2.getParentNodes().iterator();
            index = 0;
            while (indexItr.hasNext()) {
                curIONodeIndex = indexItr.next().getIndex();
                parentNode = (NeuralNode)this.nodeFromIndex(curIONodeIndex);
                prologText.append("\tprop(Obj, '");
                if (parentNode.getLabel().equals("")) {
                    prologText.append("node").append(curIONodeIndex);
                } else {
                    prologText.append(parentNode.getLabel());
                }
                prologText.append("', I_").append(index).append(") &\n");
                curEdge2 = (NeuralEdge)this.getEdge(parentNode.getIndex(), curNode2.getIndex());
                if (curEdge2 != null) {
                    textBuffer.append(" + w_").append(curEdge2.getParameterIndex());
                }
                textBuffer.append(" * I_").append(index++);
            }
            prologText.append(textBuffer).append(").\n\n");
        }
        for (NeuralNode curNode2 : this.nodes) {
            if (curNode2.getNumParentNodes() <= 0 || curNode2.getNumChildrenNodes() <= 0) continue;
            prologText.append("prop(Obj, '");
            if (curNode2.getLabel().equals("")) {
                prologText.append("node").append(curNode2.getIndex());
            } else {
                prologText.append(curNode2.getLabel());
            }
            prologText.append("', V) <-\n");
            textBuffer = new StringBuffer("\tV is sigmoid(w_" + curNode2.getParameterIndex());
            indexItr = curNode2.getParentNodes().iterator();
            index = 0;
            while (indexItr.hasNext()) {
                curIONodeIndex = indexItr.next().getIndex();
                parentNode = (NeuralNode)this.nodeFromIndex(curIONodeIndex);
                prologText.append("\tprop(Obj, '");
                if (parentNode.getLabel().equals("")) {
                    prologText.append("node").append(curIONodeIndex);
                } else {
                    prologText.append(parentNode.getLabel());
                }
                prologText.append("', I_").append(index).append(") &\n");
                curEdge2 = (NeuralEdge)this.getEdge(parentNode.getIndex(), curNode2.getIndex());
                if (curEdge2 != null) {
                    textBuffer.append(" + w_").append(curEdge2.getParameterIndex());
                }
                textBuffer.append(" * I_").append(index++);
            }
            prologText.append(textBuffer).append(").\n\n");
        }
        prologText.append("error(Obj, E) <-\n");
        textBuffer = new StringBuffer("\tE is ");
        ioNodeItr = this.outputNodes.iterator();
        index = 1;
        while (ioNodeItr.hasNext()) {
            curIONodeIndex = ioNodeItr.next().getIndex();
            curNode2 = (NeuralNode)this.nodeFromIndex(curIONodeIndex);
            String name = curNode2.getLabel().equals("") ? "node" + curIONodeIndex : curNode2.getLabel();
            prologText.append("\tpredicted_prop(Obj, '").append(name).append("', VC_").append(index).append(") &\n");
            prologText.append("\tprop(Obj, ").append(name).append("', V_").append(index).append(") &\n");
            textBuffer.append("(VC_").append(index).append(" - V_").append(index).append(") * (VC_").append(index).append(" - V_").append(index).append(")");
            if (!ioNodeItr.hasNext()) continue;
            textBuffer.append(" + ");
        }
        prologText.append(textBuffer).append(".\n\n\n");
        prologText.append("% Example Query:\n% ?nnlearn(50, 0.01, 1.0, [");
        exampleItr = this.getExampleList().getTrainingArrayList().iterator();
        index = 1;
        while (exampleItr.hasNext()) {
            prologText.append("e").append(index++);
            exampleItr.next();
            if (!exampleItr.hasNext()) continue;
            prologText.append(", ");
        }
        prologText.append("], [");
        Iterator nodeItr = this.nodes.iterator();
        while (nodeItr.hasNext()) {
            curNode2 = (NeuralNode)nodeItr.next();
            if (curNode2.getNumParentNodes() <= 0) continue;
            prologText.append("val(w_").append(curNode2.getParameterIndex()).append(", ");
            prologText.append(curNode2.getInitialParaValue()).append(")");
            if (!nodeItr.hasNext()) continue;
            prologText.append(", ");
        }
        for (NeuralEdge curEdge2 : this.edges) {
            prologText.append(", val(w_").append(curEdge2.getParameterIndex()).append(", ");
            prologText.append(curEdge2.getInitialParaValue()).append(")");
        }
        prologText.append("], P1).\n");
        return prologText.toString();
    }

    public String generateTextRep() {
        Calendar now = Calendar.getInstance();
        StringBuffer textBuffer = new StringBuffer("% Auto-generated on ");
        textBuffer.append(now.getTime().toString()).append("\n\n");
        textBuffer.append("% Nodes\n% N: index, node_name, x_position, y_position, parameter_value;\n");
        for (NeuralNode curNode : this.nodes) {
            textBuffer.append("N: ").append(curNode.getIndex()).append(", ");
            if (curNode.getLabel().equals("")) {
                textBuffer.append("Node ").append(curNode.getIndex());
            } else {
                textBuffer.append(curNode.getLabel());
            }
            textBuffer.append(", ").append(curNode.pos.x).append(", ").append(curNode.pos.y);
            textBuffer.append(", ").append(curNode.getCurrentParaValue()).append(";\n");
        }
        textBuffer.append("\n% Edges\n");
        textBuffer.append("% E: from_node_index, to_node_index, parameter_value;\n");
        for (NeuralEdge curEdge : this.edges) {
            textBuffer.append("E: ").append(((NeuralNode)curEdge.start).getIndex()).append(", ");
            textBuffer.append(((NeuralNode)curEdge.end).getIndex()).append(", ").append(curEdge.getCurrentParaValue()).append(";\n");
        }
        textBuffer.append("\n% Examples\n");
        textBuffer.append("% T: input1's title, input2's title, ..., output1's title, output2's title, ...;\n");
        textBuffer.append("% \t note that the order must be input nodes in ascending index order, \n% \t followed by output nodes in ascending index order.\n");
        textBuffer.append("% A: or X: training - input1's value, input2's value, ..., output1's value, output2's value, ...;\n");
        textBuffer.append("% B: test - input1's value, input2's value, ..., output1's value, output2's value, ...;\n");
        if (this.exampleList != null && (this.exampleList.getTrainingArrayList().size() > 0 || this.exampleList.getTestArrayList().size() > 0)) {
            textBuffer.append(this.exampleList.generateTextRep());
        } else {
            textBuffer.append("% NO TEST AND TRAINING EXAMPLES\n");
        }
        return textBuffer.toString();
    }

    public String generateXMLTextRep() {
        StringBuffer xmlText = new StringBuffer("<?xml version=\"1.0\" ?>\n<MLDBIF>\n");
        xmlText.append("<DB>\n\n");
        xmlText.append("<DESCRIPTION>\n\t<SHORT>").append(this.getShortDesc()).append("</SHORT>");
        xmlText.append("\n\t<DETAILED>").append(this.getDetailedDesc()).append("</DETAILED>\n</DESCRIPTION>\n\n");
        xmlText.append("<!-- Neural Network Definition -->\n<NETWORK>\n");
        if (this.numNodes() > 0) {
            xmlText.append("\n\t<!-- Node Definitions -->\n\n");
        }
        for (NeuralNode curNode : this.nodes) {
            xmlText.append("\t<NODE>\n\t\t<NAME>");
            if (curNode.getLabel().equals("")) {
                xmlText.append("Node ").append(curNode.getIndex());
            } else {
                xmlText.append(curNode.getLabel());
            }
            xmlText.append("</NAME>\n\t\t<WEIGHT>").append(curNode.getCurrentParaValue()).append("</WEIGHT>\n");
            xmlText.append("\t\t<XPOS>").append(curNode.pos.x).append("</XPOS>\n");
            xmlText.append("\t\t<YPOS>").append(curNode.pos.y).append("</YPOS>\n");
            xmlText.append("\t\t<INDEX>").append(curNode.getIndex()).append("</INDEX>\n");
            switch (curNode.functionType) {
                case 1: {
                    xmlText.append("\t\t<FUNCTION>linear</FUNCTION>\n");
                    break;
                }
                case 2: {
                    xmlText.append("\t\t<FUNCTION>tanh</FUNCTION>\n");
                    break;
                }
                case 3: {
                    xmlText.append("\t\t<FUNCTION>exp</FUNCTION>\n");
                    break;
                }
                case 0: {
                    xmlText.append("\t\t<FUNCTION>sigmoid</FUNCTION>\n");
                }
            }
            xmlText.append("\t</NODE>\n");
        }
        if (this.numEdges() > 0) {
            xmlText.append("\n\t<!-- Edge Definitions -->\n\n");
        }
        int i = 0;
        while (i < this.numEdges()) {
            NeuralEdge edge = (NeuralEdge)this.edgeAt(i);
            xmlText.append("\t<EDGE>\n");
            xmlText.append("\t\t<STARTINDEX>").append(((NeuralNode)edge.start).getIndex()).append("</STARTINDEX>\n");
            xmlText.append("\t\t<ENDINDEX>").append(((NeuralNode)edge.end).getIndex()).append("</ENDINDEX>\n");
            xmlText.append("\t\t<WEIGHT>").append(edge.getCurrentParaValue()).append("</WEIGHT>\n");
            xmlText.append("\t</EDGE>\n");
            ++i;
        }
        xmlText.append("\n</NETWORK>\n\n");
        xmlText.append(this.exampleList.generateXMLTextRep());
        xmlText.append("</DB>\n");
        xmlText.append("</MLDBIF>\n\n");
        return xmlText.toString();
    }

    @Override
    public void deleteSelected() {
        for (Edge curEdge : this.selectedEdges) {
            NeuralNode tmpNode = (NeuralNode)curEdge.end;
            NeuralNode tmpNode2 = (NeuralNode)curEdge.start;
            tmpNode.removeParent(tmpNode2);
            tmpNode2.removeChild(tmpNode);
            curEdge.removeFromNodes();
            this.edges.remove(curEdge);
            if (!this.paramsChanged()) continue;
            this.rebuildData();
        }
        this.selectedEdges.clear();
        for (Node curNode : this.selectedNodes) {
            Edge curEdge;
            Iterator<Node> nodeItr2 = this.getNodes();
            while (nodeItr2.hasNext()) {
                NeuralNode tmpNode = (NeuralNode)nodeItr2.next();
                tmpNode.removeParent(curNode);
                tmpNode.removeChild(curNode);
            }
            ArrayList<Edge>[] allNodeEdges = curNode.getAllEdges();
            while (allNodeEdges[0].size() > 0) {
                curEdge = allNodeEdges[0].get(0);
                curEdge.removeFromNodes();
                this.edges.remove(curEdge);
            }
            while (allNodeEdges[1].size() > 0) {
                curEdge = allNodeEdges[1].get(0);
                curEdge.removeFromNodes();
                this.edges.remove(curEdge);
            }
            this.removeNode(curNode);
            if (!this.paramsChanged()) continue;
            this.rebuildData();
        }
        this.selectedNodes.clear();
        this.setInputOutputNodes(true);
        this.backPropagation = null;
    }

    public void showPlot() {
        if (this.pFrame == null) {
            this.pFrame = new PlotFrame(this);
        }
        this.pFrame.open();
    }

    public void clearPlotFrame() {
        if (this.pFrame != null) {
            this.pFrame.clear();
        }
    }

    public void clear() {
        if (this.pFrame != null) {
            this.pFrame.clear();
            this.pFrame.setVisible(false);
        }
    }

    public IntList[] getPlotVals() {
        if (this.backPropagation == null) {
            return null;
        }
        return this.backPropagation.getPlotVals();
    }

    public IntList[] getTestPlotVals() {
        if (this.backPropagation == null) {
            return null;
        }
        return this.backPropagation.getTestPlotVals();
    }

    public double totalError() {
        if (this.backPropagation == null) {
            return 0.1;
        }
        return this.backPropagation.getCurrErr();
    }

    public void updatePlot() {
        if (this.pFrame != null && this.pFrame.isVisible()) {
            this.pFrame.repaint();
        }
    }

    public String outputValue(String[] valueArray, int outputIndex) {
        return this.nodeValue(valueArray, this.outputNodes.get(outputIndex));
    }

    public String nodeValue(String[] valueArray, Node node) {
        double value = 0.0;
        try {
            int numInputs = this.inputNodes.size();
            Double[] values = new Double[numInputs];
            int i = 0;
            while (i < numInputs) {
                values[i] = Double.valueOf(valueArray[i]);
                ++i;
            }
            if (this.backPropagation == null) {
                this.initBackProp();
            }
            value = this.backPropagation.solveNodeOutput(node.getIndex(), values);
            value = (double)Math.round(value * 10000.0) / 10000.0;
        }
        catch (NumberFormatException e) {
            System.err.println("Number format error");
        }
        return Double.toString(value);
    }

    public ArrayList<Integer> getTestExampleIndices(int indexMode, double range, int outputIndex) {
        ArrayList<Integer> exampleIndices = new ArrayList<Integer>();
        ArrayList<Hashtable<Integer, String>> testSet = this.exampleList.getTestArrayList();
        int i = 0;
        while (i < testSet.size()) {
            int currIndex = this.inputNodes.size() + outputIndex;
            double value = Double.parseDouble(testSet.get(i).get(new Integer(currIndex)));
            String[] stringInputs = new String[this.inputNodes.size()];
            int j = 0;
            while (j < stringInputs.length) {
                stringInputs[j] = testSet.get(i).get(new Integer(j));
                ++j;
            }
            double neuralValue = Double.parseDouble(this.outputValue(stringInputs, outputIndex));
            if (indexMode == CORRECT) {
                if (Math.abs(value - neuralValue) < range) {
                    exampleIndices.add(new Integer(i));
                }
            } else if (indexMode == INCORRECT) {
                if (Math.abs(value - neuralValue) >= range) {
                    exampleIndices.add(new Integer(i));
                }
            } else if (!(Math.abs(value - neuralValue) < range) && !(Math.abs(value - neuralValue) >= range)) {
                exampleIndices.add(new Integer(i));
            }
            ++i;
        }
        return exampleIndices;
    }

    public void setIOParameters() {
        int i = 0;
        while (i < this.inputNodes.size() + this.outputNodes.size()) {
            if (i < this.inputNodes.size()) {
                this.exampleList.setInputParam(true, i);
            } else {
                this.exampleList.setInputParam(false, i);
            }
            ++i;
        }
    }

    public void clearPlotPts() {
        if (this.backPropagation == null) {
            return;
        }
        this.backPropagation.clearPlotPts();
    }

    public void disposeWindows() {
        if (this.pFrame != null) {
            this.pFrame.dispose();
        }
    }

    public void setMomentum(double m) {
        this.momentum = m;
    }

    public double getMomentum() {
        return this.momentum;
    }

    public String getShortDesc() {
        return this.shortDescription;
    }

    public void setShortDesc(String description) {
        this.shortDescription = description;
        if (description.trim().equals("") || description == null) {
            this.shortDescription = "";
        }
    }

    public String getDetailedDesc() {
        return this.detailedDescription;
    }

    public void setDetailedDesc(String description) {
        this.detailedDescription = description;
        if (description.trim().equals("") || description == null) {
            this.detailedDescription = "";
        }
    }
}

