/*
 * Decompiled with CFR 0.152.
 */
package AIspace.neural;

import AIspace.graphToolKit.GraphWindow;
import AIspace.graphToolKit.dialogs.MessageDialog;
import AIspace.graphToolKit.dialogs.OpenLocationDialog;
import AIspace.graphToolKit.help.HelpFrame;
import AIspace.graphToolKit.help.HelpMenu;
import AIspace.neural.ExampleList;
import AIspace.neural.Legend;
import AIspace.neural.NeuralCanvas;
import AIspace.neural.NeuralGraph;
import AIspace.neural.dialogs.CalculateOutputDialog;
import AIspace.neural.dialogs.ExampleDialog;
import AIspace.neural.dialogs.InitializationOptionsDialog;
import AIspace.neural.dialogs.LearningOptionsDialog;
import AIspace.neural.dialogs.NeuralDescriptionDialog;
import AIspace.neural.dialogs.NeuralProblemDialog;
import AIspace.neural.dialogs.NeuralWizard;
import AIspace.neural.dialogs.ParameterInputDialog;
import AIspace.neural.dialogs.StoppingOptionsDialog;
import AIspace.neural.dialogs.TestStatisticsDialog;
import AIspace.neural.help.NeuralHelpCanvas;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.URL;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;

public class NeuralWindow
extends GraphWindow {
    private static final long serialVersionUID = 1L;
    private StoppingOptionsDialog sod;
    private LearningOptionsDialog lod;
    private InitializationOptionsDialog iod;
    private JMenu speed;
    private JMenuItem initialization;
    private JMenuItem stopping;
    private JMenuItem learning;
    private JMenuItem textRepresentationMenuItem;
    private JMenuItem xmlRepresentationMenuItem;
    private JMenuItem descriptionMenuItem;
    private JCheckBoxMenuItem showParam;
    private JButton fakeButton;
    private boolean showParameters;
    protected NeuralWizard wizard;
    protected ImageIcon stepIcon;
    protected ImageIcon fineStepIcon;
    protected ImageIcon autoSearchIcon;
    protected ImageIcon stepTargetIcon;
    protected ImageIcon stopIcon;
    protected ImageIcon resetIcon;
    protected ImageIcon quizIcon;
    protected ImageIcon invertGraphIcon;
    protected ImageIcon sumStatIcon;
    protected ImageIcon showPlotIcon;
    protected ImageIcon editIcon;
    protected ImageIcon randomIcon;

    public NeuralWindow(JApplet parent) {
        super(parent);
        this.narrowLine.setSelected(false);
        this.mediumLine.setSelected(true);
        this.wideLine.setSelected(false);
        this.initializeAppletInfo();
        this.setTitle(String.valueOf(appletTitle) + " --- untitled.txt");
        this.setSize(955, 700);
        this.switchTab("Create");
        this.initialize();
        this.construct();
        this.centerWindow();
        this.setVisible(true);
    }

    private void initializeAppletInfo() {
        appletTitle = "Neural Applet Version 4.3.8";
        appletName = "neural";
        aboutText = String.valueOf(appletTitle) + "\n\n" + "Inspired by neurons and their connections in the brain, neural network\n" + "is a representation used in machine learning. After running the\n" + "back-propagation learning algorithm on a given set of examples,\n" + "the neural network can be used to predict outcomes for any set of\n" + "input values.\n\n" + "This applet was written by Kevin O'Neill, Shinjiro Sueda, Leslie Tung,\n" + "Joseph Roy Santos, Nicole Arksey, Kyle Porter, and Byron Knoll, with\n" + "help from Mike Cline, Holger Hoos, Peter Gorniak, Cristina Conati,\n" + "Alan Mackworth, and David Poole.";
    }

    private void construct() {
        JPanel bottom = new JPanel();
        bottom.add(new JLabel("Color Key:", 4));
        bottom.add(new Legend());
        this.bottomPanel.add(bottom);
    }

    private void initialize() {
        this.stepIcon = NeuralWindow.createImageIcon("images/neural/step.png");
        this.fineStepIcon = NeuralWindow.createImageIcon("images/common/finestep.png");
        this.randomIcon = NeuralWindow.createImageIcon("images/neural/randomPara.png");
        this.stopIcon = NeuralWindow.createImageIcon("images/neural/stop.gif");
        this.editIcon = NeuralWindow.createImageIcon("images/neural/Edit24.gif");
        this.showPlotIcon = NeuralWindow.createImageIcon("images/neural/showPlot.png");
        this.sumStatIcon = NeuralWindow.createImageIcon("images/neural/History24.gif");
        this.quizIcon = NeuralWindow.createImageIcon("images/neural/quiz.gif");
        this.stepTargetIcon = NeuralWindow.createImageIcon("images/neural/stepTarget.png");
        this.solveToolBarWithText();
        this.toolBar.setVisible(false);
        this.createToolBarWithText();
        this.toolBar.setVisible(true);
        this.stopping.setEnabled(false);
        this.learning.setEnabled(false);
        this.speed.setEnabled(false);
        this.returnCanvas().setSubmode(3330);
        this.setPromptLabel("Click the canvas to create a node.");
        this.createButModes[1].setSelected(true);
    }

    @Override
    protected void getCanvas() {
        this.canvas = new NeuralCanvas(this, false);
        this.canvas.setPreferredSize(new Dimension(15000, 10000));
        this.scrollPanel = new JScrollPane(this.canvas, 20, 30);
        this.scrollPanel.setPreferredSize(new Dimension(500, 400));
        this.scrollPanel.getHorizontalScrollBar().setMaximum(15000);
        this.scrollPanel.getHorizontalScrollBar().setValue(7500);
        this.scrollPanel.getVerticalScrollBar().setMaximum(10000);
        this.scrollPanel.getVerticalScrollBar().setValue(5000);
    }

    protected void resetCanvas() {
        int speed = ((NeuralGraph)this.canvas.graph).dt;
        this.canvas.reset();
        this.iod = new InitializationOptionsDialog((JFrame)this, (NeuralGraph)this.canvas.graph, false);
        ((NeuralGraph)this.canvas.graph).dt = speed;
    }

    @Override
    protected void createToolBar() {
        this.createButModes = new JToggleButton[7];
        this.setCreateButtons(0, this.editIcon, "View/Edit Examples");
        this.setCreateButtons(1, this.createNodeIcon, "Create Node");
        this.setCreateButtons(2, this.createEdgeIcon, "Create Edge");
        this.setCreateButtons(3, this.selectIcon, "Select");
        this.setCreateButtons(4, this.deleteIcon, "Delete");
        this.setCreateButtons(5, this.setPropsIcon, "Set Properties");
        this.createToolBarLayout();
    }

    @Override
    protected void createToolBarWithText() {
        this.createButModes = new JToggleButton[7];
        this.setCreateButtonsWithText(0, "View/Edit Examples", this.editIcon, "View/Edit Examples");
        this.setCreateButtonsWithText(1, "Create Node", this.createNodeIcon, "Create Node");
        this.setCreateButtonsWithText(2, "Create Edge", this.createEdgeIcon, "Create Edge");
        this.setCreateButtonsWithText(3, "   Select   ", this.selectIcon, "Select");
        this.setCreateButtonsWithText(4, "   Delete   ", this.deleteIcon, "Delete");
        this.setCreateButtonsWithText(5, "Set Properties", this.setPropsIcon, "Set Properties");
        this.createToolBarLayout();
    }

    private void createToolBarLayout() {
        this.toolBar.removeAll();
        this.createModeButGroup = new ButtonGroup();
        this.createModeButGroup.add(this.fakeButton);
        int i = 0;
        while (i <= 5) {
            if (i == 1) {
                this.toolBar.addSeparator();
            }
            this.createModeButGroup.add(this.createButModes[i]);
            this.toolBar.add(this.createButModes[i]);
            this.createButModes[i].setFont(this.toolBarFont);
            ++i;
        }
        this.algoText.setText(" ");
    }

    @Override
    public void solveToolBarWithText() {
        super.solveToolBar();
        this.solveButModes = new JToggleButton[10];
        this.setSolveButtonsWithText(0, "View/Edit Examples", this.editIcon, "View/Edit Examples");
        this.setSolveButtonsWithText(1, " Initialize Parameters", this.randomIcon, "Initialize Parameters");
        this.setSolveButtonsWithText(2, "      Step      ", this.stepIcon, "Step");
        this.setSolveButtonsWithText(3, "Step " + ((NeuralGraph)this.canvas.graph).getNumberOfIterations() + "X", this.fineStepIcon, "Step " + ((NeuralGraph)this.canvas.graph).getNumberOfIterations() + "X");
        this.setSolveButtonsWithText(4, "Step to Target Error", this.stepTargetIcon, "Step to Target Error");
        this.setSolveButtonsWithText(5, "     Stop      ", this.stopIcon, "Stop ");
        this.setSolveButtonsWithText(6, " Calculate Output  ", this.quizIcon, "Calculate Output");
        this.setSolveButtonsWithText(7, "     Show Plot   ", this.showPlotIcon, "Show Plot");
        this.setSolveButtonsWithText(8, "Summary Statistics", this.sumStatIcon, "Summary Statistics");
        this.solveToolBarLayout();
    }

    @Override
    public void solveToolBar() {
        super.solveToolBar();
        this.solveButModes = new JToggleButton[9];
        this.setSolveButtons(0, this.editIcon, "View/Edit Examples");
        this.setSolveButtons(1, this.randomIcon, "Initialize Parameters");
        this.setSolveButtons(2, this.stepIcon, "Step");
        this.setSolveButtons(3, this.fineStepIcon, "Step " + ((NeuralGraph)this.canvas.graph).getNumberOfIterations() + "X");
        this.setSolveButtons(4, this.stepTargetIcon, "Step to Target Error");
        this.setSolveButtons(5, this.stopIcon, "Stop Search");
        this.setSolveButtons(6, this.quizIcon, "Calculate Output");
        this.setSolveButtons(7, this.showPlotIcon, "Show Plot");
        this.setSolveButtons(8, this.sumStatIcon, "Summary Statistics");
        this.solveToolBarLayout();
    }

    private void solveToolBarLayout() {
        this.solveModeButGroup = new ButtonGroup();
        this.fakeButton = new JButton();
        this.solveModeButGroup.add(this.fakeButton);
        int i = 0;
        while (i < 9) {
            if (i == 1) {
                this.toolBar.addSeparator();
            }
            this.solveModeButGroup.add(this.solveButModes[i]);
            this.toolBar.add(this.solveButModes[i]);
            this.solveButModes[i].setFont(this.toolBarFont);
            ++i;
        }
        this.solveButModes[5].setEnabled(false);
    }

    @Override
    protected void createNewGraph() {
        this.setTitle(String.valueOf(appletTitle) + " --- untitled.txt");
        this.returnCanvas().reset();
    }

    @Override
    public void switchTab(String str) {
        super.switchTab(str);
        if (str == "Create") {
            this.textRepresentationMenuItem.setText("View/Edit Text Representation");
            this.textRepresentationMenuItem.setActionCommand(this.textRepresentationMenuItem.getText());
            this.xmlRepresentationMenuItem.setText("View/Edit XML Representation");
            this.xmlRepresentationMenuItem.setActionCommand(this.xmlRepresentationMenuItem.getText());
            this.descriptionMenuItem.setText("View/Edit Graph and Data Description");
            this.descriptionMenuItem.setActionCommand(this.descriptionMenuItem.getText());
            this.speed.setEnabled(false);
            this.stopping.setEnabled(false);
            this.learning.setEnabled(false);
        } else if (str == "Solve") {
            this.textRepresentationMenuItem.setText("View Text Representation");
            this.textRepresentationMenuItem.setActionCommand(this.textRepresentationMenuItem.getText());
            this.xmlRepresentationMenuItem.setText("View XML Representation");
            this.xmlRepresentationMenuItem.setActionCommand(this.xmlRepresentationMenuItem.getText());
            this.descriptionMenuItem.setText("View Graph and Data Description");
            this.descriptionMenuItem.setActionCommand(this.descriptionMenuItem.getText());
            this.setPromptLabel("Click on an entity to view its properties.");
            this.solveButModes[5].setEnabled(false);
            this.speed.setEnabled(true);
            this.stopping.setEnabled(true);
            this.learning.setEnabled(true);
            this.returnCanvas().repaint();
        }
    }

    @Override
    protected JMenu createFileMenu() {
        JMenu m = new JMenu("File");
        m.setMnemonic(70);
        JMenuItem mItem = new JMenuItem("Create New Graph");
        mItem.setActionCommand(mItem.getText());
        mItem.addActionListener(this);
        mItem.setMnemonic(78);
        m.add(mItem);
        mItem = new JMenuItem("Load Sample Graph and Data");
        mItem.setActionCommand(mItem.getText());
        mItem.setMnemonic(71);
        mItem.addActionListener(this);
        m.add(mItem);
        JMenuItem loadsamplegraphwizard = new JMenuItem("Load Sample Data");
        loadsamplegraphwizard.setActionCommand(loadsamplegraphwizard.getText());
        loadsamplegraphwizard.setMnemonic(68);
        loadsamplegraphwizard.setDisplayedMnemonicIndex(12);
        loadsamplegraphwizard.addActionListener(this);
        m.add(loadsamplegraphwizard);
        boolean hasLocalAccess = this.hasLocalAccess();
        if (hasLocalAccess) {
            mItem = new JMenuItem("Load Graph and Data From File");
            mItem.setActionCommand(mItem.getText());
            mItem.setMnemonic(76);
            mItem.addActionListener(this);
            m.add(mItem);
            JMenuItem opengraphwizard = new JMenuItem("Load Data From File");
            opengraphwizard.setActionCommand(opengraphwizard.getText());
            opengraphwizard.addActionListener(this);
            opengraphwizard.setMnemonic(79);
            m.add(opengraphwizard);
        }
        mItem = new JMenuItem("Load Graph and Data From URL");
        mItem.setActionCommand(mItem.getText());
        mItem.setMnemonic(85);
        mItem.addActionListener(this);
        m.add(mItem);
        JMenuItem openlocwizard = new JMenuItem("Load Data From URL");
        openlocwizard.setActionCommand(openlocwizard.getText());
        openlocwizard.setMnemonic(82);
        openlocwizard.setDisplayedMnemonicIndex(16);
        openlocwizard.addActionListener(this);
        m.add(openlocwizard);
        m.addSeparator();
        if (hasLocalAccess) {
            mItem = new JMenuItem("Save Graph and Data");
            mItem.setActionCommand(mItem.getText());
            mItem.addActionListener(this);
            mItem.setMnemonic(83);
            m.add(mItem);
        }
        mItem = new JMenuItem("Print");
        mItem.setActionCommand(mItem.getText());
        mItem.addActionListener(this);
        mItem.setMnemonic(80);
        m.add(mItem);
        mItem = new JMenuItem("Quit");
        mItem.setActionCommand(mItem.getText());
        mItem.addActionListener(this);
        mItem.setMnemonic(81);
        m.add(mItem);
        return m;
    }

    protected JMenu createEditMenu() {
        JMenu m = new JMenu("Edit");
        JMenuItem mItem = new JMenuItem("View Prolog Code");
        mItem.addActionListener(this);
        m.add(mItem);
        this.textRepresentationMenuItem = new JMenuItem("View/Edit Text Representation");
        this.textRepresentationMenuItem.setMnemonic(84);
        this.textRepresentationMenuItem.setDisplayedMnemonicIndex(10);
        this.textRepresentationMenuItem.addActionListener(this);
        m.add(this.textRepresentationMenuItem);
        this.xmlRepresentationMenuItem = new JMenuItem("View/Edit XML Representation");
        this.xmlRepresentationMenuItem.setMnemonic(88);
        this.xmlRepresentationMenuItem.addActionListener(this);
        m.add(this.xmlRepresentationMenuItem);
        this.descriptionMenuItem = new JMenuItem("View/Edit Graph and Data Description");
        this.descriptionMenuItem.setMnemonic(68);
        this.descriptionMenuItem.setDisplayedMnemonicIndex(10);
        this.descriptionMenuItem.setActionCommand(this.descriptionMenuItem.getText());
        this.descriptionMenuItem.addActionListener(this);
        m.add(this.descriptionMenuItem);
        return m;
    }

    @Override
    protected JMenu createViewMenu() {
        JMenu m = super.createViewMenu();
        m.addSeparator();
        this.showParam = new JCheckBoxMenuItem("Show Parameters", true);
        this.showParam.setMnemonic(80);
        this.showParam.addActionListener(this);
        m.add(this.showParam);
        return m;
    }

    protected JMenu createGraphOptionsMenu() {
        JMenu m = new JMenu("Neural Options");
        ButtonGroup group = new ButtonGroup();
        this.speed = new JMenu("Auto Step Speed");
        JRadioButtonMenuItem xFast = new JRadioButtonMenuItem("Very Fast (0 s)", false);
        xFast.addActionListener(this);
        this.speed.add(xFast);
        group.add(xFast);
        JRadioButtonMenuItem fast = new JRadioButtonMenuItem("Fast (0.1 s)", true);
        fast.addActionListener(this);
        this.speed.add(fast);
        group.add(fast);
        JRadioButtonMenuItem medium = new JRadioButtonMenuItem("Medium (0.5 s)", false);
        medium.addActionListener(this);
        this.speed.add(medium);
        group.add(medium);
        JRadioButtonMenuItem slow = new JRadioButtonMenuItem("Slow (1 s)", false);
        slow.addActionListener(this);
        this.speed.add(slow);
        group.add(slow);
        m.add(this.speed);
        m.addSeparator();
        this.initialization = new JMenuItem("Parameter Initialization Options...");
        this.initialization.addActionListener(this);
        m.add(this.initialization);
        this.learning = new JMenuItem("Learning Options...");
        this.learning.addActionListener(this);
        m.add(this.learning);
        this.stopping = new JMenuItem("Stopping Conditions...");
        this.stopping.addActionListener(this);
        m.add(this.stopping);
        m.addSeparator();
        JCheckBoxMenuItem standardize = new JCheckBoxMenuItem("Normalize Inputs", false);
        standardize.addActionListener(this);
        m.add(standardize);
        return m;
    }

    @Override
    protected JMenu createHelpMenu() {
        return new HelpMenu("neural", this);
    }

    @Override
    protected JMenuBar createMenuBar() {
        JMenuBar menuBar = super.createMenuBar();
        menuBar.add((Component)this.createEditMenu(), 1);
        menuBar.add((Component)this.createGraphOptionsMenu(), 3);
        return menuBar;
    }

    public void loadWizard(File file) {
        try {
            this.loadWizard(new BufferedReader(new FileReader(file.getPath())));
        }
        catch (Exception e) {
            this.fileName = null;
            this.showMessage("Error", e.toString());
        }
    }

    @Override
    public void load(BufferedReader in) {
        try {
            String line;
            ((NeuralGraph)this.returnCanvas().graph).disposeWindows();
            StringBuffer allText = new StringBuffer();
            while ((line = in.readLine()) != null) {
                allText.append(line).append("\n");
            }
            in.close();
            ExampleList example = new ExampleList();
            String errorMessage = example.parseString(allText.toString());
            if (errorMessage.length() > 0 && !errorMessage.equals("OK")) {
                new MessageDialog(this).open("Error Loading File", errorMessage);
                return;
            }
            this.resetCanvas();
            ((NeuralCanvas)this.returnCanvas()).parseXML(allText.toString());
            ((NeuralGraph)((NeuralCanvas)this.returnCanvas()).graph).setInputOutputNodes(true);
            if (this.canvas.getMode() == 2221) {
                ((NeuralGraph)this.canvas.graph).setTotalErrorAfterInitialization();
            }
            this.canvas.autoscale();
            this.setTitle(String.valueOf(appletTitle) + " --- " + this.fileName);
            ((NeuralGraph)this.canvas.graph).repaint();
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            super.setPromptLabel("Error" + e.toString());
        }
    }

    @Override
    public void save(File file) {
        if (!file.getName().endsWith(".xml")) {
            file = new File(String.valueOf(file.getAbsolutePath()) + ".xml");
        }
        try {
            PrintWriter out = new PrintWriter(new FileOutputStream(file));
            out.println(((NeuralGraph)this.canvas.graph).generateXMLTextRep());
            out.close();
            this.fileName = file.getName();
            if (!file.getName().equals("undo.xml")) {
                // empty if block
            }
            this.setTitle(String.valueOf(appletTitle) + " --- " + this.fileName);
        }
        catch (FileNotFoundException e) {
            System.out.println(e);
        }
    }

    public boolean isStopEnabled() {
        return this.solveButModes[5].isEnabled();
    }

    public void enableButtons(boolean bool) {
        this.solveButModes[3].setEnabled(bool);
        this.solveButModes[4].setEnabled(bool);
        this.solveButModes[5].setEnabled(!bool);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String arg = e.getActionCommand().trim();
        if (e.getSource() == this.createButModes[3]) {
            this.returnCanvas().setSubmode(3332);
            this.setPromptLabel("Click on an entity to select or drag the mouse to select multiple entities.");
            return;
        }
        if (e.getSource() == this.createButModes[4]) {
            this.returnCanvas().setSubmode(3333);
            this.setPromptLabel("Click on an entity to delete.");
            return;
        }
        if (arg.equals("Initialize Parameters")) {
            if (!this.validGraph()) {
                return;
            }
            ((NeuralGraph)this.canvas.graph).initializeParaValues();
            ((NeuralGraph)this.canvas.graph).setTotalErrorAfterInitialization();
            this.solveModeButGroup.setSelected(this.fakeButton.getModel(), true);
            return;
        }
        if (arg.equals("Step")) {
            if (!this.validGraph()) {
                System.out.println("Not valid step");
                return;
            }
            ((NeuralGraph)this.canvas.graph).step();
            this.canvas.repaint();
            this.solveModeButGroup.setSelected(this.fakeButton.getModel(), true);
            return;
        }
        if (arg.equals("Step " + ((NeuralGraph)this.canvas.graph).getNumberOfIterations() + "X")) {
            if (!this.validGraph()) {
                return;
            }
            ((NeuralGraph)this.canvas.graph).autoStep();
            this.solveButModes[5].setEnabled(true);
            this.solveModeButGroup.setSelected(this.fakeButton.getModel(), true);
            return;
        }
        if (arg.equals("Step to Target Error")) {
            if (!this.validGraph()) {
                return;
            }
            ((NeuralGraph)this.canvas.graph).runUntilFinished();
            this.solveButModes[5].setEnabled(true);
            this.solveModeButGroup.setSelected(this.fakeButton.getModel(), true);
            return;
        }
        if (arg.equals("Stop")) {
            ((NeuralGraph)this.canvas.graph).stop();
            this.solveButModes[5].setEnabled(false);
            this.solveModeButGroup.setSelected(this.fakeButton.getModel(), true);
            return;
        }
        if (arg.equals("Calculate Output")) {
            if (!this.validGraph()) {
                return;
            }
            new CalculateOutputDialog((JFrame)this, (NeuralGraph)this.canvas.graph);
            this.solveModeButGroup.setSelected(this.fakeButton.getModel(), true);
            return;
        }
        if (arg.equals("Show Plot")) {
            if (!this.validGraph()) {
                return;
            }
            ((NeuralGraph)this.canvas.graph).showPlot();
            this.solveModeButGroup.setSelected(this.fakeButton.getModel(), true);
            return;
        }
        if (arg.equals("Summary Statistics")) {
            new TestStatisticsDialog((JFrame)this, (NeuralGraph)this.canvas.graph);
            this.solveModeButGroup.setSelected(this.fakeButton.getModel(), true);
            return;
        }
        if (arg.equals("View/Edit Examples")) {
            if (this.validGraph()) {
                new ExampleDialog((Container)this, (NeuralGraph)this.canvas.graph, ((NeuralGraph)this.canvas.graph).getExampleList());
            } else {
                this.showMessage("View/Edit Examples", "At least one input and output node are needed to manipulate examples.");
            }
            this.solveModeButGroup.setSelected(this.fakeButton.getModel(), true);
            if (this.returnCanvas().getMode() == 2220) {
                int subMode = this.returnCanvas().getSubmode();
                switch (subMode) {
                    case 3330: {
                        this.createButModes[1].setSelected(true);
                        break;
                    }
                    case 3331: {
                        this.createButModes[2].setSelected(true);
                        break;
                    }
                    case 3332: {
                        this.createButModes[3].setSelected(true);
                        break;
                    }
                    case 3333: {
                        this.createButModes[4].setSelected(true);
                        break;
                    }
                    case 3334: {
                        this.createButModes[5].setSelected(true);
                    }
                }
            }
            return;
        }
        if (arg.equals("Parameter Initialization Options...")) {
            if (this.iod == null) {
                this.iod = new InitializationOptionsDialog((JFrame)this, (NeuralGraph)this.canvas.graph, true);
            } else {
                this.iod.open();
            }
            return;
        }
        if (arg.equals("Learning Options...")) {
            if (this.lod == null) {
                this.lod = new LearningOptionsDialog((JFrame)this, (NeuralGraph)this.canvas.graph);
            } else {
                this.lod.open();
            }
            return;
        }
        if (arg.equals("Stopping Conditions...")) {
            if (this.sod == null) {
                this.sod = new StoppingOptionsDialog((JFrame)this, (NeuralGraph)this.canvas.graph, "Stopping Conditions");
            } else {
                this.sod.open();
            }
            this.solveButModes[3].setText("Step " + ((NeuralGraph)this.returnCanvas().graph).getNumberOfIterations() + "X");
            this.solveButModes[3].setToolTipText("Step " + ((NeuralGraph)this.returnCanvas().graph).getNumberOfIterations() + "X");
            this.solveButModes[3].setActionCommand(this.solveButModes[3].getToolTipText());
            if (super.isButtonTextShowing()) {
                this.solveToolBarWithText();
            } else {
                this.solveToolBar();
            }
            return;
        }
        if (arg.equals("Load Data From File")) {
            JFileChooser load = new JFileChooser();
            load.setFileSelectionMode(2);
            load.setLocation(0, 0);
            int returnval = load.showOpenDialog(this);
            if (returnval == 0) {
                File file = load.getSelectedFile();
                this.fileName = file.getName();
                this.loadWizard(file);
            }
            return;
        }
        if (arg.equals("Load Sample Data")) {
            new NeuralProblemDialog(this, true).open();
            return;
        }
        if (arg.equals("Load Graph and Data From File")) {
            this.openGraph();
            return;
        }
        if (arg.equals("Load Graph and Data From URL")) {
            this.openLocation();
            return;
        }
        if (arg.equals("Save Graph and Data")) {
            this.saveGraph();
            return;
        }
        if (arg.equals("Load Sample Graph and Data")) {
            new NeuralProblemDialog(this, false).open();
            return;
        }
        if (arg.equals("Load Data From URL")) {
            OpenLocationDialog old = new OpenLocationDialog(this);
            String urlString = old.url;
            if (urlString != null) {
                InputStream iStream = null;
                this.fileName = urlString.substring(urlString.lastIndexOf("/") + 1);
                try {
                    iStream = new URL(urlString).openStream();
                }
                catch (Exception exc) {
                    super.setPromptLabel("Error" + exc.toString());
                }
                if (iStream != null) {
                    BufferedReader file = new BufferedReader(new InputStreamReader(iStream));
                    this.loadWizard(file);
                }
            }
            return;
        }
        if (arg.equals("View Prolog Code")) {
            ((NeuralCanvas)this.canvas).openPrologTextRep();
        } else if (arg.equals("View/Edit Text Representation")) {
            ((NeuralCanvas)this.canvas).openTextRep(true);
        } else if (arg.equals("View/Edit XML Representation")) {
            ((NeuralCanvas)this.canvas).openXMLTextRep(true);
        } else if (arg.equals("View Text Representation")) {
            ((NeuralCanvas)this.canvas).openTextRep(false);
        } else if (arg.equals("View XML Representation")) {
            ((NeuralCanvas)this.canvas).openXMLTextRep(false);
        } else if (arg.equals("View/Edit Graph and Data Description")) {
            new NeuralDescriptionDialog((GraphWindow)this, (NeuralGraph)this.canvas.graph, true).open();
        } else if (arg.equals("View Graph and Data Description")) {
            new NeuralDescriptionDialog((GraphWindow)this, (NeuralGraph)this.canvas.graph, false).open();
        } else {
            if (arg.equals("Legend for Nodes/Edges")) {
                new HelpFrame("Legend", new NeuralHelpCanvas(this.isAntiAliasingEnabled()), 450, 675);
                return;
            }
            if (arg.equals("Very Fast (0 s)")) {
                ((NeuralGraph)this.canvas.graph).dt = 0;
                return;
            }
            if (arg.equals("Fast (0.1 s)")) {
                ((NeuralGraph)this.canvas.graph).dt = 100;
                return;
            }
            if (arg.equals("Medium (0.5 s)")) {
                ((NeuralGraph)this.canvas.graph).dt = 500;
                return;
            }
            if (arg.equals("Slow (1 s)")) {
                ((NeuralGraph)this.canvas.graph).dt = 1000;
                return;
            }
            if (arg.equals("Average Sum of Squares Error")) {
                ((NeuralGraph)this.canvas.graph).setErrorType(NeuralGraph.AVERAGE_SUMSQUARES);
                return;
            }
            if (arg.equals("Total Sum of Squares Error")) {
                ((NeuralGraph)this.canvas.graph).setErrorType(NeuralGraph.SUMSQUARES);
                return;
            }
            if (arg.equals("Show Parameters")) {
                ((NeuralGraph)this.canvas.graph).setShowParam(this.showParam.getState());
                return;
            }
            if (arg.equals("Normalize Inputs")) {
                NeuralGraph g = (NeuralGraph)this.canvas.graph;
                ExampleList ex = g.getExampleList();
                boolean bl = g.standardized = !g.standardized;
                if ((ex != null || g.getExampleList().getTrainingArrayList().size() > 0) && g.getInputNodes().size() > 0 && g.getOutputNodes().size() > 0) {
                    g.initBackProp();
                }
                return;
            }
        }
        super.actionPerformed(e);
    }

    public void loadWizard(String dir, String filename) {
        try {
            this.fileName = filename;
            if (this.applet != null) {
                this.loadWizard(new BufferedReader(new InputStreamReader(new URL(this.applet.getCodeBase() + dir + filename).openStream())));
            } else {
                this.loadWizard(new BufferedReader(new FileReader(String.valueOf(dir) + filename)));
            }
        }
        catch (Exception e) {
            filename = null;
            super.setPromptLabel("Error" + e.toString());
        }
    }

    public void loadWizard(BufferedReader file) {
        StringBuffer all = new StringBuffer();
        ExampleList example = null;
        try {
            String line;
            ((NeuralGraph)this.returnCanvas().graph).disposeWindows();
            while ((line = file.readLine()) != null) {
                all.append(line).append("\n");
            }
        }
        catch (Exception ex) {
            new MessageDialog(this).open("Error Loading File", "There has been an error loading the file. Terminating wizard...");
            return;
        }
        example = new ExampleList();
        String errorMessage = example.parseString(all.toString());
        this.setPromptLabel("");
        while (errorMessage.equals("You must identify parameters before loading examples")) {
            new ParameterInputDialog((JFrame)this.canvas.parent, example);
            errorMessage = example.parseString(all.toString());
        }
        if (errorMessage.length() > 0 && !errorMessage.equals("OK")) {
            new MessageDialog(this).open("Error Loading File", errorMessage);
            return;
        }
        this.resetCanvas();
        this.wizard = new NeuralWizard((JFrame)this, (NeuralGraph)this.canvas.graph, example, this.fileName);
        if (this.canvas.getMode() == 2221) {
            ((NeuralGraph)this.canvas.graph).setTotalErrorAfterInitialization();
        }
        this.setTitle(String.valueOf(appletTitle) + " --- " + this.fileName);
    }

    @Override
    protected void saveProperties() {
        super.saveProperties();
        this.showParameters = this.showParam.getState();
    }

    @Override
    protected void restoreProperties() {
        super.restoreProperties();
        if (this.returnCanvas().getMode() == 2220) {
            this.createButModes[1].setSelected(true);
            this.returnCanvas().setSubmode(3330);
            this.setPromptLabel("Click the canvas to create a node.");
        }
        this.showParam.setSelected(this.showParameters);
        ((NeuralGraph)this.canvas.graph).setShowParam(this.showParam.getState());
    }

    private boolean validGraph() {
        NeuralGraph g = (NeuralGraph)this.canvas.graph;
        return g.getInputNodes().size() > 0 && g.getOutputNodes().size() > 0;
    }

    @Override
    public void windowClosing(WindowEvent e) {
        super.windowClosing(e);
        if (this.sod != null) {
            this.sod.dispose();
        }
        if (this.lod != null) {
            this.lod.dispose();
        }
        ((NeuralGraph)this.canvas.graph).disposeWindows();
        this.dispose();
    }

    public static void main(String[] args) {
        NeuralWindow window = new NeuralWindow(null);
        if (args.length > 0) {
            String url = args[0];
            try {
                window.fileName = url.substring(url.lastIndexOf("/") + 1);
                window.load(new BufferedReader(new InputStreamReader(new URL(url).openStream())));
            }
            catch (Exception exc) {
                window.showMessage("Error", exc.toString());
            }
        }
    }
}

