/*
 * Decompiled with CFR 0.152.
 */
package AIspace.neural;

import AIspace.neural.intList.IntList;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.PrintJob;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JFrame;

public class PlotCanvas
extends Canvas
implements MouseListener {
    private Font font;
    private FontMetrics fm;
    private int width;
    private int height;
    private int width_adjusted;
    private int height_adjusted;
    private float xStep;
    private float yStep;
    private IntList xVals;
    private IntList yVals;
    private IntList xTestVals;
    private IntList yTestVals;
    private int maxTestX;
    private int maxY;
    private int maxX;
    private int skipX;
    private int skipY;
    private static final int LEFT_PAD = 100;
    private static final int RIGHT_PAD = 100;
    private static final int TOP_PAD = 50;
    private static final int BOTTOM_PAD = 50;
    private boolean useLogScale = false;
    private int mouseX;
    private int mouseY;
    private String mouseStr;
    private int redX;
    private int redY;

    public PlotCanvas() {
        this.setBackground(Color.white);
        this.addMouseListener(this);
        this.font = new Font("SansSerif", 0, 12);
        this.fm = this.getFontMetrics(this.font);
        this.xVals = new IntList();
        this.yVals = new IntList();
        this.xTestVals = new IntList();
        this.yTestVals = new IntList();
        this.maxTestX = 1;
        this.xStep = 5.0f;
        this.maxX = 1;
        this.mouseX = -100;
        this.mouseY = -100;
        this.mouseStr = "";
        this.redX = -100;
        this.redY = -100;
    }

    public void resetSteps(int maxY) {
        this.updateSize();
        this.maxY = maxY;
        if (maxY <= 0) {
            maxY = 1;
            this.yStep = 50.0f;
        } else {
            this.yStep = (float)this.height_adjusted / (float)maxY;
        }
        this.skipX = this.round(50.0 / (double)this.xStep);
        this.skipY = this.round(20.0 / (double)this.yStep);
    }

    public void resetSteps() {
        this.resetSteps(this.maxY);
    }

    private int round(double d) {
        int mult;
        int digits = 0;
        double tmp = d;
        while (tmp >= 1.0) {
            tmp /= 10.0;
            ++digits;
        }
        if (digits <= 0) {
            digits = 1;
        }
        if (d / (double)(mult = (int)Math.pow(10.0, digits)) < 0.1) {
            return (int)(0.1 * (double)mult);
        }
        if (d / (double)mult < 0.25) {
            return (int)(0.25 * (double)mult);
        }
        if (d / (double)mult < 0.5) {
            return (int)(0.5 * (double)mult);
        }
        return mult;
    }

    public void updateSize() {
        this.width = this.getSize().width;
        this.height = this.getSize().height;
        this.width_adjusted = this.getWidth() - 100 - 100;
        this.height_adjusted = this.getHeight() - 50 - 50;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    public void clear() {
        this.xVals = null;
        this.yVals = null;
        this.xTestVals = null;
        this.yTestVals = null;
        this.maxY = 1;
        this.repaint();
    }

    public void useLogScale(boolean bool) {
        this.useLogScale = bool;
        this.repaint();
    }

    public void redraw(IntList[] vals, IntList[] testVals) {
        if (vals == null) {
            return;
        }
        if (testVals == null) {
            return;
        }
        this.xVals = vals[0];
        this.yVals = vals[1];
        this.xTestVals = testVals[0];
        this.yTestVals = testVals[1];
        if (this.xVals.first() == -1) {
            return;
        }
        this.maxX = this.xVals.last();
        this.xStep = (float)this.width_adjusted / (float)this.maxX;
        this.maxY = this.yVals.first();
        int tmp = this.yVals.next();
        while (tmp != -1) {
            if (tmp > this.maxY) {
                this.maxY = tmp;
            }
            tmp = this.yVals.next();
        }
        if (this.xTestVals.first() == -1) {
            return;
        }
        this.maxTestX = this.xTestVals.last();
        this.xStep = (float)this.width_adjusted / (float)this.maxTestX;
        tmp = this.yTestVals.next();
        while (tmp != -1) {
            if (tmp > this.maxY) {
                this.maxY = tmp;
            }
            tmp = this.yTestVals.next();
        }
        this.resetSteps();
        this.repaint();
    }

    public void paint(IntList[] vals, IntList[] testVals) {
        if (vals == null) {
            return;
        }
        if (testVals == null) {
            return;
        }
        this.xTestVals = testVals[0];
        this.yTestVals = testVals[1];
        this.xVals = vals[0];
        this.yVals = vals[1];
        this.maxX = this.xVals.last();
        if (this.maxX == -1) {
            this.maxX = 1;
        }
        this.xStep = (float)this.width_adjusted / (float)this.maxX;
        if (this.maxX == 1 && this.yVals.first() > this.maxY) {
            this.maxY = this.yVals.first();
        }
        if (this.yVals.last() > this.maxY) {
            this.maxY = this.yVals.last();
        }
        this.maxTestX = this.xTestVals.last();
        if (this.maxTestX == -1) {
            this.maxTestX = 1;
        }
        this.xStep = (float)this.width_adjusted / (float)this.maxTestX;
        if (this.maxTestX == 1 && this.yTestVals.first() > this.maxY) {
            this.maxY = this.yTestVals.first();
        }
        if (this.yTestVals.last() > this.maxY) {
            this.maxY = this.yTestVals.last();
        }
        this.resetSteps();
        this.repaint();
    }

    @Override
    public void update(Graphics g) {
        this.paint(g);
    }

    @Override
    public void paint(Graphics g) {
        g.clearRect(0, 0, this.width, this.height);
        this.drawGrid(g);
        this.drawPoints(g);
        this.drawLabels(g);
        g.setColor(Color.red);
        g.drawOval((int)((float)this.redX * this.xStep) + 100 - 1, this.height - 50 - (int)((float)this.redY * this.yStep), 2, 2);
        g.setColor(Color.white);
        g.fillRect(this.mouseX, this.mouseY - this.fm.getAscent(), this.fm.stringWidth(this.mouseStr), this.fm.getHeight());
        g.setColor(Color.black);
        g.drawString(this.mouseStr, this.mouseX, this.mouseY);
    }

    private void drawGrid(Graphics graphics) {
        graphics.setColor(Color.black);
        int xStart = 100;
        if (xStart < 0) {
            xStart = 0;
        }
        int xEnd = this.width - 100;
        graphics.drawLine(xStart, this.height - 50, xEnd, this.height - 50);
        graphics.drawLine(100, this.height - 50, 100, 50);
        graphics.setColor(Color.lightGray);
        int i = 0;
        float x = 100.0f + this.xStep * (float)this.skipX;
        while (x <= (float)(100 + this.width_adjusted + 1)) {
            i += this.skipX;
            float x2 = x - 100.0f;
            if (this.useLogScale) {
                float percent = x2 / (float)this.width_adjusted;
                x2 = x2 * percent * percent;
            }
            x2 += 100.0f;
            if (x >= 0.0f) {
                graphics.drawLine((int)x2, 50, (int)x2, this.height - 50);
                graphics.drawString(String.valueOf(i), (int)x2 - this.fm.stringWidth(String.valueOf(i)) / 2, this.height - 50 + this.fm.getHeight());
            }
            x += this.xStep * (float)this.skipX;
        }
        i = 0;
        float y = (float)(this.height - 50) - this.yStep * (float)this.skipY;
        while (y >= 50.0f) {
            xStart = 100;
            graphics.drawLine(xStart, (int)y, this.width - 100, (int)y);
            String yStr = PlotCanvas.doubleToString((double)(i += this.skipY) / 100.0);
            xStart = xStart == 0 ? this.width - 100 + this.fm.stringWidth(" ") : (xStart -= this.fm.stringWidth(String.valueOf(yStr) + " "));
            graphics.drawString(yStr, xStart, (int)y + this.fm.getHeight() / 2);
            y -= this.yStep * (float)this.skipY;
        }
    }

    private void drawPoints(Graphics graphics) {
        if (this.xVals == null || this.yVals == null) {
            return;
        }
        int x = this.xVals.first();
        int y = this.yVals.first();
        int xPrev = -1;
        int yPrev = -1;
        int r = 1;
        int xStart = 100;
        int yStart = this.height - 50;
        float percent = 1.0f;
        graphics.setColor(Color.blue);
        while (x != -1 && y != -1) {
            if (this.useLogScale) {
                percent = this.percent(x);
                x = (int)((float)x * this.xStep * percent * percent);
            } else {
                x = (int)((float)x * this.xStep);
            }
            y = (int)((float)y * this.yStep);
            y = yStart - y;
            graphics.drawRect((x += xStart) - r, y - r, r * 2, r * 2);
            if (xPrev != -1 && yPrev != -1) {
                graphics.drawLine(xPrev, yPrev, x, y);
            }
            xPrev = x;
            yPrev = y;
            x = this.xVals.next();
            y = this.yVals.next();
        }
        if (this.xTestVals == null || this.yTestVals == null) {
            return;
        }
        int xTest = this.xTestVals.first();
        int yTest = this.yTestVals.first();
        int xTestPrev = -1;
        int yTestPrev = -1;
        int rTest = 1;
        int xTestStart = 100;
        int yTestStart = this.height - 50;
        float testPercent = 1.0f;
        graphics.setColor(Color.orange);
        while (xTest != -1 && yTest != -1) {
            if (this.useLogScale) {
                testPercent = this.percent(xTest);
                xTest = (int)((float)xTest * this.xStep * testPercent * testPercent);
            } else {
                xTest = (int)((float)xTest * this.xStep);
            }
            yTest = (int)((float)yTest * this.yStep);
            yTest = yTestStart - yTest;
            graphics.drawRect((xTest += xTestStart) - rTest, yTest - rTest, rTest * 2, rTest * 2);
            if (xTestPrev != -1 && yTestPrev != -1) {
                graphics.drawLine(xTestPrev, yTestPrev, xTest, yTest);
            }
            xTestPrev = xTest;
            yTestPrev = yTest;
            xTest = this.xTestVals.next();
            yTest = this.yTestVals.next();
        }
    }

    private void drawLabels(Graphics graphics) {
        String err;
        int y;
        String xName = "Step Count";
        String yName = "Total Error";
        graphics.setColor(Color.black);
        graphics.drawString(xName, this.width / 2 - this.fm.stringWidth(xName) / 2, this.height - this.fm.getHeight());
        int xStart = 50;
        int yNameWidth = this.fm.stringWidth(yName);
        if (xStart + yNameWidth < 0) {
            return;
        }
        graphics.drawString(yName, xStart - yNameWidth / 2, this.height / 2 - this.fm.getHeight() / 2);
        xStart = this.width - 100 + 5;
        if (this.yVals != null && this.yVals.last() != -1) {
            graphics.setColor(Color.blue);
            graphics.drawLine(xStart, this.height / 3 - this.fm.getHeight() / 2, xStart + 55, this.height / 3 - this.fm.getHeight() / 2);
            graphics.drawRect(xStart + 27, this.height / 3 - this.fm.getHeight() / 2 - 2, 4, 4);
            y = this.height / 3 - this.fm.getHeight();
            graphics.setColor(Color.black);
            err = PlotCanvas.doubleToString((double)this.yVals.last() / 100.0);
            graphics.drawString(String.valueOf(err) + " Train", xStart, y);
        }
        if (this.yTestVals != null && this.yTestVals.last() != -1) {
            graphics.setColor(Color.orange);
            graphics.drawLine(xStart, 2 * this.height / 3 - this.fm.getHeight() / 2, xStart + 55, 2 * this.height / 3 - this.fm.getHeight() / 2);
            graphics.drawRect(xStart + 27, 2 * this.height / 3 - this.fm.getHeight() / 2 - 2, 4, 4);
            y = 2 * this.height / 3 - this.fm.getHeight();
            err = PlotCanvas.doubleToString((double)this.yTestVals.last() / 100.0);
            graphics.setColor(Color.black);
            graphics.drawString(String.valueOf(err) + " Test", xStart, y);
        }
    }

    private float percent(int x) {
        float percent = this.maxX == 0 ? 0.0f : (float)x / (float)this.xVals.last();
        return percent;
    }

    public static String doubleToString(double d) {
        double tmp = (double)Math.round(d * 100.0) / 100.0;
        return String.valueOf(tmp);
    }

    public void print(JFrame parent) {
        PrintJob pj = Toolkit.getDefaultToolkit().getPrintJob(parent, "Title", null);
        if (pj == null) {
            System.out.println("The print request was cancelled");
            return;
        }
        Graphics g = pj.getGraphics();
        Image im = this.createImage(this.width, this.height);
        Graphics graphics = im.getGraphics();
        this.drawGrid(graphics);
        this.drawPoints(graphics);
        this.drawLabels(graphics);
        g.drawImage(im, 0, 0, this);
        g.dispose();
        pj.end();
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (this.xVals == null) {
            return;
        }
        if (this.useLogScale) {
            return;
        }
        this.mouseX = e.getX();
        this.mouseY = e.getY();
        float clickedX = (float)(this.mouseX - 100) / this.xStep;
        int x = this.xVals.first();
        int y = this.yVals.first();
        int prevX = x;
        int prevY = y;
        while ((float)x < clickedX && x != -1) {
            prevX = x;
            prevY = y;
            x = this.xVals.next();
            y = this.yVals.next();
        }
        if (Math.abs(clickedX - (float)x) > Math.abs(clickedX - (float)prevX)) {
            x = prevX;
            y = prevY;
        }
        if (x == -1) {
            this.mouseX = -100;
            this.mouseY = -100;
            this.mouseStr = "";
            this.redX = -100;
            this.redY = -100;
            return;
        }
        this.redX = x;
        this.redY = y;
        this.mouseStr = "(" + x + ", " + PlotCanvas.doubleToString((double)y / 100.0) + ")";
        this.repaint();
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.mouseX = -100;
        this.mouseY = -100;
        this.mouseStr = "";
        this.redX = -100;
        this.redY = -100;
        this.repaint();
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }
}

