/*
 * Decompiled with CFR 0.152.
 */
package AIspace.neural;

import AIspace.neural.NeuralGraph;
import AIspace.neural.PlotCanvas;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class PlotFrame
extends JFrame
implements ActionListener,
WindowListener,
ComponentListener,
ItemListener {
    private NeuralGraph graph;
    private PlotCanvas canvas;
    private GridBagConstraints gbc;
    private GridBagLayout gbl;
    private JCheckBox log;
    public JButton auto;
    public JButton run;
    public JButton stop;

    public PlotFrame(NeuralGraph graph) {
        super("Total Error Plot");
        this.addWindowListener(this);
        this.addComponentListener(this);
        this.setSize(600, 400);
        this.graph = graph;
        this.gbl = new GridBagLayout();
        this.gbc = new GridBagConstraints();
        this.gbc.anchor = 18;
        this.gbc.fill = 1;
        this.canvas = new PlotCanvas();
        JButton step = new JButton("Step");
        step.addActionListener(this);
        this.auto = new JButton("Step " + graph.getNumberOfIterations() + "X");
        this.auto.addActionListener(this);
        this.run = new JButton("Step To Target Error");
        this.run.addActionListener(this);
        this.stop = new JButton("Stop");
        this.stop.addActionListener(this);
        this.stop.setEnabled(false);
        JButton initialize = new JButton("Initialize Parameters");
        initialize.addActionListener(this);
        JPanel middle = new JPanel();
        middle.add(initialize);
        middle.add(step);
        middle.add(this.auto);
        middle.add(this.run);
        middle.add(this.stop);
        this.log = new JCheckBox("Logarithmic Scale");
        this.log.addActionListener(this);
        JButton close = new JButton("Close");
        close.addActionListener(this);
        JButton clear = new JButton("Clear");
        clear.addActionListener(this);
        JButton print = new JButton("Print");
        print.addActionListener(this);
        JPanel bottom = new JPanel();
        bottom.add(this.log);
        bottom.add(close);
        bottom.add(clear);
        bottom.add(print);
        this.getContentPane().setLayout(this.gbl);
        this.addComponent(this.canvas, this, 0, 0, 1, 1, 1.0, 1.0);
        this.addComponent(middle, this, 1, 0, 1, 1, 0.0, 0.0);
        this.addComponent(bottom, this, 2, 0, 1, 1, 0.0, 0.0);
        this.setVisible(true);
        this.canvas.resetSteps((int)(100.0 * graph.totalError()));
    }

    private void addComponent(PlotCanvas c, PlotFrame p, int row, int column, int width, int height, double wx, double wy) {
        this.gbc.gridx = column;
        this.gbc.gridy = row;
        this.gbc.gridwidth = width;
        this.gbc.gridheight = height;
        this.gbc.weightx = wx;
        this.gbc.weighty = wy;
        this.gbl.setConstraints(c, this.gbc);
        p.getContentPane().add(c);
    }

    private void addComponent(JComponent c, PlotFrame p, int row, int column, int width, int height, double wx, double wy) {
        this.gbc.gridx = column;
        this.gbc.gridy = row;
        this.gbc.gridwidth = width;
        this.gbc.gridheight = height;
        this.gbc.weightx = wx;
        this.gbc.weighty = wy;
        this.gbl.setConstraints(c, this.gbc);
        p.getContentPane().add(c);
    }

    public void open() {
        this.canvas.redraw(this.graph.getPlotVals(), this.graph.getTestPlotVals());
        this.setVisible(true);
    }

    public void clear() {
        this.graph.clearPlotPts();
        this.canvas.clear();
    }

    @Override
    public void repaint() {
        this.canvas.paint(this.graph.getPlotVals(), this.graph.getTestPlotVals());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String arg = e.getActionCommand();
        if (arg.equals("Logarithmic Scale")) {
            this.canvas.useLogScale(this.log.isSelected());
        } else if (arg.equals("Step")) {
            this.graph.step();
            this.canvas.redraw(this.graph.getPlotVals(), this.graph.getTestPlotVals());
            this.graph.canvas.repaint();
        } else if (arg.equals("Step " + this.graph.getNumberOfIterations() + "X")) {
            this.graph.autoStep();
        } else if (arg.equals("Step To Target Error")) {
            this.graph.runUntilFinished();
        } else if (arg.equals("Stop")) {
            this.graph.stop();
        } else if (arg.equals("Initialize Parameters")) {
            this.graph.initializeParaValues();
            this.graph.setTotalErrorAfterInitialization();
            this.canvas.redraw(this.graph.getPlotVals(), this.graph.getTestPlotVals());
        } else if (arg.equals("Redraw")) {
            this.canvas.redraw(this.graph.getPlotVals(), this.graph.getTestPlotVals());
        } else if (arg.equals("Close")) {
            this.setVisible(false);
        } else if (arg.equals("Clear")) {
            this.clear();
        } else if (arg.equals("Print")) {
            try {
                this.canvas.print(this);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        String arg = e.getItem().toString();
        if (arg.equals("Logarithmic Scale")) {
            this.canvas.useLogScale(this.log.isSelected());
        }
    }

    @Override
    public void windowClosing(WindowEvent e) {
        this.setVisible(false);
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowClosed(WindowEvent e) {
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }

    @Override
    public void componentResized(ComponentEvent e) {
        this.canvas.resetSteps();
        this.repaint();
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentShown(ComponentEvent e) {
    }
}

