/*
 * Decompiled with CFR 0.152.
 */
package AIspace.neural.dialogs;

import AIspace.graphToolKit.dialogs.BasicDialog;
import AIspace.graphToolKit.elements.Node;
import AIspace.neural.NeuralGraph;
import AIspace.neural.elements.NeuralNode;
import java.awt.Color;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class CalculateOutputDialog
extends BasicDialog {
    private static final long serialVersionUID = 1L;
    private JLabel[] labelInputs;
    private JTextField[] textInputs;
    private Integer[] indexInputs;
    private JLabel[] labelHidden;
    private JTextField[] textHidden;
    private Integer[] indexHidden;
    private JLabel[] labelOutputs;
    private JTextField[] textOutputs;
    private Integer[] indexOutputs;
    private JButton button1;
    private JButton button2;
    private JLabel labelError;
    private JPanel p;
    private NeuralGraph graph;
    private int numInputs;
    private int numHidden;
    private int numOutputs;
    private boolean displayHidden;

    public CalculateOutputDialog(JFrame parent, NeuralGraph g) {
        super(parent, "Calculate Output", true);
        NeuralNode tmpNode;
        this.graph = g;
        this.numHidden = 0;
        this.numOutputs = 0;
        this.numInputs = 0;
        Iterator<Node> nodeItr = this.graph.getNodes();
        while (nodeItr.hasNext()) {
            tmpNode = (NeuralNode)nodeItr.next();
            if (tmpNode.getNumParentNodes() == 0 && tmpNode.getNumChildrenNodes() > 0) {
                ++this.numInputs;
                continue;
            }
            if (tmpNode.getNumChildrenNodes() == 0 && tmpNode.getNumParentNodes() > 0) {
                ++this.numOutputs;
                continue;
            }
            if (tmpNode.getNumChildrenNodes() <= 0 || tmpNode.getNumParentNodes() <= 0) continue;
            ++this.numHidden;
        }
        this.displayHidden = true;
        if (this.numHidden > 20) {
            this.displayHidden = false;
        }
        if (this.numInputs > 0) {
            this.labelInputs = new JLabel[this.numInputs];
            this.textInputs = new JTextField[this.numInputs];
            this.indexInputs = new Integer[this.numInputs];
        }
        if (this.numHidden > 0 && this.displayHidden) {
            this.labelHidden = new JLabel[this.numHidden];
            this.textHidden = new JTextField[this.numHidden];
            this.indexHidden = new Integer[this.numHidden];
        }
        if (this.numOutputs > 0) {
            this.labelOutputs = new JLabel[this.numOutputs];
            this.textOutputs = new JTextField[this.numOutputs];
            this.indexOutputs = new Integer[this.numOutputs];
        }
        int countInput = 0;
        int countHidden = 0;
        int countOutput = 0;
        int numNodes = 0;
        nodeItr = this.graph.getNodes();
        while (nodeItr.hasNext()) {
            tmpNode = (NeuralNode)nodeItr.next();
            String nodeName = tmpNode.getLabel();
            if (nodeName.equals("")) {
                nodeName = new String("Node " + tmpNode.getIndex());
            }
            if (tmpNode.getNumParentNodes() == 0 && tmpNode.getNumChildrenNodes() > 0) {
                this.labelInputs[countInput] = new JLabel(nodeName);
                this.textInputs[countInput] = new JTextField("", 10);
                this.indexInputs[countInput] = new Integer(tmpNode.getIndex());
                ++numNodes;
                ++countInput;
                continue;
            }
            if (tmpNode.getNumChildrenNodes() == 0 && tmpNode.getNumParentNodes() > 0) {
                this.labelOutputs[countOutput] = new JLabel(nodeName);
                this.textOutputs[countOutput] = new JTextField("", 10);
                this.indexOutputs[countOutput] = new Integer(numNodes);
                ++countOutput;
                ++numNodes;
                continue;
            }
            if (tmpNode.getNumChildrenNodes() <= 0 || tmpNode.getNumParentNodes() <= 0 || !this.displayHidden) continue;
            this.labelHidden[countHidden] = new JLabel(nodeName);
            this.textHidden[countHidden] = new JTextField("", 10);
            this.indexHidden[countHidden] = new Integer(numNodes);
            ++countHidden;
            ++numNodes;
        }
        this.button1 = new JButton("Calculate");
        this.button1.addActionListener(this);
        this.button2 = new JButton("Cancel");
        this.button2.addActionListener(this);
        this.labelError = new JLabel("");
        this.p = new JPanel();
        if (this.displayHidden) {
            this.p.setLayout(new GridLayout(this.numInputs + this.numHidden + this.numOutputs + 4, 2));
        } else {
            this.p.setLayout(new GridLayout(this.numInputs + this.numOutputs + 4, 2));
        }
        this.p.add(new JLabel("Input Values:"));
        this.p.add(new JLabel(""));
        int i = 0;
        while (i < this.numInputs) {
            this.p.add(this.labelInputs[i]);
            this.p.add(this.textInputs[i]);
            ++i;
        }
        if (this.displayHidden) {
            this.p.add(new JLabel("Hidden Values:"));
            this.p.add(new JLabel(""));
            i = 0;
            while (i < this.numHidden) {
                this.p.add(this.labelHidden[i]);
                this.p.add(this.textHidden[i]);
                this.textHidden[i].setText("");
                this.textHidden[i].setEditable(false);
                ++i;
            }
        }
        this.p.add(new JLabel("Output Values:"));
        this.p.add(new JLabel(""));
        i = 0;
        while (i < this.numOutputs) {
            this.p.add(this.labelOutputs[i]);
            this.p.add(this.textOutputs[i]);
            this.textOutputs[i].setText("");
            this.textOutputs[i].setEditable(false);
            ++i;
        }
        this.p.add(this.button1);
        this.p.add(this.button2);
        this.getContentPane().add(this.p);
        this.getContentPane().add("South", this.labelError);
        this.pack();
        this.centerWindow();
        this.setVisible(true);
    }

    public void calculateOutputs() {
        try {
            String[] values = new String[this.numInputs];
            int i = 0;
            while (i < this.numInputs) {
                values[i] = String.valueOf(Double.valueOf(this.textInputs[i].getText()));
                ++i;
            }
            if (this.displayHidden) {
                Iterator<Node> nodeItr = this.graph.getNodes();
                ArrayList<NeuralNode> hiddenNodes = new ArrayList<NeuralNode>();
                while (nodeItr.hasNext()) {
                    NeuralNode tmpNode = (NeuralNode)nodeItr.next();
                    if (tmpNode.getNumChildrenNodes() <= 0 || tmpNode.getNumParentNodes() <= 0) continue;
                    hiddenNodes.add(tmpNode);
                }
                int i2 = 0;
                while (i2 < this.numHidden) {
                    double value = Double.valueOf(this.graph.nodeValue(values, (Node)hiddenNodes.get(i2)));
                    this.textHidden[i2].setText(new Double(value).toString());
                    this.textHidden[i2].setForeground(Color.red);
                    ++i2;
                }
            }
            int i3 = 0;
            while (i3 < this.numOutputs) {
                double value = Double.valueOf(this.graph.outputValue(values, i3));
                this.textOutputs[i3].setText(new Double(value).toString());
                this.textOutputs[i3].setForeground(Color.red);
                ++i3;
            }
        }
        catch (NumberFormatException e) {
            this.labelError.setText("Error: invalid number format.");
        }
    }

    @Override
    protected boolean actionOK() {
        return true;
    }

    @Override
    protected boolean actionCancel() {
        return true;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        super.actionPerformed(e);
        if (e.getActionCommand() == "Calculate") {
            this.labelError.setText("");
            this.calculateOutputs();
        }
    }
}

