/*
 * Decompiled with CFR 0.152.
 */
package AIspace.neural.dialogs;

import AIspace.graphToolKit.dialogs.BasicDialog;
import AIspace.neural.elements.NeuralEdge;
import java.awt.GridLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class EdgeDialog
extends BasicDialog {
    private JLabel labelParameters;
    private JTextField textParameters;
    private JButton buttonOk;
    private JButton buttonCancel;
    private JLabel labelError;
    private JPanel p;
    private NeuralEdge edge;

    public EdgeDialog(JFrame parent, NeuralEdge edge) {
        super(parent, "Edge Parameter Dialog", true);
        this.edge = edge;
        this.labelParameters = new JLabel("Set Weight for Edge");
        this.textParameters = new JTextField();
        this.textParameters.setText(new Double(edge.getCurrentParaValue()).toString());
        this.buttonOk = new JButton("OK");
        this.buttonOk.addActionListener(this);
        this.buttonCancel = new JButton("Cancel");
        this.buttonCancel.addActionListener(this);
        this.labelError = new JLabel("");
        this.p = new JPanel();
        this.p.setLayout(new GridLayout(2, 2));
        this.p.add(this.labelParameters);
        this.p.add(this.textParameters);
        this.p.add(this.buttonOk);
        this.p.add(this.buttonCancel);
        this.getContentPane().add(this.p);
        this.getContentPane().add("South", this.labelError);
        this.pack();
        this.centerWindow();
        this.setVisible(true);
    }

    public boolean setProperties() {
        try {
            double paraValues = Double.parseDouble(this.textParameters.getText());
            this.edge.setInitialParaValue(paraValues);
            this.edge.setCurrentParaValue(paraValues);
            return true;
        }
        catch (NumberFormatException e) {
            this.labelError.setText("Error: Parameters have invalid real number format!");
            return false;
        }
    }

    @Override
    protected boolean actionOK() {
        return this.setProperties();
    }

    @Override
    protected boolean actionCancel() {
        return true;
    }
}

