/*
 * Decompiled with CFR 0.152.
 */
package AIspace.neural.dialogs;

import AIspace.graphToolKit.GraphWindow;
import AIspace.neural.ExampleList;
import AIspace.neural.InlineNeuralApplet;
import AIspace.neural.NeuralGraph;
import AIspace.neural.NeuralWindow;
import AIspace.neural.dialogs.InputExampleDialog;
import AIspace.neural.dialogs.ParameterInputDialog;
import AIspace.neural.dialogs.SelectExamplesDialog;
import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.net.URL;
import java.util.ArrayList;
import java.util.Hashtable;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class ExampleDialog
extends JDialog
implements ActionListener,
WindowListener,
ItemListener {
    private JComboBox choiceComboBox;
    private JList targetList;
    protected Container window;
    protected ExampleList exampleList;
    protected JList trainingList;
    protected JList testList;
    protected DefaultListModel trainingModel;
    protected DefaultListModel testModel;
    protected DefaultListModel targetModel;
    private NeuralGraph graph;
    protected Font font;
    protected GridBagLayout gridBagLayout;
    protected GridBagConstraints gridBagConstraints;
    private ImageIcon rightArrowIcon;
    private ImageIcon leftArrowIcon;
    private JLabel trainingLabel;
    private JLabel testLabel;
    private boolean inline;

    public ExampleDialog(Container parent, NeuralGraph graph, ExampleList exampleList) {
        super(parent instanceof NeuralWindow ? (NeuralWindow)parent : null, "Edit Data Set Examples", false);
        this.window = parent;
        this.graph = graph;
        this.exampleList = exampleList;
        this.leftArrowIcon = ExampleDialog.createImageIcon("images/neural/arrowRight.png");
        this.rightArrowIcon = ExampleDialog.createImageIcon("images/neural/arrowLeft.png");
        this.gridBagLayout = new GridBagLayout();
        this.gridBagConstraints = new GridBagConstraints();
        this.gridBagConstraints.anchor = 18;
        this.gridBagConstraints.fill = 1;
        this.inline = !(this.window instanceof NeuralWindow);
        this.font = !this.inline ? new Font("monospaced", 0, ((NeuralWindow)parent).returnCanvas().getFontSize()) : new Font("monospaced", 0, ((InlineNeuralApplet)parent).getCanvas().getFontSize());
        this.targetList = new JList();
        this.targetList.setSelectionMode(2);
        this.targetModel = new DefaultListModel();
        this.targetList.setModel(this.targetModel);
        this.addWindowListener(this);
        this.buildDialog();
        this.populateLists();
    }

    private void buildDialog() {
        JPanel mainPanel = new JPanel();
        this.addComponent(this.makeTrainingPanel(), mainPanel, 0, 0, 1, 1, 0.5, 0.5);
        this.addComponent(this.makeCenterPanel(), mainPanel, 0, 1, 1, 1, 0.0, 0.0);
        this.addComponent(this.makeTestPanel(), mainPanel, 0, 2, 1, 1, 0.5, 0.5);
        this.addComponent(this.makeBottomPanel(), mainPanel, 1, 2, 1, 1, 0.0, 0.0);
        mainPanel.setLayout(this.gridBagLayout);
        mainPanel.setPreferredSize(new Dimension(1000, 270));
        this.getContentPane().add(mainPanel);
        this.pack();
        this.centerWindow();
        this.setVisible(true);
    }

    private void updateTrainingLabel(String label) {
        this.trainingLabel.setText(label);
    }

    private void updateTestLabel(String label) {
        this.testLabel.setText(label);
    }

    private JPanel makeTrainingPanel() {
        JPanel trainingPanel = new JPanel(new BorderLayout());
        this.trainingLabel = new JLabel("Training Examples (" + this.exampleList.getTrainingArrayList().size() + ")");
        this.trainingModel = new DefaultListModel();
        this.trainingList = new JList();
        this.trainingList.setModel(this.trainingModel);
        this.trainingList.setSelectionMode(2);
        this.trainingList.setFont(this.font);
        JScrollPane listScroller = new JScrollPane(this.trainingList);
        JPanel trainingPanelButtonPanel = this.makeTrainingButtonPanel();
        trainingPanel.add("North", this.trainingLabel);
        trainingPanel.add("Center", listScroller);
        trainingPanel.add("South", trainingPanelButtonPanel);
        return trainingPanel;
    }

    private JPanel makeTestPanel() {
        JPanel testPanel = new JPanel(new BorderLayout());
        this.testLabel = new JLabel("Test Examples (" + this.exampleList.getTestArrayList().size() + ")");
        this.testList = new JList();
        this.testModel = new DefaultListModel();
        this.testList.setModel(this.testModel);
        this.testList.setSelectionMode(2);
        this.testList.setFont(this.font);
        JScrollPane listScroller = new JScrollPane(this.testList);
        JPanel trainingPanelButtonPanel = this.makeTestButtonPanel();
        testPanel.add("North", this.testLabel);
        testPanel.add("Center", listScroller);
        testPanel.add("South", trainingPanelButtonPanel);
        return testPanel;
    }

    private JPanel makeTrainingButtonPanel() {
        JPanel buttonPanel = new JPanel();
        JButton button = new JButton("Add New");
        button.setActionCommand("add_training");
        button.setToolTipText("Add Training Example");
        button.addActionListener(this);
        buttonPanel.add(button);
        button = new JButton("Remove");
        button.setActionCommand("remove_training");
        button.setToolTipText("Remove Training Examples");
        button.addActionListener(this);
        buttonPanel.add(button);
        button = new JButton("Edit");
        button.setActionCommand("edit_training");
        button.setToolTipText("Edit Training Example");
        button.addActionListener(this);
        buttonPanel.add(button);
        String[] selectChoice = new String[]{"Select All", "Select None", "Select % of Examples", "Invert Selection"};
        this.choiceComboBox = new JComboBox<String>(selectChoice);
        this.choiceComboBox.setSelectedIndex(1);
        this.choiceComboBox.setName("TrainingChoice");
        this.choiceComboBox.addActionListener(this);
        buttonPanel.add(this.choiceComboBox);
        return buttonPanel;
    }

    private JPanel makeTestButtonPanel() {
        JPanel buttonPanel = new JPanel();
        JButton button = new JButton("Add New");
        button.setActionCommand("add_test");
        button.setToolTipText("Add Test Example");
        button.addActionListener(this);
        buttonPanel.add(button);
        button = new JButton("Remove");
        button.setActionCommand("remove_test");
        button.setToolTipText("Remove Test Examples");
        button.addActionListener(this);
        buttonPanel.add(button);
        button = new JButton("Edit");
        button.setActionCommand("edit_test");
        button.setToolTipText("Edit Test Example");
        button.addActionListener(this);
        buttonPanel.add(button);
        String[] selectChoice = new String[]{"Select All", "Select None", "Select % of Examples", "Invert Selection"};
        this.choiceComboBox = new JComboBox<String>(selectChoice);
        this.choiceComboBox.setSelectedIndex(1);
        this.choiceComboBox.setName("TestChoice");
        this.choiceComboBox.addActionListener(this);
        buttonPanel.add(this.choiceComboBox);
        return buttonPanel;
    }

    private JPanel makeBottomPanel() {
        JPanel bottomPanel = new JPanel(new FlowLayout(2));
        JButton closeButton = new JButton("Close Window");
        closeButton.addActionListener(this);
        bottomPanel.add(closeButton);
        return bottomPanel;
    }

    private JPanel makeCenterPanel() {
        JPanel centerPanel = new JPanel(new GridLayout(4, 2));
        JButton rightButton = new JButton(this.leftArrowIcon);
        rightButton.setActionCommand("Move to Test");
        rightButton.addActionListener(this);
        JButton leftButton = new JButton(this.rightArrowIcon);
        leftButton.setActionCommand("Move to Training");
        leftButton.addActionListener(this);
        centerPanel.add(new JLabel());
        centerPanel.add(rightButton);
        centerPanel.add(leftButton);
        return centerPanel;
    }

    public void changeFont(Font newFont) {
        this.font = newFont;
        this.trainingList.setFont(this.font);
        this.testList.setFont(this.font);
        this.repaint();
    }

    private void populateLists() {
        this.populateList(this.trainingList, this.exampleList.getTrainingArrayList());
        this.populateList(this.testList, this.exampleList.getTestArrayList());
    }

    private void populateList(JList currList, ArrayList<Hashtable<Integer, String>> dataList) {
        DefaultListModel currModel = (DefaultListModel)currList.getModel();
        currList.setSelectionMode(2);
        currModel.clear();
        String heading = new String("");
        if (dataList.size() < 1 || this.exampleList.getNumParameters() < 2) {
            heading = "NO DATA";
            currModel.addElement(heading);
            return;
        }
        String[] parameters = this.exampleList.getParameters();
        heading = String.valueOf(heading) + "   ";
        int[] colPos = new int[parameters.length];
        int i = 0;
        while (i < this.exampleList.getNumParameters()) {
            colPos[i] = heading.length();
            heading = String.valueOf(heading) + parameters[i];
            int j = 0;
            while (j < 5) {
                heading = String.valueOf(heading) + " ";
                ++j;
            }
            ++i;
        }
        currModel.addElement(heading);
        i = 0;
        while (i < dataList.size()) {
            String display = new String(String.valueOf(i + 1) + ": ");
            Hashtable<Integer, String> oneExample = dataList.get(i);
            int j = 0;
            while (j < this.exampleList.getNumParameters()) {
                String value = oneExample.get(new Integer(j));
                if (value != null) {
                    while (display.length() < colPos[j]) {
                        display = String.valueOf(display) + " ";
                    }
                    display = String.valueOf(display) + value;
                }
                ++j;
            }
            currModel.addElement(display);
            ++i;
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        if (command.equals("Move to Test")) {
            int[] inds = this.trainingList.getSelectedIndices();
            if (inds.length == 0) {
                return;
            }
            inds = this.adjustIndexes(inds);
            this.exampleList.moveToTest(inds);
            this.updateTrainingLabel("Training Examples (" + this.exampleList.getTrainingArrayList().size() + ")");
            this.updateTestLabel("Test Examples (" + this.exampleList.getTestArrayList().size() + ")");
            this.populateLists();
            int i = this.testModel.getSize() - 1;
            while (i > this.testModel.getSize() - inds.length - 1) {
                this.testList.setSelectedIndex(i);
                --i;
            }
            return;
        }
        if (command.equals("Move to Training")) {
            int[] inds = this.testList.getSelectedIndices();
            if (inds.length == 0) {
                return;
            }
            inds = this.adjustIndexes(inds);
            this.exampleList.moveToTraining(inds);
            this.updateTrainingLabel("Training Examples (" + this.exampleList.getTrainingArrayList().size() + ")");
            this.updateTestLabel("Test Examples (" + this.exampleList.getTestArrayList().size() + ")");
            this.populateLists();
            int i = this.trainingModel.getSize() - 1;
            while (i > this.trainingModel.getSize() - inds.length - 1) {
                this.trainingList.setSelectedIndex(i);
                --i;
            }
            return;
        }
        if (command.equals("remove_training")) {
            int[] inds = this.trainingList.getSelectedIndices();
            if (inds.length == 0) {
                return;
            }
            inds = this.adjustIndexes(inds);
            this.exampleList.removeTrainingExamples(inds);
            this.updateTrainingLabel("Training Examples (" + this.exampleList.getTrainingArrayList().size() + ")");
            this.populateLists();
            return;
        }
        if (command.equals("remove_test")) {
            int[] inds = this.testList.getSelectedIndices();
            if (inds.length == 0) {
                return;
            }
            inds = this.adjustIndexes(inds);
            this.exampleList.removeTestExamples(inds);
            this.updateTestLabel("Test Examples (" + this.exampleList.getTestArrayList().size() + ")");
            this.populateLists();
            return;
        }
        if (command.equals("add_training")) {
            if (this.inline) {
                if (this.exampleList.getNumParameters() < 2) {
                    new ParameterInputDialog(null, this.exampleList);
                } else {
                    new InputExampleDialog(null, this, this.graph, "Input Training Examples");
                }
            } else if (this.exampleList.getNumParameters() < 2) {
                new ParameterInputDialog((JFrame)((NeuralWindow)this.window), this.exampleList);
            } else {
                new InputExampleDialog((JFrame)((NeuralWindow)this.window), this, this.graph, "Input Training Examples");
            }
            this.updateTrainingLabel("Training Examples (" + this.exampleList.getTrainingArrayList().size() + ")");
            this.populateLists();
            return;
        }
        if (command.equals("add_test")) {
            if (this.inline) {
                if (this.exampleList.getNumParameters() < 2) {
                    new ParameterInputDialog(null, this.exampleList);
                } else {
                    new InputExampleDialog(null, this, this.graph, "Input Test Examples");
                }
            } else if (this.exampleList.getNumParameters() < 2) {
                new ParameterInputDialog((JFrame)((NeuralWindow)this.window), this.exampleList);
            } else {
                new InputExampleDialog((JFrame)((NeuralWindow)this.window), this, this.graph, "Input Test Examples");
            }
            this.updateTestLabel("Test Examples (" + this.exampleList.getTestArrayList().size() + ")");
            this.populateLists();
            return;
        }
        if (command.equals("Close Window")) {
            this.setVisible(false);
            return;
        }
        if (command.equals("edit_training")) {
            int[] indexes = this.trainingList.getSelectedIndices();
            if (indexes.length == 0 || indexes[0] == 0) {
                return;
            }
            if (this.inline) {
                new InputExampleDialog(null, this, this.graph, "Edit Training Example");
            } else {
                new InputExampleDialog((JFrame)((NeuralWindow)this.window), this, this.graph, "Edit Training Example");
            }
            this.populateLists();
            return;
        }
        if (command.equals("edit_test")) {
            int[] indexes = this.testList.getSelectedIndices();
            if (indexes.length == 0 || indexes[0] == 0) {
                return;
            }
            if (this.inline) {
                new InputExampleDialog(null, this, this.graph, "Edit Test Example");
            } else {
                new InputExampleDialog((JFrame)((NeuralWindow)this.window), this, this.graph, "Edit Test Example");
            }
            this.populateLists();
            return;
        }
        String selection = (String)((JComboBox)e.getSource()).getSelectedItem();
        String sourceName = ((JComboBox)e.getSource()).getName();
        if (sourceName == "TrainingChoice") {
            this.targetList = this.trainingList;
        } else if (sourceName == "TestChoice") {
            this.targetList = this.testList;
        }
        if (selection == "Select % of Examples") {
            if (this.inline) {
                new SelectExamplesDialog(null, this.targetList);
            } else {
                new SelectExamplesDialog((JFrame)((NeuralWindow)this.window), this.targetList);
            }
        } else if (selection == "Select All") {
            this.selectAll(this.targetList);
        } else if (selection == "Select None") {
            this.deSelectAll(this.targetList);
        } else if (selection == "Invert Selection") {
            this.invertSelection(this.targetList);
        }
    }

    private int[] adjustIndexes(int[] indexes) {
        int i = 0;
        while (i < indexes.length) {
            indexes[i] = indexes[i] - 1;
            ++i;
        }
        if (indexes[0] < 0) {
            int[] newIndexes = new int[indexes.length - 1];
            int i2 = 1;
            while (i2 < indexes.length) {
                newIndexes[i2 - 1] = indexes[i2];
                ++i2;
            }
            indexes = newIndexes;
        }
        return indexes;
    }

    private void deSelectAll(JList targetList) {
        targetList.clearSelection();
    }

    public JList getTrainingList() {
        return this.trainingList;
    }

    public JList getTestList() {
        return this.testList;
    }

    private void selectAll(JList targetList) {
        this.deSelectAll(targetList);
        DefaultListModel targetModel = (DefaultListModel)targetList.getModel();
        targetList.setSelectionMode(2);
        targetList.setModel(targetModel);
        int[] indices = new int[targetModel.getSize() - 1];
        int i = 1;
        while (i < targetModel.getSize()) {
            indices[i - 1] = i;
            ++i;
        }
        targetList.setSelectedIndices(indices);
    }

    private void invertSelection(JList targetList) {
        DefaultListModel targetModel = (DefaultListModel)targetList.getModel();
        ArrayList<Integer> vecInds = new ArrayList<Integer>();
        int[] selectedinds = targetList.getSelectedIndices();
        int i = 1;
        while (i < targetModel.getSize()) {
            boolean flag = false;
            int j = 0;
            while (j < selectedinds.length) {
                if (selectedinds[j] == i) {
                    flag = true;
                }
                ++j;
            }
            if (!flag) {
                vecInds.add(new Integer(i));
            }
            ++i;
        }
        int[] inds = new int[vecInds.size()];
        int j = 0;
        while (j < vecInds.size()) {
            inds[j] = (Integer)vecInds.get(j);
            ++j;
        }
        targetList.setSelectedIndices(inds);
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        String selection = (String)((JComboBox)e.getSource()).getSelectedItem();
        String sourceName = ((JComboBox)e.getSource()).getName();
        JList targetList = null;
        if (sourceName == "TrainingChoice") {
            targetList = this.trainingList;
        } else if (sourceName == "TestChoice") {
            targetList = this.testList;
        }
        if (selection == "Select Percentage of Examples") {
            if (this.inline) {
                new SelectExamplesDialog(null, targetList);
            } else {
                new SelectExamplesDialog((JFrame)((NeuralWindow)this.window), targetList);
            }
        } else if (selection == "Select All") {
            this.selectAll(targetList);
        } else if (selection == "Select None") {
            this.deSelectAll(targetList);
        } else if (selection == "Invert Selection") {
            this.invertSelection(targetList);
        }
    }

    private void addComponent(JComponent c, Container p, int row, int column, int width, int height, double wx, double wy) {
        this.gridBagConstraints.gridx = column;
        this.gridBagConstraints.gridy = row;
        this.gridBagConstraints.gridwidth = width;
        this.gridBagConstraints.gridheight = height;
        this.gridBagConstraints.weightx = wx;
        this.gridBagConstraints.weighty = wy;
        this.gridBagLayout.setConstraints(c, this.gridBagConstraints);
        p.add(c);
    }

    protected static ImageIcon createImageIcon(String path) {
        URL imgURL = GraphWindow.class.getResource(path);
        if (imgURL != null) {
            return new ImageIcon(imgURL);
        }
        System.err.println("Couldn't find file: " + path);
        return null;
    }

    private void centerWindow() {
        if (!this.inline) {
            int midX = this.window.getLocationOnScreen().x + this.window.getSize().width / 2;
            int midY = this.window.getLocationOnScreen().y + this.window.getSize().height / 2;
            this.setLocation(midX - this.getSize().width / 2, midY - this.getSize().height / 2);
        } else {
            this.setLocation(50, 50);
        }
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowClosed(WindowEvent e) {
    }

    @Override
    public void windowClosing(WindowEvent e) {
        this.setVisible(false);
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }
}

