/*
 * Decompiled with CFR 0.152.
 */
package AIspace.neural.dialogs;

import AIspace.graphToolKit.dialogs.BasicDialog;
import AIspace.neural.NeuralGraph;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;

public class InitializationOptionsDialog
extends BasicDialog
implements CaretListener,
ItemListener {
    private static final long serialVersionUID = 1L;
    private JTextField textValue;
    private JTextField textBound;
    private JCheckBox checkValue;
    private JCheckBox checkBound;
    private JLabel labelError;
    private NeuralGraph graph;

    public InitializationOptionsDialog(JFrame parent, NeuralGraph graph, boolean visible) {
        super(parent, "Parameter Initialization Options", true);
        this.graph = graph;
        this.checkValue = new JCheckBox("Constant Parameter");
        this.checkValue.setSelected(!graph.getInitParamType());
        this.checkValue.addItemListener(this);
        JLabel labelValue = new JLabel("Value: ");
        JPanel panelValue = new JPanel(new BorderLayout());
        panelValue.add((Component)this.checkValue, "West");
        panelValue.add((Component)labelValue, "East");
        this.textValue = new JTextField(String.valueOf(graph.getInitParamValue()), 20);
        this.textValue.setEnabled(!graph.getInitParamType());
        this.textValue.addCaretListener(this);
        this.checkBound = new JCheckBox("Random Parameter");
        this.checkBound.setSelected(graph.getInitParamType());
        this.checkBound.addItemListener(this);
        JLabel labelBound = new JLabel("Bound: ");
        JPanel panelBound = new JPanel(new BorderLayout());
        panelBound.add((Component)this.checkBound, "West");
        panelBound.add((Component)labelBound, "East");
        this.textBound = new JTextField(String.valueOf(graph.getInitParamBound()), 20);
        this.textBound.setEnabled(graph.getInitParamType());
        this.textBound.addCaretListener(this);
        JButton buttonOk = new JButton("OK");
        buttonOk.addActionListener(this);
        JButton buttonCancel = new JButton("Cancel");
        buttonCancel.addActionListener(this);
        buttonCancel.setPreferredSize(new Dimension(50, buttonCancel.getHeight()));
        this.labelError = new JLabel("", 0);
        JPanel panel = new JPanel(new GridLayout(3, 2));
        panel.add(panelValue);
        panel.add(this.textValue);
        panel.add(panelBound);
        panel.add(this.textBound);
        panel.add(buttonOk);
        panel.add(buttonCancel);
        this.getContentPane().add(panel);
        this.getContentPane().add("South", this.labelError);
        this.pack();
        this.centerWindow();
        this.setVisible(visible);
    }

    public void open() {
        this.textBound.setText(String.valueOf(this.graph.getInitParamValue()));
        this.textBound.setText(String.valueOf(this.graph.getInitParamBound()));
        this.pack();
        this.setVisible(true);
    }

    public boolean setProperties() {
        double bound;
        block3: {
            try {
                this.graph.setInitParamValue(Double.parseDouble(this.textValue.getText()));
                bound = Double.parseDouble(this.textBound.getText());
                if (!(bound <= 0.0)) break block3;
                this.labelError.setText("Error: parameter bound must be positive.");
                return false;
            }
            catch (NumberFormatException e) {
                this.labelError.setText("Error: Invalid number format.");
                return false;
            }
        }
        this.graph.setInitParamBound(bound);
        this.graph.setInitParamType(this.checkBound.isSelected());
        return true;
    }

    @Override
    protected boolean actionOK() {
        return this.setProperties();
    }

    @Override
    protected boolean actionCancel() {
        return true;
    }

    @Override
    public void caretUpdate(CaretEvent e) {
        this.labelError.setText("");
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getSource() == this.checkValue) {
            this.checkBound.removeActionListener(this);
            this.checkBound.setSelected(!this.checkValue.isSelected());
            this.textBound.setEnabled(!this.checkValue.isSelected());
            this.checkBound.addActionListener(this);
        } else if (e.getSource() == this.checkBound) {
            this.checkValue.removeActionListener(this);
            this.checkValue.setSelected(!this.checkBound.isSelected());
            this.textValue.setEnabled(!this.checkBound.isSelected());
            this.checkValue.addActionListener(this);
        }
    }
}

