/*
 * Decompiled with CFR 0.152.
 */
package AIspace.neural.dialogs;

import AIspace.graphToolKit.dialogs.BasicDialog;
import AIspace.graphToolKit.elements.Node;
import AIspace.neural.NeuralGraph;
import AIspace.neural.dialogs.ExampleDialog;
import AIspace.neural.elements.NeuralNode;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.util.Hashtable;
import java.util.Iterator;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class InputExampleDialog
extends BasicDialog {
    private static final long serialVersionUID = 1L;
    public static final int TRAINING_ADD = 0;
    public static final int TEST_ADD = 1;
    public static final int TRAINING_EDIT = 3;
    public static final int TEST_EDIT = 4;
    private JLabel[] labelInputs;
    private JTextField[] textInputs;
    private Integer[] indexInputs;
    private JLabel[] labelOutputs;
    private JTextField[] textOutputs;
    private Integer[] indexOutputs;
    private JButton button1;
    private JButton button2;
    private JLabel labelError;
    private JPanel p;
    private NeuralGraph graph;
    private ExampleDialog dialog;
    private int numInputs;
    private int numOutputs;
    private int mode;

    public InputExampleDialog(JFrame parent, ExampleDialog dialogParent, NeuralGraph g, String title) {
        super(parent, title, true);
        NeuralNode tmpNode;
        this.dialog = dialogParent;
        if (title == "Input Training Examples") {
            this.mode = 0;
        } else if (title == "Input Test Examples") {
            this.mode = 1;
        } else if (title == "Edit Training Example") {
            this.mode = 3;
        } else if (title == "Edit Test Example") {
            this.mode = 4;
        }
        this.graph = g;
        this.numOutputs = 0;
        this.numInputs = 0;
        Iterator<Node> nodeItr = this.graph.getNodes();
        while (nodeItr.hasNext()) {
            tmpNode = (NeuralNode)nodeItr.next();
            if (tmpNode.getNumParentNodes() == 0 && tmpNode.getNumChildrenNodes() > 0) {
                ++this.numInputs;
            }
            if (tmpNode.getNumChildrenNodes() != 0 || tmpNode.getNumParentNodes() <= 0) continue;
            ++this.numOutputs;
        }
        if (this.numInputs > 0) {
            this.labelInputs = new JLabel[this.numInputs];
            this.textInputs = new JTextField[this.numInputs];
            this.indexInputs = new Integer[this.numInputs];
        }
        if (this.numOutputs > 0) {
            this.labelOutputs = new JLabel[this.numOutputs];
            this.textOutputs = new JTextField[this.numOutputs];
            this.indexOutputs = new Integer[this.numOutputs];
        }
        int countInput = 0;
        int countOutput = 0;
        int numNodes = 0;
        int exampleIndex = -1;
        Hashtable oneExample = null;
        if (this.mode == 3) {
            exampleIndex = dialogParent.getTrainingList().getSelectedIndices()[0];
            dialogParent.getTrainingList().setSelectedIndex(exampleIndex);
            oneExample = this.graph.getExampleList().getTrainingExampleValues(exampleIndex - 1);
        } else if (this.mode == 4) {
            exampleIndex = dialogParent.getTestList().getSelectedIndices()[0];
            dialogParent.getTestList().setSelectedIndex(exampleIndex);
            oneExample = this.graph.getExampleList().getTestExampleValues(exampleIndex - 1);
        }
        nodeItr = this.graph.getNodes();
        while (nodeItr.hasNext()) {
            tmpNode = (NeuralNode)nodeItr.next();
            String nodeName = tmpNode.getLabel();
            if (nodeName.equals("")) {
                nodeName = new String("Node " + tmpNode.getIndex());
            }
            if (tmpNode.getNumParentNodes() == 0 && tmpNode.getNumChildrenNodes() > 0) {
                this.labelInputs[countInput] = new JLabel(nodeName);
                this.textInputs[countInput] = exampleIndex != -1 ? new JTextField((String)oneExample.get(new Integer(countInput)), 10) : new JTextField("", 10);
                this.indexInputs[countInput] = new Integer(tmpNode.getIndex());
                ++numNodes;
                ++countInput;
            }
            if (tmpNode.getNumChildrenNodes() != 0 || tmpNode.getNumParentNodes() <= 0) continue;
            this.labelOutputs[countOutput] = new JLabel(nodeName);
            this.textOutputs[countOutput] = exampleIndex != -1 ? new JTextField((String)oneExample.get(new Integer(countInput + countOutput)), 10) : new JTextField("", 10);
            this.indexOutputs[countOutput] = new Integer(numNodes);
            ++countOutput;
            ++numNodes;
        }
        if (this.mode == 0 || this.mode == 1) {
            this.button1 = new JButton("Add");
        } else if (this.mode == 3 || this.mode == 4) {
            this.button1 = new JButton("Update");
        }
        this.button1.addActionListener(this);
        this.button2 = new JButton("Cancel");
        this.button2.addActionListener(this);
        this.labelError = new JLabel("");
        this.p = new JPanel();
        this.p.setLayout(new GridLayout(this.numInputs + this.numOutputs + 4, 2));
        this.p.add(new JLabel("Input Values:"));
        this.p.add(new JLabel(""));
        int i = 0;
        while (i < this.numInputs) {
            this.p.add(this.labelInputs[i]);
            this.p.add(this.textInputs[i]);
            ++i;
        }
        this.p.add(new JLabel("Output Values:"));
        this.p.add(new JLabel(""));
        i = 0;
        while (i < this.numOutputs) {
            this.p.add(this.labelOutputs[i]);
            this.p.add(this.textOutputs[i]);
            ++i;
        }
        this.p.add(this.button1);
        this.p.add(this.button2);
        this.getContentPane().add(this.p);
        this.getContentPane().add("South", this.labelError);
        this.pack();
        this.centerWindow();
        this.setVisible(true);
    }

    public boolean setExample() {
        try {
            Integer[] indices = new Integer[this.numInputs + this.numOutputs];
            Double[] values = new Double[this.numInputs + this.numOutputs];
            int i = 0;
            while (i < this.numInputs) {
                indices[i] = new Integer(i);
                values[i] = Double.valueOf(this.textInputs[i].getText());
                ++i;
            }
            i = 0;
            while (i < this.numOutputs) {
                indices[i + this.numInputs] = new Integer(i + this.numInputs);
                values[i + this.numInputs] = Double.valueOf(this.textOutputs[i].getText());
                ++i;
            }
            if (this.mode == 0) {
                this.graph.addTrainingExample(indices, values);
            } else {
                this.graph.addTestExample(indices, values);
            }
            return true;
        }
        catch (NumberFormatException e) {
            this.labelError.setText("Error: Invalid number format.");
            return false;
        }
    }

    public boolean updateExample() {
        int index;
        String[] values;
        Integer[] indices;
        block10: {
            try {
                indices = new Integer[this.numInputs + this.numOutputs];
                values = new String[this.numInputs + this.numOutputs];
                boolean valuesOk = true;
                int i = 0;
                while (i < this.numInputs) {
                    indices[i] = this.indexInputs[i];
                    values[i] = "" + Double.valueOf(this.textInputs[i].getText().trim());
                    if (values[i].equals("")) {
                        valuesOk = false;
                    }
                    ++i;
                }
                i = this.numInputs;
                while (i < this.numInputs + this.numOutputs) {
                    indices[i] = this.indexOutputs[i - this.numInputs];
                    values[i] = "" + Double.valueOf(this.textOutputs[i - this.numInputs].getText().trim());
                    if (values[i].equals("")) {
                        valuesOk = false;
                    }
                    ++i;
                }
                if (valuesOk) break block10;
                this.labelError.setText("Error: Please enter all parameters.");
                return false;
            }
            catch (NumberFormatException e) {
                this.labelError.setText("Error: Invalid number format.");
                this.pack();
                return false;
            }
        }
        if (this.mode == 3) {
            index = this.dialog.getTrainingList().getSelectedIndices()[0];
            this.graph.getExampleList().updateTrainingExample(index - 1, indices, values);
        } else if (this.mode == 4) {
            index = this.dialog.getTestList().getSelectedIndices()[0];
            this.graph.getExampleList().updateTestExample(index - 1, indices, values);
        }
        return true;
    }

    @Override
    protected boolean actionOK() {
        return true;
    }

    @Override
    protected boolean actionCancel() {
        return true;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        super.actionPerformed(e);
        if (e.getActionCommand() == "Add") {
            if (this.setExample()) {
                this.setVisible(false);
                this.dispose();
            }
        } else if (e.getActionCommand() == "Update" && this.updateExample()) {
            this.setVisible(false);
            this.dispose();
        }
    }
}

