/*
 * Decompiled with CFR 0.152.
 */
package AIspace.neural.dialogs;

import AIspace.graphToolKit.dialogs.BasicFrame;
import AIspace.graphToolKit.elements.Node;
import AIspace.neural.NeuralGraph;
import AIspace.neural.elements.NeuralNode;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.util.Iterator;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class InputExampleFrame
extends BasicFrame {
    private JLabel[] labelInputs;
    private JTextField[] textInputs;
    private Integer[] indexInputs;
    private JLabel[] labelOutputs;
    private JTextField[] textOutputs;
    private Integer[] indexOutputs;
    private JButton button1;
    private JButton button2;
    private JLabel labelError;
    private JPanel p;
    private NeuralGraph graph;
    private int numInputs;
    private int numOutputs;
    private boolean mode;

    public InputExampleFrame(NeuralGraph g, String title, boolean which) {
        super(title);
        NeuralNode tmpNode;
        super.setOKString("Add");
        this.graph = g;
        this.mode = which;
        this.numOutputs = 0;
        this.numInputs = 0;
        Iterator<Node> nodeItr = this.graph.getNodes();
        while (nodeItr.hasNext()) {
            tmpNode = (NeuralNode)nodeItr.next();
            if (tmpNode.getNumParentNodes() == 0) {
                ++this.numInputs;
            }
            if (tmpNode.getNumChildrenNodes() != 0) continue;
            ++this.numOutputs;
        }
        if (this.numInputs > 0) {
            this.labelInputs = new JLabel[this.numInputs];
            this.textInputs = new JTextField[this.numInputs];
            this.indexInputs = new Integer[this.numInputs];
        }
        if (this.numOutputs > 0) {
            this.labelOutputs = new JLabel[this.numOutputs];
            this.textOutputs = new JTextField[this.numOutputs];
            this.indexOutputs = new Integer[this.numOutputs];
        }
        int countInput = 0;
        int countOutput = 0;
        nodeItr = this.graph.getNodes();
        while (nodeItr.hasNext()) {
            tmpNode = (NeuralNode)nodeItr.next();
            String nodeName = tmpNode.getLabel();
            if (nodeName.equals("")) {
                nodeName = new String("Node " + tmpNode.getIndex());
            }
            if (tmpNode.getNumParentNodes() == 0) {
                this.labelInputs[countInput] = new JLabel(nodeName);
                this.textInputs[countInput] = new JTextField("0", 20);
                this.indexInputs[countInput] = new Integer(tmpNode.getIndex());
                ++countInput;
            }
            if (tmpNode.getNumChildrenNodes() != 0) continue;
            this.labelOutputs[countOutput] = new JLabel(nodeName);
            this.textOutputs[countOutput] = new JTextField("0", 20);
            this.indexOutputs[countOutput] = new Integer(tmpNode.getIndex());
            ++countOutput;
        }
        this.button1 = this.mode ? new JButton("Add") : new JButton("Calculate");
        this.button1.addActionListener(this);
        this.button2 = new JButton("Cancel");
        this.button2.addActionListener(this);
        this.labelError = new JLabel("");
        this.p = new JPanel();
        this.p.setLayout(new GridLayout(this.numInputs + this.numOutputs + 4, 2));
        this.p.add(new JLabel("Input Values:"));
        this.p.add(new JLabel(""));
        int i = 0;
        while (i < this.numInputs) {
            this.p.add(this.labelInputs[i]);
            this.p.add(this.textInputs[i]);
            ++i;
        }
        this.p.add(new JLabel("Output Values:"));
        this.p.add(new JLabel(""));
        i = 0;
        while (i < this.numOutputs) {
            this.p.add(this.labelOutputs[i]);
            this.p.add(this.textOutputs[i]);
            if (!this.mode) {
                this.textOutputs[i].setText("");
                this.textOutputs[i].setEditable(false);
            }
            ++i;
        }
        this.p.add(this.button1);
        this.p.add(this.button2);
        this.add(this.p);
        this.add("South", this.labelError);
        this.pack();
        this.centerWindow();
        this.setVisible(true);
    }

    public boolean setExample() {
        try {
            Integer[] indices = new Integer[this.numInputs + this.numOutputs];
            Double[] values = new Double[this.numInputs + this.numOutputs];
            int i = 0;
            while (i < this.numInputs) {
                indices[i] = this.indexInputs[i];
                values[i] = Double.valueOf(this.textInputs[i].getText());
                ++i;
            }
            i = 0;
            while (i < this.numOutputs) {
                indices[i + this.numInputs] = this.indexOutputs[i];
                values[i + this.numInputs] = Double.valueOf(this.textOutputs[i].getText());
                ++i;
            }
            this.graph.addTrainingExample(indices, values);
            return true;
        }
        catch (NumberFormatException e) {
            this.labelError.setText("Error: Parameters have invalid real number format!");
            return false;
        }
    }

    public void calculateOutputs() {
        try {
            Double[] values = new Double[this.numInputs];
            int i = 0;
            while (i < this.numInputs) {
                values[i] = Double.valueOf(this.textInputs[i].getText());
                ++i;
            }
            int i2 = 0;
            while (i2 < this.numOutputs) {
                int currIndex = this.indexOutputs[i2];
                if (this.graph.backPropagation == null) {
                    this.graph.initBackProp();
                }
                double value = this.graph.backPropagation.solveNodeOutput(currIndex, values);
                value = (double)Math.round(value * 10000.0) / 10000.0;
                this.textOutputs[i2].setText(new Double(value).toString());
                ++i2;
            }
        }
        catch (NumberFormatException e) {
            this.labelError.setText("Error: Parameters have invalid real number format!");
        }
    }

    @Override
    protected boolean actionOK() {
        return this.setExample();
    }

    @Override
    protected boolean actionCancel() {
        return true;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        super.actionPerformed(e);
        if (e.getActionCommand() == "Calculate") {
            this.labelError.setText("");
            this.calculateOutputs();
        }
    }
}

