/*
 * Decompiled with CFR 0.152.
 */
package AIspace.neural.dialogs;

import AIspace.graphToolKit.dialogs.BasicDialog;
import AIspace.neural.NeuralGraph;
import java.awt.GridLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;

public class LearningOptionsDialog
extends BasicDialog
implements CaretListener {
    private JTextField textMomentum;
    private JTextField textRate;
    private JLabel labelError;
    private NeuralGraph graph;

    public LearningOptionsDialog(JFrame parent, NeuralGraph graph) {
        super(parent, "Learning Options", true);
        this.graph = graph;
        this.textMomentum = new JTextField(String.valueOf(graph.getMomentum()), 20);
        this.textMomentum.addCaretListener(this);
        this.textRate = new JTextField(String.valueOf(graph.getLearningRate()), 20);
        this.textRate.addCaretListener(this);
        JButton buttonOk = new JButton("OK");
        buttonOk.addActionListener(this);
        JButton buttonCancel = new JButton("Cancel");
        buttonCancel.addActionListener(this);
        this.labelError = new JLabel("", 0);
        JPanel panel = new JPanel();
        panel.setLayout(new GridLayout(3, 2));
        panel.add(new JLabel("Learning Rate:"));
        panel.add(this.textRate);
        panel.add(new JLabel("Momentum:"));
        panel.add(this.textMomentum);
        panel.add(buttonOk);
        panel.add(buttonCancel);
        this.getContentPane().add(panel);
        this.getContentPane().add("South", this.labelError);
        this.pack();
        this.centerWindow();
        this.setVisible(true);
    }

    public void open() {
        this.textMomentum.setText(String.valueOf(this.graph.getMomentum()));
        this.textRate.setText(String.valueOf(this.graph.getLearningRate()));
        this.setVisible(true);
    }

    public boolean setProperties() {
        double momentum;
        block3: {
            try {
                this.graph.setLearningRate(Double.parseDouble(this.textRate.getText()));
                momentum = Double.parseDouble(this.textMomentum.getText());
                if (!(momentum < 0.0) && !(momentum >= 1.0)) break block3;
                this.labelError.setText("Error: Momentum must be a real number x, 0 < x < 1.");
                return false;
            }
            catch (NumberFormatException e) {
                this.labelError.setText("Error: Invalid number format.");
                return false;
            }
        }
        this.graph.setMomentum(momentum);
        return true;
    }

    @Override
    protected boolean actionOK() {
        return this.setProperties();
    }

    @Override
    protected boolean actionCancel() {
        return true;
    }

    @Override
    public void caretUpdate(CaretEvent e) {
        this.labelError.setText("");
    }
}

