/*
 * Decompiled with CFR 0.152.
 */
package AIspace.neural.dialogs;

import AIspace.graphToolKit.dialogs.ProblemDialog;
import AIspace.neural.NeuralWindow;
import java.awt.Component;
import java.io.BufferedReader;
import java.io.InputStreamReader;

public class NeuralProblemDialog
extends ProblemDialog {
    private static final long serialVersionUID = 1L;
    private boolean withWizard;

    public NeuralProblemDialog(NeuralWindow window, boolean withWizard) {
        super(window);
        this.withWizard = withWizard;
        if (withWizard) {
            this.getContentPane().remove(1);
            this.getContentPane().add((Component)this.constructCenterPanel(), "Center");
        }
    }

    @Override
    protected boolean getProblemList() {
        try {
            String text;
            BufferedReader in = null;
            in = this.withWizard ? new BufferedReader(new InputStreamReader(this.getClass().getResourceAsStream("/SampleData.txt"))) : new BufferedReader(new InputStreamReader(this.getClass().getResourceAsStream("/SampleProblems.txt")));
            while ((text = in.readLine()) != null) {
                if ((text = text.trim()).length() <= 0 || text.substring(0, 2).equals("//")) continue;
                int p1 = text.indexOf(",");
                int p2 = text.indexOf(",", p1 + 1);
                this.problemNameToFileName.put(text.substring(0, p1), text.substring(p1 + 1, p2).trim());
                if (text.endsWith(".")) {
                    this.sampleProblemDescription.put(text.substring(0, p1), text.substring(p2 + 1, text.length()).trim());
                    continue;
                }
                this.sampleProblemDescription.put(text.substring(0, p1), "");
            }
            in.close();
            return true;
        }
        catch (Exception e) {
            this.window.showMessage("Error", "Error loading problem list: " + e.getLocalizedMessage() + ".");
            return false;
        }
    }

    @Override
    protected void loadProblem() {
        if (this.list.getSelectedValue() != null) {
            this.window.setFileName((String)this.problemNameToFileName.get(this.list.getSelectedValue()));
            if (this.withWizard) {
                ((NeuralWindow)this.window).loadWizard(new BufferedReader(new InputStreamReader(this.getClass().getResourceAsStream("/saves/" + (String)this.problemNameToFileName.get(this.list.getSelectedValue())))));
            } else {
                this.window.load(new BufferedReader(new InputStreamReader(this.getClass().getResourceAsStream("/saves/" + (String)this.problemNameToFileName.get(this.list.getSelectedValue())))));
            }
        } else {
            this.window.showMessage("Error", "Error loading file.");
        }
    }
}

