/*
 * Decompiled with CFR 0.152.
 */
package AIspace.neural.dialogs;

import AIspace.graphToolKit.GraphConsts;
import AIspace.graphToolKit.dialogs.BasicDialog;
import AIspace.graphToolKit.elements.Node;
import AIspace.graphToolKit.elements.Point;
import AIspace.neural.ExampleList;
import AIspace.neural.NeuralCanvas;
import AIspace.neural.NeuralGraph;
import AIspace.neural.dialogs.NeuralWizardOrderedQueryDialog;
import AIspace.neural.elements.NeuralEdge;
import AIspace.neural.elements.NeuralNode;
import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.Hashtable;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;

public class NeuralWizard
extends BasicDialog
implements ItemListener,
KeyListener {
    private JTextField hiddenLayerNumber;
    private JTextField hiddenLayerNodeNumber;
    private int[] numHiddenNodes;
    private JCheckBox[] nodeList;
    private JComboBox hiddenLayerIndex;
    private DefaultComboBoxModel comboModel;
    private JCheckBox[] ordered;
    private NeuralGraph nGraph;
    private ExampleList example;
    private JLabel errLabel;

    public NeuralWizard(JFrame parent, NeuralGraph graph, ExampleList example, String filename) {
        super(parent, "Neural Network Construction Wizard", true, 2);
        this.gbl = new GridBagLayout();
        this.gbc = new GridBagConstraints();
        this.gbc.fill = 2;
        this.nGraph = graph;
        this.example = example;
        JPanel mainPanel = new JPanel(this.gbl);
        mainPanel.setBorder(new EmptyBorder(3, 3, 3, 3));
        JLabel sourceName = new JLabel("Filename: " + filename, 0);
        sourceName.setForeground(Color.blue);
        JPanel hiddenLayerNumberPanel = new JPanel(new FlowLayout(0, 1, 0));
        JLabel tempLabel = new JLabel("Create ");
        hiddenLayerNumberPanel.add(tempLabel);
        this.hiddenLayerNumber = new JTextField("1", 3);
        this.hiddenLayerNumber.setHorizontalAlignment(4);
        this.hiddenLayerNumber.setName("hiddenLayerNumber");
        this.hiddenLayerNumber.addKeyListener(this);
        hiddenLayerNumberPanel.add(this.hiddenLayerNumber);
        tempLabel = new JLabel(" hidden layers");
        hiddenLayerNumberPanel.add(tempLabel);
        JPanel layerChoicePanel = new JPanel(new FlowLayout(0, 0, 0));
        tempLabel = new JLabel("Hidden layer ");
        layerChoicePanel.add(tempLabel);
        String hiddenString = "1";
        this.comboModel = new DefaultComboBoxModel();
        this.comboModel.addElement(hiddenString);
        this.hiddenLayerIndex = new JComboBox();
        this.hiddenLayerIndex.setModel(this.comboModel);
        this.hiddenLayerIndex.setSelectedIndex(0);
        this.hiddenLayerIndex.setName("hiddenLayerIndex");
        this.hiddenLayerIndex.addActionListener(this);
        layerChoicePanel.add(this.hiddenLayerIndex);
        tempLabel = new JLabel(" has ");
        layerChoicePanel.add(tempLabel);
        this.hiddenLayerNodeNumber = new JTextField("2");
        this.hiddenLayerNodeNumber.setName("hiddenLayerNodeNumber");
        this.hiddenLayerNodeNumber.addKeyListener(this);
        this.numHiddenNodes = new int[1];
        this.numHiddenNodes[0] = 2;
        layerChoicePanel.add(this.hiddenLayerNodeNumber);
        tempLabel = new JLabel(" nodes.");
        layerChoicePanel.add(tempLabel);
        JLabel categoryLabel = new JLabel("Choose categories as outputs:");
        this.nodeList = new JCheckBox[example.getNumParameters()];
        this.ordered = new JCheckBox[example.getNumParameters()];
        String[] paraNames = example.getParameters();
        int i = 0;
        while (i < this.nodeList.length) {
            this.nodeList[i] = new JCheckBox(paraNames[i]);
            this.nodeList[i].setSelected(!example.isInputParam(i));
            this.nodeList[i].setName(new Integer(i).toString());
            this.nodeList[i].addItemListener(this);
            this.ordered[i] = new JCheckBox("ordered?");
            ++i;
        }
        JPanel buttonPanel = new JPanel(new FlowLayout());
        JButton ok = new JButton("OK");
        ok.addActionListener(this);
        JButton cancel = new JButton("Cancel");
        cancel.addActionListener(this);
        buttonPanel.add(ok);
        buttonPanel.add(cancel);
        this.addComponent(sourceName, mainPanel, 0, 0, 2, 1, 2.0, 1.0);
        this.addComponent(hiddenLayerNumberPanel, mainPanel, 2, 0, 2, 1, 2.0, 1.0);
        this.addComponent(layerChoicePanel, mainPanel, 3, 0, 2, 1, 2.0, 1.0);
        this.addComponent(categoryLabel, mainPanel, 4, 0, 2, 1, 2.0, 1.0);
        int totalLength = 4 + this.nodeList.length;
        int i2 = 0;
        while (i2 < this.nodeList.length) {
            this.addComponent(this.nodeList[i2], mainPanel, 5 + i2, 0, 1, 1, 1.0, 1.0);
            this.addComponent(this.ordered[i2], mainPanel, 5 + i2, 1, 1, 1, 1.0, 1.0);
            ++i2;
        }
        this.errLabel = new JLabel();
        this.errLabel.setForeground(Color.red);
        this.addComponent(this.errLabel, mainPanel, totalLength + 1, 0, 2, 1, 2.0, 1.0);
        this.addComponent(buttonPanel, mainPanel, totalLength + 2, 0, 2, 1, 2.0, 1.0);
        this.getContentPane().add(mainPanel);
        this.setSize(280, 300);
        this.centerWindow();
        this.setVisible(true);
    }

    public NeuralWizard(JFrame parent, NeuralGraph graph, ExampleList example) {
        super(parent, "Neural Network Construction Wizard", true, 2);
        this.nGraph = graph;
        this.example = example;
        this.hiddenLayerNumber = new JTextField("1");
        this.hiddenLayerNumber.setName("hiddenLayerNumber");
        this.hiddenLayerNumber.addKeyListener(this);
        String[] hidenString = new String[]{"1"};
        this.hiddenLayerIndex = new JComboBox<String>(hidenString);
        this.numHiddenNodes = new int[1];
        this.numHiddenNodes[0] = 2;
        this.nodeList = new JCheckBox[example.getNumParameters()];
        this.ordered = new JCheckBox[example.getNumParameters()];
        String[] paraNames = example.getParameters();
        int i = 0;
        while (i < this.nodeList.length) {
            this.nodeList[i] = new JCheckBox(paraNames[i]);
            this.nodeList[i].setSelected(!example.isInputParam(i));
            this.nodeList[i].setName(new Integer(i).toString());
            this.nodeList[i].addItemListener(this);
            this.ordered[i] = new JCheckBox("ordered?");
            ++i;
        }
        this.buildGraph();
    }

    @Override
    protected boolean actionCancel() {
        return true;
    }

    @Override
    protected boolean actionOK() {
        if (!this.validOutputSelection()) {
            this.errLabel.setText("Must select at least one output and input");
            return false;
        }
        this.setCursor(GraphConsts.WAIT_CURSOR);
        this.buildGraph();
        this.setCursor(GraphConsts.DEFAULT_CURSOR);
        this.nGraph.setExampleList(this.example);
        return true;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        super.actionPerformed(e);
        if (e.getActionCommand() == "comboBoxChanged" && this.hiddenLayerIndex.getSelectedIndex() != -1) {
            this.hiddenLayerNodeNumber.setText("" + this.numHiddenNodes[this.hiddenLayerIndex.getSelectedIndex()]);
        }
    }

    public boolean validOutputSelection() {
        boolean hasInput = false;
        boolean hasOutput = false;
        int i = 0;
        while (i < this.nodeList.length) {
            hasInput = !this.nodeList[i].isSelected() || hasInput;
            hasOutput = this.nodeList[i].isSelected() || hasOutput;
            ++i;
        }
        return hasInput && hasOutput;
    }

    public void setExampleList(ExampleList list) {
        this.example = list;
    }

    public void buildGraph() {
        int j;
        String para;
        NeuralCanvas newCanvas = (NeuralCanvas)this.nGraph.canvas;
        this.nGraph = (NeuralGraph)newCanvas.graph;
        this.nGraph.setExampleList(this.example);
        ArrayList[] rangeArray = new ArrayList[this.example.getNumParameters()];
        Hashtable[] valueMapArray = new Hashtable[this.example.getNumParameters()];
        boolean[] nonCategorical = new boolean[this.example.getNumParameters()];
        int i = 0;
        while (i < nonCategorical.length) {
            nonCategorical[i] = true;
            ++i;
        }
        ArrayList<Hashtable<Integer, String>> test = this.example.getTestArrayList();
        ArrayList<Hashtable<Integer, String>> training = this.example.getTrainingArrayList();
        Hashtable<Integer, String> oneExample = null;
        int allExamples = 0;
        while (allExamples < training.size()) {
            oneExample = training.get(allExamples);
            int i2 = 0;
            while (i2 < oneExample.size()) {
                para = oneExample.get(new Integer(i2));
                int j2 = 0;
                while (j2 < para.length()) {
                    if (!nonCategorical[i2]) break;
                    nonCategorical[i2] = (Character.isDigit(para.charAt(j2)) || para.charAt(j2) == '.') && nonCategorical[i2];
                    ++j2;
                }
                ++i2;
            }
            ++allExamples;
        }
        int i3 = 0;
        while (i3 < nonCategorical.length) {
            valueMapArray[i3] = null;
            rangeArray[i3] = nonCategorical[i3] ? null : new ArrayList();
            ++i3;
        }
        i3 = 0;
        while (i3 < training.size()) {
            oneExample = training.get(i3);
            j = 0;
            while (j < oneExample.size()) {
                if (rangeArray[j] != null && !rangeArray[j].contains(para = oneExample.get(new Integer(j)))) {
                    rangeArray[j].add(para);
                }
                ++j;
            }
            ++i3;
        }
        i3 = 0;
        while (i3 < test.size()) {
            oneExample = test.get(i3);
            j = 0;
            while (j < oneExample.size()) {
                if (rangeArray[j] != null && !rangeArray[j].contains(para = oneExample.get(new Integer(j)))) {
                    rangeArray[j].add(para);
                }
                ++j;
            }
            ++i3;
        }
        int k = 0;
        while (k < rangeArray.length) {
            if (this.ordered[k].isSelected()) {
                if (rangeArray[k] == null) {
                    rangeArray[k] = new ArrayList();
                    int i4 = 0;
                    while (i4 < training.size()) {
                        oneExample = training.get(i4);
                        para = oneExample.get(new Integer(k));
                        if (!rangeArray[k].contains(para)) {
                            rangeArray[k].add(para);
                        }
                        ++i4;
                    }
                    i4 = 0;
                    while (i4 < test.size()) {
                        oneExample = test.get(i4);
                        para = oneExample.get(new Integer(k));
                        if (!rangeArray[k].contains(para)) {
                            rangeArray[k].add(para);
                        }
                        ++i4;
                    }
                }
                NeuralWizardOrderedQueryDialog dial = new NeuralWizardOrderedQueryDialog((JFrame)super.getParent(), rangeArray[k], this.nodeList[k].getText());
                valueMapArray[k] = dial.returnValue();
                dial.dispose();
            }
            ++k;
        }
        ExampleList newExample = new ExampleList();
        ArrayList<String> newPara = new ArrayList<String>();
        int counter = 0;
        int i5 = 0;
        while (i5 < this.nodeList.length) {
            if (!this.nodeList[i5].isSelected()) {
                if (rangeArray[i5] == null) {
                    newPara.add(this.nodeList[i5].getText());
                    ++counter;
                } else if (!this.ordered[i5].isSelected()) {
                    int limit = rangeArray[i5].size();
                    if (rangeArray[i5].size() == 2) {
                        --limit;
                    }
                    int j3 = 0;
                    while (j3 < limit) {
                        newPara.add(String.valueOf(this.nodeList[i5].getText()) + "=" + (String)rangeArray[i5].get(j3));
                        ++counter;
                        ++j3;
                    }
                } else {
                    newPara.add(this.nodeList[i5].getText());
                    ++counter;
                }
            }
            ++i5;
        }
        int inputLimit = counter;
        int i6 = 0;
        while (i6 < this.nodeList.length) {
            if (this.nodeList[i6].isSelected()) {
                if (rangeArray[i6] == null) {
                    newPara.add(this.nodeList[i6].getText());
                    ++counter;
                } else if (!this.ordered[i6].isSelected()) {
                    int limit = rangeArray[i6].size();
                    if (rangeArray[i6].size() == 2) {
                        --limit;
                    }
                    int j4 = 0;
                    while (j4 < limit) {
                        newPara.add((String)rangeArray[i6].get(j4));
                        ++counter;
                        ++j4;
                    }
                } else {
                    newPara.add(this.nodeList[i6].getText());
                    ++counter;
                }
            }
            ++i6;
        }
        newExample.setParameters(newPara);
        i6 = 0;
        while (i6 < counter) {
            if (i6 < inputLimit) {
                newExample.setInputParam(true, i6);
            } else {
                newExample.setInputParam(false, i6);
            }
            ++i6;
        }
        String[] values = null;
        int c = 0;
        while (c < training.size()) {
            values = this.orderElements(training.get(c), newPara.size(), rangeArray, valueMapArray);
            newExample.addTrainingExample(newExample.getIndices(), values);
            ++c;
        }
        c = 0;
        while (c < test.size()) {
            values = this.orderElements(test.get(c), newPara.size(), rangeArray, valueMapArray);
            newExample.addTestExample(newExample.getIndices(), values);
            ++c;
        }
        this.example = newExample;
        NeuralNode node = null;
        int X = -200;
        int Y = -200;
        ArrayList<NeuralNode> prevLayer = new ArrayList<NeuralNode>();
        int i7 = 0;
        while (i7 < inputLimit) {
            Point p;
            node = new NeuralNode(this.nGraph);
            node.setLabel(newPara.get(i7));
            node.pos = p = new Point(X, Y);
            this.nGraph.addNode(node);
            node.updateSize();
            X += 400;
            prevLayer.add(node);
            ++i7;
        }
        X = -200;
        Y += 400;
        int hiddenNumber = new Integer(this.hiddenLayerNumber.getText());
        int hiddenCounter = 1;
        int i8 = 0;
        while (i8 < hiddenNumber) {
            ArrayList<NeuralNode> tempList = new ArrayList<NeuralNode>();
            int j5 = 0;
            while (j5 < this.numHiddenNodes[i8]) {
                node = new NeuralNode(this.nGraph);
                node.setLabel("Hidden " + hiddenCounter);
                Point p = new Point(X, Y);
                ++hiddenCounter;
                node.pos = p;
                this.nGraph.addNode(node);
                node.updateSize();
                X += 400;
                tempList.add(node);
                int k2 = 0;
                while (k2 < prevLayer.size()) {
                    NeuralNode to = node;
                    NeuralNode from = (NeuralNode)prevLayer.get(k2);
                    if (!to.equals(from)) {
                        from.addChild(to);
                        to.addParent(from);
                        NeuralEdge edge = new NeuralEdge(this.nGraph, (Node)from, (Node)to);
                        this.nGraph.addEdge(edge, false);
                    }
                    ++k2;
                }
                ++j5;
            }
            X = -200;
            Y += 400;
            prevLayer = tempList;
            ++i8;
        }
        i8 = inputLimit;
        while (i8 < counter) {
            Point p;
            node = new NeuralNode(this.nGraph);
            node.setLabel(newPara.get(i8));
            node.pos = p = new Point(X, Y);
            this.nGraph.addNode(node);
            node.updateSize();
            X += 400;
            int k3 = 0;
            while (k3 < prevLayer.size()) {
                NeuralNode to = node;
                NeuralNode from = (NeuralNode)prevLayer.get(k3);
                if (!to.equals(from)) {
                    from.addChild(to);
                    to.addParent(from);
                    NeuralEdge edge = new NeuralEdge(this.nGraph, (Node)from, (Node)to);
                    this.nGraph.addEdge(edge, false);
                }
                ++k3;
            }
            ++i8;
        }
        this.nGraph.setExampleList(newExample);
        this.nGraph.setInputOutputNodes(true);
        this.nGraph.canvas.repaint();
        this.nGraph.canvas.autoscale();
    }

    public String[] orderElements(Hashtable oneExample, int newLength, ArrayList[] rangeArray, Hashtable[] valueMapArray) {
        int j;
        int limit;
        String result;
        String[] val = new String[newLength];
        int counter = 0;
        int i = 0;
        while (i < this.nodeList.length) {
            if (!this.nodeList[i].isSelected()) {
                if (rangeArray[i] == null) {
                    val[counter] = (String)oneExample.get(new Integer(i));
                    ++counter;
                } else if (!this.ordered[i].isSelected()) {
                    result = (String)oneExample.get(new Integer(i));
                    limit = rangeArray[i].size();
                    if (rangeArray[i].size() == 2) {
                        --limit;
                    }
                    j = 0;
                    while (j < limit) {
                        val[counter] = ((String)rangeArray[i].get(j)).equals(result) ? new Double(1.0).toString() : new Double(0.0).toString();
                        ++counter;
                        ++j;
                    }
                } else {
                    result = (String)oneExample.get(new Integer(i));
                    val[counter] = ((Double)valueMapArray[i].get(result)).toString();
                    ++counter;
                }
            }
            ++i;
        }
        i = 0;
        while (i < this.nodeList.length) {
            if (this.nodeList[i].isSelected()) {
                if (rangeArray[i] == null) {
                    val[counter] = (String)oneExample.get(new Integer(i));
                    ++counter;
                } else if (!this.ordered[i].isSelected()) {
                    result = (String)oneExample.get(new Integer(i));
                    limit = rangeArray[i].size();
                    if (rangeArray[i].size() == 2) {
                        --limit;
                    }
                    j = 0;
                    while (j < limit) {
                        val[counter] = ((String)rangeArray[i].get(j)).equals(result) ? new Double(1.0).toString() : new Double(0.0).toString();
                        ++counter;
                        ++j;
                    }
                } else {
                    result = (String)oneExample.get(new Integer(i));
                    val[counter] = ((Double)valueMapArray[i].get(result)).toString();
                    ++counter;
                }
            }
            ++i;
        }
        return val;
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        int index = new Integer(((JComponent)e.getSource()).getName());
        if (e.getStateChange() == 1) {
            this.example.setInputParam(false, index);
        } else {
            this.example.setInputParam(true, index);
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
        if (((JComponent)e.getSource()).getName().equals("hiddenLayerNumber")) {
            this.errLabel.setText("");
            if (this.hiddenLayerNumber.getText() == "") {
                return;
            }
            int hiddenNumber = 1;
            try {
                hiddenNumber = Integer.parseInt(this.hiddenLayerNumber.getText());
            }
            catch (NumberFormatException ex) {
                this.errLabel.setText("Hidden Layer number must be integer");
                return;
            }
            int[] numHidden = new int[hiddenNumber];
            this.comboModel.removeAllElements();
            int i = 0;
            while (i < hiddenNumber) {
                this.comboModel.addElement(new Integer(i + 1).toString());
                numHidden[i] = i < this.numHiddenNodes.length ? this.numHiddenNodes[i] : 2;
                ++i;
            }
            this.numHiddenNodes = numHidden;
            this.hiddenLayerIndex.repaint();
            this.hiddenLayerIndex.setSelectedIndex(0);
        } else if (((JComponent)e.getSource()).getName().equals("hiddenLayerNodeNumber")) {
            this.errLabel.setText("");
            if (this.hiddenLayerNodeNumber.getText() == "") {
                return;
            }
            int hiddenNodeNumber = 1;
            try {
                hiddenNodeNumber = new Integer(this.hiddenLayerNodeNumber.getText());
            }
            catch (NumberFormatException ex) {
                this.errLabel.setText("Number of nodes must be an integer");
                return;
            }
            this.numHiddenNodes[this.hiddenLayerIndex.getSelectedIndex()] = hiddenNodeNumber;
        }
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent arg0) {
    }
}

