/*
 * Decompiled with CFR 0.152.
 */
package AIspace.neural.dialogs;

import AIspace.graphToolKit.dialogs.BasicDialog;
import java.awt.Color;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Hashtable;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class NeuralWizardOrderedQueryDialog
extends BasicDialog {
    private JLabel[] elementLabels;
    private JTextField[] elementFields;
    private JButton ok;
    private JLabel errLabel;
    private Hashtable<String, Double> map;
    private ArrayList<String> elements;

    NeuralWizardOrderedQueryDialog(JFrame parent, ArrayList<String> elements, String name) {
        super(parent, "Define Category Value Mapping", true);
        this.gbl = new GridBagLayout();
        this.gbc = new GridBagConstraints();
        this.map = new Hashtable();
        JPanel mainPanel = new JPanel(this.gbl);
        JLabel header = new JLabel("Input the values of these elements for " + name + " :");
        header.setForeground(Color.blue);
        this.addComponent(header, mainPanel, 0, 0, 2, 1, 2.0, 1.0);
        this.elementLabels = new JLabel[elements.size()];
        this.elementFields = new JTextField[elements.size()];
        this.gbc.fill = 2;
        int i = 0;
        while (i < elements.size()) {
            this.elementLabels[i] = new JLabel(String.valueOf(elements.get(i)) + " :");
            this.addComponent(this.elementLabels[i], mainPanel, i + 1, 0, 1, 1, 1.0, 1.0);
            this.elementFields[i] = new JTextField("");
            this.elementFields[i].addActionListener(this);
            this.addComponent(this.elementFields[i], mainPanel, i + 1, 1, 1, 1, 1.0, 1.0);
            ++i;
        }
        this.elements = elements;
        this.errLabel = new JLabel();
        this.errLabel.setForeground(Color.red);
        this.addComponent(this.errLabel, mainPanel, elements.size() + 1, 0, 2, 1, 2.0, 1.0);
        this.ok = new JButton("OK");
        this.ok.addActionListener(this);
        this.addComponent(this.ok, mainPanel, elements.size() + 2, 0, 2, 1, 2.0, 1.0);
        this.getContentPane().add(mainPanel);
        this.pack();
        this.centerWindow();
        this.setVisible(true);
    }

    @Override
    protected boolean actionOK() {
        if (!this.setMap()) {
            this.errLabel.setText("Must set all fields to real numbers");
            return false;
        }
        return true;
    }

    @Override
    protected boolean actionCancel() {
        return true;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() instanceof JTextField) {
            this.errLabel.setText("");
        } else {
            super.actionPerformed(e);
        }
    }

    private boolean setMap() {
        int i = 0;
        while (i < this.elementFields.length) {
            Double value;
            try {
                value = new Double(this.elementFields[i].getText());
            }
            catch (NumberFormatException ex) {
                this.map = new Hashtable();
                return false;
            }
            this.map.put(this.elements.get(i), value);
            ++i;
        }
        return true;
    }

    public Hashtable returnValue() {
        return this.map;
    }
}

