/*
 * Decompiled with CFR 0.152.
 */
package AIspace.neural.dialogs;

import AIspace.graphToolKit.dialogs.BasicDialog;
import AIspace.graphToolKit.elements.Node;
import AIspace.neural.NeuralGraph;
import AIspace.neural.elements.NeuralEdge;
import AIspace.neural.elements.NeuralNode;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class NodeDialog
extends BasicDialog {
    public boolean isCancelled = true;
    private boolean isEditable;
    private JTextField textNodeName;
    private JTextField[] textParameters;
    private JLabel labelError;
    private int nodeIndex;
    private NeuralGraph graph;
    private NeuralNode selected;
    private int numParents;
    private ArrayList<Node> parents;
    private JCheckBox sigmoid;
    private JCheckBox linear;
    private JCheckBox tanh;
    private JCheckBox exp;

    public NodeDialog(JFrame parent, NeuralGraph g, int selectedNodeIndex, String title, boolean edit, NeuralNode node) {
        super(parent, title, true);
        int parameterIndex;
        this.graph = g;
        this.nodeIndex = selectedNodeIndex;
        this.selected = node;
        this.numParents = this.selected.getNumParentNodes();
        this.parents = this.selected.getParentNodes();
        this.isEditable = edit;
        String tmpString = new String(" ");
        String nodeName = this.selected.getLabel();
        if (nodeName.equals("")) {
            boolean nameFound = false;
            int nameCount = 0;
            nodeName = "Node " + nameCount;
            block0: while (!nameFound && this.graph.numNodes() > 0) {
                int count = 0;
                while (count < this.graph.numNodes()) {
                    if (this.graph.nodeAt(count).getLabel().equals(nodeName)) {
                        nodeName = "Node " + ++nameCount;
                        continue block0;
                    }
                    if (count == this.graph.numNodes() - 1) {
                        nameFound = true;
                    }
                    ++count;
                }
            }
        }
        this.textNodeName = new JTextField(nodeName, 20);
        this.textNodeName.setEditable(this.isEditable);
        this.textNodeName.addActionListener(this);
        JLabel[] labelParameters = new JLabel[this.numParents + 1];
        this.textParameters = new JTextField[this.numParents + 1];
        if (!this.isEditable && (parameterIndex = this.selected.getParameterIndex()) > -1) {
            tmpString = new String(" w_" + parameterIndex + " ");
        }
        labelParameters[0] = this.numParents > 0 ? new JLabel("Parameter" + tmpString + ":") : new JLabel("");
        this.textParameters[0] = new JTextField(new Double(this.selected.getCurrentParaValue()).toString(), 20);
        this.textParameters[0].setEditable(this.isEditable);
        int i = 1;
        while (i < this.numParents + 1) {
            NeuralEdge edge;
            tmpString = new String(" ");
            NeuralNode tempParentNode = (NeuralNode)this.parents.get(i - 1);
            nodeName = tempParentNode.getLabel();
            if (nodeName.equals("")) {
                nodeName = new String("Node " + tempParentNode.getIndex());
            }
            if (!this.isEditable && (edge = (NeuralEdge)this.graph.getEdge(tempParentNode.getIndex(), this.selected.getIndex())) != null && (parameterIndex = edge.getParameterIndex()) != -1) {
                tmpString = new String(" w_" + parameterIndex + " ");
            }
            labelParameters[i] = new JLabel("Parameter" + tmpString + "(for " + nodeName + "):");
            edge = (NeuralEdge)this.graph.getEdge(tempParentNode.getIndex(), this.nodeIndex);
            this.textParameters[i] = edge != null ? new JTextField(new Double(edge.getCurrentParaValue()).toString(), 20) : new JTextField("Error", 20);
            this.textParameters[i].setEditable(this.isEditable);
            ++i;
        }
        JButton buttonOk = new JButton("OK");
        buttonOk.addActionListener(this);
        JButton buttonCancel = new JButton("Cancel");
        buttonCancel.addActionListener(this);
        this.labelError = new JLabel("");
        JPanel panel = new JPanel();
        if (this.numParents != 0) {
            panel.setLayout(new GridLayout(this.numParents + 5, 2));
        } else {
            panel.setLayout(new GridLayout(2, 2));
        }
        panel.add(new JLabel("Node name:"));
        panel.add(this.textNodeName);
        if (this.numParents > 0) {
            int i2 = 0;
            while (i2 < this.numParents + 1) {
                panel.add(labelParameters[i2]);
                panel.add(this.textParameters[i2]);
                ++i2;
            }
        }
        ButtonGroup functionGroup = new ButtonGroup();
        this.setFunction();
        functionGroup.add(this.sigmoid);
        functionGroup.add(this.linear);
        functionGroup.add(this.tanh);
        functionGroup.add(this.exp);
        if (this.numParents != 0) {
            panel.add(this.sigmoid);
            panel.add(this.linear);
            panel.add(this.tanh);
            panel.add(this.exp);
        }
        panel.add(buttonOk);
        panel.add(buttonCancel);
        this.getContentPane().add(panel);
        this.getContentPane().add("South", this.labelError);
        this.pack();
        this.centerWindow();
        this.setVisible(true);
    }

    private void setFunction() {
        this.sigmoid = new JCheckBox("Sigmoid Function");
        this.linear = new JCheckBox("Linear Function");
        this.tanh = new JCheckBox("Tanh Function");
        this.exp = new JCheckBox("Exponential Function");
        if (!this.isEditable) {
            this.sigmoid.setEnabled(false);
            this.linear.setEnabled(false);
            this.tanh.setEnabled(false);
            this.exp.setEnabled(false);
        }
        this.selectFunction();
    }

    private void selectFunction() {
        switch (this.selected.functionType) {
            case 0: {
                this.sigmoid.setSelected(true);
                break;
            }
            case 1: {
                this.linear.setSelected(true);
                break;
            }
            case 2: {
                this.tanh.setSelected(true);
                break;
            }
            case 3: {
                this.exp.setSelected(true);
            }
        }
    }

    public void open(NeuralNode node) {
        this.isCancelled = true;
        this.selected = node;
        this.textNodeName.setText(this.selected.getLabel());
        this.selectFunction();
        this.setVisible(true);
    }

    public boolean setProperties() {
        int i;
        Double[] tempParaValues;
        block14: {
            block13: {
                if (!this.textNodeName.getText().trim().equals("")) break block13;
                this.graph.showMessage("Error in Name", "Name cannot be blank.");
                return false;
            }
            tempParaValues = new Double[this.numParents + 1];
            i = 0;
            while (i < this.numParents + 1) {
                tempParaValues[i] = Double.valueOf(this.textParameters[i].getText());
                ++i;
            }
            if (this.selected.getLabel().equals(this.textNodeName.getText().trim()) || this.graph.isNodeNameAllowed(this.textNodeName.getText().trim(), this.selected)) break block14;
            this.graph.showMessage("Error in Name", "Name has already been used.");
            return false;
        }
        try {
            this.selected.setLabel(this.textNodeName.getText().trim());
            this.graph.rebuildData();
            this.selected.setInitialParaValue(tempParaValues[0]);
            this.selected.setCurrentParaValue(tempParaValues[0]);
            i = 1;
            while (i < this.numParents + 1) {
                NeuralNode tempParentNode = (NeuralNode)this.parents.get(i - 1);
                NeuralEdge edge = (NeuralEdge)this.graph.getEdge(tempParentNode.getIndex(), this.nodeIndex);
                edge.setInitialParaValue(tempParaValues[i]);
                edge.setCurrentParaValue(tempParaValues[i]);
                ++i;
            }
            if (this.sigmoid.isSelected()) {
                this.selected.functionType = 0;
            } else if (this.linear.isSelected()) {
                this.selected.functionType = 1;
            } else if (this.tanh.isSelected()) {
                this.selected.functionType = 2;
            } else if (this.exp.isSelected()) {
                this.selected.functionType = 3;
            }
            return true;
        }
        catch (NumberFormatException e) {
            this.labelError.setText("Error: Parameters have invalid real number format!");
            return false;
        }
    }

    public boolean isCancelled() {
        return this.isCancelled;
    }

    @Override
    protected boolean actionOK() {
        if (this.isEditable) {
            if (!this.setProperties()) {
                return false;
            }
            this.isCancelled = false;
        }
        return true;
    }

    @Override
    protected boolean actionCancel() {
        return true;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource().equals(this.textNodeName)) {
            this.textNodeName.transferFocus();
        } else {
            super.actionPerformed(e);
        }
    }
}

