/*
 * Decompiled with CFR 0.152.
 */
package AIspace.neural.dialogs;

import AIspace.graphToolKit.dialogs.BasicDialog;
import AIspace.graphToolKit.dialogs.MessageDialog;
import AIspace.neural.ExampleList;
import AIspace.neural.NeuralWindow;
import java.awt.BorderLayout;
import java.awt.FlowLayout;
import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class ParameterInputDialog
extends BasicDialog {
    private ExampleList eList;
    private JTextField promptText;

    public ParameterInputDialog(JFrame parent, ExampleList eList) {
        super(parent, "Data Set Parameter Input", true);
        this.eList = eList;
        JPanel instructionPanel = new JPanel(new BorderLayout());
        instructionPanel.add("North", new JLabel("Please enter the parameters for the new dataset."));
        instructionPanel.add("South", new JLabel("Separate each parameter with a comma and specify the output parameter last."));
        JPanel inputPanel = new JPanel(new BorderLayout());
        inputPanel.add("West", new JLabel("Parameters: "));
        this.promptText = new JTextField(50);
        inputPanel.add("East", this.promptText);
        JPanel buttonPanel = new JPanel(new FlowLayout());
        JButton okButton = new JButton("OK");
        okButton.addActionListener(this);
        buttonPanel.add(okButton);
        JButton cancelButton = new JButton("Cancel");
        cancelButton.addActionListener(this);
        buttonPanel.add(cancelButton);
        this.getContentPane().add("North", instructionPanel);
        this.getContentPane().add("Center", inputPanel);
        this.getContentPane().add("South", buttonPanel);
        this.pack();
        this.centerWindow();
        this.promptText.requestFocus();
        this.setVisible(true);
    }

    @Override
    protected boolean actionOK() {
        return this.parseInput();
    }

    @Override
    protected boolean actionCancel() {
        return true;
    }

    private boolean parseInput() {
        ArrayList<String> parameters = new ArrayList<String>(5);
        StringTokenizer tokenizer = new StringTokenizer(this.promptText.getText());
        while (tokenizer.hasMoreTokens()) {
            parameters.add(tokenizer.nextToken(", "));
        }
        if (parameters.size() < 2) {
            new MessageDialog((NeuralWindow)this.getParent()).open("Invalid Input", "You must enter at least two parameters");
            return false;
        }
        this.eList.setParameters(parameters);
        return true;
    }
}

