/*
 * Decompiled with CFR 0.152.
 */
package AIspace.neural.dialogs;

import AIspace.graphToolKit.dialogs.BasicDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class SelectExamplesDialog
extends BasicDialog {
    private DefaultListModel exampleModel;
    private JComboBox choiceComboBox;
    private JTextField X;
    private JLabel selectLabel = new JLabel("Select");
    private JLabel percentLabel = new JLabel("%    of the data");
    private JLabel labelError;
    private JButton okButton = new JButton("OK");
    private JButton cancelButton = new JButton("Cancel");
    private JPanel p;
    private JPanel q;
    private JPanel p1;
    private int numExamples;
    private JList exampleList;

    public SelectExamplesDialog(JFrame parent, JList exampleList) {
        super(parent, "Select Data Examples", true);
        this.exampleModel = (DefaultListModel)exampleList.getModel();
        this.exampleList = exampleList;
        this.exampleList.setModel(this.exampleModel);
        this.numExamples = this.exampleModel.getSize() - 1;
        this.okButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        String[] choiceString = new String[]{"Random", "the First", "the Last"};
        this.choiceComboBox = new JComboBox<String>(choiceString);
        this.X = new JTextField(3);
        this.labelError = new JLabel("");
        this.p = new JPanel();
        this.q = new JPanel();
        this.p.add(this.selectLabel);
        this.p.add(this.choiceComboBox);
        this.p.add(this.X);
        this.p.add(this.percentLabel);
        this.q.add(this.okButton);
        this.q.add(this.cancelButton);
        this.p1 = new JPanel();
        this.p1.setLayout(new BorderLayout());
        this.p1.add((Component)this.p, "Center");
        this.p1.add((Component)this.q, "South");
        this.getContentPane().add(this.p1);
        this.getContentPane().add("South", this.labelError);
        this.pack();
        this.centerWindow();
        this.setVisible(true);
    }

    @Override
    protected boolean actionOK() {
        if (this.parseX()) {
            double x = new Double(this.X.getText());
            int numToMove = (int)((double)this.numExamples * (x / 100.0));
            int[] inds = new int[numToMove];
            if (numToMove > 0) {
                if (this.choiceComboBox.getSelectedItem() == "the First") {
                    int i = 0;
                    while (i < numToMove) {
                        inds[i] = i;
                        ++i;
                    }
                } else if (this.choiceComboBox.getSelectedItem() == "the Last") {
                    int i = 0;
                    while (i < numToMove) {
                        inds[i] = this.numExamples - numToMove + i;
                        ++i;
                    }
                } else if (this.choiceComboBox.getSelectedItem() == "Random") {
                    int n;
                    inds[0] = n = (int)((double)this.numExamples * Math.random());
                    int i = 1;
                    while (i < numToMove) {
                        boolean different = false;
                        block3: while (!different) {
                            n = (int)((double)this.numExamples * Math.random());
                            different = true;
                            int j = 0;
                            while (j < i) {
                                if (inds[j] == n) {
                                    different = false;
                                    continue block3;
                                }
                                ++j;
                            }
                        }
                        inds[i] = n;
                        ++i;
                    }
                }
                this.selectItems(inds);
            }
            return true;
        }
        return false;
    }

    @Override
    protected boolean actionCancel() {
        return true;
    }

    private void selectItems(int[] inds) {
        int i = 0;
        while (i < inds.length) {
            inds[i] = inds[i] + 1;
            ++i;
        }
        this.exampleList.setSelectedIndices(inds);
    }

    private boolean parseX() {
        try {
            double x = new Double(this.X.getText());
            if (x < 0.0 || x > 100.0) {
                throw new NumberFormatException();
            }
        }
        catch (NumberFormatException e) {
            this.labelError.setText("Error: Parameter should have a real value between 0 and 100");
            return false;
        }
        return true;
    }
}

