/*
 * Decompiled with CFR 0.152.
 */
package AIspace.neural.dialogs;

import AIspace.graphToolKit.dialogs.BasicDialog;
import AIspace.neural.NeuralGraph;
import java.awt.GridLayout;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class StoppingOptionsDialog
extends BasicDialog
implements TextListener {
    private JLabel labelIter;
    private JTextField textIter;
    private JLabel labelErr;
    private JTextField textErr;
    private JButton buttonOk;
    private JButton buttonCancel;
    private JLabel labelError;
    private JPanel p;
    private NeuralGraph graph;
    private int iterations;
    private double err;

    public StoppingOptionsDialog(JFrame parent, NeuralGraph graph, String title) {
        super(parent, title, true);
        this.graph = graph;
        this.labelIter = new JLabel("Number Of Iterations:");
        this.labelErr = new JLabel("Target Error:");
        this.iterations = graph.getNumberOfIterations();
        this.textIter = new JTextField(String.valueOf(this.iterations), 20);
        this.textIter.addActionListener(this);
        this.textIter.addActionListener(this);
        this.err = graph.getStoppingErrVal();
        this.textErr = new JTextField(String.valueOf(this.err), 20);
        this.textErr.addActionListener(this);
        this.textErr.addActionListener(this);
        this.buttonOk = new JButton("OK");
        this.buttonOk.addActionListener(this);
        this.buttonCancel = new JButton("Cancel");
        this.buttonCancel.addActionListener(this);
        this.labelError = new JLabel("", 0);
        this.p = new JPanel();
        this.p.setLayout(new GridLayout(3, 2));
        this.p.add(this.labelIter);
        this.p.add(this.textIter);
        this.p.add(this.labelErr);
        this.p.add(this.textErr);
        this.p.add(this.buttonOk);
        this.p.add(this.buttonCancel);
        this.getContentPane().add(this.p);
        this.getContentPane().add("South", this.labelError);
        this.pack();
        this.centerWindow();
        this.setVisible(true);
    }

    public void open() {
        this.iterations = this.graph.getNumberOfIterations();
        this.textIter.setText(String.valueOf(this.iterations));
        this.err = this.graph.getStoppingErrVal();
        this.textErr.setText(String.valueOf(this.err));
        this.setVisible(true);
    }

    public boolean setProperties() {
        block6: {
            block5: {
                try {
                    this.iterations = Integer.valueOf(this.textIter.getText());
                    if (this.iterations > 0) break block5;
                    this.labelError.setText("Error: Number of iterations must be an integer > 0.");
                    return false;
                }
                catch (NumberFormatException e) {
                    this.labelError.setText("Error: Invalid number format!");
                    return false;
                }
            }
            this.err = Double.valueOf(this.textErr.getText());
            if (!(this.err < 0.0)) break block6;
            this.labelError.setText("Error: Target error value must be non-negative.");
            return false;
        }
        this.graph.setNumberOfIterations(this.iterations);
        this.graph.setStoppingErrVal(this.err);
        if (this.graph.pFrame != null) {
            this.graph.pFrame.auto.setText("Step " + this.iterations + "X");
        }
        return true;
    }

    @Override
    protected boolean actionOK() {
        return this.setProperties();
    }

    @Override
    protected boolean actionCancel() {
        return true;
    }

    @Override
    public void textValueChanged(TextEvent e) {
        if (e.getSource().equals(this.textIter)) {
            this.labelError.setText("");
        }
    }
}

