/*
 * Decompiled with CFR 0.152.
 */
package AIspace.neural.dialogs;

import AIspace.graphToolKit.GraphConsts;
import AIspace.graphToolKit.dialogs.BasicDialog;
import AIspace.graphToolKit.elements.Node;
import AIspace.neural.ExampleList;
import AIspace.neural.NeuralGraph;
import AIspace.neural.elements.NeuralNode;
import java.awt.BorderLayout;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Hashtable;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;

public class TestStatisticsDialog
extends BasicDialog
implements ItemListener,
FocusListener {
    protected NeuralGraph graph;
    protected ExampleList exampleList;
    protected Font font;
    protected ArrayList<Integer> correctExamples = null;
    protected ArrayList<Integer> noPredictionExamples = null;
    protected ArrayList<Integer> incorrectExamples = null;
    protected JTextArea correctTextArea;
    protected JTextArea noPredictionTextArea;
    protected JTextArea incorrectTextArea;
    protected JTextField rangeField;
    protected JPanel centerPanel;
    protected JPanel mainPanel;
    protected JPanel bottomPanel;
    protected JLabel correct;
    protected JLabel incorrect;
    protected ButtonGroup outputSelection;
    private int currentItem;
    private double rangeFieldValue;

    public TestStatisticsDialog(JFrame parent, NeuralGraph g) {
        super(parent, "Test Results", true);
        super.setCancelString("Close");
        this.graph = g;
        this.rangeFieldValue = 0.5;
        this.exampleList = this.graph.getExampleList();
        this.font = new Font("courier", 0, 13);
        this.getData();
        this.mainPanel = this.makeMainPanel();
        this.mainPanel.setBorder(new EmptyBorder(3, 3, 3, 3));
        this.getContentPane().add(this.mainPanel);
        this.currentItem = 0;
        this.pack();
        this.centerWindow();
        this.setVisible(true);
    }

    protected JPanel makeMainPanel() {
        JPanel mainPanel = new JPanel(new BorderLayout());
        mainPanel.add("North", this.makeCenterPanel());
        mainPanel.add("South", this.makeBottomPanel());
        return mainPanel;
    }

    protected JPanel makeCenterPanel() {
        this.centerPanel = new JPanel();
        int panelCount = 0;
        if (this.correctTextArea.getText().length() < 1 && this.noPredictionTextArea.getText().length() < 1 && this.incorrectTextArea.getText().length() < 1) {
            this.centerPanel.add(new JLabel("There are no test examples"));
        } else {
            if (this.correctTextArea.getText().length() > 1) {
                JPanel correctPanel = new JPanel(new BorderLayout());
                JLabel correctLabel = new JLabel("Correctly Predicted Examples (" + this.correctExamples.size() + "):");
                this.correctTextArea.setRows(10);
                this.correctTextArea.setFont(this.font);
                this.correctTextArea.setEditable(false);
                this.correctTextArea.setCursor(GraphConsts.DEFAULT_CURSOR);
                JScrollPane correctScrollPane = new JScrollPane(this.correctTextArea, 20, 30);
                correctPanel.add("North", correctLabel);
                correctPanel.add("Center", correctScrollPane);
                this.centerPanel.add(correctPanel);
                ++panelCount;
            }
            if (this.noPredictionTextArea.getText().length() > 1) {
                JPanel noPredictionPanel = new JPanel(new BorderLayout());
                JLabel noPredictionLabel = new JLabel("Examples With No Prediction (" + this.noPredictionExamples.size() + "):");
                this.noPredictionTextArea.setRows(10);
                this.noPredictionTextArea.setFont(this.font);
                this.noPredictionTextArea.setEditable(false);
                this.noPredictionTextArea.setCursor(GraphConsts.DEFAULT_CURSOR);
                JScrollPane noPredictionScrollPane = new JScrollPane(this.noPredictionTextArea, 20, 30);
                noPredictionPanel.add("North", noPredictionLabel);
                noPredictionPanel.add("Center", noPredictionScrollPane);
                this.centerPanel.add(noPredictionPanel);
                ++panelCount;
            }
            if (this.incorrectTextArea.getText().length() > 1) {
                JPanel incorrectPanel = new JPanel(new BorderLayout());
                JLabel incorrectLabel = new JLabel("Incorrectly Predicted Examples (" + this.incorrectExamples.size() + "):");
                this.incorrectTextArea.setRows(10);
                this.incorrectTextArea.setFont(this.font);
                this.incorrectTextArea.setEditable(false);
                this.incorrectTextArea.setCursor(GraphConsts.DEFAULT_CURSOR);
                JScrollPane incorrectScrollPane = new JScrollPane(this.incorrectTextArea, 20, 30);
                incorrectPanel.add("North", incorrectLabel);
                incorrectPanel.add("Center", incorrectScrollPane);
                this.centerPanel.add(incorrectPanel);
                ++panelCount;
            }
        }
        this.centerPanel.setLayout(new GridLayout(panelCount, 1));
        return this.centerPanel;
    }

    protected JPanel updateCenterPanel() {
        if (this.centerPanel == null) {
            this.centerPanel = new JPanel();
        } else {
            this.centerPanel.removeAll();
        }
        int panelCount = 0;
        if (this.correctTextArea.getText().length() < 1 && this.noPredictionTextArea.getText().length() < 1 && this.incorrectTextArea.getText().length() < 1) {
            this.centerPanel.add(new JLabel("There are no test examples"));
        } else {
            if (this.correctTextArea.getText().length() > 1) {
                JPanel correctPanel = new JPanel(new BorderLayout());
                JLabel correctLabel = new JLabel("Correctly Predicted Examples (" + this.correctExamples.size() + "):");
                this.correctTextArea.setRows(10);
                this.correctTextArea.setFont(this.font);
                this.correctTextArea.setEditable(false);
                this.correctTextArea.setCursor(GraphConsts.DEFAULT_CURSOR);
                correctPanel.add("North", correctLabel);
                correctPanel.add("Center", this.correctTextArea);
                this.centerPanel.add(correctPanel);
                ++panelCount;
            }
            if (this.noPredictionTextArea.getText().length() > 1) {
                JPanel noPredictionPanel = new JPanel(new BorderLayout());
                JLabel noPredictionLabel = new JLabel("Examples With No Prediction (" + this.noPredictionExamples.size() + "):");
                this.noPredictionTextArea.setRows(10);
                this.noPredictionTextArea.setFont(this.font);
                this.noPredictionTextArea.setEditable(false);
                this.noPredictionTextArea.setCursor(GraphConsts.DEFAULT_CURSOR);
                noPredictionPanel.add("North", noPredictionLabel);
                noPredictionPanel.add("Center", this.noPredictionTextArea);
                this.centerPanel.add(noPredictionPanel);
                ++panelCount;
            }
            if (this.incorrectTextArea.getText().length() > 1) {
                JPanel incorrectPanel = new JPanel(new BorderLayout());
                JLabel incorrectLabel = new JLabel("Incorrectly Predicted Examples (" + this.incorrectExamples.size() + "):");
                this.incorrectTextArea.setRows(10);
                this.incorrectTextArea.setFont(this.font);
                this.incorrectTextArea.setEditable(false);
                this.incorrectTextArea.setCursor(GraphConsts.DEFAULT_CURSOR);
                incorrectPanel.add("North", incorrectLabel);
                incorrectPanel.add("Center", this.incorrectTextArea);
                this.centerPanel.add(incorrectPanel);
                ++panelCount;
            }
        }
        this.centerPanel.setLayout(new GridLayout(panelCount, 1));
        return this.centerPanel;
    }

    protected void updateBottomLabels() {
        int numCorrect = 0;
        if (this.correctExamples != null) {
            numCorrect += this.correctExamples.size();
        }
        int numIncorrect = 0;
        if (this.exampleList.getTestArrayList().size() > 0) {
            numCorrect = numCorrect * 100 / this.exampleList.getTestArrayList().size();
            numIncorrect = 100 - numCorrect;
        }
        this.correct.setText("Predicted Correctly: " + numCorrect + "%");
        this.incorrect.setText("Predicted Incorrectly: " + numIncorrect + "%");
    }

    private void fillTextArea(JTextArea targetTextArea, ArrayList<Integer> selectedIndices, ArrayList<Hashtable<Integer, String>> allExamples, boolean showPrediction) {
        int i;
        targetTextArea.setText("");
        int maxColWidth = 0;
        String heading = new String("");
        if (selectedIndices == null || selectedIndices.size() < 1 || this.exampleList.getNumParameters() < 2) {
            return;
        }
        int numParameters = this.exampleList.getNumParameters();
        if (showPrediction) {
            ++numParameters;
        }
        String[] parameters = this.exampleList.getParameters();
        if (showPrediction) {
            String[] newParameters = new String[parameters.length + 1];
            i = 0;
            while (i < parameters.length) {
                newParameters[i] = parameters[i];
                ++i;
            }
            newParameters[newParameters.length - 1] = "Predicted Value";
            parameters = newParameters;
        }
        int[] colPos = new int[parameters.length];
        i = 0;
        while (i < numParameters) {
            colPos[i] = heading.length();
            heading = String.valueOf(heading) + parameters[i];
            int j = 0;
            while (j < 5) {
                heading = String.valueOf(heading) + " ";
                ++j;
            }
            ++i;
        }
        targetTextArea.setText(String.valueOf(targetTextArea.getText()) + heading);
        i = 0;
        while (i < selectedIndices.size()) {
            String display = new String("");
            Hashtable<Integer, String> oneExample = allExamples.get(selectedIndices.get(i));
            int j = 0;
            while (j < numParameters) {
                String value = "";
                if (showPrediction && j == numParameters - 1) {
                    String[] values = new String[oneExample.size()];
                    int k = 0;
                    while (k < oneExample.size()) {
                        values[k] = oneExample.get(new Integer(k));
                        ++k;
                    }
                    value = this.graph.outputValue(values, this.currentItem);
                } else {
                    value = oneExample.get(new Integer(j));
                }
                if (value != null) {
                    while (display.length() < colPos[j]) {
                        display = String.valueOf(display) + " ";
                    }
                    display = String.valueOf(display) + value;
                }
                ++j;
            }
            if (maxColWidth < display.length()) {
                maxColWidth = heading.length();
            }
            targetTextArea.setText(String.valueOf(targetTextArea.getText()) + "\n" + display);
            ++i;
        }
        targetTextArea.setColumns(maxColWidth);
        targetTextArea.setRows(selectedIndices.size() + 1);
    }

    protected JPanel makeBottomPanel() {
        this.bottomPanel = new JPanel(new BorderLayout());
        JPanel buttonPanel = new JPanel();
        JPanel percentagePanel = new JPanel(new GridLayout(3, 2));
        int numCorrect = 0;
        if (this.correctExamples != null) {
            numCorrect += this.correctExamples.size();
        }
        int numIncorrect = 0;
        if (this.exampleList.getTestArrayList().size() > 0) {
            numCorrect = numCorrect * 100 / this.exampleList.getTestArrayList().size();
            numIncorrect = 100 - numCorrect;
        }
        this.correct = new JLabel("Predicted Correctly: " + numCorrect + "%");
        this.incorrect = new JLabel("Predicted Incorrectly: " + numIncorrect + "%");
        JPanel rangePanel = new JPanel(new FlowLayout(0, 0, 0));
        JLabel rangeLabel = new JLabel("Input range threshold of classification: ");
        rangePanel.add(rangeLabel);
        this.rangeField = new JTextField("0.5");
        this.rangeField.setName("rangeField");
        this.rangeField.setColumns(3);
        this.rangeField.addFocusListener(this);
        rangePanel.add(this.rangeField);
        rangePanel.add(new JLabel("  "));
        percentagePanel.add(rangePanel);
        percentagePanel.add(new JLabel(""));
        percentagePanel.add(this.correct);
        percentagePanel.add(new JLabel(""));
        percentagePanel.add(this.incorrect);
        percentagePanel.add(new JLabel(""));
        JButton closeButton = new JButton("Close");
        closeButton.addActionListener(this);
        buttonPanel.add(closeButton);
        JPanel selectPanel = new JPanel(new BorderLayout());
        JPanel checkboxPanel = new JPanel(new FlowLayout());
        JLabel header = new JLabel("Select an output to analyze:");
        header.setAlignmentX(0.0f);
        selectPanel.add("North", header);
        ArrayList<Node> outputIndexList = this.graph.getOutputNodes();
        String nodeName = "";
        this.outputSelection = new ButtonGroup();
        int i = 0;
        while (i < outputIndexList.size()) {
            JCheckBox outButton;
            nodeName = ((NeuralNode)outputIndexList.get(i)).getLabel();
            if (i == 0) {
                outButton = new JCheckBox(nodeName, true);
                this.outputSelection.add(outButton);
            } else {
                outButton = new JCheckBox(nodeName, false);
                this.outputSelection.add(outButton);
            }
            outButton.setName(Integer.toString(i));
            outButton.addItemListener(this);
            checkboxPanel.add(outButton);
            ++i;
        }
        selectPanel.add("Center", checkboxPanel);
        this.bottomPanel.add("North", percentagePanel);
        this.bottomPanel.add("Center", selectPanel);
        this.bottomPanel.add("South", buttonPanel);
        return this.bottomPanel;
    }

    protected void getData() {
        this.correctExamples = this.graph.getTestExampleIndices(NeuralGraph.CORRECT, this.rangeFieldValue, this.currentItem);
        this.noPredictionExamples = this.graph.getTestExampleIndices(NeuralGraph.NO_PREDICTION, this.rangeFieldValue, this.currentItem);
        this.incorrectExamples = this.graph.getTestExampleIndices(NeuralGraph.INCORRECT, this.rangeFieldValue, this.currentItem);
        this.correctTextArea = new JTextArea("", 5, 5);
        this.noPredictionTextArea = new JTextArea("", 5, 5);
        this.incorrectTextArea = new JTextArea("", 5, 5);
        this.fillTextArea(this.correctTextArea, this.correctExamples, this.exampleList.getTestArrayList(), true);
        this.fillTextArea(this.noPredictionTextArea, this.noPredictionExamples, this.exampleList.getTestArrayList(), true);
        this.fillTextArea(this.incorrectTextArea, this.incorrectExamples, this.exampleList.getTestArrayList(), true);
    }

    @Override
    protected boolean actionOK() {
        return true;
    }

    @Override
    protected boolean actionCancel() {
        return true;
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        JCheckBox current = (JCheckBox)e.getItemSelectable();
        String indexName = current.getName();
        int index = Integer.parseInt(indexName);
        if (index != this.currentItem) {
            this.currentItem = index;
            this.getData();
            this.updateCenterPanel();
            this.updateBottomLabels();
            this.validate();
        }
    }

    @Override
    public void focusGained(FocusEvent e) {
        if (e.getComponent().getName().equals("rangeField")) {
            try {
                this.rangeFieldValue = Double.parseDouble(this.rangeField.getText());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    @Override
    public void focusLost(FocusEvent e) {
        if (e.getComponent().getName().equals("rangeField")) {
            try {
                double range = Double.parseDouble(this.rangeField.getText());
                if (this.rangeFieldValue != range) {
                    this.rangeFieldValue = range;
                    this.getData();
                    this.updateCenterPanel();
                    this.updateBottomLabels();
                    this.validate();
                    this.pack();
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }
}

