/*
 * Decompiled with CFR 0.152.
 */
package AIspace.neural.elements;

import AIspace.graphToolKit.elements.Edge;
import AIspace.graphToolKit.elements.Node;
import AIspace.neural.BackPropagation;
import AIspace.neural.NeuralGraph;
import AIspace.neural.PlotCanvas;
import java.awt.Color;
import java.awt.Graphics;

public class NeuralEdge
extends Edge {
    private double initialParaValue;
    private double currentParaValue;
    private int parameterIndex;

    public NeuralEdge(NeuralGraph graph, Node tail, Node head) {
        super(graph, tail, head);
        if (graph.getInitParamType()) {
            Double tempValue = 2.0 * graph.getInitParamBound() * Math.random() - graph.getInitParamBound();
            this.initialParaValue = tempValue;
            this.currentParaValue = tempValue;
        } else {
            this.initialParaValue = graph.getInitParamValue();
            this.currentParaValue = graph.getInitParamValue();
        }
        this.edgeType = 5551;
        this.parameterIndex = -1;
        this.setLabel(graph.showParam);
    }

    public double getInitialParaValue() {
        return this.initialParaValue;
    }

    public void setInitialParaValue(double value) {
        this.initialParaValue = value;
    }

    public double getCurrentParaValue() {
        return this.currentParaValue;
    }

    public void setCurrentParaValue(double value) {
        this.currentParaValue = value;
        this.setLabel(((NeuralGraph)this.graph).showParam);
    }

    public void setParameterIndex(int index) {
        this.parameterIndex = index;
    }

    public int getParameterIndex() {
        return this.parameterIndex;
    }

    public void setLabel(boolean showParam) {
        if (showParam) {
            this.setLabel(PlotCanvas.doubleToString(this.currentParaValue));
        } else {
            this.setLabel("");
        }
    }

    @Override
    public void draw(Graphics offscreen, boolean moving) {
        if (this.graph.isInSolveMode()) {
            float r_comp = 1.0f;
            float g_comp = 1.0f;
            float b_comp = 1.0f;
            double value = BackPropagation.sigmoidFunction(this.currentParaValue * 0.5);
            if (value < 0.5) {
                g_comp = (float)(value * 2.0);
                b_comp = (float)(1.0 - (0.5 - value) * 2.0);
            } else {
                r_comp = (float)((1.0 - value) * 2.0);
                b_comp = (float)(1.0 - (value - 0.5) * 2.0);
            }
            this.color = new Color(r_comp, g_comp, b_comp);
        } else {
            this.color = Color.black;
        }
        super.draw(offscreen, moving);
    }
}

