/*
 * Decompiled with CFR 0.152.
 */
package AIspace.neural.elements;

import AIspace.graphToolKit.elements.Node;
import AIspace.neural.BackPropagation;
import AIspace.neural.NeuralGraph;
import AIspace.neural.PlotCanvas;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.util.ArrayList;

public class NeuralNode
extends Node {
    public static final int SIGMOID = 0;
    public static final int LINEAR = 1;
    public static final int TANH = 2;
    public static final int EXP = 3;
    private ArrayList<Node> parents;
    private ArrayList<Node> children;
    private double initialParaValue;
    private double currentParaValue;
    private int parameterIndex;
    private boolean coloring;
    public int functionType;
    public double[] currentError;
    private double currOutput;

    public NeuralNode(NeuralGraph graph) {
        super(graph);
        this.shape = 1111;
        this.wPad = 10;
        this.hPad = 10;
        this.parents = new ArrayList(5);
        this.children = new ArrayList(5);
        if (graph.getInitParamType()) {
            Double tempValue = 2.0 * graph.getInitParamBound() * Math.random() - graph.getInitParamBound();
            this.initialParaValue = tempValue;
            this.currentParaValue = tempValue;
        } else {
            this.initialParaValue = graph.getInitParamValue();
            this.currentParaValue = graph.getInitParamValue();
        }
        this.parameterIndex = -1;
        this.coloring = false;
        this.functionType = 0;
        this.currentError = null;
        this.currOutput = 0.0;
    }

    public double getOutputValue() {
        return this.currOutput;
    }

    public void setOutputValue(double out) {
        this.currOutput = out;
    }

    public double getInitialParaValue() {
        return this.initialParaValue;
    }

    public void setInitialParaValue(double value) {
        this.initialParaValue = value;
    }

    public double getCurrentParaValue() {
        return this.currentParaValue;
    }

    public void setCurrentParaValue(double value) {
        this.currentParaValue = value;
        this.setLabel(((NeuralGraph)this.graph).showParam);
    }

    public ArrayList<Node> getParentNodes() {
        return this.parents;
    }

    public ArrayList<Node> getChildrenNodes() {
        return this.children;
    }

    public int getNumParentNodes() {
        return this.parents.size();
    }

    public int getNumChildrenNodes() {
        return this.children.size();
    }

    public void addParent(Node node) {
        if (!this.parents.contains(new Integer(this.index))) {
            this.parents.add(node);
        }
    }

    public void addChild(Node node) {
        if (!this.children.contains(new Integer(this.index))) {
            this.children.add(node);
        }
    }

    public void removeParent(Node node) {
        this.parents.remove(node);
    }

    public void removeChild(Node node) {
        this.children.remove(node);
    }

    public void setParameterIndex(int index) {
        this.parameterIndex = index;
    }

    public int getParameterIndex() {
        return this.parameterIndex;
    }

    public void setColoring(boolean value) {
        this.coloring = value;
    }

    public void setLabel(boolean showParam) {
        this.label[1] = showParam && this.parents.size() != 0 ? PlotCanvas.doubleToString(this.currentParaValue) : "";
        this.updateSize();
    }

    @Override
    protected int getWidth() {
        FontMetrics fm = this.graph.canvas.getFontMetrics();
        try {
            if (this.label[1].equals("")) {
                return fm.stringWidth(this.label[0]) + this.wPad;
            }
            int width1 = this.label[0] == null || this.label[0].equals("") ? 0 : fm.stringWidth(this.label[0]) + this.wPad;
            int width2 = this.label[1] == null || this.label[1].equals("") ? 0 : fm.stringWidth(this.label[1]) + this.wPad;
            return Math.max(width1, width2);
        }
        catch (Exception e) {
            System.out.println(String.valueOf(this.label[0]) + ", " + this.label[1]);
            return 10;
        }
    }

    @Override
    protected int getHeight() {
        int height = this.graph.canvas.getFontMetrics().getHeight() + this.hPad;
        if (!this.label[1].equals("")) {
            height *= 2;
        }
        return height;
    }

    @Override
    public void draw(Graphics offscreen, boolean moving) {
        if (this.graph.isInSolveMode() && this.coloring) {
            Color newColor;
            float r_comp = 1.0f;
            float g_comp = 1.0f;
            float b_comp = 1.0f;
            double value = BackPropagation.sigmoidFunction(this.currentParaValue * 0.5);
            if (value < 0.5) {
                g_comp = (float)(value * 2.0);
                b_comp = (float)(1.0 - (0.5 - value) * 2.0);
            } else {
                r_comp = (float)((1.0 - value) * 2.0);
                b_comp = (float)(1.0 - (value - 0.5) * 2.0);
            }
            this.color = newColor = new Color(r_comp, g_comp, b_comp);
        } else {
            this.color = Color.black;
        }
        super.draw(offscreen, moving);
    }

    @Override
    protected void drawLabel(Graphics offscreen) {
        FontMetrics fm = this.graph.canvas.getFontMetrics();
        int h = fm.getAscent();
        int width1 = fm.stringWidth(this.label[0]) + this.wPad;
        int width2 = fm.stringWidth(this.label[1]) + this.wPad;
        if (this.isBold && this.color == Color.black) {
            offscreen.setColor(Color.white);
        } else {
            offscreen.setColor(Color.black);
        }
        if (this.label[1].equals("")) {
            offscreen.drawString(this.label[0], (int)this.pos.x - (width1 - this.wPad) / 2, (int)this.pos.y + h / 2);
        } else {
            offscreen.drawString(this.label[0], (int)this.pos.x - (width1 - this.wPad) / 2, (int)this.pos.y - (this.height - this.hPad) / 4 + h / 2);
            offscreen.drawString(this.label[1], (int)this.pos.x - (width2 - this.wPad) / 2, (int)this.pos.y + (this.height - this.hPad) / 4 + h / 2);
        }
    }

    @Override
    public String toString() {
        return String.valueOf(this.index) + ": " + this.label[0];
    }
}

