/*
 * Decompiled with CFR 0.152.
 */
package AIspace.neural.help;

import AIspace.graphToolKit.help.HelpCanvas;
import java.awt.Color;
import java.awt.Graphics;
import java.text.DecimalFormat;

public class NeuralHelpCanvas
extends HelpCanvas {
    public NeuralHelpCanvas(boolean isAntiAliasingEnabled) {
        super(isAntiAliasingEnabled);
    }

    @Override
    public void paint(Graphics graphics) {
        int x = 35;
        int y = 15;
        int w = 30;
        int h = 15;
        graphics.drawString("Legend for Nodes", x, y);
        this.drawDiamondNode(graphics, x, y += 35, w, h, Color.BLACK, false, false);
        graphics.drawString("Input Node (Diamond)", x + 50, y);
        this.drawOvalNode(graphics, x, y += 35, w, h, Color.BLACK, false, false);
        graphics.drawString("Hidden Layer Node (Oval)", x + 50, y);
        this.drawRectangleNode(graphics, x, y += 35, w, h, Color.BLACK, false, false);
        graphics.drawString("Output Node (Rectangle)", x + 50, y);
        graphics.drawString("Legend for Edge Colouring in Solution Mode", x, y += 60);
        double prevVal = 0.0;
        double nextVal = 0.0;
        DecimalFormat decFormat = new DecimalFormat("0.000");
        int i = 0;
        while (i <= 10) {
            float b_comp;
            float g_comp;
            float r_comp;
            y += 35;
            double value = (double)i * 0.1;
            prevVal = nextVal;
            nextVal = -Math.log(1.0 / (value + 0.05) - 1.0);
            if (value < 0.5) {
                r_comp = 1.0f;
                g_comp = (float)(value * 2.0);
                b_comp = (float)(1.0 - (0.5 - value) * 2.0);
            } else {
                r_comp = (float)((1.0 - value) * 2.0);
                g_comp = 1.0f;
                b_comp = (float)(1.0 - (value - 0.5) * 2.0);
            }
            this.drawEdge(graphics, x, y, w, new Color(r_comp, g_comp, b_comp), false, true, true);
            String interval = i == 0 ? "x <= " + decFormat.format(nextVal) : (i == 10 ? "x > " + decFormat.format(prevVal) : String.valueOf(decFormat.format(prevVal)) + " < x <= " + decFormat.format(nextVal));
            graphics.drawString("Edge with parameters " + interval, x + 50, y);
            ++i;
        }
    }
}

