clear all; close all;
%
M=100;
T=1024*1; 
frv=[1:T/2-1]; frvr=frv/T;
% noises
KrOut=0.0; KrIn=0.0; ExtIn=0.0; Nlin=1.0;
%
Syu=zeros(T,1); Suu=Syu; Syy=Syu; G=Syu;
%
orN=5; [br1,ar1]=butter(orN,[0.3 0.6]); 
orN=7; [br2,ar2]=butter(orN,0.4); 
%
[Rf1,W1] = freqz(br1,ar1,T/2-1);
[Rf2,W2] = freqz(br2,ar2,T/2-1);
figure(1), subplot(211), plot(W1/2/pi,db(Rf1)); axis([0 .5 -100 20]); title('Unknown input'); grid; 
           subplot(212), plot(W2/2/pi,db(Rf2)); axis([0 .5 -100 20]); title('Measured system');grid; 
%
for k=1:M, k,
u0=randn(T,1); u01=randn(T,1);
u0ext=filter(br1,ar1,u01); 
u0full=u0+ExtIn*u0ext;
y0=filter(br2,ar2,u0full); 
if Nlin > 0, y0=tanh(10*y0); end; 
%
um=u0+KrIn*randn(size(u0));
ym=y0+KrOut*randn(size(y0));
%
Um=fft(um); Ym=fft(ym);
%
Syu=Syu+(Ym.*conj(Um)-Syu)/k;
Suu=Suu+(Um.*conj(Um)-Suu)/k;
Syy=Syy+(Ym.*conj(Ym)-Syy)/k;
G=abs(Syu).^2./(Syy.*Suu);
%
figure(3), 
plot(frvr,abs(G(frv)),'b',frvr,abs(Rf2),'g'); grid; 
%axis([0 .5 -100 20]); drawnow;
%
end;




