clear all; close all;
%
M=4;
T=1024*1; 
%
frv=[1:T/2-1]; frvr=frv/T;
% noises
KrOut=0.0; KrIn=0.0;
%
Syu=zeros(T,1); Suu=Syu; G=Syu;  
%------------------------
%orN=5; [br,ar]=butter(orN,[0.3 0.6]); 
orN=7; [br,ar]=butter(orN,0.4); 
%
[Rf,W] = freqz(br,ar,T/2-1);
figure(1), plot(W/2/pi,db(Rf)); grid; 
title('R System','FontName','Arial','Fontsize',12);
axis([0 .5 -100 20]);
%
u0=randn(T,1); 
y0=filter(br,ar,u0); 
%
figure(2), subplot(211), plot(u0); grid;  title('Input');
subplot(212), plot(y0); grid; title('Output');
%
for k=1:M,
u0=randn(T,1); 
y0=filter(br,ar,u0); 
%
%-noisy measurement ------------
um=u0+KrIn*randn(size(u0));
ym=y0+KrOut*randn(size(y0));
Um=fft(um); Ym=fft(ym);
%
Syu=Syu+(Ym.*conj(Um)-Syu)/k;
Suu=Suu+(Um.*conj(Um)-Suu)/k;
G=Syu./Suu;
%
figure(3), 
plot(frvr,db(G(frv)),'b',frvr,db(Rf),'g'); grid; 
title(['M = ', num2str(k)]); axis([0 .5 -100 20]); drawnow;
end;

mean(abs(G(1:100)-Rf(1:100)))
