clear all; close all;
%
M=100;
T=1024*1; 
%
nfreq1=fix(T/2-1); 
fvo1=[1:1:nfreq1]'; 
frv=fvo1; frvr=fvo1/T;
fvo1RMS=[1:1:fix(2*nfreq1/3)]'; 
%
junit=-sqrt(-1); pi2j=2*pi*junit;
% noises
KrOut=0.0; KrIn=0.5;
%
Syu=zeros(1,T); Suu=Syu; Syy=Syu;  Suy=Syu; GH1=Syu; GH2=Syu; GH1save=Syu; GH2save=Syu; 
%------------------------
%orN=5; [br,ar]=butter(orN,[0.3 0.6]); 
orN=7; [br,ar]=butter(orN,0.4); 
%
[Rf,W] = freqz(br,ar,T/2-1);
figure(1), plot(W/2/pi,db(Rf)); grid; 
title('R System','FontName','Arial','Fontsize',12);
axis([0 .5 -100 20]);
%
S=zeros(T,1);
S(fvo1RMS) = ones(size(fvo1RMS)).* exp(pi2j*rand(size(fvo1RMS)));
Signal = 2*real(ifft(S));
u0 = Signal/std(Signal);
y0=filter(br,ar,u0); 
%
figure(2), subplot(211), plot(u0); grid;  title('Input');
subplot(212), plot(y0); grid; title('Output');
%
for k=1:M,
S(fvo1RMS) = ones(size(fvo1RMS)).* exp(pi2j*rand(size(fvo1RMS)));
Signal = 2*real(ifft(S));
u0 = Signal/std(Signal);
y0=filter(br,ar,u0); 
%
%-noisy measurement ------------
um=u0+KrIn*randn(size(u0));
ym=y0+KrOut*randn(size(y0));
Um=fft(um); Ym=fft(ym);
%
Syu(:)=Syu(:)+(Ym.*conj(Um)-Syu(:))/k;
Suy(:)=conj(Syu(:));
Suu(:)=Suu(:)+(Um.*conj(Um)-Suu(:))/k;
Syy(:)=Syy(:)+(Ym.*conj(Ym)-Syy(:))/k;
GH1(:)=Syu./Suu;
GH2(:)=Syy./Suy;
%
figure(13), 
plot(frvr,db(GH2(frv)),'r',frvr,db(GH1(frv)),'b',frvr,db(Rf),'g'); grid; 
title(['M = ', num2str(k)]); axis([0 .5 -100 20]); drawnow;
%
end;


