clear all; close all;
%
M=1;
T=1024*1; 
%
nfreq1=fix(T/2-1); 
fvo1=[1:1:nfreq1]'; 
frv=fvo1; frvr=fvo1/T;
%
junit=-sqrt(-1); pi2j=2*pi*junit;
% noises
KrOut=0.0; KrIn=0.0;
%
Syu=zeros(T,1); Suu=Syu; G=Syu;  
%------------------------
%orN=5; [br,ar]=butter(orN,[0.3 0.6]); 
orN=7; [br,ar]=butter(orN,0.4); 
%
[Rf,W] = freqz(br,ar,T/2-1);
figure(11), plot(W/2/pi,db(Rf)); grid; 
title('R System','FontName','Arial','Fontsize',12);
axis([0 .5 -100 20]);
%
for k=1:M,
S=zeros(T,1);
S(fvo1) = ones(size(fvo1)).* exp(pi2j*rand(size(fvo1)));
Signal = 2*real(ifft(S));
u0 = Signal/std(Signal); 
y0=filter(br,ar,u0); 
%
%-noisy measurement ------------
um=u0+KrIn*randn(size(u0));
ym=y0+KrOut*randn(size(y0));
Um=fft(um); Ym=fft(ym);
%
Syu=Syu+(Ym.*conj(Um)-Syu)/k;
Suu=Suu+(Um.*conj(Um)-Suu)/k;
G=Syu./Suu;
%
figure(13), 
plot(frvr,db(G(frv)),'b',frvr,db(Rf),'g'); grid; 
title(['M = ', num2str(k)]);
axis([0 .5 -100 20]); drawnow;
%
end;

mean(abs(G(1:100)-Rf(1:100)))
