clear all; close all;
%
M=100;
T=1024*1; 
%
frv=[1:T/2]; frvr=[1:T/2]/T;
% noises
KrOut=0.5; KrIn=0.0;
% regularization constants
lamb=200;
%
Syu=zeros(T,1); Suu=Syu; G=Syu; Gave=G; Gavereg=G; Greg=G;
%
%orN=5; [br,ar]=butter(orN,[0.3 0.6]); 
orN=7; [br,ar]=butter(orN,0.4); 
fvrel1=frv/T; zet1=exp(-sqrt(-1)*2*pi*fvrel1);
%
[Rf,W] = freqz(br,ar,T/2);
figure(1), plot(W,db(Rf)); grid; 
title('R System','FontName','Arial','Fontsize',12);
%
u0=randn(T,1); 
y0=filter(br,ar,u0); 
%
figure(2), subplot(211), plot(u0); grid;  title('Input');
subplot(212), plot(y0); grid; title('Output');
%
for k=1:M,
u0=randn(T,1); 
y0=filter(br,ar,u0); 
%
%-noisy measurement ------------
um=u0+KrIn*randn(size(u0));
ym=y0+KrOut*randn(size(y0));
Um=fft(um); Ym=fft(ym);
Syu=Ym.*conj(Um); Suu=Um.*conj(Um);
G=Syu./Suu;
Gave=Gave+(G-Gave)/k;
Greg=Syu./(Suu+lamb);
Gavereg=Gavereg+(Greg-Gavereg)/k;
%
%-------------------------------
figure(3), 
%plot(frvr,db(G(frv)),'k',frvr,db(Gave(frv)),'b',frvr,db(Rf),'g',...
%    frvr,db(Greg(frv)),'c',frvr,db(Gavereg(frv)),'r'); grid;
plot(frvr,db(Gave(frv)),'b',frvr,db(Rf),'g',frvr,db(Gavereg(frv)),'r'); grid;
title(['M = ', num2str(k)]);
axis([0 .5 -100 20]);
%
end;



