clear all; close all;
%
M=100;
T=1024; 
%
nfreq1=fix(T/2-1); 
fvo1=[1:1:nfreq1]'; 
%
frv=fvo1; frvr=fvo1/T;
junit=-sqrt(-1); pi2j=2*pi*junit;
%
Syu1=zeros(T,1); Suu1=Syu1; G1=Syu1; 
Syu2=zeros(T,1); Suu2=Syu2; G2=Syu2; 
%------------------------
%orN=5; [br,ar]=butter(orN,[0.3 0.6]); 
orN=7; [br,ar]=butter(orN,0.4); 
%
[Rf,W] = freqz(br,ar,T/2-1);
figure(1), plot(W/2/pi,db(Rf)); grid; 
title('R System','FontName','Arial','Fontsize',12);
axis([0 .5 -100 20]);
%
for k=1:M,
S=zeros(T,1);
S(fvo1) = ones(size(fvo1)).* exp(pi2j*rand(size(fvo1)));
Signal = 2*real(ifft(S));
u0 = Signal/std(Signal); 
u0=[u0; u0; u0; u0];
y0=filter(br,ar,u0); 
%
D = 50;
u01=u0(1:T); y01=y0(1:T);  
u01=u0(1+D:T+D); y01=y0(1+D:T+D);  
u02=u0(3*T+1:4*T); y02=y0(3*T+1:4*T);  
%
%-noisy measurement ------------
um1=u01; ym1=y01;
Um1=fft(um1); Ym1=fft(ym1);
um2=u02; ym2=y02;
Um2=fft(um2); Ym2=fft(ym2);
%
Syu1=Syu1+(Ym1.*conj(Um1)-Syu1)/k;
Suu1=Suu1+(Um1.*conj(Um1)-Suu1)/k;
G1=Syu1./Suu1;
%
Syu2=Syu2+(Ym2.*conj(Um2)-Syu2)/k;
Suu2=Suu2+(Um2.*conj(Um2)-Suu2)/k;
G2=Syu2./Suu2;
%-------------------------------
%
figure(3), 
plot(frvr,db(G1(frv)),'b',frvr,db(Rf),'g',frvr,db(G2(frv)),'r'); grid; 
title(['M = ', num2str(k)]);
axis([0 .5 -300 20]); drawnow;
%
end;

