% NAME: imtc2004-mimo4.m
% SIMO with 4 inputs
% same grids
clear all; close all; rand('seed',0);
%------------------------------------
a1=1; a2=1; a3=1; a4=1; aorder1=[a1, a2, a3, a4];
%
Nynoise=0.5;

% excitation signals: odd multisine
%--------------------------------------
junit=-sqrt(-1); 
ML=100;  					%number of measurements
%
npoints1=1024*2*8; 		    % number of time domain points
n1=npoints1/2;     			% maximum number of frequencies
nfreq1=fix(npoints1/10); 
fv1=[1:nfreq1]'; 
fvo1=[1:2:nfreq1]'; %fvo1=fv1;
NN1=2*length(fvo1);
%
orNR1=9; [br1,ar1]=cheby1(orNR1,25,0.15); 
orNR2=3; [br2,ar2]=cheby1(orNR2,10,0.02,'high'); 
orNR3=9; [br3,ar3]=cheby1(orNR3,10,0.15); 
orNR4=9; [br4,ar4]=cheby1(orNR4,25,0.05,'high'); 
orNS1=3; [bs1,as1]=cheby1(orNS1,1,0.07);
%
fvrel1=0.1*fv1/nfreq1; zet1=exp(-sqrt(-1)*2*pi*fvrel1);
%
HR1fD=br1(1); HR1fN=ar1(1); 
for or=1:orNR1, HR1fD=HR1fD+br1(or+1)*zet1.^or; HR1fN=HR1fN+ar1(or+1)*zet1.^or; end; 
R1f1=(HR1fD./HR1fN);
%
HR2fD=br2(1); HR2fN=ar2(1); 
for or=1:orNR2, HR2fD=HR2fD+br2(or+1)*zet1.^or; HR2fN=HR2fN+ar2(or+1)*zet1.^or; end; 
R2f1=(HR2fD./HR2fN);
%
HR3fD=br3(1); HR3fN=ar3(1); 
for or=1:orNR3, HR3fD=HR3fD+br3(or+1)*zet1.^or; HR3fN=HR3fN+ar3(or+1)*zet1.^or; end; 
R3f1=(HR3fD./HR3fN);
%
HR4fD=br4(1); HR4fN=ar4(1); 
for or=1:orNR4, HR4fD=HR4fD+br4(or+1)*zet1.^or; HR4fN=HR4fN+ar4(or+1)*zet1.^or; end; 
R4f1=(HR4fD./HR4fN);
%
HS1fD=bs1(1); HS1fN=as1(1); 
for or=1:orNS1, HS1fD=HS1fD+bs1(or+1)*zet1.^or; HS1fN=HS1fN+as1(or+1)*zet1.^or; end;
S1f1=(HS1fD./HS1fN);
%
R1S1f1=R1f1.*S1f1; 
R2S1f1=R2f1.*S1f1; 
R3S1f1=R3f1.*S1f1; 
R4S1f1=R4f1.*S1f1; 
%
figure(1),
 subplot(4,3,1), plot(fvrel1,db(R1f1)); grid; title('R1 Input System','FontName','Arial','Fontsize',12);
 subplot(4,3,2), plot(fvrel1,db(S1f1)); grid; title('S1 Output System','FontName','Arial','Fontsize',12);
 subplot(4,3,3), plot(fvrel1,db(R1S1f1)); grid; title('R1*S1 Linear System','FontName','Arial','Fontsize',12);
 subplot(4,3,4), plot(fvrel1,db(R2f1)); grid; title('R2 Input System','FontName','Arial','Fontsize',12);
 subplot(4,3,5), plot(fvrel1,db(S1f1)); grid; title('S1 Output System','FontName','Arial','Fontsize',12);
 subplot(4,3,6), plot(fvrel1,db(R2S1f1)); grid; title('R2*S1 Linear System','FontName','Arial','Fontsize',12);
 subplot(4,3,7), plot(fvrel1,db(R3f1)); grid; title('R3 Input System','FontName','Arial','Fontsize',12);
 subplot(4,3,8), plot(fvrel1,db(S1f1)); grid; title('S1 Output System','FontName','Arial','Fontsize',12);
 subplot(4,3,9), plot(fvrel1,db(R3S1f1)); grid; title('R3*S1 Linear System','FontName','Arial','Fontsize',12);
 subplot(4,3,10), plot(fvrel1,db(R4f1)); grid; title('R4 Input System','FontName','Arial','Fontsize',12);
 subplot(4,3,11), plot(fvrel1,db(S1f1)); grid; title('S1 Output System','FontName','Arial','Fontsize',12);
 subplot(4,3,12), plot(fvrel1,db(R4S1f1)); grid; title('R4*S1 Linear System','FontName','Arial','Fontsize',12);
%
pause

X1=zeros(npoints1,1); Xo1=X1; Zo1=X1; Vo1=X1; Yo1=zeros(length(fv1),1); 
X2=zeros(npoints1,1); Xo2=X2;
X3=zeros(npoints1,1); Xo3=X3;
X4=zeros(npoints1,1); Xo4=X4;
%
Go11m=zeros(length(fvo1),1); Go12m=zeros(length(fvo1),1); Go13m=zeros(length(fvo1),1); Go14m=zeros(length(fvo1),1); 
Go11t=zeros(length(fvo1),1); Go12t=zeros(length(fvo1),1); Go13t=zeros(length(fvo1),1); Go14t=zeros(length(fvo1),1); 
%
Nc1=0;
while Nc1<ML, % generation of excitation signals
%
% 1st experiment
fio1=rand(length(fvo1),1)*2*pi; Zxo1=exp(-junit*fio1); Xo1=0*Xo1; Xo1(fvo1+1)=Zxo1; 
Xo1(2*n1+1-fvo1)=conj(Xo1(1+fvo1)); xo1=npoints1*real(ifft(Xo1)); Ax1=sqrt(sum(xo1.^2)/npoints1); 
xo1ref=xo1/Ax1; Xo1ref=Xo1/Ax1;
%
fio1=rand(length(fvo1),1)*2*pi; Zxo1=exp(-junit*fio1); Xo2=0*Xo2; Xo2(fvo1+1)=Zxo1; 
Xo2(2*n1+1-fvo1)=conj(Xo2(1+fvo1)); xo2=npoints1*real(ifft(Xo2)); Ax2=sqrt(sum(xo2.^2)/npoints1); 
xo2ref=xo2/Ax2; Xo2ref=Xo2/Ax2;
%
fio1=rand(length(fvo1),1)*2*pi; Zxo1=exp(-junit*fio1); Xo3=0*Xo3; Xo3(fvo1+1)=Zxo1; 
Xo3(2*n1+1-fvo1)=conj(Xo3(1+fvo1)); xo3=npoints1*real(ifft(Xo3)); Ax3=sqrt(sum(xo3.^2)/npoints1); 
xo3ref=xo3/Ax3; Xo3ref=Xo3/Ax3;
%
fio1=rand(length(fvo1),1)*2*pi; Zxo1=exp(-junit*fio1); Xo4=0*Xo4; Xo4(fvo1+1)=Zxo1; 
Xo4(2*n1+1-fvo1)=conj(Xo4(1+fvo1)); xo4=npoints1*real(ifft(Xo4)); Ax4=sqrt(sum(xo4.^2)/npoints1); 
xo4ref=xo4/Ax4; Xo4ref=Xo4/Ax4;
%
%
xo1=xo1ref; Xo1=Xo1ref; 
xo2=xo2ref; Xo2=Xo2ref; 
xo3=xo3ref; Xo3=Xo3ref; 
xo4=xo4ref; Xo4=Xo4ref;
%
X1e1=Xo1(fvo1+1); X2e1=Xo2(fvo1+1); X3e1=Xo3(fvo1+1); X4e1=Xo4(fvo1+1); 
%
% passing signals through input dynamics
Zo1(fvo1+1)=Xo1(fvo1+1).*R1f1(fvo1); Zo1(2*n1+1-fvo1)=conj(Zo1(1+fvo1)); zo1=npoints1*real(ifft(Zo1));
Zo1(fvo1+1)=Xo2(fvo1+1).*R2f1(fvo1); Zo1(2*n1+1-fvo1)=conj(Zo1(1+fvo1)); zo2=npoints1*real(ifft(Zo1));
Zo1(fvo1+1)=Xo3(fvo1+1).*R3f1(fvo1); Zo1(2*n1+1-fvo1)=conj(Zo1(1+fvo1)); zo3=npoints1*real(ifft(Zo1));
Zo1(fvo1+1)=Xo4(fvo1+1).*R4f1(fvo1); Zo1(2*n1+1-fvo1)=conj(Zo1(1+fvo1)); zo4=npoints1*real(ifft(Zo1));
% passing signals through nonlinear system
vo1=zo1+zo2+zo3+zo4+Nynoise*randn(size(zo1));
% passing signals through output dynamics
Ybe1=fft(vo1)/npoints1; YS1=Ybe1(fv1+1); Yo11e1=YS1.*S1f1(fv1);
%
% 2nd experiment
fio1=rand(length(fvo1),1)*2*pi; Zxo1=exp(-junit*fio1); Xo1=0*Xo1; Xo1(fvo1+1)=Zxo1; 
Xo1(2*n1+1-fvo1)=conj(Xo1(1+fvo1)); xo1=npoints1*real(ifft(Xo1)); Ax1=sqrt(sum(xo1.^2)/npoints1); 
xo1ref=xo1/Ax1; Xo1ref=Xo1/Ax1;
%
fio1=rand(length(fvo1),1)*2*pi; Zxo1=exp(-junit*fio1); Xo2=0*Xo2; Xo2(fvo1+1)=Zxo1; 
Xo2(2*n1+1-fvo1)=conj(Xo2(1+fvo1)); xo2=npoints1*real(ifft(Xo2)); Ax2=sqrt(sum(xo2.^2)/npoints1); 
xo2ref=xo2/Ax2; Xo2ref=Xo2/Ax2;
%
fio1=rand(length(fvo1),1)*2*pi; Zxo1=exp(-junit*fio1); Xo3=0*Xo3; Xo3(fvo1+1)=Zxo1; 
Xo3(2*n1+1-fvo1)=conj(Xo3(1+fvo1)); xo3=npoints1*real(ifft(Xo3)); Ax3=sqrt(sum(xo3.^2)/npoints1); 
xo3ref=xo3/Ax3; Xo3ref=Xo3/Ax3;
%
fio1=rand(length(fvo1),1)*2*pi; Zxo1=exp(-junit*fio1); Xo4=0*Xo4; Xo4(fvo1+1)=Zxo1; 
Xo4(2*n1+1-fvo1)=conj(Xo4(1+fvo1)); xo4=npoints1*real(ifft(Xo4)); Ax4=sqrt(sum(xo4.^2)/npoints1); 
xo4ref=xo4/Ax4; Xo4ref=Xo4/Ax4;
%
xo1=xo1ref; Xo1=Xo1ref; 
xo2=xo2ref; Xo2=Xo2ref; 
xo3=xo3ref; Xo3=Xo3ref; 
xo4=xo4ref; Xo4=Xo4ref;
%
X1e2=Xo1(fvo1+1); X2e2=Xo2(fvo1+1); X3e2=Xo3(fvo1+1); X4e2=Xo4(fvo1+1); 
%
% passing signals through input dynamics
Zo1(fvo1+1)=Xo1(fvo1+1).*R1f1(fvo1); Zo1(2*n1+1-fvo1)=conj(Zo1(1+fvo1)); zo1=npoints1*real(ifft(Zo1));
Zo1(fvo1+1)=Xo2(fvo1+1).*R2f1(fvo1); Zo1(2*n1+1-fvo1)=conj(Zo1(1+fvo1)); zo2=npoints1*real(ifft(Zo1));
Zo1(fvo1+1)=Xo3(fvo1+1).*R3f1(fvo1); Zo1(2*n1+1-fvo1)=conj(Zo1(1+fvo1)); zo3=npoints1*real(ifft(Zo1));
Zo1(fvo1+1)=Xo4(fvo1+1).*R4f1(fvo1); Zo1(2*n1+1-fvo1)=conj(Zo1(1+fvo1)); zo4=npoints1*real(ifft(Zo1));
% passing signals through nonlinear system
vo1=zo1+zo2+zo3+zo4+Nynoise*randn(size(zo1));
% passing signals through output dynamics
Ybe1=fft(vo1)/npoints1; YS1=Ybe1(fv1+1); Yo11e2=YS1.*S1f1(fv1);
%
% 3rd experiment
fio1=rand(length(fvo1),1)*2*pi; Zxo1=exp(-junit*fio1); Xo1=0*Xo1; Xo1(fvo1+1)=Zxo1; 
Xo1(2*n1+1-fvo1)=conj(Xo1(1+fvo1)); xo1=npoints1*real(ifft(Xo1)); Ax1=sqrt(sum(xo1.^2)/npoints1); 
xo1ref=xo1/Ax1; Xo1ref=Xo1/Ax1;
%
fio1=rand(length(fvo1),1)*2*pi; Zxo1=exp(-junit*fio1); Xo2=0*Xo2; Xo2(fvo1+1)=Zxo1; 
Xo2(2*n1+1-fvo1)=conj(Xo2(1+fvo1)); xo2=npoints1*real(ifft(Xo2)); Ax2=sqrt(sum(xo2.^2)/npoints1); 
xo2ref=xo2/Ax2; Xo2ref=Xo2/Ax2;
%
fio1=rand(length(fvo1),1)*2*pi; Zxo1=exp(-junit*fio1); Xo3=0*Xo3; Xo3(fvo1+1)=Zxo1; 
Xo3(2*n1+1-fvo1)=conj(Xo3(1+fvo1)); xo3=npoints1*real(ifft(Xo3)); Ax3=sqrt(sum(xo3.^2)/npoints1); 
xo3ref=xo3/Ax3; Xo3ref=Xo3/Ax3;
%
fio1=rand(length(fvo1),1)*2*pi; Zxo1=exp(-junit*fio1); Xo4=0*Xo4; Xo4(fvo1+1)=Zxo1; 
Xo4(2*n1+1-fvo1)=conj(Xo4(1+fvo1)); xo4=npoints1*real(ifft(Xo4)); Ax4=sqrt(sum(xo4.^2)/npoints1); 
xo4ref=xo4/Ax4; Xo4ref=Xo4/Ax4;
%
xo1=xo1ref; Xo1=Xo1ref; 
xo2=xo2ref; Xo2=Xo2ref; 
xo3=xo3ref; Xo3=Xo3ref; 
xo4=xo4ref; Xo4=Xo4ref;
%
X1e3=Xo1(fvo1+1); X2e3=Xo2(fvo1+1); X3e3=Xo3(fvo1+1); X4e3=Xo4(fvo1+1); 
%
% passing signals through input dynamics
Zo1(fvo1+1)=Xo1(fvo1+1).*R1f1(fvo1); Zo1(2*n1+1-fvo1)=conj(Zo1(1+fvo1)); zo1=npoints1*real(ifft(Zo1));
Zo1(fvo1+1)=Xo2(fvo1+1).*R2f1(fvo1); Zo1(2*n1+1-fvo1)=conj(Zo1(1+fvo1)); zo2=npoints1*real(ifft(Zo1));
Zo1(fvo1+1)=Xo3(fvo1+1).*R3f1(fvo1); Zo1(2*n1+1-fvo1)=conj(Zo1(1+fvo1)); zo3=npoints1*real(ifft(Zo1));
Zo1(fvo1+1)=Xo4(fvo1+1).*R4f1(fvo1); Zo1(2*n1+1-fvo1)=conj(Zo1(1+fvo1)); zo4=npoints1*real(ifft(Zo1));
% passing signals through nonlinear system
vo1=zo1+zo2+zo3+zo4+Nynoise*randn(size(zo1));
% passing signals through output dynamics
Ybe1=fft(vo1)/npoints1; YS1=Ybe1(fv1+1); Yo11e3=YS1.*S1f1(fv1);
%
% 4th experiment
fio1=rand(length(fvo1),1)*2*pi; Zxo1=exp(-junit*fio1); Xo1=0*Xo1; Xo1(fvo1+1)=Zxo1; 
Xo1(2*n1+1-fvo1)=conj(Xo1(1+fvo1)); xo1=npoints1*real(ifft(Xo1)); Ax1=sqrt(sum(xo1.^2)/npoints1); 
xo1ref=xo1/Ax1; Xo1ref=Xo1/Ax1;
%
fio1=rand(length(fvo1),1)*2*pi; Zxo1=exp(-junit*fio1); Xo2=0*Xo2; Xo2(fvo1+1)=Zxo1; 
Xo2(2*n1+1-fvo1)=conj(Xo2(1+fvo1)); xo2=npoints1*real(ifft(Xo2)); Ax2=sqrt(sum(xo2.^2)/npoints1); 
xo2ref=xo2/Ax2; Xo2ref=Xo2/Ax2;
%
fio1=rand(length(fvo1),1)*2*pi; Zxo1=exp(-junit*fio1); Xo3=0*Xo3; Xo3(fvo1+1)=Zxo1; 
Xo3(2*n1+1-fvo1)=conj(Xo3(1+fvo1)); xo3=npoints1*real(ifft(Xo3)); Ax3=sqrt(sum(xo3.^2)/npoints1); 
xo3ref=xo3/Ax3; Xo3ref=Xo3/Ax3;
%
fio1=rand(length(fvo1),1)*2*pi; Zxo1=exp(-junit*fio1); Xo4=0*Xo4; Xo4(fvo1+1)=Zxo1; 
Xo4(2*n1+1-fvo1)=conj(Xo4(1+fvo1)); xo4=npoints1*real(ifft(Xo4)); Ax4=sqrt(sum(xo4.^2)/npoints1); 
xo4ref=xo4/Ax4; Xo4ref=Xo4/Ax4;
%
xo1=xo1ref; Xo1=Xo1ref; 
xo2=xo2ref; Xo2=Xo2ref; 
xo3=xo3ref; Xo3=Xo3ref; 
xo4=xo4ref; Xo4=Xo4ref;
%
X1e4=Xo1(fvo1+1); X2e4=Xo2(fvo1+1); X3e4=Xo3(fvo1+1); X4e4=Xo4(fvo1+1); 
%
% passing signals through input dynamics
Zo1(fvo1+1)=Xo1(fvo1+1).*R1f1(fvo1); Zo1(2*n1+1-fvo1)=conj(Zo1(1+fvo1)); zo1=npoints1*real(ifft(Zo1));
Zo1(fvo1+1)=Xo2(fvo1+1).*R2f1(fvo1); Zo1(2*n1+1-fvo1)=conj(Zo1(1+fvo1)); zo2=npoints1*real(ifft(Zo1));
Zo1(fvo1+1)=Xo3(fvo1+1).*R3f1(fvo1); Zo1(2*n1+1-fvo1)=conj(Zo1(1+fvo1)); zo3=npoints1*real(ifft(Zo1));
Zo1(fvo1+1)=Xo4(fvo1+1).*R4f1(fvo1); Zo1(2*n1+1-fvo1)=conj(Zo1(1+fvo1)); zo4=npoints1*real(ifft(Zo1));
% passing signals through nonlinear system
vo1=zo1+zo2+zo3+zo4+Nynoise*randn(size(zo1));
% passing signals through output dynamics
Ybe1=fft(vo1)/npoints1; YS1=Ybe1(fv1+1); Yo11e4=YS1.*S1f1(fv1);
%
Ye1=Yo11e1(fvo1); Ye2=Yo11e2(fvo1); Ye3=Yo11e3(fvo1); Ye4=Yo11e4(fvo1); 
%
% set of equations, result Go11t, Go12t for frequency 1 ... N 
for k=1:length(fvo1),
    Yvec=[Ye1(k), Ye2(k), Ye3(k), Ye4(k)].';
    Xmat=[X1e1(k),  X2e1(k),  X3e1(k),  X4e1(k); 
          X1e2(k),  X2e2(k),  X3e2(k),  X4e2(k);
          X1e3(k),  X2e3(k),  X3e3(k),  X4e3(k); 
          X1e4(k),  X2e4(k),  X3e4(k),  X4e4(k); ];
    Gvec=inv(Xmat)*Yvec;
    Go11t(k)=Gvec(1); Go12t(k)=Gvec(2); Go13t(k)=Gvec(3); Go14t(k)=Gvec(4);
end;
%
Nc1=Nc1+1,
%
Go11m(:)=Go11m(:)+(Go11t-Go11m(:))/Nc1; Go12m(:)=Go12m(:)+(Go12t-Go12m(:))/Nc1;
Go13m(:)=Go13m(:)+(Go13t-Go13m(:))/Nc1; Go14m(:)=Go14m(:)+(Go14t-Go14m(:))/Nc1;
%
figure(8), 
subplot(221), plot(fvo1,db(a1*R1S1f1(fvo1)),'g',fvo1,db(Go11t),'k',fvo1,db(Go11m),'b');
title('Systems in channel 1','FontName','Arial','Fontsize',14); grid; drawnow;
subplot(222), plot(fvo1,db(a2*R2S1f1(fvo1)),'g',fvo1,db(Go12t),'k',fvo1,db(Go12m),'b');
title('Systems in channel 2','FontName','Arial','Fontsize',14); grid; drawnow;
subplot(223), plot(fvo1,db(a3*R3S1f1(fvo1)),'g',fvo1,db(Go13t),'k',fvo1,db(Go13m),'b');
title('Systems in channel 3','FontName','Arial','Fontsize',14); grid; drawnow;
subplot(224), plot(fvo1,db(a4*R4S1f1(fvo1)),'g',fvo1,db(Go14t),'k',fvo1,db(Go14m),'b');
title('Systems in channel 4','FontName','Arial','Fontsize',14); grid; drawnow;
%
end;

