clear all; close all;
%
N=1024;
junit=-sqrt(-1); pi2j=2*pi*junit;
nfreq1=fix(N/10); 
n1=N/2; fv1=[1:nfreq1]'; fvo1=[1:2:nfreq1]'; 
%--------
S1=zeros(N,1); S2=S1; S3=S2;
%
fi1=0*ones(size(fvo1));
fi2=rand(size(fvo1));
fi3=zeros(size(fvo1)); for k=1:length(fvo1), fi3(k)=-k*(k-1)*pi/length(fvo1); end;
%
S1(fvo1) = ones(size(fvo1)).* exp(pi2j*fi1);
S1s = 2*real(ifft(S1));
u1 = S1s/std(S1s);
S2(fvo1) = ones(size(fvo1)).* exp(pi2j*fi2);
S2s = 2*real(ifft(S2));
u2 = S2s/std(S2s);
S3(fvo1) = ones(size(fvo1)).* exp(junit*fi3);
S3s = 2*real(ifft(S3));
u3 = S3s/std(S3s);
%
CR1=max(abs(u1))/mean(u1.^2);
CR2=max(abs(u2))/mean(u2.^2);
CR3=max(abs(u3))/mean(u3.^2);
%
figure(2), 
subplot(131), plot([1:N],u1,'k'); title(['CR = ' num2str(CR1)]); axis([0 1000 -3 11]); grid; drawnow;
subplot(132), plot([1:N],u2,'r'); title(['CR = ' num2str(CR2)]); axis([0 1000 -3 11]);grid; drawnow;
subplot(133), plot([1:N],u3,'b'); title(['CR = ' num2str(CR3)]); axis([0 1000 -3 11]);grid; drawnow;

