/*
 * Decompiled with CFR 0.152.
 */
package demo;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Point;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.dial.DialBackground;
import org.jfree.chart.plot.dial.DialCap;
import org.jfree.chart.plot.dial.DialPlot;
import org.jfree.chart.plot.dial.DialPointer;
import org.jfree.chart.plot.dial.DialTextAnnotation;
import org.jfree.chart.plot.dial.DialValueIndicator;
import org.jfree.chart.plot.dial.StandardDialFrame;
import org.jfree.chart.plot.dial.StandardDialRange;
import org.jfree.chart.plot.dial.StandardDialScale;
import org.jfree.data.general.DefaultValueDataset;
import org.jfree.data.general.ValueDataset;
import org.jfree.ui.GradientPaintTransformType;
import org.jfree.ui.GradientPaintTransformer;
import org.jfree.ui.StandardGradientPaintTransformer;

public class DialDemo1
extends JFrame {
    public DialDemo1(String string) {
        super(string);
        this.setDefaultCloseOperation(3);
        this.setContentPane(DialDemo1.createDemoPanel());
    }

    public static JPanel createDemoPanel() {
        return new DemoPanel();
    }

    public static void main(String[] stringArray) {
        DialDemo1 dialDemo1 = new DialDemo1("JFreeChart - Demo Dial 1");
        dialDemo1.pack();
        dialDemo1.setVisible(true);
    }

    static class DemoPanel
    extends JPanel
    implements ChangeListener {
        JSlider slider;
        DefaultValueDataset dataset = new DefaultValueDataset(10.0);

        public DemoPanel() {
            super(new BorderLayout());
            JFreeChart jFreeChart = DemoPanel.createStandardDialChart("Dial Demo 1", "Temperature", this.dataset, -40.0, 60.0, 10.0, 4);
            DialPlot dialPlot = (DialPlot)jFreeChart.getPlot();
            StandardDialRange standardDialRange = new StandardDialRange(40.0, 60.0, Color.red);
            standardDialRange.setInnerRadius(0.52);
            standardDialRange.setOuterRadius(0.55);
            dialPlot.addLayer(standardDialRange);
            StandardDialRange standardDialRange2 = new StandardDialRange(10.0, 40.0, Color.orange);
            standardDialRange2.setInnerRadius(0.52);
            standardDialRange2.setOuterRadius(0.55);
            dialPlot.addLayer(standardDialRange2);
            StandardDialRange standardDialRange3 = new StandardDialRange(-40.0, 10.0, Color.green);
            standardDialRange3.setInnerRadius(0.52);
            standardDialRange3.setOuterRadius(0.55);
            dialPlot.addLayer(standardDialRange3);
            GradientPaint gradientPaint = new GradientPaint(new Point(), new Color(255, 255, 255), new Point(), new Color(170, 170, 220));
            DialBackground dialBackground = new DialBackground(gradientPaint);
            dialBackground.setGradientPaintTransformer((GradientPaintTransformer)new StandardGradientPaintTransformer(GradientPaintTransformType.VERTICAL));
            dialPlot.setBackground(dialBackground);
            dialPlot.removePointer(0);
            DialPointer.Pointer pointer = new DialPointer.Pointer();
            pointer.setFillPaint(Color.yellow);
            dialPlot.addPointer(pointer);
            ChartPanel chartPanel = new ChartPanel(jFreeChart);
            chartPanel.setPreferredSize(new Dimension(400, 400));
            this.slider = new JSlider(-40, 60);
            this.slider.setMajorTickSpacing(10);
            this.slider.setPaintLabels(true);
            this.slider.addChangeListener(this);
            this.add(chartPanel);
            this.add((Component)this.slider, "South");
        }

        public static JFreeChart createStandardDialChart(String string, String string2, ValueDataset valueDataset, double d, double d2, double d3, int n) {
            DialPlot dialPlot = new DialPlot();
            dialPlot.setDataset(valueDataset);
            dialPlot.setDialFrame(new StandardDialFrame());
            dialPlot.setBackground(new DialBackground());
            DialTextAnnotation dialTextAnnotation = new DialTextAnnotation(string2);
            dialTextAnnotation.setFont(new Font("Dialog", 1, 14));
            dialTextAnnotation.setRadius(0.7);
            dialPlot.addLayer(dialTextAnnotation);
            DialValueIndicator dialValueIndicator = new DialValueIndicator(0);
            dialPlot.addLayer(dialValueIndicator);
            StandardDialScale standardDialScale = new StandardDialScale(d, d2, -120.0, -300.0, 10.0, 4);
            standardDialScale.setMajorTickIncrement(d3);
            standardDialScale.setMinorTickCount(n);
            standardDialScale.setTickRadius(0.88);
            standardDialScale.setTickLabelOffset(0.15);
            standardDialScale.setTickLabelFont(new Font("Dialog", 0, 14));
            dialPlot.addScale(0, standardDialScale);
            dialPlot.addPointer(new DialPointer.Pin());
            DialCap dialCap = new DialCap();
            dialPlot.setCap(dialCap);
            return new JFreeChart(string, dialPlot);
        }

        public void stateChanged(ChangeEvent changeEvent) {
            this.dataset.setValue(new Integer(this.slider.getValue()));
        }
    }
}

