/*
 * Decompiled with CFR 0.152.
 */
package demo;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.entity.CategoryItemEntity;
import org.jfree.chart.entity.EntityCollection;
import org.jfree.chart.event.RendererChangeEvent;
import org.jfree.chart.labels.CategoryItemLabelGenerator;
import org.jfree.chart.labels.CategoryToolTipGenerator;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.CategoryItemRendererState;
import org.jfree.chart.renderer.category.IntervalBarRenderer;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.gantt.GanttCategoryDataset;
import org.jfree.ui.RectangleEdge;

public class GanttRenderer2
extends IntervalBarRenderer
implements Serializable {
    private static final long serialVersionUID = -4010349116350119512L;
    private Paint completePaint;
    private Paint incompletePaint;
    private double startPercent;
    private double endPercent;

    public GanttRenderer2() {
        this.setIncludeBaseInRange(false);
        this.completePaint = Color.green;
        this.incompletePaint = Color.red;
        this.startPercent = 0.35;
        this.endPercent = 0.65;
    }

    public Paint getCompletePaint() {
        return this.completePaint;
    }

    public void setCompletePaint(Paint paint) {
        if (paint == null) {
            throw new IllegalArgumentException("Null 'paint' argument.");
        }
        this.completePaint = paint;
        this.notifyListeners(new RendererChangeEvent(this));
    }

    public Paint getIncompletePaint() {
        return this.incompletePaint;
    }

    public void setIncompletePaint(Paint paint) {
        if (paint == null) {
            throw new IllegalArgumentException("Null 'paint' argument.");
        }
        this.incompletePaint = paint;
        this.notifyListeners(new RendererChangeEvent(this));
    }

    public double getStartPercent() {
        return this.startPercent;
    }

    public void setStartPercent(double d) {
        this.startPercent = d;
        this.notifyListeners(new RendererChangeEvent(this));
    }

    public double getEndPercent() {
        return this.endPercent;
    }

    public void setEndPercent(double d) {
        this.endPercent = d;
        this.notifyListeners(new RendererChangeEvent(this));
    }

    public void drawItem(Graphics2D graphics2D, CategoryItemRendererState categoryItemRendererState, Rectangle2D rectangle2D, CategoryPlot categoryPlot, CategoryAxis categoryAxis, ValueAxis valueAxis, CategoryDataset categoryDataset, int n, int n2, int n3) {
        if (categoryDataset instanceof GanttCategoryDataset) {
            GanttCategoryDataset ganttCategoryDataset = (GanttCategoryDataset)categoryDataset;
            this.drawTasks(graphics2D, categoryItemRendererState, rectangle2D, categoryPlot, categoryAxis, valueAxis, ganttCategoryDataset, n, n2);
        } else {
            super.drawItem(graphics2D, categoryItemRendererState, rectangle2D, categoryPlot, categoryAxis, valueAxis, categoryDataset, n, n2, n3);
        }
    }

    protected void drawTasks(Graphics2D graphics2D, CategoryItemRendererState categoryItemRendererState, Rectangle2D rectangle2D, CategoryPlot categoryPlot, CategoryAxis categoryAxis, ValueAxis valueAxis, GanttCategoryDataset ganttCategoryDataset, int n, int n2) {
        int n3 = ganttCategoryDataset.getSubIntervalCount(n, n2);
        if (n3 == 0) {
            this.drawTask(graphics2D, categoryItemRendererState, rectangle2D, categoryPlot, categoryAxis, valueAxis, ganttCategoryDataset, n, n2);
        }
        for (int i = 0; i < n3; ++i) {
            EntityCollection entityCollection;
            double d;
            RectangleEdge rectangleEdge = categoryPlot.getRangeAxisEdge();
            Number number = ganttCategoryDataset.getStartValue(n, n2, i);
            if (number == null) {
                return;
            }
            double d2 = valueAxis.valueToJava2D(number.doubleValue(), rectangle2D, rectangleEdge);
            Number number2 = ganttCategoryDataset.getEndValue(n, n2, i);
            if (number2 == null) {
                return;
            }
            double d3 = valueAxis.valueToJava2D(number2.doubleValue(), rectangle2D, rectangleEdge);
            if (d3 < d2) {
                d = d3;
                d3 = d2;
                d2 = d;
            }
            d = this.calculateBarW0(categoryPlot, categoryPlot.getOrientation(), rectangle2D, categoryAxis, categoryItemRendererState, n, n2);
            double d4 = Math.abs(d3 - d2);
            double d5 = categoryItemRendererState.getBarWidth();
            Rectangle2D.Double double_ = null;
            if (categoryPlot.getOrientation() == PlotOrientation.HORIZONTAL) {
                double_ = new Rectangle2D.Double(d2, d, d4, d5);
            } else if (categoryPlot.getOrientation() == PlotOrientation.VERTICAL) {
                double_ = new Rectangle2D.Double(d, d2, d5, d4);
            }
            Rectangle2D.Double double_2 = null;
            Rectangle2D.Double double_3 = null;
            Number number3 = ganttCategoryDataset.getPercentComplete(n, n2, i);
            double d6 = this.getStartPercent();
            double d7 = this.getEndPercent();
            if (number3 != null) {
                double d8 = number3.doubleValue();
                if (categoryPlot.getOrientation() == PlotOrientation.HORIZONTAL) {
                    double_2 = new Rectangle2D.Double(d2, d + d6 * d5, d4 * d8, d5 * (d7 - d6));
                    double_3 = new Rectangle2D.Double(d2 + d4 * d8, d + d6 * d5, d4 * (1.0 - d8), d5 * (d7 - d6));
                } else if (categoryPlot.getOrientation() == PlotOrientation.VERTICAL) {
                    double_2 = new Rectangle2D.Double(d + d6 * d5, d2 + d4 * (1.0 - d8), d5 * (d7 - d6), d4 * d8);
                    double_3 = new Rectangle2D.Double(d + d6 * d5, d2, d5 * (d7 - d6), d4 * (1.0 - d8));
                }
            }
            Paint paint = this.getItemPaint(n, n2);
            graphics2D.setPaint(paint);
            graphics2D.fill(double_);
            if (double_2 != null) {
                graphics2D.setPaint(this.getCompletePaint());
                graphics2D.fill(double_2);
            }
            if (double_3 != null) {
                graphics2D.setPaint(this.getIncompletePaint());
                graphics2D.fill(double_3);
            }
            if (this.isDrawBarOutline() && categoryItemRendererState.getBarWidth() > 3.0) {
                graphics2D.setStroke(this.getItemStroke(n, n2));
                graphics2D.setPaint(this.getItemOutlinePaint(n, n2));
                graphics2D.draw(double_);
            }
            if (categoryItemRendererState.getInfo() == null || (entityCollection = categoryItemRendererState.getEntityCollection()) == null) continue;
            String string = null;
            if (this.getToolTipGenerator(n, n2) != null) {
                string = this.getToolTipGenerator(n, n2).generateToolTip(ganttCategoryDataset, n, n2);
            }
            String string2 = null;
            if (this.getItemURLGenerator(n, n2) != null) {
                string2 = this.getItemURLGenerator(n, n2).generateURL(ganttCategoryDataset, n, n2);
            }
            CategoryItemEntity categoryItemEntity = new CategoryItemEntity(double_, string, string2, ganttCategoryDataset, ganttCategoryDataset.getRowKey(n), ganttCategoryDataset.getColumnKey(n2));
            entityCollection.add(categoryItemEntity);
        }
    }

    protected void drawTask(Graphics2D graphics2D, CategoryItemRendererState categoryItemRendererState, Rectangle2D rectangle2D, CategoryPlot categoryPlot, CategoryAxis categoryAxis, ValueAxis valueAxis, GanttCategoryDataset ganttCategoryDataset, int n, int n2) {
        Object object;
        Object object2;
        int n3;
        PlotOrientation plotOrientation = categoryPlot.getOrientation();
        RectangleEdge rectangleEdge = categoryPlot.getRangeAxisEdge();
        Number number = ganttCategoryDataset.getEndValue(n, n2);
        if (number == null) {
            return;
        }
        double d = valueAxis.valueToJava2D(number.doubleValue(), rectangle2D, rectangleEdge);
        Number number2 = ganttCategoryDataset.getStartValue(n, n2);
        if (number2 == null) {
            return;
        }
        double d2 = valueAxis.valueToJava2D(number2.doubleValue(), rectangle2D, rectangleEdge);
        if (d2 < d) {
            double d3 = d2;
            d2 = d;
            d = d3;
            Number number3 = number2;
            number2 = number;
            number = number3;
        }
        if ((n3 = this.countNonNullValues(ganttCategoryDataset, n2)) == 0) {
            return;
        }
        int n4 = this.countPriorNonNullValues(ganttCategoryDataset, n2, n);
        double d4 = (categoryAxis.getCategoryEnd(n2, this.getColumnCount(), rectangle2D, categoryPlot.getDomainAxisEdge()) - categoryAxis.getCategoryStart(n2, this.getColumnCount(), rectangle2D, categoryPlot.getDomainAxisEdge())) / (double)n3;
        double d5 = categoryAxis.getCategoryStart(n2, this.getColumnCount(), rectangle2D, categoryPlot.getDomainAxisEdge()) + d4 * (double)n4;
        double d6 = Math.abs(d2 - d);
        Rectangle2D.Double double_ = null;
        if (plotOrientation == PlotOrientation.HORIZONTAL) {
            double_ = new Rectangle2D.Double(d, d5, d6, d4);
        } else if (plotOrientation == PlotOrientation.VERTICAL) {
            double_ = new Rectangle2D.Double(d5, d2, d4, d6);
        }
        Rectangle2D.Double double_2 = null;
        Rectangle2D.Double double_3 = null;
        Number number4 = ganttCategoryDataset.getPercentComplete(n, n2);
        double d7 = this.getStartPercent();
        double d8 = this.getEndPercent();
        if (number4 != null) {
            double d9 = number4.doubleValue();
            if (categoryPlot.getOrientation() == PlotOrientation.HORIZONTAL) {
                double_2 = new Rectangle2D.Double(d, d5 + d7 * d4, d6 * d9, d4 * (d8 - d7));
                double_3 = new Rectangle2D.Double(d + d6 * d9, d5 + d7 * d4, d6 * (1.0 - d9), d4 * (d8 - d7));
            } else if (categoryPlot.getOrientation() == PlotOrientation.VERTICAL) {
                double_2 = new Rectangle2D.Double(d5 + d7 * d4, d2 + d6 * (1.0 - d9), d4 * (d8 - d7), d6 * d9);
                double_3 = new Rectangle2D.Double(d5 + d7 * d4, d2, d4 * (d8 - d7), d6 * (1.0 - d9));
            }
        }
        Paint paint = this.getItemPaint(n, n2);
        graphics2D.setPaint(paint);
        graphics2D.fill(double_);
        if (double_2 != null) {
            graphics2D.setPaint(this.getCompletePaint());
            graphics2D.fill(double_2);
        }
        if (double_3 != null) {
            graphics2D.setPaint(this.getIncompletePaint());
            graphics2D.fill(double_3);
        }
        if (this.isDrawBarOutline() && categoryItemRendererState.getBarWidth() > 3.0) {
            object2 = this.getItemOutlineStroke(n, n2);
            object = this.getItemOutlinePaint(n, n2);
            if (object2 != null && object != null) {
                graphics2D.setStroke((Stroke)object2);
                graphics2D.setPaint((Paint)object);
                graphics2D.draw(double_);
            }
        }
        if ((object2 = this.getItemLabelGenerator(n, n2)) != null && this.isItemLabelVisible(n, n2)) {
            this.drawItemLabel(graphics2D, ganttCategoryDataset, n, n2, categoryPlot, (CategoryItemLabelGenerator)object2, double_, false);
        }
        if (categoryItemRendererState.getInfo() != null && (object = categoryItemRendererState.getEntityCollection()) != null) {
            String string = null;
            CategoryToolTipGenerator categoryToolTipGenerator = this.getToolTipGenerator(n, n2);
            if (categoryToolTipGenerator != null) {
                string = categoryToolTipGenerator.generateToolTip(ganttCategoryDataset, n, n2);
            }
            String string2 = null;
            if (this.getItemURLGenerator(n, n2) != null) {
                string2 = this.getItemURLGenerator(n, n2).generateURL(ganttCategoryDataset, n, n2);
            }
            CategoryItemEntity categoryItemEntity = new CategoryItemEntity(double_, string, string2, ganttCategoryDataset, ganttCategoryDataset.getRowKey(n), ganttCategoryDataset.getColumnKey(n2));
            object.add(categoryItemEntity);
        }
    }

    protected double calculateBarW0(CategoryPlot categoryPlot, PlotOrientation plotOrientation, Rectangle2D rectangle2D, CategoryAxis categoryAxis, CategoryItemRendererState categoryItemRendererState, int n, int n2) {
        double d = 0.0;
        d = plotOrientation == PlotOrientation.HORIZONTAL ? rectangle2D.getHeight() : rectangle2D.getWidth();
        double d2 = categoryAxis.getCategoryStart(n2, this.getColumnCount(), rectangle2D, categoryPlot.getDomainAxisEdge());
        int n3 = this.getRowCount();
        int n4 = this.getColumnCount();
        if (n3 > 1) {
            double d3 = d * this.getItemMargin() / (double)(n4 * (n3 - 1));
            double d4 = this.calculateSeriesWidth(d, categoryAxis, n4, n3);
            d2 = d2 + (double)n * (d4 + d3) + d4 / 2.0 - categoryItemRendererState.getBarWidth() / 2.0;
        } else {
            d2 = categoryAxis.getCategoryMiddle(n2, this.getColumnCount(), rectangle2D, categoryPlot.getDomainAxisEdge()) - categoryItemRendererState.getBarWidth() / 2.0;
        }
        return d2;
    }

    private int countNonNullValues(CategoryDataset categoryDataset, int n) {
        return this.countPriorNonNullValues(categoryDataset, n, categoryDataset.getRowCount());
    }

    private int countPriorNonNullValues(CategoryDataset categoryDataset, int n, int n2) {
        if (n2 == 0) {
            return 0;
        }
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            if (categoryDataset.getValue(i, n) == null) continue;
            ++n3;
        }
        return n3;
    }
}

