/*
 * Decompiled with CFR 0.152.
 */
package demo;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.data.xy.DefaultXYZDataset;
import org.jfree.data.xy.XYZDataset;
import org.jfree.ui.ApplicationFrame;
import org.jfree.ui.RefineryUtilities;

public class HideSeriesDemo3
extends ApplicationFrame {
    public HideSeriesDemo3(String string) {
        super(string);
        this.setContentPane(new DemoPanel());
    }

    public static JPanel createDemoPanel() {
        return new DemoPanel();
    }

    public static void main(String[] stringArray) {
        HideSeriesDemo3 hideSeriesDemo3 = new HideSeriesDemo3("JFreeChart: HideSeriesDemo3.java");
        hideSeriesDemo3.pack();
        RefineryUtilities.centerFrameOnScreen((Window)((Object)hideSeriesDemo3));
        hideSeriesDemo3.setVisible(true);
    }

    static class DemoPanel
    extends JPanel
    implements ActionListener {
        private XYItemRenderer renderer;

        public DemoPanel() {
            super(new BorderLayout());
            XYZDataset xYZDataset = this.createSampleDataset();
            JFreeChart jFreeChart = this.createChart(xYZDataset);
            ChartPanel chartPanel = new ChartPanel(jFreeChart);
            JPanel jPanel = new JPanel();
            JCheckBox jCheckBox = new JCheckBox("Series 1");
            jCheckBox.setActionCommand("S1");
            jCheckBox.addActionListener(this);
            jCheckBox.setSelected(true);
            JCheckBox jCheckBox2 = new JCheckBox("Series 2");
            jCheckBox2.setActionCommand("S2");
            jCheckBox2.addActionListener(this);
            jCheckBox2.setSelected(true);
            JCheckBox jCheckBox3 = new JCheckBox("Series 3");
            jCheckBox3.setActionCommand("S3");
            jCheckBox3.addActionListener(this);
            jCheckBox3.setSelected(true);
            jPanel.add(jCheckBox);
            jPanel.add(jCheckBox2);
            jPanel.add(jCheckBox3);
            this.add(chartPanel);
            this.add((Component)jPanel, "South");
            chartPanel.setPreferredSize(new Dimension(500, 270));
        }

        private XYZDataset createSampleDataset() {
            DefaultXYZDataset defaultXYZDataset = new DefaultXYZDataset();
            double[] dArray = new double[]{2.1, 2.3, 2.3};
            double[] dArray2 = new double[]{14.1, 11.1, 10.0};
            double[] dArray3 = new double[]{2.4, 2.7, 2.7};
            double[][] dArrayArray = new double[][]{dArray, dArray2, dArray3};
            defaultXYZDataset.addSeries((Comparable)((Object)"Series 1"), dArrayArray);
            dArray = new double[]{2.2, 2.2, 1.8};
            dArray2 = new double[]{14.1, 11.1, 10.0};
            dArray3 = new double[]{2.2, 2.2, 2.2};
            dArrayArray = new double[][]{dArray, dArray2, dArray3};
            defaultXYZDataset.addSeries((Comparable)((Object)"Series 2"), dArrayArray);
            dArray = new double[]{1.8, 1.9, 2.3, 3.8};
            dArray2 = new double[]{5.4, 4.1, 4.1, 25.0};
            dArray3 = new double[]{2.1, 2.2, 1.6, 4.0};
            dArrayArray = new double[][]{dArray, dArray2, dArray3};
            defaultXYZDataset.addSeries((Comparable)((Object)"Series 3"), dArrayArray);
            return defaultXYZDataset;
        }

        private JFreeChart createChart(XYZDataset xYZDataset) {
            JFreeChart jFreeChart = ChartFactory.createBubbleChart("Hide Series Demo 3", "X", "Y", xYZDataset, PlotOrientation.VERTICAL, true, true, false);
            XYPlot xYPlot = (XYPlot)jFreeChart.getPlot();
            this.renderer = xYPlot.getRenderer(0);
            return jFreeChart;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n = -1;
            if (actionEvent.getActionCommand().equals("S1")) {
                n = 0;
            } else if (actionEvent.getActionCommand().equals("S2")) {
                n = 1;
            } else if (actionEvent.getActionCommand().equals("S3")) {
                n = 2;
            }
            if (n >= 0) {
                boolean bl = this.renderer.getItemVisible(n, 0);
                this.renderer.setSeriesVisible(n, new Boolean(!bl));
            }
        }
    }
}

