/*
 * Decompiled with CFR 0.152.
 */
package demo;

import java.awt.Color;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartRenderingInfo;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.entity.StandardEntityCollection;
import org.jfree.chart.imagemap.ImageMapUtilities;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.data.xy.DefaultXYZDataset;
import org.jfree.data.xy.XYZDataset;

public class ImageMapDemo8 {
    private static JFreeChart createChart(XYZDataset xYZDataset) {
        JFreeChart jFreeChart = ChartFactory.createBubbleChart("Bubble Chart Demo 1", "X", "Y", xYZDataset, PlotOrientation.HORIZONTAL, true, true, true);
        XYPlot xYPlot = (XYPlot)jFreeChart.getPlot();
        xYPlot.setForegroundAlpha(0.65f);
        XYItemRenderer xYItemRenderer = xYPlot.getRenderer();
        xYItemRenderer.setSeriesPaint(0, Color.blue);
        NumberAxis numberAxis = (NumberAxis)xYPlot.getDomainAxis();
        numberAxis.setLowerMargin(0.15);
        numberAxis.setUpperMargin(0.15);
        NumberAxis numberAxis2 = (NumberAxis)xYPlot.getRangeAxis();
        numberAxis2.setLowerMargin(0.15);
        numberAxis2.setUpperMargin(0.15);
        return jFreeChart;
    }

    public static XYZDataset createDataset() {
        DefaultXYZDataset defaultXYZDataset = new DefaultXYZDataset();
        double[] dArray = new double[]{2.1, 2.3, 2.3, 2.2, 2.2, 1.8, 1.8, 1.9, 2.3, 3.8};
        double[] dArray2 = new double[]{14.1, 11.1, 10.0, 8.8, 8.7, 8.4, 5.4, 4.1, 4.1, 25.0};
        double[] dArray3 = new double[]{2.4, 2.7, 2.7, 2.2, 2.2, 2.2, 2.1, 2.2, 1.6, 4.0};
        double[][] dArrayArray = new double[][]{dArray, dArray2, dArray3};
        defaultXYZDataset.addSeries((Comparable)((Object)"Series 1"), dArrayArray);
        return defaultXYZDataset;
    }

    public static void main(String[] stringArray) {
        JFreeChart jFreeChart = ImageMapDemo8.createChart(ImageMapDemo8.createDataset());
        try {
            ChartRenderingInfo chartRenderingInfo = new ChartRenderingInfo(new StandardEntityCollection());
            File file = new File("bubble100.png");
            ChartUtilities.saveChartAsPNG(file, jFreeChart, 600, 400, chartRenderingInfo);
            File file2 = new File("bubble100.html");
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file2));
            PrintWriter printWriter = new PrintWriter(bufferedOutputStream);
            printWriter.println("<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Strict//EN\"");
            printWriter.println("\"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd\">");
            printWriter.println("<html xmlns=\"http://www.w3.org/1999/xhtml\" lang=\"en\" xml:lang=\"en\">");
            printWriter.println("<head><title>JFreeChart Image Map Demo 8</title></head>");
            printWriter.println("<body><p>");
            ImageMapUtilities.writeImageMap(printWriter, "chart", chartRenderingInfo);
            printWriter.println("<img src=\"bubble100.png\" width=\"600\" height=\"400\" usemap=\"#chart\" alt=\"bubble100.png\"/>");
            printWriter.println("</p></body>");
            printWriter.println("</html>");
            printWriter.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }
}

