/*
 * Decompiled with CFR 0.152.
 */
package demo;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.geom.Rectangle2D;
import javax.swing.JPanel;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.annotations.XYAnnotation;
import org.jfree.chart.annotations.XYLineAnnotation;
import org.jfree.chart.annotations.XYShapeAnnotation;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.IntervalMarker;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import org.jfree.ui.ApplicationFrame;
import org.jfree.ui.Layer;
import org.jfree.ui.RectangleInsets;
import org.jfree.ui.RefineryUtilities;

public class PlotOrientationDemo2
extends ApplicationFrame {
    private static final int CHART_COUNT = 8;

    public PlotOrientationDemo2(String string) {
        super(string);
        this.setContentPane(new DemoPanel());
    }

    private static XYDataset createDataset(int n) {
        XYSeries xYSeries = new XYSeries((Comparable)((Object)("Series " + (n + 1))));
        xYSeries.add(-10.0, -5.0);
        xYSeries.add(10.0, 5.0);
        XYSeriesCollection xYSeriesCollection = new XYSeriesCollection();
        xYSeriesCollection.addSeries(xYSeries);
        return xYSeriesCollection;
    }

    private static JFreeChart createChart(int n, XYDataset xYDataset) {
        JFreeChart jFreeChart = ChartFactory.createXYLineChart("Chart " + (n + 1), "X", "Y", xYDataset, PlotOrientation.VERTICAL, false, false, false);
        jFreeChart.setBackgroundPaint(Color.white);
        XYPlot xYPlot = (XYPlot)jFreeChart.getPlot();
        xYPlot.setBackgroundPaint(Color.lightGray);
        xYPlot.setAxisOffset(new RectangleInsets(5.0, 5.0, 5.0, 5.0));
        xYPlot.setDomainGridlinePaint(Color.white);
        xYPlot.setRangeGridlinePaint(Color.white);
        XYLineAndShapeRenderer xYLineAndShapeRenderer = (XYLineAndShapeRenderer)xYPlot.getRenderer();
        xYLineAndShapeRenderer.setBaseShapesVisible(true);
        xYLineAndShapeRenderer.setBaseShapesFilled(true);
        ValueAxis valueAxis = xYPlot.getDomainAxis();
        valueAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        ValueAxis valueAxis2 = xYPlot.getRangeAxis();
        valueAxis2.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        return jFreeChart;
    }

    public static JPanel createDemoPanel() {
        return new DemoPanel();
    }

    public static void main(String[] stringArray) {
        PlotOrientationDemo2 plotOrientationDemo2 = new PlotOrientationDemo2("Plot Orientation Demo 2");
        plotOrientationDemo2.pack();
        RefineryUtilities.centerFrameOnScreen((Window)((Object)plotOrientationDemo2));
        plotOrientationDemo2.setVisible(true);
    }

    static class DemoPanel
    extends JPanel {
        private XYDataset[] datasets = new XYDataset[8];
        private JFreeChart[] charts = new JFreeChart[8];
        private ChartPanel[] panels = new ChartPanel[8];

        public DemoPanel() {
            super(new GridLayout(2, 4));
            Cloneable cloneable;
            Cloneable cloneable2;
            XYPlot xYPlot;
            for (int i = 0; i < 8; ++i) {
                this.datasets[i] = PlotOrientationDemo2.createDataset(i);
                this.charts[i] = PlotOrientationDemo2.createChart(i, this.datasets[i]);
                xYPlot = (XYPlot)this.charts[i].getPlot();
                cloneable2 = new XYShapeAnnotation(new Rectangle2D.Double(1.0, 2.0, 2.0, 3.0), new BasicStroke(1.0f), Color.blue);
                cloneable = new XYLineAnnotation(0.0, -5.0, 10.0, -5.0);
                xYPlot.addAnnotation((XYAnnotation)((Object)cloneable2));
                xYPlot.addAnnotation((XYAnnotation)((Object)cloneable));
                xYPlot.addDomainMarker(new IntervalMarker(5.0, 10.0), Layer.BACKGROUND);
                xYPlot.addRangeMarker(new IntervalMarker(-2.0, 0.0), Layer.BACKGROUND);
                this.panels[i] = new ChartPanel(this.charts[i]);
            }
            XYPlot xYPlot2 = (XYPlot)this.charts[1].getPlot();
            xYPlot = (XYPlot)this.charts[2].getPlot();
            cloneable2 = (XYPlot)this.charts[3].getPlot();
            cloneable = (XYPlot)this.charts[4].getPlot();
            XYPlot xYPlot3 = (XYPlot)this.charts[5].getPlot();
            XYPlot xYPlot4 = (XYPlot)this.charts[6].getPlot();
            XYPlot xYPlot5 = (XYPlot)this.charts[7].getPlot();
            xYPlot2.getDomainAxis().setInverted(true);
            xYPlot.getRangeAxis().setInverted(true);
            ((XYPlot)cloneable2).getDomainAxis().setInverted(true);
            ((XYPlot)cloneable2).getRangeAxis().setInverted(true);
            xYPlot3.getDomainAxis().setInverted(true);
            xYPlot4.getRangeAxis().setInverted(true);
            ((XYPlot)cloneable).getDomainAxis().setInverted(true);
            ((XYPlot)cloneable).getRangeAxis().setInverted(true);
            ((XYPlot)cloneable).setOrientation(PlotOrientation.HORIZONTAL);
            xYPlot3.setOrientation(PlotOrientation.HORIZONTAL);
            xYPlot4.setOrientation(PlotOrientation.HORIZONTAL);
            xYPlot5.setOrientation(PlotOrientation.HORIZONTAL);
            this.add(this.panels[0]);
            this.add(this.panels[1]);
            this.add(this.panels[4]);
            this.add(this.panels[5]);
            this.add(this.panels[2]);
            this.add(this.panels[3]);
            this.add(this.panels[6]);
            this.add(this.panels[7]);
            this.setPreferredSize(new Dimension(800, 600));
        }
    }
}

