/*
 * Decompiled with CFR 0.152.
 */
package demo;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Window;
import java.text.DecimalFormat;
import javax.swing.JPanel;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYBarRenderer;
import org.jfree.chart.util.RelativeDateFormat;
import org.jfree.data.time.Day;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.xy.IntervalXYDataset;
import org.jfree.ui.ApplicationFrame;
import org.jfree.ui.RectangleInsets;
import org.jfree.ui.RefineryUtilities;

public class RelativeDateFormatDemo2
extends ApplicationFrame {
    public RelativeDateFormatDemo2(String string) {
        super(string);
        JPanel jPanel = RelativeDateFormatDemo2.createDemoPanel();
        jPanel.setPreferredSize(new Dimension(500, 270));
        this.setContentPane(jPanel);
    }

    private static JFreeChart createChart(IntervalXYDataset intervalXYDataset) {
        JFreeChart jFreeChart = ChartFactory.createXYBarChart("RelativeDateFormat Demo 2", "Date ", true, "Time To Complete", intervalXYDataset, PlotOrientation.VERTICAL, true, true, false);
        jFreeChart.setBackgroundPaint(Color.white);
        XYPlot xYPlot = (XYPlot)jFreeChart.getPlot();
        xYPlot.setBackgroundPaint(Color.lightGray);
        xYPlot.setDomainGridlinePaint(Color.white);
        xYPlot.setRangeGridlinePaint(Color.white);
        xYPlot.setAxisOffset(new RectangleInsets(5.0, 5.0, 5.0, 5.0));
        xYPlot.setDomainCrosshairVisible(true);
        xYPlot.setRangeCrosshairVisible(true);
        XYBarRenderer xYBarRenderer = (XYBarRenderer)xYPlot.getRenderer();
        xYBarRenderer.setDrawBarOutline(false);
        DateAxis dateAxis = new DateAxis();
        RelativeDateFormat relativeDateFormat = new RelativeDateFormat();
        relativeDateFormat.setShowZeroDays(false);
        relativeDateFormat.setSecondFormatter(new DecimalFormat("00"));
        dateAxis.setDateFormatOverride(relativeDateFormat);
        xYPlot.setRangeAxis(dateAxis);
        return jFreeChart;
    }

    private static IntervalXYDataset createDataset() {
        TimeSeries timeSeries = new TimeSeries((Comparable)((Object)"Completion"));
        timeSeries.add((RegularTimePeriod)new Day(19, 1, 2007), 3343000.0);
        timeSeries.add((RegularTimePeriod)new Day(20, 1, 2007), 3420000.0);
        timeSeries.add((RegularTimePeriod)new Day(21, 1, 2007), 3515000.0);
        timeSeries.add((RegularTimePeriod)new Day(22, 1, 2007), 3315000.0);
        timeSeries.add((RegularTimePeriod)new Day(23, 1, 2007), 3490000.0);
        timeSeries.add((RegularTimePeriod)new Day(24, 1, 2007), 3556000.0);
        timeSeries.add((RegularTimePeriod)new Day(25, 1, 2007), 3383000.0);
        timeSeries.add((RegularTimePeriod)new Day(26, 1, 2007), 3575000.0);
        TimeSeriesCollection timeSeriesCollection = new TimeSeriesCollection();
        timeSeriesCollection.addSeries(timeSeries);
        return timeSeriesCollection;
    }

    public static JPanel createDemoPanel() {
        JFreeChart jFreeChart = RelativeDateFormatDemo2.createChart(RelativeDateFormatDemo2.createDataset());
        return new ChartPanel(jFreeChart);
    }

    public static void main(String[] stringArray) {
        RelativeDateFormatDemo2 relativeDateFormatDemo2 = new RelativeDateFormatDemo2("JFreeChart - RelativeDateFormatDemo2");
        relativeDateFormatDemo2.pack();
        RefineryUtilities.centerFrameOnScreen((Window)((Object)relativeDateFormatDemo2));
        relativeDateFormatDemo2.setVisible(true);
    }
}

