/*
 * Decompiled with CFR 0.152.
 */
package demo;

import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.DefaultFontMapper;
import com.lowagie.text.pdf.FontMapper;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfTemplate;
import com.lowagie.text.pdf.PdfWriter;
import demo.DemoDescription;
import demo.MemoryUsageDemo;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics2D;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Rectangle2D;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.ui.ApplicationFrame;
import org.jfree.ui.RectangleInsets;
import org.jfree.ui.RefineryUtilities;

public class SuperDemo
extends ApplicationFrame
implements ActionListener,
TreeSelectionListener {
    public static final String EXIT_COMMAND = "EXIT";
    private JPanel displayPanel;
    private JPanel chartContainer;
    private JPanel descriptionContainer;
    private JTextPane descriptionPane;
    static /* synthetic */ Class class$demo$SuperDemo;

    public SuperDemo(String string) {
        super(string);
        this.setContentPane(this.createContent());
        this.setJMenuBar(this.createMenuBar());
    }

    private JComponent createContent() {
        MemoryUsageDemo memoryUsageDemo;
        JPanel jPanel = new JPanel(new BorderLayout());
        JTabbedPane jTabbedPane = new JTabbedPane();
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        JSplitPane jSplitPane = new JSplitPane(1);
        JTree jTree = new JTree(this.createTreeModel());
        jTree.addTreeSelectionListener(this);
        JScrollPane jScrollPane = new JScrollPane(jTree);
        jScrollPane.setPreferredSize(new Dimension(300, 100));
        jSplitPane.setLeftComponent(jScrollPane);
        jSplitPane.setRightComponent(this.createChartDisplayPanel());
        jPanel2.add(jSplitPane);
        jTabbedPane.add("Demos", jPanel2);
        MemoryUsageDemo memoryUsageDemo2 = memoryUsageDemo = new MemoryUsageDemo(300000);
        memoryUsageDemo2.getClass();
        memoryUsageDemo2.new MemoryUsageDemo.DataGenerator(1000).start();
        jTabbedPane.add("Memory Usage", memoryUsageDemo);
        jTabbedPane.add("Source Code", this.createSourceCodePanel());
        jTabbedPane.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        jPanel.add(jTabbedPane);
        return jPanel;
    }

    private JMenuBar createMenuBar() {
        JMenuBar jMenuBar = new JMenuBar();
        JMenu jMenu = new JMenu("File", true);
        jMenu.setMnemonic('F');
        JMenuItem jMenuItem = new JMenuItem("Export to PDF...", 112);
        jMenuItem.setActionCommand("EXPORT_TO_PDF");
        jMenuItem.addActionListener(this);
        jMenu.add(jMenuItem);
        jMenu.addSeparator();
        JMenuItem jMenuItem2 = new JMenuItem("Exit", 120);
        jMenuItem2.setActionCommand(EXIT_COMMAND);
        jMenuItem2.addActionListener(this);
        jMenu.add(jMenuItem2);
        jMenuBar.add(jMenu);
        return jMenuBar;
    }

    private JPanel createSourceCodePanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        JEditorPane jEditorPane = new JEditorPane();
        jEditorPane.setEditable(false);
        URL uRL = (class$demo$SuperDemo == null ? (class$demo$SuperDemo = SuperDemo.class$("demo.SuperDemo")) : class$demo$SuperDemo).getResource("source.html");
        if (uRL != null) {
            try {
                jEditorPane.setPage(uRL);
            }
            catch (IOException iOException) {
                System.err.println("Attempted to read a bad URL: " + uRL);
            }
        } else {
            System.err.println("Couldn't find file: source.html");
        }
        JScrollPane jScrollPane = new JScrollPane(jEditorPane);
        jScrollPane.setVerticalScrollBarPolicy(20);
        jScrollPane.setPreferredSize(new Dimension(250, 145));
        jScrollPane.setMinimumSize(new Dimension(10, 10));
        jPanel.add(jScrollPane);
        return jPanel;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("EXPORT_TO_PDF")) {
            this.exportToPDF();
        } else if (string.equals(EXIT_COMMAND)) {
            this.attemptExit();
        }
    }

    private void exportToPDF() {
        Component component = this.chartContainer.getComponent(0);
        if (component instanceof ChartPanel) {
            JFileChooser jFileChooser = new JFileChooser();
            jFileChooser.setName("untitled.pdf");
            jFileChooser.setFileFilter(new FileFilter(){

                public boolean accept(File file) {
                    return file.isDirectory() || file.getName().endsWith(".pdf");
                }

                public String getDescription() {
                    return "Portable Document Format (PDF)";
                }
            });
            int n = jFileChooser.showSaveDialog((Component)((Object)this));
            if (n == 0) {
                ChartPanel chartPanel = (ChartPanel)component;
                try {
                    JFreeChart jFreeChart = (JFreeChart)chartPanel.getChart().clone();
                    PDFExportTask pDFExportTask = new PDFExportTask(jFreeChart, chartPanel.getWidth(), chartPanel.getHeight(), jFileChooser.getSelectedFile());
                    Thread thread = new Thread(pDFExportTask);
                    thread.start();
                }
                catch (CloneNotSupportedException cloneNotSupportedException) {
                    cloneNotSupportedException.printStackTrace();
                }
            }
        } else {
            String string = "Unable to export the selected item.  There is ";
            string = string + "either no chart selected,\nor else the chart is not ";
            string = string + "at the expected location in the component hierarchy\n";
            string = string + "(future versions of the demo may include code to ";
            string = string + "handle these special cases).";
            JOptionPane.showMessageDialog((Component)((Object)this), string, "PDF Export", 1);
        }
    }

    public static void writeChartAsPDF(OutputStream outputStream, JFreeChart jFreeChart, int n, int n2, FontMapper fontMapper) throws IOException {
        Rectangle rectangle = new Rectangle((float)n, (float)n2);
        Document document = new Document(rectangle, 50.0f, 50.0f, 50.0f, 50.0f);
        try {
            PdfWriter pdfWriter = PdfWriter.getInstance((Document)document, (OutputStream)outputStream);
            document.addAuthor("JFreeChart");
            document.addSubject("Demonstration");
            document.open();
            PdfContentByte pdfContentByte = pdfWriter.getDirectContent();
            PdfTemplate pdfTemplate = pdfContentByte.createTemplate((float)n, (float)n2);
            Graphics2D graphics2D = pdfTemplate.createGraphics((float)n, (float)n2, fontMapper);
            Rectangle2D.Double double_ = new Rectangle2D.Double(0.0, 0.0, n, n2);
            jFreeChart.draw(graphics2D, double_);
            graphics2D.dispose();
            pdfContentByte.addTemplate(pdfTemplate, 0.0f, 0.0f);
        }
        catch (DocumentException documentException) {
            System.err.println(documentException.getMessage());
        }
        document.close();
    }

    public static void saveChartAsPDF(File file, JFreeChart jFreeChart, int n, int n2, FontMapper fontMapper) throws IOException {
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
        SuperDemo.writeChartAsPDF(bufferedOutputStream, jFreeChart, n, n2, fontMapper);
        ((OutputStream)bufferedOutputStream).close();
    }

    private void attemptExit() {
        String string = "Are you sure you want to exit the demo?";
        String string2 = "Confirm";
        int n = JOptionPane.showConfirmDialog((Component)((Object)this), string, string2, 0, 3);
        if (n == 0) {
            this.dispose();
            System.exit(0);
        }
    }

    private JPanel createChartDisplayPanel() {
        this.displayPanel = new JPanel(new BorderLayout());
        this.chartContainer = new JPanel(new BorderLayout());
        this.chartContainer.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4), BorderFactory.createLineBorder(Color.black)));
        this.chartContainer.add(this.createNoDemoSelectedPanel());
        this.descriptionContainer = new JPanel(new BorderLayout());
        this.descriptionContainer.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        this.descriptionContainer.setPreferredSize(new Dimension(600, 140));
        this.descriptionPane = new JTextPane();
        this.descriptionPane.setEditable(false);
        JScrollPane jScrollPane = new JScrollPane(this.descriptionPane, 20, 31);
        this.descriptionContainer.add(jScrollPane);
        this.displayDescription("select.html");
        JSplitPane jSplitPane = new JSplitPane(0);
        jSplitPane.setTopComponent(this.chartContainer);
        jSplitPane.setBottomComponent(this.descriptionContainer);
        this.displayPanel.add(jSplitPane);
        jSplitPane.setDividerLocation(0.75);
        return this.displayPanel;
    }

    private TreeModel createTreeModel() {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode("JFreeChart");
        defaultMutableTreeNode.add(this.createAreaChartsNode());
        defaultMutableTreeNode.add(this.createBarChartsNode());
        defaultMutableTreeNode.add(this.createStackedBarChartsNode());
        defaultMutableTreeNode.add(this.createCombinedAxisChartsNode());
        defaultMutableTreeNode.add(this.createFinancialChartsNode());
        defaultMutableTreeNode.add(this.createGanttChartsNode());
        defaultMutableTreeNode.add(this.createLineChartsNode());
        defaultMutableTreeNode.add(this.createMeterChartsNode());
        defaultMutableTreeNode.add(this.createMultipleAxisChartsNode());
        defaultMutableTreeNode.add(this.createOverlaidChartsNode());
        defaultMutableTreeNode.add(this.createPieChartsNode());
        defaultMutableTreeNode.add(this.createStatisticalChartsNode());
        defaultMutableTreeNode.add(this.createTimeSeriesChartsNode());
        defaultMutableTreeNode.add(this.createXYChartsNode());
        defaultMutableTreeNode.add(this.createMiscellaneousChartsNode());
        defaultMutableTreeNode.add(this.createExperimentalNode());
        return new DefaultTreeModel(defaultMutableTreeNode);
    }

    private MutableTreeNode createPieChartsNode() {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode("Pie Charts");
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(new DemoDescription("demo.PieChartDemo1", "PieChartDemo1.java"));
        DefaultMutableTreeNode defaultMutableTreeNode3 = new DefaultMutableTreeNode(new DemoDescription("demo.PieChartDemo2", "PieChartDemo2.java"));
        DefaultMutableTreeNode defaultMutableTreeNode4 = new DefaultMutableTreeNode(new DemoDescription("demo.PieChartDemo3", "PieChartDemo3.java"));
        DefaultMutableTreeNode defaultMutableTreeNode5 = new DefaultMutableTreeNode(new DemoDescription("demo.PieChartDemo4", "PieChartDemo4.java"));
        DefaultMutableTreeNode defaultMutableTreeNode6 = new DefaultMutableTreeNode(new DemoDescription("demo.PieChartDemo5", "PieChartDemo5.java"));
        DefaultMutableTreeNode defaultMutableTreeNode7 = new DefaultMutableTreeNode(new DemoDescription("demo.PieChartDemo6", "PieChartDemo6.java"));
        DefaultMutableTreeNode defaultMutableTreeNode8 = new DefaultMutableTreeNode(new DemoDescription("demo.PieChartDemo7", "PieChartDemo7.java"));
        DefaultMutableTreeNode defaultMutableTreeNode9 = new DefaultMutableTreeNode(new DemoDescription("demo.PieChartDemo8", "PieChartDemo8.java"));
        DefaultMutableTreeNode defaultMutableTreeNode10 = new DefaultMutableTreeNode(new DemoDescription("demo.PieChart3DDemo1", "PieChart3DDemo1.java"));
        DefaultMutableTreeNode defaultMutableTreeNode11 = new DefaultMutableTreeNode(new DemoDescription("demo.PieChart3DDemo2", "PieChart3DDemo2.java"));
        DefaultMutableTreeNode defaultMutableTreeNode12 = new DefaultMutableTreeNode(new DemoDescription("demo.PieChart3DDemo3", "PieChart3DDemo3.java"));
        DefaultMutableTreeNode defaultMutableTreeNode13 = new DefaultMutableTreeNode(new DemoDescription("demo.MultiplePieChartDemo1", "MultiplePieChartDemo1.java"));
        DefaultMutableTreeNode defaultMutableTreeNode14 = new DefaultMutableTreeNode(new DemoDescription("demo.MultiplePieChartDemo2", "MultiplePieChartDemo2.java"));
        DefaultMutableTreeNode defaultMutableTreeNode15 = new DefaultMutableTreeNode(new DemoDescription("demo.MultiplePieChartDemo3", "MultiplePieChartDemo3.java"));
        DefaultMutableTreeNode defaultMutableTreeNode16 = new DefaultMutableTreeNode(new DemoDescription("demo.MultiplePieChartDemo4", "MultiplePieChartDemo4.java"));
        DefaultMutableTreeNode defaultMutableTreeNode17 = new DefaultMutableTreeNode(new DemoDescription("demo.RingChartDemo1", "RingChartDemo1.java"));
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
        defaultMutableTreeNode.add(defaultMutableTreeNode3);
        defaultMutableTreeNode.add(defaultMutableTreeNode4);
        defaultMutableTreeNode.add(defaultMutableTreeNode5);
        defaultMutableTreeNode.add(defaultMutableTreeNode6);
        defaultMutableTreeNode.add(defaultMutableTreeNode7);
        defaultMutableTreeNode.add(defaultMutableTreeNode8);
        defaultMutableTreeNode.add(defaultMutableTreeNode9);
        defaultMutableTreeNode.add(defaultMutableTreeNode10);
        defaultMutableTreeNode.add(defaultMutableTreeNode11);
        defaultMutableTreeNode.add(defaultMutableTreeNode12);
        defaultMutableTreeNode.add(defaultMutableTreeNode13);
        defaultMutableTreeNode.add(defaultMutableTreeNode14);
        defaultMutableTreeNode.add(defaultMutableTreeNode15);
        defaultMutableTreeNode.add(defaultMutableTreeNode16);
        defaultMutableTreeNode.add(defaultMutableTreeNode17);
        return defaultMutableTreeNode;
    }

    private MutableTreeNode createOverlaidChartsNode() {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode("Overlaid Charts");
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(new DemoDescription("demo.OverlaidBarChartDemo1", "OverlaidBarChartDemo1.java"));
        DefaultMutableTreeNode defaultMutableTreeNode3 = new DefaultMutableTreeNode(new DemoDescription("demo.OverlaidBarChartDemo2", "OverlaidBarChartDemo2.java"));
        DefaultMutableTreeNode defaultMutableTreeNode4 = new DefaultMutableTreeNode(new DemoDescription("demo.OverlaidXYPlotDemo1", "OverlaidXYPlotDemo1.java"));
        DefaultMutableTreeNode defaultMutableTreeNode5 = new DefaultMutableTreeNode(new DemoDescription("demo.OverlaidXYPlotDemo2", "OverlaidXYPlotDemo2.java"));
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
        defaultMutableTreeNode.add(defaultMutableTreeNode3);
        defaultMutableTreeNode.add(defaultMutableTreeNode4);
        defaultMutableTreeNode.add(defaultMutableTreeNode5);
        return defaultMutableTreeNode;
    }

    private MutableTreeNode createBarChartsNode() {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode("Bar Charts");
        defaultMutableTreeNode.add(this.createCategoryBarChartsNode());
        defaultMutableTreeNode.add(this.createXYBarChartsNode());
        return defaultMutableTreeNode;
    }

    private MutableTreeNode createStackedBarChartsNode() {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode("Bar Charts - Stacked");
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(new DemoDescription("demo.StackedBarChartDemo1", "StackedBarChartDemo1.java"));
        DefaultMutableTreeNode defaultMutableTreeNode3 = new DefaultMutableTreeNode(new DemoDescription("demo.StackedBarChartDemo2", "StackedBarChartDemo2.java"));
        DefaultMutableTreeNode defaultMutableTreeNode4 = new DefaultMutableTreeNode(new DemoDescription("demo.StackedBarChartDemo3", "StackedBarChartDemo3.java"));
        DefaultMutableTreeNode defaultMutableTreeNode5 = new DefaultMutableTreeNode(new DemoDescription("demo.StackedBarChartDemo4", "StackedBarChartDemo4.java"));
        DefaultMutableTreeNode defaultMutableTreeNode6 = new DefaultMutableTreeNode(new DemoDescription("demo.StackedBarChartDemo5", "StackedBarChartDemo5.java"));
        DefaultMutableTreeNode defaultMutableTreeNode7 = new DefaultMutableTreeNode(new DemoDescription("demo.StackedBarChartDemo6", "StackedBarChartDemo6.java"));
        DefaultMutableTreeNode defaultMutableTreeNode8 = new DefaultMutableTreeNode(new DemoDescription("demo.StackedBarChartDemo7", "StackedBarChartDemo7.java"));
        DefaultMutableTreeNode defaultMutableTreeNode9 = new DefaultMutableTreeNode(new DemoDescription("demo.StackedBarChart3DDemo1", "StackedBarChart3DDemo1.java"));
        DefaultMutableTreeNode defaultMutableTreeNode10 = new DefaultMutableTreeNode(new DemoDescription("demo.StackedBarChart3DDemo2", "StackedBarChart3DDemo2.java"));
        DefaultMutableTreeNode defaultMutableTreeNode11 = new DefaultMutableTreeNode(new DemoDescription("demo.StackedBarChart3DDemo3", "StackedBarChart3DDemo3.java"));
        DefaultMutableTreeNode defaultMutableTreeNode12 = new DefaultMutableTreeNode(new DemoDescription("demo.StackedBarChart3DDemo4", "StackedBarChart3DDemo4.java"));
        DefaultMutableTreeNode defaultMutableTreeNode13 = new DefaultMutableTreeNode(new DemoDescription("demo.StackedBarChart3DDemo5", "StackedBarChart3DDemo5.java"));
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
        defaultMutableTreeNode.add(defaultMutableTreeNode3);
        defaultMutableTreeNode.add(defaultMutableTreeNode4);
        defaultMutableTreeNode.add(defaultMutableTreeNode5);
        defaultMutableTreeNode.add(defaultMutableTreeNode6);
        defaultMutableTreeNode.add(defaultMutableTreeNode7);
        defaultMutableTreeNode.add(defaultMutableTreeNode8);
        defaultMutableTreeNode.add(defaultMutableTreeNode9);
        defaultMutableTreeNode.add(defaultMutableTreeNode10);
        defaultMutableTreeNode.add(defaultMutableTreeNode11);
        defaultMutableTreeNode.add(defaultMutableTreeNode12);
        defaultMutableTreeNode.add(defaultMutableTreeNode13);
        return defaultMutableTreeNode;
    }

    private MutableTreeNode createCategoryBarChartsNode() {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode("CategoryPlot");
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(new DemoDescription("demo.BarChartDemo1", "BarChartDemo1.java"));
        DefaultMutableTreeNode defaultMutableTreeNode3 = new DefaultMutableTreeNode(new DemoDescription("demo.BarChartDemo2", "BarChartDemo2.java"));
        DefaultMutableTreeNode defaultMutableTreeNode4 = new DefaultMutableTreeNode(new DemoDescription("demo.BarChartDemo3", "BarChartDemo3.java"));
        DefaultMutableTreeNode defaultMutableTreeNode5 = new DefaultMutableTreeNode(new DemoDescription("demo.BarChartDemo4", "BarChartDemo4.java"));
        DefaultMutableTreeNode defaultMutableTreeNode6 = new DefaultMutableTreeNode(new DemoDescription("demo.BarChartDemo5", "BarChartDemo5.java"));
        DefaultMutableTreeNode defaultMutableTreeNode7 = new DefaultMutableTreeNode(new DemoDescription("demo.BarChartDemo6", "BarChartDemo6.java"));
        DefaultMutableTreeNode defaultMutableTreeNode8 = new DefaultMutableTreeNode(new DemoDescription("demo.BarChartDemo7", "BarChartDemo7.java"));
        DefaultMutableTreeNode defaultMutableTreeNode9 = new DefaultMutableTreeNode(new DemoDescription("demo.BarChartDemo8", "BarChartDemo8.java"));
        DefaultMutableTreeNode defaultMutableTreeNode10 = new DefaultMutableTreeNode(new DemoDescription("demo.BarChartDemo9", "BarChartDemo9.java"));
        DefaultMutableTreeNode defaultMutableTreeNode11 = new DefaultMutableTreeNode(new DemoDescription("demo.BarChartDemo10", "BarChartDemo10.java"));
        DefaultMutableTreeNode defaultMutableTreeNode12 = new DefaultMutableTreeNode(new DemoDescription("demo.BarChart3DDemo1", "BarChart3DDemo1.java"));
        DefaultMutableTreeNode defaultMutableTreeNode13 = new DefaultMutableTreeNode(new DemoDescription("demo.BarChart3DDemo2", "BarChart3DDemo2.java"));
        DefaultMutableTreeNode defaultMutableTreeNode14 = new DefaultMutableTreeNode(new DemoDescription("demo.BarChart3DDemo3", "BarChart3DDemo3.java"));
        DefaultMutableTreeNode defaultMutableTreeNode15 = new DefaultMutableTreeNode(new DemoDescription("demo.BarChart3DDemo4", "BarChart3DDemo4.java"));
        DefaultMutableTreeNode defaultMutableTreeNode16 = new DefaultMutableTreeNode(new DemoDescription("demo.CylinderChartDemo1", "CylinderChartDemo1.java"));
        DefaultMutableTreeNode defaultMutableTreeNode17 = new DefaultMutableTreeNode(new DemoDescription("demo.CylinderChartDemo2", "CylinderChartDemo2.java"));
        DefaultMutableTreeNode defaultMutableTreeNode18 = new DefaultMutableTreeNode(new DemoDescription("demo.IntervalBarChartDemo1", "IntervalBarChartDemo1.java"));
        DefaultMutableTreeNode defaultMutableTreeNode19 = new DefaultMutableTreeNode(new DemoDescription("demo.LayeredBarChartDemo1", "LayeredBarChartDemo1.java"));
        DefaultMutableTreeNode defaultMutableTreeNode20 = new DefaultMutableTreeNode(new DemoDescription("demo.LayeredBarChartDemo2", "LayeredBarChartDemo2.java"));
        DefaultMutableTreeNode defaultMutableTreeNode21 = new DefaultMutableTreeNode(new DemoDescription("demo.StatisticalBarChartDemo1", "StatisticalBarChartDemo1.java"));
        DefaultMutableTreeNode defaultMutableTreeNode22 = new DefaultMutableTreeNode(new DemoDescription("demo.SurveyResultsDemo1", "SurveyResultsDemo1.java"));
        DefaultMutableTreeNode defaultMutableTreeNode23 = new DefaultMutableTreeNode(new DemoDescription("demo.SurveyResultsDemo2", "SurveyResultsDemo2.java"));
        DefaultMutableTreeNode defaultMutableTreeNode24 = new DefaultMutableTreeNode(new DemoDescription("demo.SurveyResultsDemo3", "SurveyResultsDemo3.java"));
        DefaultMutableTreeNode defaultMutableTreeNode25 = new DefaultMutableTreeNode(new DemoDescription("demo.WaterfallChartDemo1", "WaterfallChartDemo1.java"));
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
        defaultMutableTreeNode.add(defaultMutableTreeNode3);
        defaultMutableTreeNode.add(defaultMutableTreeNode4);
        defaultMutableTreeNode.add(defaultMutableTreeNode5);
        defaultMutableTreeNode.add(defaultMutableTreeNode6);
        defaultMutableTreeNode.add(defaultMutableTreeNode7);
        defaultMutableTreeNode.add(defaultMutableTreeNode8);
        defaultMutableTreeNode.add(defaultMutableTreeNode9);
        defaultMutableTreeNode.add(defaultMutableTreeNode10);
        defaultMutableTreeNode.add(defaultMutableTreeNode11);
        defaultMutableTreeNode.add(defaultMutableTreeNode12);
        defaultMutableTreeNode.add(defaultMutableTreeNode13);
        defaultMutableTreeNode.add(defaultMutableTreeNode14);
        defaultMutableTreeNode.add(defaultMutableTreeNode15);
        defaultMutableTreeNode.add(defaultMutableTreeNode16);
        defaultMutableTreeNode.add(defaultMutableTreeNode17);
        defaultMutableTreeNode.add(defaultMutableTreeNode18);
        defaultMutableTreeNode.add(defaultMutableTreeNode19);
        defaultMutableTreeNode.add(defaultMutableTreeNode20);
        defaultMutableTreeNode.add(defaultMutableTreeNode21);
        defaultMutableTreeNode.add(defaultMutableTreeNode22);
        defaultMutableTreeNode.add(defaultMutableTreeNode23);
        defaultMutableTreeNode.add(defaultMutableTreeNode24);
        defaultMutableTreeNode.add(defaultMutableTreeNode25);
        return defaultMutableTreeNode;
    }

    private MutableTreeNode createXYBarChartsNode() {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode("XYPlot");
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(new DemoDescription("demo.XYBarChartDemo1", "XYBarChartDemo1.java"));
        DefaultMutableTreeNode defaultMutableTreeNode3 = new DefaultMutableTreeNode(new DemoDescription("demo.XYBarChartDemo2", "XYBarChartDemo2.java"));
        DefaultMutableTreeNode defaultMutableTreeNode4 = new DefaultMutableTreeNode(new DemoDescription("demo.XYBarChartDemo3", "XYBarChartDemo3.java"));
        DefaultMutableTreeNode defaultMutableTreeNode5 = new DefaultMutableTreeNode(new DemoDescription("demo.XYBarChartDemo4", "XYBarChartDemo4.java"));
        DefaultMutableTreeNode defaultMutableTreeNode6 = new DefaultMutableTreeNode(new DemoDescription("demo.XYBarChartDemo5", "XYBarChartDemo5.java"));
        DefaultMutableTreeNode defaultMutableTreeNode7 = new DefaultMutableTreeNode(new DemoDescription("demo.XYBarChartDemo6", "XYBarChartDemo6.java"));
        DefaultMutableTreeNode defaultMutableTreeNode8 = new DefaultMutableTreeNode(new DemoDescription("demo.XYBarChartDemo7", "XYBarChartDemo7.java"));
        DefaultMutableTreeNode defaultMutableTreeNode9 = new DefaultMutableTreeNode(new DemoDescription("demo.ClusteredXYBarRendererDemo1", "ClusteredXYBarRendererDemo1.java"));
        DefaultMutableTreeNode defaultMutableTreeNode10 = new DefaultMutableTreeNode(new DemoDescription("demo.StackedXYBarChartDemo1", "StackedXYBarChartDemo1.java"));
        DefaultMutableTreeNode defaultMutableTreeNode11 = new DefaultMutableTreeNode(new DemoDescription("demo.StackedXYBarChartDemo2", "StackedXYBarChartDemo2.java"));
        DefaultMutableTreeNode defaultMutableTreeNode12 = new DefaultMutableTreeNode(new DemoDescription("demo.StackedXYBarChartDemo3", "StackedXYBarChartDemo3.java"));
        DefaultMutableTreeNode defaultMutableTreeNode13 = new DefaultMutableTreeNode(new DemoDescription("demo.RelativeDateFormatDemo1", "RelativeDateFormatDemo1.java"));
        DefaultMutableTreeNode defaultMutableTreeNode14 = new DefaultMutableTreeNode(new DemoDescription("demo.RelativeDateFormatDemo2", "RelativeDateFormatDemo2.java"));
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
        defaultMutableTreeNode.add(defaultMutableTreeNode3);
        defaultMutableTreeNode.add(defaultMutableTreeNode4);
        defaultMutableTreeNode.add(defaultMutableTreeNode5);
        defaultMutableTreeNode.add(defaultMutableTreeNode6);
        defaultMutableTreeNode.add(defaultMutableTreeNode7);
        defaultMutableTreeNode.add(defaultMutableTreeNode8);
        defaultMutableTreeNode.add(defaultMutableTreeNode9);
        defaultMutableTreeNode.add(defaultMutableTreeNode10);
        defaultMutableTreeNode.add(defaultMutableTreeNode11);
        defaultMutableTreeNode.add(defaultMutableTreeNode12);
        defaultMutableTreeNode.add(defaultMutableTreeNode13);
        defaultMutableTreeNode.add(defaultMutableTreeNode14);
        return defaultMutableTreeNode;
    }

    private MutableTreeNode createLineChartsNode() {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode("Line Charts");
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(new DemoDescription("demo.AnnotationDemo1", "AnnotationDemo1.java"));
        DefaultMutableTreeNode defaultMutableTreeNode3 = new DefaultMutableTreeNode(new DemoDescription("demo.LineChartDemo1", "LineChartDemo1.java"));
        DefaultMutableTreeNode defaultMutableTreeNode4 = new DefaultMutableTreeNode(new DemoDescription("demo.LineChartDemo2", "LineChartDemo2.java"));
        DefaultMutableTreeNode defaultMutableTreeNode5 = new DefaultMutableTreeNode(new DemoDescription("demo.LineChartDemo3", "LineChartDemo3.java"));
        DefaultMutableTreeNode defaultMutableTreeNode6 = new DefaultMutableTreeNode(new DemoDescription("demo.LineChartDemo4", "LineChartDemo4.java"));
        DefaultMutableTreeNode defaultMutableTreeNode7 = new DefaultMutableTreeNode(new DemoDescription("demo.LineChartDemo5", "LineChartDemo5.java"));
        DefaultMutableTreeNode defaultMutableTreeNode8 = new DefaultMutableTreeNode(new DemoDescription("demo.LineChartDemo6", "LineChartDemo6.java"));
        DefaultMutableTreeNode defaultMutableTreeNode9 = new DefaultMutableTreeNode(new DemoDescription("demo.LineChartDemo7", "LineChartDemo7.java"));
        DefaultMutableTreeNode defaultMutableTreeNode10 = new DefaultMutableTreeNode(new DemoDescription("demo.LineChartDemo8", "LineChartDemo8.java"));
        DefaultMutableTreeNode defaultMutableTreeNode11 = new DefaultMutableTreeNode(new DemoDescription("demo.LineChart3DDemo1", "LineChart3DDemo1.java"));
        DefaultMutableTreeNode defaultMutableTreeNode12 = new DefaultMutableTreeNode(new DemoDescription("demo.StatisticalLineChartDemo1", "StatisticalLineChartDemo1.java"));
        DefaultMutableTreeNode defaultMutableTreeNode13 = new DefaultMutableTreeNode(new DemoDescription("demo.XYSplineRendererDemo1", "XYSplineRendererDemo1.java"));
        DefaultMutableTreeNode defaultMutableTreeNode14 = new DefaultMutableTreeNode(new DemoDescription("demo.XYStepRendererDemo1", "XYStepRendererDemo1.java"));
        DefaultMutableTreeNode defaultMutableTreeNode15 = new DefaultMutableTreeNode(new DemoDescription("demo.XYStepRendererDemo2", "XYStepRendererDemo2.java"));
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
        defaultMutableTreeNode.add(defaultMutableTreeNode3);
        defaultMutableTreeNode.add(defaultMutableTreeNode4);
        defaultMutableTreeNode.add(defaultMutableTreeNode5);
        defaultMutableTreeNode.add(defaultMutableTreeNode6);
        defaultMutableTreeNode.add(defaultMutableTreeNode7);
        defaultMutableTreeNode.add(defaultMutableTreeNode8);
        defaultMutableTreeNode.add(defaultMutableTreeNode9);
        defaultMutableTreeNode.add(defaultMutableTreeNode10);
        defaultMutableTreeNode.add(defaultMutableTreeNode11);
        defaultMutableTreeNode.add(defaultMutableTreeNode12);
        defaultMutableTreeNode.add(defaultMutableTreeNode13);
        defaultMutableTreeNode.add(defaultMutableTreeNode14);
        defaultMutableTreeNode.add(defaultMutableTreeNode15);
        return defaultMutableTreeNode;
    }

    private MutableTreeNode createAreaChartsNode() {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode("Area Charts");
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(new DemoDescription("demo.AreaChartDemo1", "AreaChartDemo1.java"));
        DefaultMutableTreeNode defaultMutableTreeNode3 = new DefaultMutableTreeNode(new DemoDescription("demo.StackedXYAreaChartDemo1", "StackedXYAreaChartDemo1.java"));
        DefaultMutableTreeNode defaultMutableTreeNode4 = new DefaultMutableTreeNode(new DemoDescription("demo.StackedXYAreaChartDemo2", "StackedXYAreaChartDemo2.java"));
        DefaultMutableTreeNode defaultMutableTreeNode5 = new DefaultMutableTreeNode(new DemoDescription("demo.XYAreaChartDemo1", "XYAreaChartDemo1.java"));
        DefaultMutableTreeNode defaultMutableTreeNode6 = new DefaultMutableTreeNode(new DemoDescription("demo.XYAreaChartDemo2", "XYAreaChartDemo2.java"));
        DefaultMutableTreeNode defaultMutableTreeNode7 = new DefaultMutableTreeNode(new DemoDescription("demo.XYStepAreaRendererDemo1", "XYStepAreaRendererDemo1.java"));
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
        defaultMutableTreeNode.add(defaultMutableTreeNode3);
        defaultMutableTreeNode.add(defaultMutableTreeNode4);
        defaultMutableTreeNode.add(defaultMutableTreeNode5);
        defaultMutableTreeNode.add(defaultMutableTreeNode6);
        defaultMutableTreeNode.add(defaultMutableTreeNode7);
        return defaultMutableTreeNode;
    }

    private MutableTreeNode createStatisticalChartsNode() {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode("Statistical Charts");
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(new DemoDescription("demo.BoxAndWhiskerChartDemo1", "BoxAndWhiskerChartDemo1.java"));
        DefaultMutableTreeNode defaultMutableTreeNode3 = new DefaultMutableTreeNode(new DemoDescription("demo.HistogramDemo1", "HistogramDemo1.java"));
        DefaultMutableTreeNode defaultMutableTreeNode4 = new DefaultMutableTreeNode(new DemoDescription("demo.MinMaxCategoryPlotDemo1", "MinMaxCategoryPlotDemo1.java"));
        DefaultMutableTreeNode defaultMutableTreeNode5 = new DefaultMutableTreeNode(new DemoDescription("demo.NormalDistributionDemo1", "NormalDistributionDemo1.java"));
        DefaultMutableTreeNode defaultMutableTreeNode6 = new DefaultMutableTreeNode(new DemoDescription("demo.RegressionDemo1", "RegressionDemo1.java"));
        DefaultMutableTreeNode defaultMutableTreeNode7 = new DefaultMutableTreeNode(new DemoDescription("demo.ScatterPlotDemo1", "ScatterPlotDemo1.java"));
        DefaultMutableTreeNode defaultMutableTreeNode8 = new DefaultMutableTreeNode(new DemoDescription("demo.ScatterPlotDemo2", "ScatterPlotDemo2.java"));
        DefaultMutableTreeNode defaultMutableTreeNode9 = new DefaultMutableTreeNode(new DemoDescription("demo.ScatterPlotDemo3", "ScatterPlotDemo3.java"));
        DefaultMutableTreeNode defaultMutableTreeNode10 = new DefaultMutableTreeNode(new DemoDescription("demo.ScatterPlotDemo4", "ScatterPlotDemo4.java"));
        DefaultMutableTreeNode defaultMutableTreeNode11 = new DefaultMutableTreeNode(new DemoDescription("demo.XYErrorRendererDemo1", "XYErrorRendererDemo1.java"));
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
        defaultMutableTreeNode.add(defaultMutableTreeNode3);
        defaultMutableTreeNode.add(defaultMutableTreeNode4);
        defaultMutableTreeNode.add(defaultMutableTreeNode5);
        defaultMutableTreeNode.add(defaultMutableTreeNode6);
        defaultMutableTreeNode.add(defaultMutableTreeNode7);
        defaultMutableTreeNode.add(defaultMutableTreeNode8);
        defaultMutableTreeNode.add(defaultMutableTreeNode9);
        defaultMutableTreeNode.add(defaultMutableTreeNode10);
        defaultMutableTreeNode.add(defaultMutableTreeNode11);
        return defaultMutableTreeNode;
    }

    private MutableTreeNode createTimeSeriesChartsNode() {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode("Time Series Charts");
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(new DemoDescription("demo.PeriodAxisDemo1", "PeriodAxisDemo1.java"));
        DefaultMutableTreeNode defaultMutableTreeNode3 = new DefaultMutableTreeNode(new DemoDescription("demo.PeriodAxisDemo2", "PeriodAxisDemo2.java"));
        DefaultMutableTreeNode defaultMutableTreeNode4 = new DefaultMutableTreeNode(new DemoDescription("demo.RelativeDateFormatDemo1", "RelativeDateFormatDemo1.java"));
        DefaultMutableTreeNode defaultMutableTreeNode5 = new DefaultMutableTreeNode(new DemoDescription("demo.TimeSeriesDemo1", "TimeSeriesDemo1.java"));
        DefaultMutableTreeNode defaultMutableTreeNode6 = new DefaultMutableTreeNode(new DemoDescription("demo.TimeSeriesDemo2", "TimeSeriesDemo2.java"));
        DefaultMutableTreeNode defaultMutableTreeNode7 = new DefaultMutableTreeNode(new DemoDescription("demo.TimeSeriesDemo3", "TimeSeriesDemo3.java"));
        DefaultMutableTreeNode defaultMutableTreeNode8 = new DefaultMutableTreeNode(new DemoDescription("demo.TimeSeriesDemo4", "TimeSeriesDemo4.java"));
        DefaultMutableTreeNode defaultMutableTreeNode9 = new DefaultMutableTreeNode(new DemoDescription("demo.TimeSeriesDemo5", "TimeSeriesDemo5.java"));
        DefaultMutableTreeNode defaultMutableTreeNode10 = new DefaultMutableTreeNode(new DemoDescription("demo.TimeSeriesDemo6", "TimeSeriesDemo6.java"));
        DefaultMutableTreeNode defaultMutableTreeNode11 = new DefaultMutableTreeNode(new DemoDescription("demo.TimeSeriesDemo7", "TimeSeriesDemo7.java"));
        DefaultMutableTreeNode defaultMutableTreeNode12 = new DefaultMutableTreeNode(new DemoDescription("demo.TimeSeriesDemo8", "TimeSeriesDemo8.java"));
        DefaultMutableTreeNode defaultMutableTreeNode13 = new DefaultMutableTreeNode(new DemoDescription("demo.TimeSeriesDemo9", "TimeSeriesDemo9.java"));
        DefaultMutableTreeNode defaultMutableTreeNode14 = new DefaultMutableTreeNode(new DemoDescription("demo.TimeSeriesDemo10", "TimeSeriesDemo10.java"));
        DefaultMutableTreeNode defaultMutableTreeNode15 = new DefaultMutableTreeNode(new DemoDescription("demo.TimeSeriesDemo11", "TimeSeriesDemo11.java"));
        DefaultMutableTreeNode defaultMutableTreeNode16 = new DefaultMutableTreeNode(new DemoDescription("demo.TimeSeriesDemo12", "TimeSeriesDemo12.java"));
        DefaultMutableTreeNode defaultMutableTreeNode17 = new DefaultMutableTreeNode(new DemoDescription("demo.TimeSeriesDemo13", "TimeSeriesDemo13.java"));
        DefaultMutableTreeNode defaultMutableTreeNode18 = new DefaultMutableTreeNode(new DemoDescription("demo.DeviationRendererDemo1", "DeviationRendererDemo1.java"));
        DefaultMutableTreeNode defaultMutableTreeNode19 = new DefaultMutableTreeNode(new DemoDescription("demo.DeviationRendererDemo2", "DeviationRendererDemo2.java"));
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
        defaultMutableTreeNode.add(defaultMutableTreeNode3);
        defaultMutableTreeNode.add(defaultMutableTreeNode4);
        defaultMutableTreeNode.add(defaultMutableTreeNode5);
        defaultMutableTreeNode.add(defaultMutableTreeNode6);
        defaultMutableTreeNode.add(defaultMutableTreeNode7);
        defaultMutableTreeNode.add(defaultMutableTreeNode8);
        defaultMutableTreeNode.add(defaultMutableTreeNode9);
        defaultMutableTreeNode.add(defaultMutableTreeNode10);
        defaultMutableTreeNode.add(defaultMutableTreeNode11);
        defaultMutableTreeNode.add(defaultMutableTreeNode12);
        defaultMutableTreeNode.add(defaultMutableTreeNode13);
        defaultMutableTreeNode.add(defaultMutableTreeNode14);
        defaultMutableTreeNode.add(defaultMutableTreeNode15);
        defaultMutableTreeNode.add(defaultMutableTreeNode16);
        defaultMutableTreeNode.add(defaultMutableTreeNode17);
        defaultMutableTreeNode.add(defaultMutableTreeNode18);
        defaultMutableTreeNode.add(defaultMutableTreeNode19);
        return defaultMutableTreeNode;
    }

    private MutableTreeNode createFinancialChartsNode() {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode("Financial Charts");
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(new DemoDescription("demo.CandlestickChartDemo1", "CandlestickChartDemo1.java"));
        DefaultMutableTreeNode defaultMutableTreeNode3 = new DefaultMutableTreeNode(new DemoDescription("demo.HighLowChartDemo1", "HighLowChartDemo1.java"));
        DefaultMutableTreeNode defaultMutableTreeNode4 = new DefaultMutableTreeNode(new DemoDescription("demo.HighLowChartDemo2", "HighLowChartDemo2.java"));
        DefaultMutableTreeNode defaultMutableTreeNode5 = new DefaultMutableTreeNode(new DemoDescription("demo.PriceVolumeDemo1", "PriceVolumeDemo1.java"));
        DefaultMutableTreeNode defaultMutableTreeNode6 = new DefaultMutableTreeNode(new DemoDescription("demo.YieldCurveDemo", "YieldCurveDemo.java"));
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
        defaultMutableTreeNode.add(defaultMutableTreeNode3);
        defaultMutableTreeNode.add(defaultMutableTreeNode4);
        defaultMutableTreeNode.add(defaultMutableTreeNode5);
        defaultMutableTreeNode.add(defaultMutableTreeNode6);
        return defaultMutableTreeNode;
    }

    private MutableTreeNode createXYChartsNode() {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode("XY Charts");
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(new DemoDescription("demo.ScatterPlotDemo1", "ScatterPlotDemo1.java"));
        DefaultMutableTreeNode defaultMutableTreeNode3 = new DefaultMutableTreeNode(new DemoDescription("demo.ScatterPlotDemo2", "ScatterPlotDemo2.java"));
        DefaultMutableTreeNode defaultMutableTreeNode4 = new DefaultMutableTreeNode(new DemoDescription("demo.ScatterPlotDemo3", "ScatterPlotDemo3.java"));
        DefaultMutableTreeNode defaultMutableTreeNode5 = new DefaultMutableTreeNode(new DemoDescription("demo.XYBlockChartDemo1", "XYBlockChartDemo1.java"));
        DefaultMutableTreeNode defaultMutableTreeNode6 = new DefaultMutableTreeNode(new DemoDescription("demo.XYBlockChartDemo2", "XYBlockChartDemo2.java"));
        DefaultMutableTreeNode defaultMutableTreeNode7 = new DefaultMutableTreeNode(new DemoDescription("demo.XYBlockChartDemo3", "XYBlockChartDemo3.java"));
        DefaultMutableTreeNode defaultMutableTreeNode8 = new DefaultMutableTreeNode(new DemoDescription("demo.XYLineAndShapeRendererDemo1", "XYLineAndShapeRendererDemo1.java"));
        DefaultMutableTreeNode defaultMutableTreeNode9 = new DefaultMutableTreeNode(new DemoDescription("demo.XYLineAndShapeRendererDemo2", "XYLineAndShapeRendererDemo2.java"));
        DefaultMutableTreeNode defaultMutableTreeNode10 = new DefaultMutableTreeNode(new DemoDescription("demo.XYSeriesDemo1", "XYSeriesDemo1.java"));
        DefaultMutableTreeNode defaultMutableTreeNode11 = new DefaultMutableTreeNode(new DemoDescription("demo.XYSeriesDemo2", "XYSeriesDemo2.java"));
        DefaultMutableTreeNode defaultMutableTreeNode12 = new DefaultMutableTreeNode(new DemoDescription("demo.XYSeriesDemo3", "XYSeriesDemo3.java"));
        DefaultMutableTreeNode defaultMutableTreeNode13 = new DefaultMutableTreeNode(new DemoDescription("demo.VectorPlotDemo1", "VectorPlotDemo1.java"));
        DefaultMutableTreeNode defaultMutableTreeNode14 = new DefaultMutableTreeNode(new DemoDescription("demo.WindChartDemo1", "WindChartDemo1.java"));
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
        defaultMutableTreeNode.add(defaultMutableTreeNode3);
        defaultMutableTreeNode.add(defaultMutableTreeNode4);
        defaultMutableTreeNode.add(defaultMutableTreeNode5);
        defaultMutableTreeNode.add(defaultMutableTreeNode6);
        defaultMutableTreeNode.add(defaultMutableTreeNode7);
        defaultMutableTreeNode.add(defaultMutableTreeNode8);
        defaultMutableTreeNode.add(defaultMutableTreeNode9);
        defaultMutableTreeNode.add(defaultMutableTreeNode10);
        defaultMutableTreeNode.add(defaultMutableTreeNode11);
        defaultMutableTreeNode.add(defaultMutableTreeNode12);
        defaultMutableTreeNode.add(defaultMutableTreeNode13);
        defaultMutableTreeNode.add(defaultMutableTreeNode14);
        return defaultMutableTreeNode;
    }

    private MutableTreeNode createMeterChartsNode() {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode("Dial / Meter Charts");
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(new DemoDescription("demo.DialDemo1", "DialDemo1.java"));
        DefaultMutableTreeNode defaultMutableTreeNode3 = new DefaultMutableTreeNode(new DemoDescription("demo.DialDemo2", "DialDemo2.java"));
        DefaultMutableTreeNode defaultMutableTreeNode4 = new DefaultMutableTreeNode(new DemoDescription("demo.DialDemo3", "DialDemo3.java"));
        DefaultMutableTreeNode defaultMutableTreeNode5 = new DefaultMutableTreeNode(new DemoDescription("demo.DialDemo4", "DialDemo4.java"));
        DefaultMutableTreeNode defaultMutableTreeNode6 = new DefaultMutableTreeNode(new DemoDescription("demo.DialDemo5", "DialDemo5.java"));
        DefaultMutableTreeNode defaultMutableTreeNode7 = new DefaultMutableTreeNode(new DemoDescription("demo.MeterChartDemo1", "MeterChartDemo1.java"));
        DefaultMutableTreeNode defaultMutableTreeNode8 = new DefaultMutableTreeNode(new DemoDescription("demo.MeterChartDemo2", "MeterChartDemo2.java"));
        DefaultMutableTreeNode defaultMutableTreeNode9 = new DefaultMutableTreeNode(new DemoDescription("demo.MeterChartDemo3", "MeterChartDemo3.java"));
        DefaultMutableTreeNode defaultMutableTreeNode10 = new DefaultMutableTreeNode(new DemoDescription("demo.ThermometerDemo1", "ThermometerDemo1.java"));
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
        defaultMutableTreeNode.add(defaultMutableTreeNode3);
        defaultMutableTreeNode.add(defaultMutableTreeNode4);
        defaultMutableTreeNode.add(defaultMutableTreeNode5);
        defaultMutableTreeNode.add(defaultMutableTreeNode6);
        defaultMutableTreeNode.add(defaultMutableTreeNode7);
        defaultMutableTreeNode.add(defaultMutableTreeNode8);
        defaultMutableTreeNode.add(defaultMutableTreeNode9);
        defaultMutableTreeNode.add(defaultMutableTreeNode10);
        return defaultMutableTreeNode;
    }

    private MutableTreeNode createMultipleAxisChartsNode() {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode("Multiple Axis Charts");
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(new DemoDescription("demo.DualAxisDemo1", "DualAxisDemo1.java"));
        DefaultMutableTreeNode defaultMutableTreeNode3 = new DefaultMutableTreeNode(new DemoDescription("demo.DualAxisDemo2", "DualAxisDemo2.java"));
        DefaultMutableTreeNode defaultMutableTreeNode4 = new DefaultMutableTreeNode(new DemoDescription("demo.DualAxisDemo3", "DualAxisDemo3.java"));
        DefaultMutableTreeNode defaultMutableTreeNode5 = new DefaultMutableTreeNode(new DemoDescription("demo.DualAxisDemo4", "DualAxisDemo4.java"));
        DefaultMutableTreeNode defaultMutableTreeNode6 = new DefaultMutableTreeNode(new DemoDescription("demo.DualAxisDemo5", "DualAxisDemo5.java"));
        DefaultMutableTreeNode defaultMutableTreeNode7 = new DefaultMutableTreeNode(new DemoDescription("demo.MultipleAxisDemo1", "MultipleAxisDemo1.java"));
        DefaultMutableTreeNode defaultMutableTreeNode8 = new DefaultMutableTreeNode(new DemoDescription("demo.MultipleAxisDemo2", "MultipleAxisDemo2.java"));
        DefaultMutableTreeNode defaultMutableTreeNode9 = new DefaultMutableTreeNode(new DemoDescription("demo.MultipleAxisDemo3", "MultipleAxisDemo3.java"));
        DefaultMutableTreeNode defaultMutableTreeNode10 = new DefaultMutableTreeNode(new DemoDescription("demo.ParetoChartDemo1", "ParetoChartDemo1.java"));
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
        defaultMutableTreeNode.add(defaultMutableTreeNode3);
        defaultMutableTreeNode.add(defaultMutableTreeNode4);
        defaultMutableTreeNode.add(defaultMutableTreeNode5);
        defaultMutableTreeNode.add(defaultMutableTreeNode6);
        defaultMutableTreeNode.add(defaultMutableTreeNode7);
        defaultMutableTreeNode.add(defaultMutableTreeNode8);
        defaultMutableTreeNode.add(defaultMutableTreeNode9);
        defaultMutableTreeNode.add(defaultMutableTreeNode10);
        return defaultMutableTreeNode;
    }

    private MutableTreeNode createCombinedAxisChartsNode() {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode("Combined Axis Charts");
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(new DemoDescription("demo.CombinedCategoryPlotDemo1", "CombinedCategoryPlotDemo1.java"));
        DefaultMutableTreeNode defaultMutableTreeNode3 = new DefaultMutableTreeNode(new DemoDescription("demo.CombinedCategoryPlotDemo2", "CombinedCategoryPlotDemo2.java"));
        DefaultMutableTreeNode defaultMutableTreeNode4 = new DefaultMutableTreeNode(new DemoDescription("demo.CombinedTimeSeriesDemo1", "CombinedTimeSeriesDemo1.java"));
        DefaultMutableTreeNode defaultMutableTreeNode5 = new DefaultMutableTreeNode(new DemoDescription("demo.CombinedXYPlotDemo1", "CombinedXYPlotDemo1.java"));
        DefaultMutableTreeNode defaultMutableTreeNode6 = new DefaultMutableTreeNode(new DemoDescription("demo.CombinedXYPlotDemo2", "CombinedXYPlotDemo2.java"));
        DefaultMutableTreeNode defaultMutableTreeNode7 = new DefaultMutableTreeNode(new DemoDescription("demo.CombinedXYPlotDemo3", "CombinedXYPlotDemo3.java"));
        DefaultMutableTreeNode defaultMutableTreeNode8 = new DefaultMutableTreeNode(new DemoDescription("demo.CombinedXYPlotDemo4", "CombinedXYPlotDemo4.java"));
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
        defaultMutableTreeNode.add(defaultMutableTreeNode3);
        defaultMutableTreeNode.add(defaultMutableTreeNode4);
        defaultMutableTreeNode.add(defaultMutableTreeNode5);
        defaultMutableTreeNode.add(defaultMutableTreeNode6);
        defaultMutableTreeNode.add(defaultMutableTreeNode7);
        defaultMutableTreeNode.add(defaultMutableTreeNode8);
        return defaultMutableTreeNode;
    }

    private MutableTreeNode createGanttChartsNode() {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode("Gantt Charts");
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(new DemoDescription("demo.GanttDemo1", "GanttDemo1.java"));
        DefaultMutableTreeNode defaultMutableTreeNode3 = new DefaultMutableTreeNode(new DemoDescription("demo.GanttDemo2", "GanttDemo2.java"));
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
        defaultMutableTreeNode.add(defaultMutableTreeNode3);
        return defaultMutableTreeNode;
    }

    private MutableTreeNode createMiscellaneousChartsNode() {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode("Miscellaneous");
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(new DemoDescription("demo.BubbleChartDemo1", "BubbleChartDemo1.java"));
        DefaultMutableTreeNode defaultMutableTreeNode3 = new DefaultMutableTreeNode(new DemoDescription("demo.BubbleChartDemo2", "BubbleChartDemo2.java"));
        DefaultMutableTreeNode defaultMutableTreeNode4 = new DefaultMutableTreeNode(new DemoDescription("demo.CategoryLabelPositionsDemo1", "CategoryLabelPositionsDemo1.java"));
        DefaultMutableTreeNode defaultMutableTreeNode5 = new DefaultMutableTreeNode(new DemoDescription("demo.CategoryStepChartDemo1", "CategoryStepChartDemo1.java"));
        DefaultMutableTreeNode defaultMutableTreeNode6 = new DefaultMutableTreeNode(new DemoDescription("demo.CompassDemo1", "CompassDemo1.java"));
        DefaultMutableTreeNode defaultMutableTreeNode7 = new DefaultMutableTreeNode(new DemoDescription("demo.CompassFormatDemo1", "CompassFormatDemo1.java"));
        DefaultMutableTreeNode defaultMutableTreeNode8 = new DefaultMutableTreeNode(new DemoDescription("demo.CompassFormatDemo2", "CompassFormatDemo2.java"));
        DefaultMutableTreeNode defaultMutableTreeNode9 = new DefaultMutableTreeNode(new DemoDescription("demo.DifferenceChartDemo1", "DifferenceChartDemo1.java"));
        DefaultMutableTreeNode defaultMutableTreeNode10 = new DefaultMutableTreeNode(new DemoDescription("demo.DifferenceChartDemo2", "DifferenceChartDemo2.java"));
        DefaultMutableTreeNode defaultMutableTreeNode11 = new DefaultMutableTreeNode(new DemoDescription("demo.EventFrequencyDemo1", "EventFrequencyDemo1.java"));
        DefaultMutableTreeNode defaultMutableTreeNode12 = new DefaultMutableTreeNode(new DemoDescription("demo.GradientPaintTransformerDemo1", "GradientPaintTransformerDemo1.java"));
        DefaultMutableTreeNode defaultMutableTreeNode13 = new DefaultMutableTreeNode(new DemoDescription("demo.GridBandDemo1", "GridBandDemo1.java"));
        DefaultMutableTreeNode defaultMutableTreeNode14 = new DefaultMutableTreeNode(new DemoDescription("demo.HideSeriesDemo1", "HideSeriesDemo1.java"));
        DefaultMutableTreeNode defaultMutableTreeNode15 = new DefaultMutableTreeNode(new DemoDescription("demo.HideSeriesDemo2", "HideSeriesDemo2.java"));
        DefaultMutableTreeNode defaultMutableTreeNode16 = new DefaultMutableTreeNode(new DemoDescription("demo.HideSeriesDemo3", "HideSeriesDemo3.java"));
        DefaultMutableTreeNode defaultMutableTreeNode17 = new DefaultMutableTreeNode(new DemoDescription("demo.MultipleDatasetDemo1", "MultipleDatasetDemo1.java"));
        DefaultMutableTreeNode defaultMutableTreeNode18 = new DefaultMutableTreeNode(new DemoDescription("demo.PolarChartDemo1", "PolarChartDemo1.java"));
        DefaultMutableTreeNode defaultMutableTreeNode19 = new DefaultMutableTreeNode(new DemoDescription("demo.ScatterRendererDemo1", "ScatterRendererDemo1.java"));
        DefaultMutableTreeNode defaultMutableTreeNode20 = new DefaultMutableTreeNode(new DemoDescription("demo.SpiderWebChartDemo1", "SpiderWebChartDemo1.java"));
        DefaultMutableTreeNode defaultMutableTreeNode21 = new DefaultMutableTreeNode(new DemoDescription("demo.SymbolAxisDemo1", "SymbolAxisDemo1.java"));
        DefaultMutableTreeNode defaultMutableTreeNode22 = new DefaultMutableTreeNode(new DemoDescription("demo.ThermometerDemo1", "ThermometerDemo1.java"));
        DefaultMutableTreeNode defaultMutableTreeNode23 = new DefaultMutableTreeNode(new DemoDescription("demo.ThermometerDemo2", "ThermometerDemo2.java"));
        DefaultMutableTreeNode defaultMutableTreeNode24 = new DefaultMutableTreeNode(new DemoDescription("demo.TranslateDemo1", "TranslateDemo1.java"));
        DefaultMutableTreeNode defaultMutableTreeNode25 = new DefaultMutableTreeNode(new DemoDescription("demo.YIntervalChartDemo1", "YIntervalChartDemo1.java"));
        defaultMutableTreeNode.add(this.createAnnotationsNode());
        defaultMutableTreeNode.add(this.createCrosshairChartsNode());
        defaultMutableTreeNode.add(this.createDynamicChartsNode());
        defaultMutableTreeNode.add(this.createItemLabelsNode());
        defaultMutableTreeNode.add(this.createLegendNode());
        defaultMutableTreeNode.add(this.createMarkersNode());
        defaultMutableTreeNode.add(this.createOrientationNode());
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
        defaultMutableTreeNode.add(defaultMutableTreeNode3);
        defaultMutableTreeNode.add(defaultMutableTreeNode4);
        defaultMutableTreeNode.add(defaultMutableTreeNode5);
        defaultMutableTreeNode.add(defaultMutableTreeNode6);
        defaultMutableTreeNode.add(defaultMutableTreeNode7);
        defaultMutableTreeNode.add(defaultMutableTreeNode8);
        defaultMutableTreeNode.add(defaultMutableTreeNode9);
        defaultMutableTreeNode.add(defaultMutableTreeNode10);
        defaultMutableTreeNode.add(defaultMutableTreeNode11);
        defaultMutableTreeNode.add(defaultMutableTreeNode12);
        defaultMutableTreeNode.add(defaultMutableTreeNode13);
        defaultMutableTreeNode.add(defaultMutableTreeNode14);
        defaultMutableTreeNode.add(defaultMutableTreeNode15);
        defaultMutableTreeNode.add(defaultMutableTreeNode16);
        defaultMutableTreeNode.add(defaultMutableTreeNode17);
        defaultMutableTreeNode.add(defaultMutableTreeNode18);
        defaultMutableTreeNode.add(defaultMutableTreeNode19);
        defaultMutableTreeNode.add(defaultMutableTreeNode20);
        defaultMutableTreeNode.add(defaultMutableTreeNode21);
        defaultMutableTreeNode.add(defaultMutableTreeNode22);
        defaultMutableTreeNode.add(defaultMutableTreeNode23);
        defaultMutableTreeNode.add(defaultMutableTreeNode24);
        defaultMutableTreeNode.add(defaultMutableTreeNode25);
        return defaultMutableTreeNode;
    }

    private MutableTreeNode createAnnotationsNode() {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode("Annotations");
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(new DemoDescription("demo.AnnotationDemo1", "AnnotationDemo1.java"));
        DefaultMutableTreeNode defaultMutableTreeNode3 = new DefaultMutableTreeNode(new DemoDescription("demo.AnnotationDemo2", "AnnotationDemo2.java"));
        DefaultMutableTreeNode defaultMutableTreeNode4 = new DefaultMutableTreeNode(new DemoDescription("demo.CategoryPointerAnnotationDemo1", "CategoryPointerAnnotationDemo1.java"));
        DefaultMutableTreeNode defaultMutableTreeNode5 = new DefaultMutableTreeNode(new DemoDescription("demo.XYBoxAnnotationDemo1", "XYBoxAnnotationDemo1.java"));
        DefaultMutableTreeNode defaultMutableTreeNode6 = new DefaultMutableTreeNode(new DemoDescription("demo.XYPolygonAnnotationDemo1", "XYPolygonAnnotationDemo1.java"));
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
        defaultMutableTreeNode.add(defaultMutableTreeNode3);
        defaultMutableTreeNode.add(defaultMutableTreeNode4);
        defaultMutableTreeNode.add(defaultMutableTreeNode5);
        defaultMutableTreeNode.add(defaultMutableTreeNode6);
        return defaultMutableTreeNode;
    }

    private MutableTreeNode createCrosshairChartsNode() {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode("Crosshairs");
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(new DemoDescription("demo.CrosshairDemo1", "CrosshairDemo1.java"));
        DefaultMutableTreeNode defaultMutableTreeNode3 = new DefaultMutableTreeNode(new DemoDescription("demo.CrosshairDemo2", "CrosshairDemo2.java"));
        DefaultMutableTreeNode defaultMutableTreeNode4 = new DefaultMutableTreeNode(new DemoDescription("demo.CrosshairDemo3", "CrosshairDemo3.java"));
        DefaultMutableTreeNode defaultMutableTreeNode5 = new DefaultMutableTreeNode(new DemoDescription("demo.CrosshairDemo4", "CrosshairDemo4.java"));
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
        defaultMutableTreeNode.add(defaultMutableTreeNode3);
        defaultMutableTreeNode.add(defaultMutableTreeNode4);
        defaultMutableTreeNode.add(defaultMutableTreeNode5);
        return defaultMutableTreeNode;
    }

    private MutableTreeNode createDynamicChartsNode() {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode("Dynamic Charts");
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(new DemoDescription("demo.DynamicDataDemo1", "DynamicDataDemo1.java"));
        DefaultMutableTreeNode defaultMutableTreeNode3 = new DefaultMutableTreeNode(new DemoDescription("demo.DynamicDataDemo2", "DynamicDataDemo2.java"));
        DefaultMutableTreeNode defaultMutableTreeNode4 = new DefaultMutableTreeNode(new DemoDescription("demo.DynamicDataDemo3", "DynamicDataDemo3.java"));
        DefaultMutableTreeNode defaultMutableTreeNode5 = new DefaultMutableTreeNode(new DemoDescription("demo.MouseOverDemo1", "MouseOverDemo1.java"));
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
        defaultMutableTreeNode.add(defaultMutableTreeNode3);
        defaultMutableTreeNode.add(defaultMutableTreeNode4);
        defaultMutableTreeNode.add(defaultMutableTreeNode5);
        return defaultMutableTreeNode;
    }

    private MutableTreeNode createItemLabelsNode() {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode("Item Labels");
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(new DemoDescription("demo.ItemLabelDemo1", "ItemLabelDemo1.java"));
        DefaultMutableTreeNode defaultMutableTreeNode3 = new DefaultMutableTreeNode(new DemoDescription("demo.ItemLabelDemo2", "ItemLabelDemo2.java"));
        DefaultMutableTreeNode defaultMutableTreeNode4 = new DefaultMutableTreeNode(new DemoDescription("demo.ItemLabelDemo3", "ItemLabelDemo3.java"));
        DefaultMutableTreeNode defaultMutableTreeNode5 = new DefaultMutableTreeNode(new DemoDescription("demo.ItemLabelDemo4", "ItemLabelDemo4.java"));
        DefaultMutableTreeNode defaultMutableTreeNode6 = new DefaultMutableTreeNode(new DemoDescription("demo.ItemLabelDemo5", "ItemLabelDemo5.java"));
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
        defaultMutableTreeNode.add(defaultMutableTreeNode3);
        defaultMutableTreeNode.add(defaultMutableTreeNode4);
        defaultMutableTreeNode.add(defaultMutableTreeNode5);
        defaultMutableTreeNode.add(defaultMutableTreeNode6);
        return defaultMutableTreeNode;
    }

    private MutableTreeNode createLegendNode() {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode("Legends");
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(new DemoDescription("demo.LegendWrapperDemo1", "LegendWrapperDemo1.java"));
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
        return defaultMutableTreeNode;
    }

    private MutableTreeNode createMarkersNode() {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode("Markers");
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(new DemoDescription("demo.CategoryMarkerDemo1", "CategoryMarkerDemo1.java"));
        DefaultMutableTreeNode defaultMutableTreeNode3 = new DefaultMutableTreeNode(new DemoDescription("demo.CategoryMarkerDemo2", "CategoryMarkerDemo2.java"));
        DefaultMutableTreeNode defaultMutableTreeNode4 = new DefaultMutableTreeNode(new DemoDescription("demo.MarkerDemo1", "MarkerDemo1.java"));
        DefaultMutableTreeNode defaultMutableTreeNode5 = new DefaultMutableTreeNode(new DemoDescription("demo.MarkerDemo2", "MarkerDemo2.java"));
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
        defaultMutableTreeNode.add(defaultMutableTreeNode3);
        defaultMutableTreeNode.add(defaultMutableTreeNode4);
        defaultMutableTreeNode.add(defaultMutableTreeNode5);
        return defaultMutableTreeNode;
    }

    private MutableTreeNode createOrientationNode() {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode("Plot Orientation");
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(new DemoDescription("demo.PlotOrientationDemo1", "PlotOrientationDemo1.java"));
        DefaultMutableTreeNode defaultMutableTreeNode3 = new DefaultMutableTreeNode(new DemoDescription("demo.PlotOrientationDemo2", "PlotOrientationDemo2.java"));
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
        defaultMutableTreeNode.add(defaultMutableTreeNode3);
        return defaultMutableTreeNode;
    }

    private MutableTreeNode createExperimentalNode() {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode("Experimental");
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(new DemoDescription("demo.LogAxisDemo1", "LogAxisDemo1.java"));
        DefaultMutableTreeNode defaultMutableTreeNode3 = new DefaultMutableTreeNode(new DemoDescription("demo.experimental.XYTitleAnnotationDemo1", "XYTitleAnnotationDemo1.java"));
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
        defaultMutableTreeNode.add(defaultMutableTreeNode3);
        return defaultMutableTreeNode;
    }

    private void displayDescription(String string) {
        URL uRL = (class$demo$SuperDemo == null ? (class$demo$SuperDemo = SuperDemo.class$("demo.SuperDemo")) : class$demo$SuperDemo).getResource(string);
        if (uRL != null) {
            try {
                this.descriptionPane.setPage(uRL);
            }
            catch (IOException iOException) {
                System.err.println("Attempted to read a bad URL: " + uRL);
            }
        } else {
            System.err.println("Couldn't find file: " + string);
        }
    }

    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        TreePath treePath = treeSelectionEvent.getPath();
        Object object = treePath.getLastPathComponent();
        if (object != null) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)object;
            Object object2 = defaultMutableTreeNode.getUserObject();
            if (object2 instanceof DemoDescription) {
                DemoDescription demoDescription = (DemoDescription)object2;
                SwingUtilities.invokeLater(new DisplayDemo(this, demoDescription));
            } else {
                this.chartContainer.removeAll();
                this.chartContainer.add(this.createNoDemoSelectedPanel());
                this.displayPanel.validate();
                this.displayDescription("select.html");
            }
        }
        System.out.println(object);
    }

    private JPanel createNoDemoSelectedPanel() {
        JPanel jPanel = new JPanel(new FlowLayout()){

            public String getToolTipText() {
                return "(" + this.getWidth() + ", " + this.getHeight() + ")";
            }
        };
        ToolTipManager.sharedInstance().registerComponent(jPanel);
        jPanel.add(new JLabel("No demo selected"));
        jPanel.setPreferredSize(new Dimension(600, 400));
        return jPanel;
    }

    public static void main(String[] stringArray) {
        SuperDemo superDemo = new SuperDemo("JFreeChart 1.0.9 Demo Collection");
        superDemo.pack();
        RefineryUtilities.centerFrameOnScreen((Window)((Object)superDemo));
        superDemo.setVisible(true);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static class DisplayDemo
    implements Runnable {
        private SuperDemo app;
        private DemoDescription demoDescription;

        public DisplayDemo(SuperDemo superDemo, DemoDescription demoDescription) {
            this.app = superDemo;
            this.demoDescription = demoDescription;
        }

        public void run() {
            try {
                String string;
                Class<?> clazz = Class.forName(this.demoDescription.getClassName());
                Method method = clazz.getDeclaredMethod("createDemoPanel", null);
                JPanel jPanel = (JPanel)method.invoke(null, null);
                this.app.chartContainer.removeAll();
                this.app.chartContainer.add(jPanel);
                this.app.displayPanel.validate();
                String string2 = string = clazz.getName();
                int n = string.lastIndexOf(46);
                if (n > 0) {
                    string2 = string.substring(n + 1);
                }
                string2 = string2 + ".html";
                this.app.displayDescription(string2);
            }
            catch (ClassNotFoundException classNotFoundException) {
                classNotFoundException.printStackTrace();
            }
            catch (NoSuchMethodException noSuchMethodException) {
                noSuchMethodException.printStackTrace();
            }
            catch (InvocationTargetException invocationTargetException) {
                invocationTargetException.printStackTrace();
            }
            catch (IllegalAccessException illegalAccessException) {
                illegalAccessException.printStackTrace();
            }
        }
    }

    static class PDFExportTask
    implements Runnable {
        JFreeChart chart;
        int width;
        int height;
        File file;

        public PDFExportTask(JFreeChart jFreeChart, int n, int n2, File file) {
            this.chart = jFreeChart;
            this.file = file;
            this.width = n;
            this.height = n2;
            jFreeChart.setBorderVisible(true);
            jFreeChart.setPadding(new RectangleInsets(2.0, 2.0, 2.0, 2.0));
        }

        public void run() {
            try {
                SuperDemo.saveChartAsPDF(this.file, this.chart, this.width, this.height, (FontMapper)new DefaultFontMapper());
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }
}

