/*
 * Decompiled with CFR 0.152.
 */
package demo;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Window;
import java.text.SimpleDateFormat;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.axis.DateTickUnit;
import org.jfree.chart.axis.TickUnits;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.time.Week;
import org.jfree.data.xy.XYDataset;
import org.jfree.ui.ApplicationFrame;
import org.jfree.ui.RectangleInsets;
import org.jfree.ui.RefineryUtilities;

public class TimeSeriesDemo13
extends ApplicationFrame {
    static /* synthetic */ Class class$org$jfree$data$time$Week;

    public TimeSeriesDemo13(String string) {
        super(string);
        this.setContentPane(TimeSeriesDemo13.createDemoPanel());
    }

    private static JFreeChart createChart(XYDataset xYDataset) {
        Cloneable cloneable;
        JFreeChart jFreeChart = ChartFactory.createTimeSeriesChart("Weekly Data", "Date", "Value", xYDataset, true, true, false);
        jFreeChart.setBackgroundPaint(Color.white);
        XYPlot xYPlot = (XYPlot)jFreeChart.getPlot();
        xYPlot.setBackgroundPaint(Color.lightGray);
        xYPlot.setDomainGridlinePaint(Color.white);
        xYPlot.setRangeGridlinePaint(Color.white);
        xYPlot.setAxisOffset(new RectangleInsets(5.0, 5.0, 5.0, 5.0));
        xYPlot.setDomainCrosshairVisible(true);
        xYPlot.setRangeCrosshairVisible(true);
        XYItemRenderer xYItemRenderer = xYPlot.getRenderer();
        if (xYItemRenderer instanceof XYLineAndShapeRenderer) {
            cloneable = (XYLineAndShapeRenderer)xYItemRenderer;
            ((XYLineAndShapeRenderer)cloneable).setBaseShapesVisible(true);
            ((XYLineAndShapeRenderer)cloneable).setBaseShapesFilled(true);
        }
        cloneable = (DateAxis)xYPlot.getDomainAxis();
        TickUnits tickUnits = new TickUnits();
        tickUnits.add(new DateTickUnit(2, 1, new SimpleDateFormat("MMM dd ''yy")));
        tickUnits.add(new DateTickUnit(2, 7, new SimpleDateFormat("MMM dd ''yy")));
        tickUnits.add(new DateTickUnit(1, 1, new SimpleDateFormat("MMM ''yy")));
        ((ValueAxis)cloneable).setStandardTickUnits(tickUnits);
        return jFreeChart;
    }

    private static XYDataset createDataset(int n) {
        TimeSeries timeSeries = new TimeSeries((Comparable)((Object)"Random Data"), class$org$jfree$data$time$Week == null ? (class$org$jfree$data$time$Week = TimeSeriesDemo13.class$("org.jfree.data.time.Week")) : class$org$jfree$data$time$Week);
        RegularTimePeriod regularTimePeriod = new Week();
        double d = 100.0;
        for (int i = 0; i < n; ++i) {
            timeSeries.add(regularTimePeriod, d);
            d *= 1.0 + (Math.random() - 0.499) / 100.0;
            regularTimePeriod = ((RegularTimePeriod)regularTimePeriod).next();
        }
        TimeSeriesCollection timeSeriesCollection = new TimeSeriesCollection(timeSeries);
        return timeSeriesCollection;
    }

    public static JPanel createDemoPanel() {
        XYDataset xYDataset = TimeSeriesDemo13.createDataset(26);
        JFreeChart jFreeChart = TimeSeriesDemo13.createChart(xYDataset);
        ChartPanel chartPanel = new ChartPanel(jFreeChart);
        XYDataset xYDataset2 = TimeSeriesDemo13.createDataset(1);
        JFreeChart jFreeChart2 = TimeSeriesDemo13.createChart(xYDataset2);
        ChartPanel chartPanel2 = new ChartPanel(jFreeChart2);
        JTabbedPane jTabbedPane = new JTabbedPane();
        jTabbedPane.add("Chart 1", chartPanel);
        jTabbedPane.add("Chart 2", chartPanel2);
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setPreferredSize(new Dimension(500, 270));
        jPanel.add(jTabbedPane);
        return jPanel;
    }

    public static void main(String[] stringArray) {
        TimeSeriesDemo13 timeSeriesDemo13 = new TimeSeriesDemo13("Time Series Demo 13");
        timeSeriesDemo13.pack();
        RefineryUtilities.centerFrameOnScreen((Window)((Object)timeSeriesDemo13));
        timeSeriesDemo13.setVisible(true);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

