/*
 * Decompiled with CFR 0.152.
 */
package demo;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Window;
import java.text.DecimalFormat;
import javax.swing.JPanel;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberTickUnit;
import org.jfree.chart.axis.TickUnits;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.labels.StandardCategoryItemLabelGenerator;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.BarRenderer;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.ui.ApplicationFrame;
import org.jfree.ui.RectangleInsets;
import org.jfree.ui.RefineryUtilities;

public class WaterfallChartDemo1
extends ApplicationFrame {
    public WaterfallChartDemo1(String string) {
        super(string);
        JPanel jPanel = WaterfallChartDemo1.createDemoPanel();
        jPanel.setPreferredSize(new Dimension(500, 270));
        this.setContentPane(jPanel);
    }

    private static CategoryDataset createDataset() {
        DefaultCategoryDataset defaultCategoryDataset = new DefaultCategoryDataset();
        defaultCategoryDataset.addValue(15.76, (Comparable)((Object)"Product 1"), (Comparable)((Object)"Labour"));
        defaultCategoryDataset.addValue(8.66, (Comparable)((Object)"Product 1"), (Comparable)((Object)"Administration"));
        defaultCategoryDataset.addValue(4.71, (Comparable)((Object)"Product 1"), (Comparable)((Object)"Marketing"));
        defaultCategoryDataset.addValue(3.51, (Comparable)((Object)"Product 1"), (Comparable)((Object)"Distribution"));
        defaultCategoryDataset.addValue(32.64, (Comparable)((Object)"Product 1"), (Comparable)((Object)"Total Expense"));
        return defaultCategoryDataset;
    }

    private static JFreeChart createChart(CategoryDataset categoryDataset) {
        JFreeChart jFreeChart = ChartFactory.createWaterfallChart("Product Cost Breakdown", "Expense Category", "Cost Per Unit", categoryDataset, PlotOrientation.VERTICAL, false, true, false);
        jFreeChart.setBackgroundPaint(Color.white);
        CategoryPlot categoryPlot = (CategoryPlot)jFreeChart.getPlot();
        categoryPlot.setBackgroundPaint(Color.lightGray);
        categoryPlot.setRangeGridlinePaint(Color.white);
        categoryPlot.setRangeGridlinesVisible(true);
        categoryPlot.setAxisOffset(new RectangleInsets(5.0, 5.0, 5.0, 5.0));
        ValueAxis valueAxis = categoryPlot.getRangeAxis();
        DecimalFormat decimalFormat = new DecimalFormat("##,###");
        decimalFormat.setNegativePrefix("(");
        decimalFormat.setNegativeSuffix(")");
        TickUnits tickUnits = new TickUnits();
        tickUnits.add(new NumberTickUnit(5.0, decimalFormat));
        tickUnits.add(new NumberTickUnit(10.0, decimalFormat));
        tickUnits.add(new NumberTickUnit(20.0, decimalFormat));
        tickUnits.add(new NumberTickUnit(50.0, decimalFormat));
        tickUnits.add(new NumberTickUnit(100.0, decimalFormat));
        tickUnits.add(new NumberTickUnit(200.0, decimalFormat));
        tickUnits.add(new NumberTickUnit(500.0, decimalFormat));
        tickUnits.add(new NumberTickUnit(1000.0, decimalFormat));
        tickUnits.add(new NumberTickUnit(2000.0, decimalFormat));
        tickUnits.add(new NumberTickUnit(5000.0, decimalFormat));
        valueAxis.setStandardTickUnits(tickUnits);
        BarRenderer barRenderer = (BarRenderer)categoryPlot.getRenderer();
        barRenderer.setDrawBarOutline(false);
        barRenderer.setBase(5.0);
        DecimalFormat decimalFormat2 = new DecimalFormat("$##,###.00");
        decimalFormat2.setNegativePrefix("(");
        decimalFormat2.setNegativeSuffix(")");
        barRenderer.setBaseItemLabelGenerator(new StandardCategoryItemLabelGenerator("{2}", decimalFormat2));
        barRenderer.setBaseItemLabelsVisible(true);
        return jFreeChart;
    }

    public static JPanel createDemoPanel() {
        return new ChartPanel(WaterfallChartDemo1.createChart(WaterfallChartDemo1.createDataset()));
    }

    public static void main(String[] stringArray) {
        WaterfallChartDemo1 waterfallChartDemo1 = new WaterfallChartDemo1("Waterfall Chart Demo");
        waterfallChartDemo1.pack();
        RefineryUtilities.centerFrameOnScreen((Window)((Object)waterfallChartDemo1));
        waterfallChartDemo1.setVisible(true);
    }
}

